/*
 * Decompiled with CFR 0.152.
 */
package asn1;

import asn1.ASN1Any;
import asn1.ASN1BitString;
import asn1.ASN1Decoder;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1Integer;
import asn1.ASN1ObjectDescriptor;
import asn1.ASN1ObjectIdentifier;
import asn1.ASN1OctetString;
import asn1.BERConstructed;
import asn1.BEREncoding;
import asn1.BERPrimitive;

public final class ASN1External
extends ASN1Any {
    public static final int TAG = 8;
    public ASN1ObjectIdentifier s_direct_reference;
    public ASN1Integer s_indirect_reference;
    public ASN1ObjectDescriptor s_data_value_descriptor;
    public ASN1Any c_singleASN1type;
    public ASN1OctetString c_octetAligned;
    public ASN1BitString c_arbitrary;

    public ASN1External() {
    }

    public ASN1External(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        if (flag && (berencoding.tag_get() != 8 || berencoding.tag_type_get() != 0)) {
            throw new ASN1EncodingException("ASN.1 EXTERNAL: bad BER: tag=" + berencoding.tag_get() + " expected 8\n");
        }
        if (berencoding instanceof BERPrimitive) {
            throw new ASN1EncodingException("ASN.1 EXTERNAL: incorrect form, primitive encoding");
        }
        BERConstructed berconstructed = (BERConstructed)berencoding;
        this.s_direct_reference = null;
        this.s_indirect_reference = null;
        this.s_data_value_descriptor = null;
        this.c_singleASN1type = null;
        this.c_octetAligned = null;
        this.c_arbitrary = null;
        int i = berconstructed.number_components();
        if (i < 1) {
            throw new ASN1EncodingException("ASN.1 EXTERNAL: incomplete");
        }
        int j = 0;
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 6 && berencoding1.tag_type_get() == 0) {
            this.s_direct_reference = new ASN1ObjectIdentifier(berencoding1, true);
            if (i <= ++j) {
                throw new ASN1EncodingException("ASN.1 EXTERNAL: incomplete");
            }
            berencoding1 = berconstructed.elementAt(j);
        }
        if (berencoding1.tag_get() == 2 && berencoding1.tag_type_get() == 0) {
            this.s_indirect_reference = new ASN1Integer(berencoding1, true);
            if (i <= ++j) {
                throw new ASN1EncodingException("ASN.1 EXTERNAL: incomplete");
            }
            berencoding1 = berconstructed.elementAt(j);
        }
        if (berencoding1.tag_get() == 7 && berencoding1.tag_type_get() == 0) {
            this.s_data_value_descriptor = new ASN1ObjectDescriptor(berencoding1, true);
            if (i <= ++j) {
                throw new ASN1EncodingException("ASN.1 EXTERNAL: incomplete");
            }
            berencoding1 = berconstructed.elementAt(j);
        }
        switch (berencoding1.tag_get()) {
            case 0: {
                if (!(berencoding1 instanceof BERConstructed)) {
                    throw new ASN1EncodingException("ASN.1 EXTERNAL: singleASN1type: bad form, primitive");
                }
                if (((BERConstructed)berencoding1).number_components() != 1) {
                    throw new ASN1EncodingException("ASN.1 EXTERNAL: singleASN1type: bad form, no explicit tag");
                }
                this.c_singleASN1type = ASN1Decoder.toASN1((BEREncoding)((BERConstructed)berencoding1).elementAt(0));
                break;
            }
            case 1: {
                if (berencoding1.tag_type_get() != 128) {
                    throw new ASN1EncodingException("ASN.1 EXTERNAL: encoding: bad tag type " + berencoding1);
                }
                this.c_octetAligned = new ASN1OctetString(berencoding1, false);
                break;
            }
            case 2: {
                if (berencoding1.tag_type_get() != 128) {
                    throw new ASN1EncodingException("ASN.1 EXTERNAL: encoding: bad tag type " + berencoding1);
                }
                this.c_arbitrary = new ASN1BitString(berencoding1, false);
                break;
            }
            default: {
                throw new ASN1EncodingException("ASN.1 EXTERNAL: encoding: tag = " + berencoding1.tag_get());
            }
        }
        if (j != i - 1) {
            throw new ASN1Exception("ASN.1 EXTERNAL: extra element(s)");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 8);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 0;
        if (this.c_singleASN1type != null) {
            ++k;
        }
        if (this.c_octetAligned != null) {
            ++k;
        }
        if (this.c_arbitrary != null) {
            ++k;
        }
        if (k < 1) {
            throw new ASN1Exception("ASN1 EXTERNAL: no encoding has been set");
        }
        if (k > 1) {
            throw new ASN1Exception("ASN1 EXTERNAL: more than one encoding set");
        }
        if (this.s_direct_reference != null) {
            ++k;
        }
        if (this.s_indirect_reference != null) {
            ++k;
        }
        if (this.s_data_value_descriptor != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        if (this.s_direct_reference != null) {
            aberencoding[l++] = this.s_direct_reference.ber_encode();
        }
        if (this.s_indirect_reference != null) {
            aberencoding[l++] = this.s_indirect_reference.ber_encode();
        }
        if (this.s_data_value_descriptor != null) {
            aberencoding[l++] = this.s_data_value_descriptor.ber_encode();
        }
        if (this.c_singleASN1type != null) {
            BEREncoding[] aberencoding1 = new BEREncoding[]{this.c_singleASN1type.ber_encode()};
            aberencoding[l] = new BERConstructed(128, 0, aberencoding1);
        } else if (this.c_octetAligned != null) {
            aberencoding[l] = this.c_octetAligned.ber_encode(128, 1);
        } else if (this.c_arbitrary != null) {
            aberencoding[l] = this.c_arbitrary.ber_encode(128, 2);
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        boolean flag = false;
        if (this.s_direct_reference != null) {
            stringbuffer.append("directReference ");
            stringbuffer.append(this.s_direct_reference);
            flag = true;
        }
        if (this.s_indirect_reference != null) {
            if (flag) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("indirectReference ");
            stringbuffer.append(this.s_indirect_reference);
            flag = true;
        }
        if (this.s_data_value_descriptor != null) {
            if (flag) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("dataValueDescriptor ");
            stringbuffer.append(this.s_data_value_descriptor);
            flag = true;
        }
        if (flag) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("encoding {");
        if (this.c_singleASN1type != null) {
            stringbuffer.append("singleASN1type ");
            stringbuffer.append(this.c_singleASN1type);
        }
        if (this.c_octetAligned != null) {
            stringbuffer.append("octetAligned ");
            stringbuffer.append(this.c_octetAligned);
        }
        if (this.c_arbitrary != null) {
            stringbuffer.append("arbitrary ");
            stringbuffer.append(this.c_arbitrary);
        }
        stringbuffer.append("}}");
        return stringbuffer.toString();
    }
}

