/*
 * Decompiled with CFR 0.152.
 */
package asn1;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.BEREncoding;
import asn1.BERPrimitive;

public final class ASN1Integer
extends ASN1Any {
    public static final int TAG = 2;
    private int value;

    public ASN1Integer(int i) {
        this.value = i;
    }

    public ASN1Integer(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1EncodingException {
        if (flag && (berencoding.tag_get() != 2 || berencoding.tag_type_get() != 0)) {
            throw new ASN1EncodingException("ASN.1 INTEGER: bad BER: tag=" + berencoding.tag_get() + " expected 2\n");
        }
        if (!(berencoding instanceof BERPrimitive)) {
            throw new ASN1EncodingException("ASN.1 INTEGER: bad form, constructed");
        }
        BERPrimitive berprimitive = (BERPrimitive)berencoding;
        int[] ai = berprimitive.peek();
        if (ai.length < 1) {
            throw new ASN1EncodingException("ASN.1 INTEGER: invalid encoding, length = " + ai.length);
        }
        this.value = (byte)ai[0];
        for (int i = 1; i < ai.length; ++i) {
            this.value <<= 8;
            this.value |= ai[i] & 0xFF;
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 2);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        boolean flag;
        int k = 0;
        int l = this.value;
        if (this.value < 0) {
            l = ~this.value;
        }
        do {
            flag = (l & 0x80) == 128;
            ++k;
        } while ((l >>= 8) != 0);
        if (flag) {
            ++k;
        }
        int[] ai = new int[k];
        int i1 = 0;
        while (k > 0) {
            ai[i1++] = this.value >> 8 * (k - 1) & 0xFF;
            --k;
        }
        return new BERPrimitive(i, j, ai);
    }

    public ASN1Integer set(int i) {
        this.value = i;
        return this;
    }

    public int get() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

