/*
 * Decompiled with CFR 0.152.
 */
package asn1;

import asn1.ASN1Any;
import asn1.ASN1Decoder;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.BERConstructed;
import asn1.BEREncoding;
import asn1.BERPrimitive;

public final class ASN1Set
extends ASN1Any {
    public static final int TAG = 17;
    private ASN1Any[] elements;

    public ASN1Set(ASN1Any[] aasn1any) {
        this.elements = aasn1any;
    }

    public ASN1Set(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        if (flag && (berencoding.tag_get() != 17 || berencoding.tag_type_get() != 0)) {
            throw new ASN1EncodingException("ASN.1 SET: bad BER: tag=" + berencoding.tag_get() + " expected 17\n");
        }
        if (berencoding instanceof BERPrimitive) {
            throw new ASN1EncodingException("ASN.1 SET: bad form, primitive");
        }
        BERConstructed berconstructed = (BERConstructed)berencoding;
        int i = berconstructed.number_components();
        this.elements = new ASN1Any[i];
        for (int j = 0; j < i; ++j) {
            this.elements[j] = ASN1Decoder.toASN1((BEREncoding)berconstructed.elementAt(j));
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 17);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = this.elements.length;
        BEREncoding[] aberencoding = new BEREncoding[k];
        for (int l = 0; l < k; ++l) {
            aberencoding[l] = this.elements[l].ber_encode();
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public void set(ASN1Any[] aasn1any) {
        this.elements = aasn1any;
    }

    public ASN1Any[] get() {
        return this.elements;
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        for (int i = 0; i < this.elements.length; ++i) {
            if (i != 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append(this.elements[i].toString());
        }
        stringbuffer.append('}');
        return new String(stringbuffer);
    }
}

