/*
 * Decompiled with CFR 0.152.
 */
package asn1;

import asn1.ASN1Exception;
import asn1.BEREncoding;
import java.io.IOException;
import java.io.OutputStream;

public class BERPrimitive
extends BEREncoding {
    private int[] contents_octets;

    BERPrimitive(int i, int j, int[] ai) throws ASN1Exception {
        this.init(i, false, j, ai.length);
        this.contents_octets = ai;
    }

    int[] peek() {
        return this.contents_octets;
    }

    public void output(OutputStream outputstream) throws IOException {
        this.output_head(outputstream);
        this.output_bytes(this.contents_octets, outputstream);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("[");
        switch (this.i_tag_type) {
            case 0: {
                stringbuffer.append("UNIVERSAL ");
                break;
            }
            case 64: {
                stringbuffer.append("APPLICATION ");
                break;
            }
            case 128: {
                stringbuffer.append("CONTEXT SPECIFIC ");
                break;
            }
            case 192: {
                stringbuffer.append("PRIVATE ");
            }
        }
        stringbuffer.append(String.valueOf(this.i_tag) + "] '");
        for (int i = 0; i < this.contents_octets.length; ++i) {
            int j = this.contents_octets[i];
            char[] ac = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
            stringbuffer.append(ac[j >> 4 & 0xF]);
            stringbuffer.append(ac[j & 0xF]);
        }
        stringbuffer.append("'H");
        return new String(stringbuffer);
    }

    protected int i_encoding_get(int i, byte[] abyte0) {
        i = this.i_get_head(i, abyte0);
        for (int j = 0; j < this.contents_octets.length; ++j) {
            abyte0[i++] = (byte)this.contents_octets[j];
        }
        return i;
    }
}

