/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.as.config;

import cz.kpsys.as.config.AppserverUpdateRunner;
import cz.kpsys.as.config.ExceptionMailingUpdateRunner;
import cz.kpsys.as.config.PortaroUpdateRunner;
import cz.kpsys.as.config.SettingKeys;
import cz.kpsys.as.config.UpdateRunner;
import cz.kpsys.as.licence.VerbisVersionProvider;
import cz.kpsys.as.setting.StaticKeyContextualProvider;
import cz.kpsys.common.Licensing;
import cz.kpsys.common.VerbisVersion;
import cz.kpsys.db.DbCache2;
import cz.kpsys.db.DbConfig;
import cz.kpsys.db.TableDescriptorProvider;
import cz.kpsys.db.model.intern.SmtpSettings;
import cz.kpsys.kpwin2.rest.Configuration;
import cz.kpsys.portaro.commons.barcode.ValidLengthBarCodeValidator;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.convert.ConversionTableConverter;
import cz.kpsys.portaro.commons.convert.EToEConverter;
import cz.kpsys.portaro.commons.convert.StringToIntegerConverter;
import cz.kpsys.portaro.commons.object.CachedProvider;
import cz.kpsys.portaro.commons.object.FallbackedProvider;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.StaticProvider;
import cz.kpsys.portaro.database.IntegerValueDatabaseLoader;
import cz.kpsys.portaro.databaseproperties.DatabaseConnectionSettings;
import cz.kpsys.portaro.department.Department;
import cz.kpsys.portaro.licence.Licence;
import cz.kpsys.portaro.licence.LicenceKeyDecoder;
import cz.kpsys.portaro.licence.LicenceKeyDecodingLicenceKeyExpiredPredicate;
import cz.kpsys.portaro.licence.LicenceKeyDecodingLicenceProvider;
import cz.kpsys.portaro.licence.LicenceServerFetchingLicenceKeyProvider;
import cz.kpsys.portaro.licence.jwt.Auth0JwtLicenceKeyDecoder;
import cz.kpsys.portaro.search.PageSearchLoader;
import cz.kpsys.portaro.setting.IniKeyNotExistException;
import cz.kpsys.portaro.setting.SettingTypeId;
import cz.kpsys.portaro.setting.StaticDepartmentCustomSettingValueLoader;
import cz.kpsys.portaro.sql.generator.QueryFactory;
import cz.kpsys.portaro.user.SearchingMultiTryingSuUserIdProvider;
import cz.kpsys.portaro.user.SpringDbUserIdSearchLoader;
import cz.kpsys.service.mail.AsyncEmailService;
import cz.kpsys.service.mail.DefaultMailerProvider;
import cz.kpsys.service.mail.EmailFactory;
import cz.kpsys.service.mail.ErrorMailer;
import cz.kpsys.service.mail.ErrorMailerDefault;
import cz.kpsys.service.mail.SimpleJavaMailSyncEmailService;
import cz.kpsys.service.mail.SyncDelegatingAsyncEmailService;
import cz.kpsys.service.mail.SyncEmailService;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.sql.DataSource;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.core.convert.converter.Converter;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.web.client.RestOperations;

public class CompositeUpdateRunner
implements UpdateRunner {
    @NonNull
    private final DbConfig dbConfig;
    @NonNull
    private final Configuration configuration;
    @NonNull
    private final DataSource appserverUpdateDataSource;
    @NonNull
    private final DataSource writeExecutorDataSource;
    @NonNull
    private final DataSource portaroAutoCommittingDataSource;
    @NonNull
    private final DatabaseConnectionSettings databaseProperties;
    @NonNull
    private final NamedParameterJdbcTemplate autoCommittingJdbcTemplate;
    @NonNull
    private final StaticDepartmentCustomSettingValueLoader initCustomSettingLoader;
    @NonNull
    private final Provider<Department> initRootDepartmentProvider;
    @NonNull
    private final QueryFactory queryFactory;
    @NonNull
    private final RestOperations rest;
    @NonNull
    private final @NonNull Provider<@NonNull String> serialCodeProvider;
    @NonNull
    private final @NonNull Provider<@NonNull String> kpsysApiKeyProvider;
    @NonNull
    private final Provider<String> externalResourcesFondProvider;

    public void updateResources() {
        UpdateRunner appserverUpdateRunner = this.appserverUpdateRunner();
        appserverUpdateRunner.updateResources();
        UpdateRunner portaroUpdateRunner = this.portaroUpdateRunner();
        portaroUpdateRunner.updateResources();
    }

    private UpdateRunner appserverUpdateRunner() {
        Licensing.init((Provider)this.verbisVersionProvider(), (Supplier)this.serialCodeProvider);
        return new AppserverUpdateRunner(this.dbConfig, (Supplier)this.verbisVersionProvider(), this.configuration, this.initRootDepartmentProvider, (ErrorMailer)this.errorMailer(), this.appserverUpdateDataSource, this.serialCodeProvider, this.suUserIdProvider(), this.externalResourcesFondProvider);
    }

    private UpdateRunner portaroUpdateRunner() {
        PortaroUpdateRunner updateRunner = new PortaroUpdateRunner((Supplier)this.verbisVersionProvider(), this.writeExecutorDataSource, this.portaroAutoCommittingDataSource, this.tableDescriptorProvider(), this.autoCommittingJdbcTemplate, this.queryFactory, this.suUserIdProvider(), this.initRootDepartmentProvider, this.databaseProperties);
        return new ExceptionMailingUpdateRunner((UpdateRunner)updateRunner, (ErrorMailer)this.errorMailer());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private Provider<Integer> suUserIdProvider() {
        SpringDbUserIdSearchLoader userIdSearchLoader = new SpringDbUserIdSearchLoader((NamedParameterJdbcOperations)this.autoCommittingJdbcTemplate, this.queryFactory, () -> new ValidLengthBarCodeValidator((Provider)StaticProvider.of((Object)13)));
        @NonNull SearchingMultiTryingSuUserIdProvider primaryProvider = new SearchingMultiTryingSuUserIdProvider((PageSearchLoader)userIdSearchLoader, "SU");
        @NonNull IntegerValueDatabaseLoader fallbackProvider = IntegerValueDatabaseLoader.ofQuery((NamedParameterJdbcOperations)this.autoCommittingJdbcTemplate, (QueryFactory)this.queryFactory, (String)"uzivatele", (String)"id_uziv", where -> where.eq("username", (Object)"SU"));
        return new FallbackedProvider((Provider)primaryProvider, (Provider)fallbackProvider).fallbackOnException(BadSqlGrammarException.class).cached();
    }

    private TableDescriptorProvider tableDescriptorProvider() {
        return Objects.requireNonNull(DbCache2.tableDescriptorProvider);
    }

    private ErrorMailerDefault errorMailer() {
        SimpleJavaMailSyncEmailService syncService = new SimpleJavaMailSyncEmailService((ContextualProvider)this.mailerProvider());
        return new ErrorMailerDefault((AsyncEmailService)new SyncDelegatingAsyncEmailService((SyncEmailService)syncService), this.emailFactory(), this.initRootDepartmentProvider);
    }

    protected EmailFactory emailFactory() {
        return new EmailFactory((ContextualProvider)new StaticKeyContextualProvider(this.initCustomSettingLoader, SettingKeys.SMTP_SENDER_NAME, (Converter)new EToEConverter()), (ContextualProvider)new StaticKeyContextualProvider(this.initCustomSettingLoader, SettingKeys.SMTP_SENDER_ADDRESS, (Converter)new EToEConverter()));
    }

    protected DefaultMailerProvider mailerProvider() {
        return new DefaultMailerProvider((ContextualProvider)new StaticKeyContextualProvider(this.initCustomSettingLoader, SettingKeys.SMTP_MAIL_PROVIDER, (Converter)new ConversionTableConverter(SmtpSettings.CONVERSION_MAP)), (ContextualProvider)new StaticKeyContextualProvider(this.initCustomSettingLoader, SettingKeys.SMTP_SERVER_ADDRESS, (Converter)new EToEConverter()), (ContextualProvider)new StaticKeyContextualProvider(this.initCustomSettingLoader, SettingKeys.SMTP_SERVER_PORT, (Converter)new StringToIntegerConverter(Integer.valueOf(25))), (ContextualProvider)new StaticKeyContextualProvider(this.initCustomSettingLoader, SettingKeys.SMTP_SERVER_USERNAME, (Converter)new EToEConverter()), (ContextualProvider)new StaticKeyContextualProvider(this.initCustomSettingLoader, SettingKeys.SMTP_SERVER_PASSWORD, (Converter)new EToEConverter()));
    }

    private Provider<VerbisVersion> verbisVersionProvider() {
        return new VerbisVersionProvider((Supplier)this.licenceProvider());
    }

    private Provider<Licence> licenceProvider() {
        return new LicenceKeyDecodingLicenceProvider((Supplier)this.jwtLicenceKeyProvider(), (LicenceKeyDecoder)this.jwtLicenceKeyDecoder());
    }

    private Provider<@NonNull String> jwtLicenceKeyProvider() {
        CachedProvider fromIniProvider = this.initCustomSettingLoader.getProvider((SettingTypeId)SettingKeys.LICENCE_KEY).cached();
        LicenceServerFetchingLicenceKeyProvider fromServerProvider = new LicenceServerFetchingLicenceKeyProvider(this.rest, this.serialCodeProvider, this.kpsysApiKeyProvider);
        LicenceKeyDecodingLicenceKeyExpiredPredicate keyExpiredPredicate = new LicenceKeyDecodingLicenceKeyExpiredPredicate((LicenceKeyDecoder)this.jwtLicenceKeyDecoder());
        return new FallbackedProvider((Provider)fromIniProvider, (Provider)fromServerProvider).fallbackOnNull().fallbackOnValue((Predicate)keyExpiredPredicate).fallbackOnException(IniKeyNotExistException.class).throwingWhenNull();
    }

    private Auth0JwtLicenceKeyDecoder jwtLicenceKeyDecoder() {
        return Auth0JwtLicenceKeyDecoder.ofInternalPublicKey();
    }

    @ConstructorProperties(value={"dbConfig", "configuration", "appserverUpdateDataSource", "writeExecutorDataSource", "portaroAutoCommittingDataSource", "databaseProperties", "autoCommittingJdbcTemplate", "initCustomSettingLoader", "initRootDepartmentProvider", "queryFactory", "rest", "serialCodeProvider", "kpsysApiKeyProvider", "externalResourcesFondProvider"})
    @Generated
    public CompositeUpdateRunner(@NonNull DbConfig dbConfig, @NonNull Configuration configuration, @NonNull DataSource appserverUpdateDataSource, @NonNull DataSource writeExecutorDataSource, @NonNull DataSource portaroAutoCommittingDataSource, @NonNull DatabaseConnectionSettings databaseProperties, @NonNull NamedParameterJdbcTemplate autoCommittingJdbcTemplate, @NonNull StaticDepartmentCustomSettingValueLoader initCustomSettingLoader, @NonNull Provider<Department> initRootDepartmentProvider, @NonNull QueryFactory queryFactory, @NonNull RestOperations rest, @NonNull @NonNull Provider<@NonNull String> serialCodeProvider, @NonNull @NonNull Provider<@NonNull String> kpsysApiKeyProvider, @NonNull Provider<String> externalResourcesFondProvider) {
        Objects.requireNonNull(dbConfig, "dbConfig is marked non-null but is null");
        Objects.requireNonNull(configuration, "configuration is marked non-null but is null");
        Objects.requireNonNull(appserverUpdateDataSource, "appserverUpdateDataSource is marked non-null but is null");
        Objects.requireNonNull(writeExecutorDataSource, "writeExecutorDataSource is marked non-null but is null");
        Objects.requireNonNull(portaroAutoCommittingDataSource, "portaroAutoCommittingDataSource is marked non-null but is null");
        Objects.requireNonNull(databaseProperties, "databaseProperties is marked non-null but is null");
        Objects.requireNonNull(autoCommittingJdbcTemplate, "autoCommittingJdbcTemplate is marked non-null but is null");
        Objects.requireNonNull(initCustomSettingLoader, "initCustomSettingLoader is marked non-null but is null");
        Objects.requireNonNull(initRootDepartmentProvider, "initRootDepartmentProvider is marked non-null but is null");
        Objects.requireNonNull(queryFactory, "queryFactory is marked non-null but is null");
        Objects.requireNonNull(rest, "rest is marked non-null but is null");
        Objects.requireNonNull(serialCodeProvider, "serialCodeProvider is marked non-null but is null");
        Objects.requireNonNull(kpsysApiKeyProvider, "kpsysApiKeyProvider is marked non-null but is null");
        Objects.requireNonNull(externalResourcesFondProvider, "externalResourcesFondProvider is marked non-null but is null");
        this.dbConfig = dbConfig;
        this.configuration = configuration;
        this.appserverUpdateDataSource = appserverUpdateDataSource;
        this.writeExecutorDataSource = writeExecutorDataSource;
        this.portaroAutoCommittingDataSource = portaroAutoCommittingDataSource;
        this.databaseProperties = databaseProperties;
        this.autoCommittingJdbcTemplate = autoCommittingJdbcTemplate;
        this.initCustomSettingLoader = initCustomSettingLoader;
        this.initRootDepartmentProvider = initRootDepartmentProvider;
        this.queryFactory = queryFactory;
        this.rest = rest;
        this.serialCodeProvider = serialCodeProvider;
        this.kpsysApiKeyProvider = kpsysApiKeyProvider;
        this.externalResourcesFondProvider = externalResourcesFondProvider;
    }
}

