/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.as.config;

import cz.kpsys.portaro.logging.TraceIdInterceptor;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import lombok.Generated;
import lombok.NonNull;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.NTCredentials;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.CredentialsProviderBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactoryBuilder;
import org.apache.hc.client5.http.ssl.TrustAllStrategy;
import org.apache.hc.client5.http.utils.URIUtils;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class HttpFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpFactory.class);

    public static RestOperations rest(HttpClient httpClient, Supplier<UUID> traceIdSupplier) {
        HttpComponentsClientHttpRequestFactory rf = new HttpComponentsClientHttpRequestFactory(httpClient);
        RestTemplate rest = new RestTemplate((ClientHttpRequestFactory)rf);
        rest.getInterceptors().add(new TraceIdInterceptor(traceIdSupplier));
        return rest;
    }

    public static void addProxy(HttpClientBuilder builder, String httpProxyUrl, boolean httpProxyAuth, String httpProxyUsername, String httpProxyPassword) {
        log.info(String.format("Enabling http proxy %s%s", httpProxyUrl, httpProxyAuth ? " with authorization" : ""));
        if (httpProxyAuth) {
            CredentialsProvider credsProvider = CredentialsProviderBuilder.create().add(new AuthScope(URIUtils.extractHost((URI)URI.create(Objects.requireNonNull(httpProxyUrl)))), (Credentials)new NTCredentials(Objects.requireNonNull(httpProxyUsername), Objects.requireNonNull(httpProxyPassword).toCharArray(), "", "")).build();
            builder.setDefaultCredentialsProvider(credsProvider);
        }
    }

    public static HttpClientBuilder httpClientBuilder(@NonNull String userAgent) {
        Objects.requireNonNull(userAgent, "userAgent is marked non-null but is null");
        try {
            PoolingHttpClientConnectionManager connectionManager = PoolingHttpClientConnectionManagerBuilder.create().setMaxConnTotal(100).setMaxConnPerRoute(50).setDefaultConnectionConfig(ConnectionConfig.custom().setConnectTimeout(Timeout.ofSeconds((long)10L)).setSocketTimeout(Timeout.ofSeconds((long)10L)).build()).setSSLSocketFactory((LayeredConnectionSocketFactory)SSLConnectionSocketFactoryBuilder.create().setSslContext(SSLContextBuilder.create().loadTrustMaterial((TrustStrategy)TrustAllStrategy.INSTANCE).build()).setHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).build()).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(Timeout.ofSeconds((long)10L)).build()).setPoolConcurrencyPolicy(PoolConcurrencyPolicy.STRICT).setConnPoolPolicy(PoolReusePolicy.LIFO).build();
            return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(Timeout.ofSeconds((long)5L)).build()).setDefaultHeaders(List.of(new BasicHeader("Accept-Encoding", (Object)"*"), new BasicHeader("User-Agent", (Object)userAgent)));
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Cannot create http client", e);
        }
    }
}

