/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.as.config;

import cz.kpsys.as.config.SettingKeys;
import cz.kpsys.as.licence.AuthenticatedTransactionalLicenceKeyUpdater;
import cz.kpsys.as.web.LicenceApiController;
import cz.kpsys.portaro.commons.logging.Logged;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.commons.object.repo.Saver;
import cz.kpsys.portaro.licence.DelegatingLicenceKeyUpdater;
import cz.kpsys.portaro.licence.Licence;
import cz.kpsys.portaro.licence.LicenceKeyDecoder;
import cz.kpsys.portaro.licence.LicenceKeyDecodingLicenceKeyExpiredPredicate;
import cz.kpsys.portaro.licence.LicenceKeyDecodingLicenceProvider;
import cz.kpsys.portaro.licence.LicenceKeyUpdater;
import cz.kpsys.portaro.licence.LicenceServerFetchingLicenceKeyProvider;
import cz.kpsys.portaro.licence.OnceUpdatingLicenceKeyProvider;
import cz.kpsys.portaro.licence.jwt.Auth0JwtLicenceKeyDecoder;
import cz.kpsys.portaro.setting.CustomSetting;
import cz.kpsys.portaro.setting.CustomSettingLoader;
import cz.kpsys.portaro.setting.DelegatingValueCustomSettingSaver;
import cz.kpsys.portaro.setting.SettingLoader;
import cz.kpsys.portaro.setting.SettingTypeId;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.web.client.RestOperations;

@Configuration
public class LicenceBeansConfig {
    @NonNull
    private final RestOperations rest;
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final Provider<Integer> rootDepartmentIdProvider;
    @NonNull
    private final @NonNull Provider<@NonNull String> rootSerialCodeProvider;
    @NonNull
    private final Saver<CustomSetting<String>> customSettingSaver;
    @NonNull
    private final CustomSettingLoader customSettingLoader;
    @NonNull
    private final Runnable saveTransactionAuthenticator;

    @Bean
    public LicenceApiController licenceApiController() {
        return new LicenceApiController(this.licenceProvider(), this.licenceKeyUpdater());
    }

    @Bean
    public LicenceKeyUpdater licenceKeyUpdater() {
        LicenceServerFetchingLicenceKeyProvider keyProvider = new LicenceServerFetchingLicenceKeyProvider(this.rest, this.rootSerialCodeProvider, this.settingLoader.getOnRootProvider(SettingKeys.KPSYS_API_KEY));
        DelegatingLicenceKeyUpdater delegate = new DelegatingLicenceKeyUpdater((Provider)keyProvider, this.licenceKeySaver());
        return new AuthenticatedTransactionalLicenceKeyUpdater((LicenceKeyUpdater)delegate, this.saveTransactionAuthenticator);
    }

    @Bean
    public Saver<String> licenceKeySaver() {
        return new DelegatingValueCustomSettingSaver(this.customSettingSaver, (SettingTypeId)SettingKeys.LICENCE_KEY, this.rootDepartmentIdProvider, this.customSettingLoader);
    }

    @Logged
    @Scheduled(initialDelay=180000L, fixedDelay=28800000L)
    public void updateLicenceKey() {
        this.licenceKeyUpdater().update();
    }

    @Bean
    @Scope(proxyMode=ScopedProxyMode.INTERFACES)
    public Provider<Licence> licenceProvider() {
        Auth0JwtLicenceKeyDecoder jwtLicenceKeyDecoder = Auth0JwtLicenceKeyDecoder.ofInternalPublicKey();
        return new LicenceKeyDecodingLicenceProvider((Supplier)this.jwtLicenceKeyProvider(), (LicenceKeyDecoder)jwtLicenceKeyDecoder);
    }

    @Bean
    public Provider<String> jwtLicenceKeyProvider() {
        Provider fromIniProvider = this.settingLoader.getOnRootProvider(SettingKeys.LICENCE_KEY);
        LicenceKeyDecodingLicenceKeyExpiredPredicate keyExpiredPredicate = new LicenceKeyDecodingLicenceKeyExpiredPredicate(this.licenceKeyDecoder());
        return OnceUpdatingLicenceKeyProvider.whenCurrentLicenceKeyIsNullOrIsExpired((Provider)fromIniProvider, (LicenceKeyUpdater)this.licenceKeyUpdater(), (Predicate)keyExpiredPredicate);
    }

    @Bean
    public LicenceKeyDecoder licenceKeyDecoder() {
        return Auth0JwtLicenceKeyDecoder.ofInternalPublicKey();
    }

    @ConstructorProperties(value={"rest", "settingLoader", "rootDepartmentIdProvider", "rootSerialCodeProvider", "customSettingSaver", "customSettingLoader", "saveTransactionAuthenticator"})
    @Generated
    public LicenceBeansConfig(@NonNull RestOperations rest, @NonNull SettingLoader settingLoader, @NonNull Provider<Integer> rootDepartmentIdProvider, @NonNull @NonNull Provider<@NonNull String> rootSerialCodeProvider, @NonNull Saver<CustomSetting<String>> customSettingSaver, @NonNull CustomSettingLoader customSettingLoader, @NonNull Runnable saveTransactionAuthenticator) {
        Objects.requireNonNull(rest, "rest is marked non-null but is null");
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(rootDepartmentIdProvider, "rootDepartmentIdProvider is marked non-null but is null");
        Objects.requireNonNull(rootSerialCodeProvider, "rootSerialCodeProvider is marked non-null but is null");
        Objects.requireNonNull(customSettingSaver, "customSettingSaver is marked non-null but is null");
        Objects.requireNonNull(customSettingLoader, "customSettingLoader is marked non-null but is null");
        Objects.requireNonNull(saveTransactionAuthenticator, "saveTransactionAuthenticator is marked non-null but is null");
        this.rest = rest;
        this.settingLoader = settingLoader;
        this.rootDepartmentIdProvider = rootDepartmentIdProvider;
        this.rootSerialCodeProvider = rootSerialCodeProvider;
        this.customSettingSaver = customSettingSaver;
        this.customSettingLoader = customSettingLoader;
        this.saveTransactionAuthenticator = saveTransactionAuthenticator;
    }
}

