/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.as.config;

import cz.kpsys.as.config.SettingKeys;
import cz.kpsys.db.extern.loan.DefaultExternalLoanServiceResolver;
import cz.kpsys.db.extern.loan.ExternalLoanLoanCategoryResolver;
import cz.kpsys.db.extern.loan.ExternalLoanService;
import cz.kpsys.db.extern.loan.ExternalLoanServiceResolver;
import cz.kpsys.db.extern.loan.ExternalLoanValueResolver;
import cz.kpsys.db.extern.loan.FlexibooksExternalLoanService;
import cz.kpsys.db.extern.loan.LevnaknihovnaExternalLoanService;
import cz.kpsys.db.extern.loan.MlpExternalLoanService;
import cz.kpsys.db.extern.loan.PalmknihyExternalLoanService;
import cz.kpsys.portaro.commons.contextual.ContextIgnoringContextualProvider;
import cz.kpsys.portaro.commons.contextual.ContextualProvider;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.licence.Licence;
import cz.kpsys.portaro.setting.SettingLoader;
import jakarta.validation.constraints.NotBlank;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class LoanConfig {
    @NonNull
    private final SettingLoader settingLoader;
    @NonNull
    private final Provider<Licence> licenceProvider;

    @Bean
    public ExternalLoanLoanCategoryResolver externLoanLoanCategoryResolver() {
        return new ExternalLoanLoanCategoryResolver(new ExternalLoanValueResolver(this.settingLoader.getDepartmentedProvider(SettingKeys.PALMKNIHY_LOANS_LOAN_CATEGORY_ID).throwingWhenNull().invalidWhen(String::isBlank), this.settingLoader.getDepartmentedProvider(SettingKeys.FLEXIBOOKS_LOANS_LOAN_CATEGORY_ID).throwingWhenNull().invalidWhen(String::isBlank), this.settingLoader.getDepartmentedProvider(SettingKeys.LEVNAKNIHOVNA_LOANS_LOAN_CATEGORY_ID).throwingWhenNull().invalidWhen(String::isBlank), this.settingLoader.getDepartmentedProvider(SettingKeys.MLP_LOANS_LOAN_CATEGORY_ID).throwingWhenNull().invalidWhen(String::isBlank)));
    }

    @Bean
    public ExternalLoanValueResolver<@NotBlank @NonNull String> externLoanFeedUrlResolver() {
        return new ExternalLoanValueResolver((ContextualProvider)ContextIgnoringContextualProvider.of((Object)"http://www.ereading.cz/xml/xml_rent.php"), this.settingLoader.getDepartmentedProvider(SettingKeys.FLEXIBOOKS_LOANS_FEED_URL).throwingWhenNull().invalidWhen(String::isBlank), this.settingLoader.getDepartmentedProvider(SettingKeys.LEVNAKNIHOVNA_LOANS_FEED_URL).throwingWhenNull().invalidWhen(String::isBlank), this.settingLoader.getDepartmentedProvider(SettingKeys.MLP_LOANS_LOAN_CATEGORY_ID).throwingWhenNull().invalidWhen(String::isBlank));
    }

    @Bean
    public ExternalLoanValueResolver<@NonNull BigDecimal> externalLoanPriceLimitResolver() {
        return new ExternalLoanValueResolver((ContextualProvider)ContextIgnoringContextualProvider.of((Object)BigDecimal.ZERO), this.settingLoader.getDepartmentedProvider(SettingKeys.FLEXIBOOKS_LOANS_PRICE_LIMIT), this.settingLoader.getDepartmentedProvider(SettingKeys.LEVNAKNIHOVNA_LOANS_PRICE_LIMIT), (ContextualProvider)ContextIgnoringContextualProvider.of((Object)BigDecimal.ZERO));
    }

    @Bean
    public ExternalLoanServiceResolver externalLoanServiceResolver() {
        return new DefaultExternalLoanServiceResolver().addService(this.palmknihyExternalLoanService()).addService(this.flexibooksExternalLoanService()).addService(this.levnaknihovnaExternalLoanService()).addService(this.mlpExternalLoanService());
    }

    @Bean
    public ExternalLoanService palmknihyExternalLoanService() {
        return new PalmknihyExternalLoanService(this.licenceProvider, this.settingLoader.getStaticValueMatchingContextsProvider(SettingKeys.PALMKNIHY_LOANS_ENABLED, (Object)true), this.settingLoader.getDepartmentedProvider(SettingKeys.PALMKNIHY_LOANS_ENABLED), this.settingLoader.getDepartmentedProvider(SettingKeys.PALMKNIHY_LOANS_LIBRARY_ID).throwingWhenNull().invalidWhen(String::isBlank), this.settingLoader.getDepartmentedProvider(SettingKeys.PALMKNIHY_LOANS_LOAN_CATEGORY_ID).throwingWhenNull().invalidWhen(String::isBlank));
    }

    @Bean
    public ExternalLoanService flexibooksExternalLoanService() {
        return new FlexibooksExternalLoanService(this.licenceProvider, this.settingLoader.getStaticValueMatchingContextsProvider(SettingKeys.FLEXIBOOKS_LOANS_ENABLED, (Object)true), this.settingLoader.getDepartmentedProvider(SettingKeys.FLEXIBOOKS_LOANS_ENABLED), this.settingLoader.getDepartmentedProvider(SettingKeys.FLEXIBOOKS_LOANS_EMAIL).throwingWhenNull().invalidWhen(String::isBlank));
    }

    @Bean
    public ExternalLoanService levnaknihovnaExternalLoanService() {
        return new LevnaknihovnaExternalLoanService(this.licenceProvider, this.settingLoader.getStaticValueMatchingContextsProvider(SettingKeys.LEVNAKNIHOVNA_LOANS_ENABLED, (Object)true), this.settingLoader.getDepartmentedProvider(SettingKeys.LEVNAKNIHOVNA_LOANS_ENABLED), this.settingLoader.getDepartmentedProvider(SettingKeys.LEVNAKNIHOVNA_LOANS_FEED_URL).throwingWhenNull().invalidWhen(String::isBlank));
    }

    @Bean
    public ExternalLoanService mlpExternalLoanService() {
        return new MlpExternalLoanService(this.licenceProvider, this.settingLoader.getStaticValueMatchingContextsProvider(SettingKeys.MLP_LOANS_ENABLED, (Object)true), this.settingLoader.getDepartmentedProvider(SettingKeys.MLP_LOANS_ENABLED), this.settingLoader.getDepartmentedProvider(SettingKeys.MLP_LOANS_LOAN_CATEGORY_ID).throwingWhenNull().invalidWhen(String::isBlank));
    }

    @ConstructorProperties(value={"settingLoader", "licenceProvider"})
    @Generated
    public LoanConfig(@NonNull SettingLoader settingLoader, @NonNull Provider<Licence> licenceProvider) {
        Objects.requireNonNull(settingLoader, "settingLoader is marked non-null but is null");
        Objects.requireNonNull(licenceProvider, "licenceProvider is marked non-null but is null");
        this.settingLoader = settingLoader;
        this.licenceProvider = licenceProvider;
    }
}

