/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.as.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import cz.kpsys.as.web.ApiExceptionHandler;
import cz.kpsys.as.web.RequestMappingSupportingWebMvcConfigurationSupport;
import cz.kpsys.as.web.WwwUrlEncodedFormMappingJackson2XmlHttpMessageConverter;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.support.AllEncompassingFormHttpMessageConverter;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;

@Configuration
public class WebMvcConfig
extends RequestMappingSupportingWebMvcConfigurationSupport {
    @NonNull
    private final ObjectMapper xmlMapper;
    @NonNull
    private final FormattingConversionService conversionService;

    public void extendMessageConverters(@NotNull List<HttpMessageConverter<?>> converters) {
        Stream firstLevelConverters = converters.stream();
        Stream multipartConverters = converters.stream().filter(AllEncompassingFormHttpMessageConverter.class::isInstance).map(AllEncompassingFormHttpMessageConverter.class::cast).flatMap(c -> c.getPartConverters().stream());
        Stream.concat(firstLevelConverters, multipartConverters).filter(MappingJackson2XmlHttpMessageConverter.class::isInstance).map(MappingJackson2XmlHttpMessageConverter.class::cast).forEach(c -> c.setObjectMapper(this.xmlMapper));
        converters.add((HttpMessageConverter<?>)new WwwUrlEncodedFormMappingJackson2XmlHttpMessageConverter(this.xmlMapper));
    }

    @Bean
    @NotNull
    public FormattingConversionService mvcConversionService() {
        return this.conversionService;
    }

    @Bean
    public ApiExceptionHandler apiExceptionHandler() {
        return new ApiExceptionHandler();
    }

    @ConstructorProperties(value={"xmlMapper", "conversionService"})
    @Generated
    public WebMvcConfig(@NonNull ObjectMapper xmlMapper, @NonNull FormattingConversionService conversionService) {
        Objects.requireNonNull(xmlMapper, "xmlMapper is marked non-null but is null");
        Objects.requireNonNull(conversionService, "conversionService is marked non-null but is null");
        this.xmlMapper = xmlMapper;
        this.conversionService = conversionService;
    }
}

