/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.as.loan;

import cz.kpsys.as.loan.Kat15sSlotAvailabilityRequest;
import cz.kpsys.db.model.v2.Kat1_4;
import cz.kpsys.db.model.v2.Kat1_5;
import cz.kpsys.portaro.commons.object.repo.ByIdLoadable;
import cz.kpsys.portaro.exemplar.Exemplar;
import cz.kpsys.portaro.loan.availability.timeslot.SlotAvailabilityResolver;
import cz.kpsys.portaro.loan.availability.timeslot.TimeslotAvailabilityResult;
import cz.kpsys.portaro.record.Record;
import cz.kpsys.portaro.user.BasicUser;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.core.convert.converter.Converter;

public class DelegatingKat15BasedSlotAvailabilityResolver {
    @NonNull
    private final SlotAvailabilityResolver slotAvailabilityResolver;
    @NonNull
    private final Converter<Kat1_5, Exemplar> kat15ToExemplarConverter;
    @NonNull
    private final Converter<Kat1_4, Record> kat14ToRecordMapper;
    @NonNull
    private final ByIdLoadable<BasicUser, Integer> basicUserLoader;

    public TimeslotAvailabilityResult resolve(@NonNull Kat15sSlotAvailabilityRequest request) {
        Objects.requireNonNull(request, "request is marked non-null but is null");
        List<Exemplar> exemplars = request.getKat15s().stream().map(source -> Objects.requireNonNull((Exemplar)this.kat15ToExemplarConverter.convert(source))).toList();
        BasicUser user = request.getUserId() == null ? null : (BasicUser)this.basicUserLoader.getById((Object)request.getUserId());
        Record document = Objects.requireNonNull((Record)this.kat14ToRecordMapper.convert((Object)request.getKat14()));
        return this.slotAvailabilityResolver.resolve(user, document, exemplars, request.getRequestDepartment(), request.getPeriod());
    }

    @ConstructorProperties(value={"slotAvailabilityResolver", "kat15ToExemplarConverter", "kat14ToRecordMapper", "basicUserLoader"})
    @Generated
    public DelegatingKat15BasedSlotAvailabilityResolver(@NonNull SlotAvailabilityResolver slotAvailabilityResolver, @NonNull Converter<Kat1_5, Exemplar> kat15ToExemplarConverter, @NonNull Converter<Kat1_4, Record> kat14ToRecordMapper, @NonNull ByIdLoadable<BasicUser, Integer> basicUserLoader) {
        Objects.requireNonNull(slotAvailabilityResolver, "slotAvailabilityResolver is marked non-null but is null");
        Objects.requireNonNull(kat15ToExemplarConverter, "kat15ToExemplarConverter is marked non-null but is null");
        Objects.requireNonNull(kat14ToRecordMapper, "kat14ToRecordMapper is marked non-null but is null");
        Objects.requireNonNull(basicUserLoader, "basicUserLoader is marked non-null but is null");
        this.slotAvailabilityResolver = slotAvailabilityResolver;
        this.kat15ToExemplarConverter = kat15ToExemplarConverter;
        this.kat14ToRecordMapper = kat14ToRecordMapper;
        this.basicUserLoader = basicUserLoader;
    }
}

