/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.as.web;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import cz.kpsys.portaro.commons.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.json.AbstractJackson2HttpMessageConverter;
import org.springframework.util.Assert;

public class WwwUrlEncodedFormMappingJackson2XmlHttpMessageConverter
extends AbstractJackson2HttpMessageConverter {
    public WwwUrlEncodedFormMappingJackson2XmlHttpMessageConverter(ObjectMapper objectMapper) {
        super(objectMapper, MediaType.APPLICATION_FORM_URLENCODED);
        Assert.isInstanceOf(XmlMapper.class, (Object)objectMapper, (String)"XmlMapper required");
    }

    public Object read(Type type, Class<?> contextClass, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        JavaType javaType = this.getJavaType(type, contextClass);
        return this.readJavaType(javaType, inputMessage);
    }

    protected Object readInternal(Class<?> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        JavaType javaType = this.getJavaType(clazz, null);
        return this.readJavaType(javaType, inputMessage);
    }

    private Object readJavaType(JavaType javaType, HttpInputMessage inputMessage) throws IOException {
        try {
            String encodedBody = IOUtils.toString((InputStream)inputMessage.getBody(), (Charset)StandardCharsets.UTF_8);
            String decodedBody = URLDecoder.decode(encodedBody, StandardCharsets.UTF_8.name());
            String xml = StringUtil.removePrefix((String)decodedBody, (String)"data=");
            return this.defaultObjectMapper.readValue(xml, javaType);
        }
        catch (InvalidDefinitionException ex) {
            throw new HttpMessageConversionException("Type definition error: " + ex.getType(), (Throwable)ex);
        }
        catch (JsonProcessingException ex) {
            throw new HttpMessageNotReadableException("JSON parse error: " + ex.getOriginalMessage(), (Throwable)ex, inputMessage);
        }
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        throw new IllegalStateException("Use constructor injection");
    }
}

