/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.db;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DbHelpers {
    static final Pattern p = Pattern.compile("[^[a-z][A-Z][0-9]_]");

    public static boolean isValidSQLName(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        Matcher m = p.matcher(name);
        return !m.matches();
    }

    public static String generateQuestionMarks(int count) {
        if (count < 10) {
            switch (count) {
                case 1: {
                    return "?";
                }
                case 2: {
                    return "?,?";
                }
                case 3: {
                    return "?,?,?";
                }
                case 4: {
                    return "?,?,?,?";
                }
                case 5: {
                    return "?,?,?,?,?";
                }
                case 6: {
                    return "?,?,?,?,?,?";
                }
                case 7: {
                    return "?,?,?,?,?,?,?";
                }
                case 8: {
                    return "?,?,?,?,?,?,?,?";
                }
                case 9: {
                    return "?,?,?,?,?,?,?,?,?";
                }
            }
            return "";
        }
        StringBuilder sb = new StringBuilder("?");
        for (int i = 1; i < count; ++i) {
            sb.append(",?");
        }
        return sb.toString();
    }
}

