/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.db;

import cz.kpsys.AppServerStatus;
import cz.kpsys.db.BeanHandlers;
import cz.kpsys.db.DatabaseEngine;
import cz.kpsys.db.DbCache2;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.GenericExecutor;
import cz.kpsys.db.ProxoolUtil;
import cz.kpsys.db.model.DbUpdateInput;
import cz.kpsys.db.model.DbUpdateOutput;
import cz.kpsys.db.model.v2.DbUpdate;
import cz.kpsys.db.model.v2.DefAkce;
import cz.kpsys.db.model.v2.DefUziv;
import cz.kpsys.service.Utils;
import java.sql.SQLException;
import java.text.ParseException;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DbUpdateExecutor
extends GenericExecutor {
    private static final int AKCE_4631 = 4631;
    private static final Logger logger = LoggerFactory.getLogger(DbUpdateExecutor.class);
    final DbUpdateInput input;
    final DbUpdateOutput output = new DbUpdateOutput();
    private QueryRunner qr;

    public DbUpdateExecutor(DbCore2 core2, DbUpdateInput input) {
        this.input = input;
        this.core2 = core2;
    }

    public static DbUpdateInput parseDbUpdateInput(Document doc, DbCore2 core2) throws ParseException, SQLException {
        String prefix = "//collection/db_update/";
        DbUpdateInput dbUpdateInput = new DbUpdateInput();
        dbUpdateInput.idZmeny = Long.parseLong(DbUpdateExecutor.parseTag((Document)doc, (String)"//collection/db_update/ID_ZMENY"));
        return dbUpdateInput;
    }

    public DbUpdateOutput dbUpdate() throws SQLException, AppServerStatus {
        this.qr = this.core2.obtainQueryRunnerOpened();
        DbUpdate dbUpdate = (DbUpdate)this.qr.query("SELECT * FROM DB_UPDATE WHERE ID_DBUPDATE=?", (ResultSetHandler)BeanHandlers.dbUpdateHandler(), new Object[]{this.input.idZmeny});
        if (dbUpdate == null) {
            throw new AppServerStatus("radek neexistuje", 1);
        }
        String vysledekPoprve = dbUpdate.getVYSLEDEK_POPRVE();
        String vysledekOpak = dbUpdate.getVYSLEDEK_OPAK();
        if (StringUtils.isNotBlank((CharSequence)vysledekPoprve) && vysledekPoprve.toUpperCase().startsWith("OK") || StringUtils.isNotBlank((CharSequence)vysledekOpak) && vysledekOpak.toUpperCase().startsWith("OK")) {
            throw new AppServerStatus("radek uz byl uspesne vykonan", 2);
        }
        if (!this.maPravoProvestAkci()) {
            throw new AppServerStatus("nemate pravo provest akci", 3);
        }
        try {
            String command = Utils.prevedNaCisteSQL((String)dbUpdate.getPRIKAZ(), (DatabaseEngine)ProxoolUtil.engine());
            this.output.fkUzivOpak = this.core2.fkUziv();
            this.qr.update(command);
            this.output.vysledekOpak = "OK";
            this.zapisVysledekDoDb(this.qr, dbUpdate);
        }
        catch (SQLException se) {
            String message = se.getMessage();
            this.output.vysledekOpak = "KO - " + message;
            this.zapisVysledekDoDb(this.qr, dbUpdate);
            AppServerStatus ase = new AppServerStatus("nepodarilo se provest radek", 4);
            ase.addReturnValue("EXCEPTION", message);
            throw ase;
        }
        return this.output;
    }

    private void zapisVysledekDoDb(QueryRunner qr, DbUpdate dbUpdate) throws SQLException {
        qr.update("UPDATE DB_UPDATE SET DATCAS_OPAK=" + Utils.todayNowString((int)2, (DatabaseEngine)ProxoolUtil.engine()) + ", FK_UZIV_OPAK=?, VYSLEDEK_OPAK=? WHERE ID_DBUPDATE=?", new Object[]{this.output.fkUzivOpak, StringUtils.left((String)this.output.vysledekOpak, (int)1024), dbUpdate.getID_DBUPDATE()});
        this.core2.commit();
    }

    private boolean maPravoProvestAkci() throws SQLException, AppServerStatus {
        int fkUziv = this.core2.fkUziv();
        DefUziv uziv = (DefUziv)DbCache2.uzivMap.get(fkUziv);
        if (uziv == null || !uziv.getJE_POVOL()) {
            throw new AppServerStatus("neco je s uzivatelem v neporadku", 3);
        }
        if (uziv.getUROVEN() == 0) {
            return true;
        }
        DefAkce defAkce = (DefAkce)this.qr.query("SELECT * FROM AKCE_PRAVA WHERE FK_AKCE=? AND CIS_UZIVGROUP=?", (ResultSetHandler)BeanHandlers.defAkceHandler(), new Object[]{4631, fkUziv});
        return defAkce != null && defAkce.getDEF_POVOL() != 0;
    }
}

