/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.db;

import cz.kpsys.AppServerStatus;
import cz.kpsys.common.Licensing;
import cz.kpsys.db.BeanHandlers;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.ExternVsbExecutor;
import cz.kpsys.db.GenericExecutor;
import cz.kpsys.db.model.ExternKontoInput;
import cz.kpsys.db.model.ExternKontoOutput;
import cz.kpsys.db.model.v2.Ctenari;
import cz.kpsys.db.model.v2.Osoby;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExternKontoExecutor
extends GenericExecutor {
    private static final Logger logger = LoggerFactory.getLogger(ExternKontoExecutor.class);
    final ExternKontoInput input;
    private ExternKontoOutput output;

    public ExternKontoExecutor(DbCore2 core2, ExternKontoInput input) {
        this.core2 = core2;
        this.input = input;
    }

    public static ExternKontoInput parseExternKontoInput(Document doc, DbCore2 core2) throws ParseException, SQLException {
        Element rootNode = doc.getRootElement();
        String prefix = "//collection/extern_konto/";
        ExternKontoInput externKontoInput = new ExternKontoInput();
        externKontoInput.idCten = ExternKontoExecutor.parseCtenTag((Document)doc, (String)"//collection/extern_konto/ID_CTEN", (boolean)false);
        return externKontoInput;
    }

    public ExternKontoOutput externKonto() throws AppServerStatus, SQLException {
        BigDecimal zustatek;
        String netId;
        ExternVsbExecutor executor;
        this.output = new ExternKontoOutput();
        this.qr = this.core2.obtainQueryRunnerOpened();
        if (Licensing.isVSB()) {
            executor = new ExternVsbExecutor();
            Ctenari ctenar = (Ctenari)this.qr.query("SELECT * FROM CTENARI WHERE FK_UZIV=?", (ResultSetHandler)BeanHandlers.ctenariHandler(), new Object[]{this.input.idCten});
            Osoby osoba = (Osoby)this.qr.query("SELECT * FROM OSOBY WHERE FK_UZIV=?", (ResultSetHandler)BeanHandlers.osobyHandler(), new Object[]{this.input.idCten});
            if (ctenar == null) {
                throw new AppServerStatus("ctenar nenalezen v DB Verbis", 1);
            }
            netId = osoba.getNET_ID();
            if (StringUtils.isBlank((CharSequence)netId)) {
                throw new AppServerStatus("ctenar ma prazdne netid", 2);
            }
        } else {
            throw new AppServerStatus("neplatna instituce, API nepodporovano", 1);
        }
        this.output.stavKonta = zustatek = executor.vsbZustatekKonta(netId);
        if (this.output.stavKonta == null) {
            throw new AppServerStatus("nepodarilo se zjistit zustatek " + this.input, 2);
        }
        return this.output;
    }
}

