/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.db;

import cz.kpsys.AppServerStatus;
import cz.kpsys.common.CiselnikCZEM;
import cz.kpsys.db.BeanHandlers;
import cz.kpsys.db.DatabaseEngine;
import cz.kpsys.db.DbCache2;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.DbHelper;
import cz.kpsys.db.ExternVSBExecutorNG;
import cz.kpsys.db.ExternVsbExecutor;
import cz.kpsys.db.GeneratorKlicu;
import cz.kpsys.db.GenericExecutor;
import cz.kpsys.db.ProxoolUtil;
import cz.kpsys.db.QueryRunnerOpened;
import cz.kpsys.db.model.ExternCtenInput;
import cz.kpsys.db.model.ExternCtenModel;
import cz.kpsys.db.model.ExternCtenOutput;
import cz.kpsys.db.model.v2.Ctenari;
import cz.kpsys.db.model.v2.DefPoplVsb;
import cz.kpsys.db.model.v2.LogAuto;
import cz.kpsys.db.model.v2.vsb.VsbDefFormaStudia;
import cz.kpsys.db.model.v2.vsb.VsbDefVztahuniv;
import cz.kpsys.db.model.v2.vsb.VsbVztahy;
import cz.kpsys.kpwin2.XMLService;
import cz.kpsys.kpwin2.rest.KPWINServiceApplication;
import cz.kpsys.service.DateConversions;
import cz.kpsys.service.OkHttpClientFactory;
import cz.kpsys.service.Utils;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Credentials;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.core5.http.HttpException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternVsbExecutor {
    final Logger logger = LoggerFactory.getLogger(ExternVsbExecutor.class);
    private static final int ERR4_IGNORUJ_PRAZDNY_TYPUZIV = 4;
    private static final int ERR4_IGNORUJ_NEPLATNOU_KATEGORII = 4;
    private static final String TYP_UZIV = "TYP_UZIV";
    private static final int ERR3_PROBLEM_KOMUNIKACE = 3;
    private static final int HTTP_200_OK = 200;
    private static final String APPLICATION_SOAP_XML = "text/xml";
    private static final int ERR1_ID_NEPREDANO = 1;
    private static final String PRE_STAT = "PRE_STAT";
    private static final String TRV_STAT = "TRV_STAT";
    private static final String EMAIL_KOPIE = "EMAIL_KOPIE";
    private static final String NET_ID = "NET_ID";
    private static final String VZTAH_UNIV = "VZTAH_UNIV";
    private static final String TITUL_ZA = "TITUL_ZA";
    private static final String EMAIL_ZAKZAST = "EMAIL_ZAKZAST";
    private static final String FORMA_STUDIA = "FORMA_STUDIA";
    final String platbyZarizeni = "UK-platby";
    final String globalPrefix = "//Envelope/Body/findReaderInfoResponse/person";
    final String getPersonSoapTemplate = "<soapenv:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:urn=\"urn:srvUK\">   <soapenv:Header/>   <soapenv:Body>      <urn:GetPerson soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">         <idf xsi:type=\"xsd:string\">%s</idf>         <amt xsi:type=\"xsd:integer\" xsi:nil=\"true\"></amt>         <zarizeni xsi:type=\"xsd:string\">%s</zarizeni>      </urn:GetPerson>   </soapenv:Body></soapenv:Envelope>";
    final String findUpdatedPeopleTemplate = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:per=\"http://edison.vsb.cz/PersonWS/\">\n   <soapenv:Header/>\n   <soapenv:Body>\n  \t<per:findUpdatedPeople>\n     \t<updatedMin>%s</updatedMin>\n  \t</per:findUpdatedPeople>\n   </soapenv:Body>\n</soapenv:Envelope>";
    final String prehledBlokaciSoapTemplate = "<soapenv:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:urn=\"urn:srvUK\">   <soapenv:Header/>   <soapenv:Body>      <urn:PrehledBlokaci soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"/>   </soapenv:Body></soapenv:Envelope>";
    final String uzavriTransakciSoapTemplate = "<soapenv:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:urn=\"urn:srvUK\">   <soapenv:Header/>   <soapenv:Body>      <urn:UzavriTransakci soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">         <id_operace xsi:type=\"xsd:integer\">%s</id_operace>         <id_sortiment xsi:type=\"xsd:integer\">%d</id_sortiment>         <mnozstvi xsi:type=\"xsd:integer\">%d</mnozstvi>         <cena xsi:type=\"xsd:double\">%s</cena>         <zarizeni xsi:type=\"xsd:string\">%s</zarizeni>      </urn:UzavriTransakci>   </soapenv:Body></soapenv:Envelope>";
    final String zalozTransakciSoapTemplate = "<soapenv:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:urn=\"urn:srvUK\">   <soapenv:Header/>   <soapenv:Body>      <urn:ZalozTransakci soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">         <idf xsi:type=\"xsd:string\">%s</idf>         <amt xsi:type=\"xsd:integer\"  xsi:nil=\"true\"></amt>         <blokace xsi:type=\"xsd:double\">%s</blokace>         <zarizeni xsi:type=\"xsd:string\">%s</zarizeni>      </urn:ZalozTransakci>   </soapenv:Body></soapenv:Envelope>";
    final String zmenTransakciSoapTemplate = "<soapenv:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:urn=\"urn:srvUK\">   <soapenv:Header/>   <soapenv:Body>      <urn:ZmenTransakci soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">         <id_operace xsi:type=\"xsd:integer\">?</id_operace>         <blokace xsi:type=\"xsd:double\">?</blokace>      </urn:ZmenTransakci>   </soapenv:Body></soapenv:Envelope>";
    final String findReaderInfoSoapTemplate = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:per=\"http://edison.vsb.cz/PersonWS/\">\t   <soapenv:Header/>\t   <soapenv:Body>\t      <per:findReaderInfo>\t         <login>%s</login>\t      </per:findReaderInfo>\t   </soapenv:Body>\t</soapenv:Envelope>";
    private DbCore2 core2;
    private ExternCtenInput inputExternCten;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String dotazNaPaymentService(String soapMessage) throws AppServerStatus, HttpException, IOException, DocumentException, ParseException {
        String responseString;
        String username = "verbis";
        String password = Utils.decodeString((String)"d3MsdmVyLkJJUw==");
        String url = DbCache2.vsbExternConfig.getString("ext_platby.url", "https://karty.vsb.cz/UKtest/srvUK.php");
        String completeMessage = soapMessage;
        this.logger.debug("dotaz na externi sluzbu URL: " + url);
        this.logger.debug("dotaz na externi sluzbu zprava: " + completeMessage);
        OkHttpClient client = OkHttpClientFactory.clientByURL((String)url);
        try {
            RequestBody requestBody = RequestBody.create((String)completeMessage, (MediaType)MediaType.parse((String)APPLICATION_SOAP_XML));
            Request request = new Request.Builder().url(url).addHeader("Authorization", Credentials.basic((String)username, (String)password)).addHeader("SOAPAction", "\"urn:ukAction\"").post(requestBody).build();
            Call call = client.newCall(request);
            Response response = call.execute();
            responseString = response.body().string();
            int responseCode = response.code();
            if (responseCode != 200) {
                this.logger.error("chybovy navratovy kod z volani VSB WS " + completeMessage);
                this.logger.error("odpoved kod: " + response.code());
                this.logger.error("odpoved telo: " + responseString);
            } else {
                this.logger.debug("odpoved kod: " + response.code());
                this.logger.debug("odpoved telo: " + responseString);
            }
            response.close();
        }
        finally {
            client.dispatcher().executorService().shutdown();
        }
        return responseString;
    }

    public VysledekTransakce vsbZalozTransakci(String idf, BigDecimal castka) {
        VysledekTransakce vysledekTransakce = new VysledekTransakce(this);
        BigDecimal zustatekKonta = this.vsbZustatekKonta(idf);
        if (zustatekKonta == null || zustatekKonta.compareTo(castka) < 0) {
            vysledekTransakce.ok = false;
            vysledekTransakce.transakceZalozena = false;
            vysledekTransakce.message = "zustatek konta je nedostatecny (nebo se jej nepodarilo zjistit)";
        } else {
            String request = String.format("<soapenv:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:urn=\"urn:srvUK\">   <soapenv:Header/>   <soapenv:Body>      <urn:ZalozTransakci soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">         <idf xsi:type=\"xsd:string\">%s</idf>         <amt xsi:type=\"xsd:integer\"  xsi:nil=\"true\"></amt>         <blokace xsi:type=\"xsd:double\">%s</blokace>         <zarizeni xsi:type=\"xsd:string\">%s</zarizeni>      </urn:ZalozTransakci>   </soapenv:Body></soapenv:Envelope>", idf, castka.toPlainString(), "UK-platby");
            try {
                String responseStringRaw = this.dotazNaPaymentService(request);
                if (StringUtils.isNotBlank((CharSequence)responseStringRaw)) {
                    String responseString = XMLService.cleanSOAPResponse((String)responseStringRaw);
                    Document doc = XMLService.getDocument((String)responseString);
                    String header = "//Envelope/Body/ZalozTransakciResponse";
                    Node errorTextNode = doc.getRootElement().selectSingleNode("//Envelope/Body/ZalozTransakciResponse/errtxt");
                    String errorText = null;
                    if (errorTextNode != null) {
                        errorText = errorTextNode.getText();
                    }
                    if (StringUtils.isNotBlank(errorText)) {
                        String errorMessage = "problem pri zalozeni transakce, chybova zprava " + errorText;
                        this.logger.error(errorMessage);
                        vysledekTransakce.ok = false;
                        vysledekTransakce.message = errorMessage;
                    }
                    Long idOperace = Long.parseLong(doc.getRootElement().selectSingleNode("//Envelope/Body/ZalozTransakciResponse/id_operace").getText());
                    vysledekTransakce.idTransakce = idOperace;
                }
            }
            catch (Exception e) {
                this.logger.error("selhani", (Throwable)e);
                vysledekTransakce.ok = false;
                vysledekTransakce.message = e.toString();
            }
        }
        return vysledekTransakce;
    }

    public BigDecimal vsbZustatekKonta(String idf) {
        String request = String.format("<soapenv:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:urn=\"urn:srvUK\">   <soapenv:Header/>   <soapenv:Body>      <urn:GetPerson soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">         <idf xsi:type=\"xsd:string\">%s</idf>         <amt xsi:type=\"xsd:integer\" xsi:nil=\"true\"></amt>         <zarizeni xsi:type=\"xsd:string\">%s</zarizeni>      </urn:GetPerson>   </soapenv:Body></soapenv:Envelope>", idf, "UK-platby");
        try {
            String responseStringRaw = this.dotazNaPaymentService(request);
            String responseString = XMLService.cleanSOAPResponse((String)responseStringRaw);
            Document doc = XMLService.getDocument((String)responseString);
            Node zustatekNode = doc.getRootElement().selectSingleNode("//Envelope/Body/GetPersonResponse/zustatek");
            if (zustatekNode != null) {
                BigDecimal zustatek = new BigDecimal(zustatekNode.getText());
                return zustatek;
            }
        }
        catch (Exception e) {
            this.logger.error("selhani", (Throwable)e);
        }
        return null;
    }

    public Short zjistiIdTransakce(short fkDekPopl) throws SQLException {
        QueryRunner qr = ProxoolUtil.obtainQueryRunnerRO();
        DefPoplVsb defPoplVsb = (DefPoplVsb)qr.query("SELECT * FROM DEF_POPL_VSB WHERE FK_POPL=?", (ResultSetHandler)new BeanHandler(DefPoplVsb.class), new Object[]{fkDekPopl});
        if (defPoplVsb != null) {
            return defPoplVsb.getFK_POPL_VSB();
        }
        return null;
    }

    public int vsbUzavriTransakci(long idOperace, short idSortiment, BigDecimal cena) {
        int retVal = -1;
        NumberFormat castkaFormat = NumberFormat.getInstance(Locale.ROOT);
        String request = String.format("<soapenv:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:urn=\"urn:srvUK\">   <soapenv:Header/>   <soapenv:Body>      <urn:UzavriTransakci soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">         <id_operace xsi:type=\"xsd:integer\">%s</id_operace>         <id_sortiment xsi:type=\"xsd:integer\">%d</id_sortiment>         <mnozstvi xsi:type=\"xsd:integer\">%d</mnozstvi>         <cena xsi:type=\"xsd:double\">%s</cena>         <zarizeni xsi:type=\"xsd:string\">%s</zarizeni>      </urn:UzavriTransakci>   </soapenv:Body></soapenv:Envelope>", Long.toString(idOperace), idSortiment, 1, castkaFormat.format(cena), "UK-platby");
        try {
            String responseStringRaw = this.dotazNaPaymentService(request);
            String responseString = XMLService.cleanSOAPResponse((String)responseStringRaw);
            Document doc = XMLService.getDocument((String)responseString);
            String header = "//Envelope/Body/UzavriTransakciResponse";
            Node errorTextNode = doc.getRootElement().selectSingleNode("//Envelope/Body/UzavriTransakciResponse/errtxt");
            String errorText = null;
            if (errorTextNode != null) {
                errorText = errorTextNode.getText();
            }
            if (StringUtils.isNotBlank(errorText)) {
                this.logger.error("problem pri uzavreni transakce, chybova zprava " + errorText);
            } else {
                retVal = Integer.parseInt(doc.getRootElement().selectSingleNode("//Envelope/Body/UzavriTransakciResponse/res").getText());
            }
        }
        catch (Exception e) {
            this.logger.error("selhani", (Throwable)e);
        }
        return retVal;
    }

    public ExternCtenOutput externCten(ExternCtenInput input, DbCore2 core2, ExternCtenOutput output) throws AppServerStatus, HttpException, IOException, DocumentException, ParseException {
        return output;
    }

    private void zpracujVztah(DbCore2 core2, ExternCtenInput input, ExternCtenOutput output) {
        this.logger.warn("zpracovani vztahu " + input + " " + output);
        if (output.getNalezeniCtenari().isEmpty()) {
            this.logger.warn("ctenar v UNISu nenalezen, koncim");
            return;
        }
        long idVztahu = 0L;
        try {
            Date datReg;
            Date ctenarKonReg;
            ExternCtenModel ctenar = (ExternCtenModel)output.getNalezeniCtenari().get(0);
            String netId = (String)ctenar.getCustomMap().get(NET_ID);
            String relationIdString = (String)ctenar.getCustomMap().get("relationId");
            ctenar.getCustomMap().remove("relationId");
            if (StringUtils.isBlank((CharSequence)relationIdString)) {
                return;
            }
            idVztahu = Long.parseLong(relationIdString);
            String konRegString = (String)ctenar.getCustomMap().get("KON_REG");
            this.logger.warn("udaje ctenare NET_ID:" + netId + " ID_VZTAHU:" + idVztahu + " KON_REG:" + konRegString);
            try {
                ctenarKonReg = Utils.sdfSQLDate().parse(konRegString);
            }
            catch (ParseException e) {
                this.logger.warn("nepodarilo se nacist datum konce registrace " + konRegString);
                return;
            }
            QueryRunnerOpened qr = core2.obtainQueryRunnerOpened();
            VsbVztahy vsbVztahy = (VsbVztahy)qr.query("SELECT * FROM VSB_VZTAHY WHERE ID_VZTAHU=?", (ResultSetHandler)new BeanHandler(VsbVztahy.class), new Object[]{idVztahu});
            int fkUziv = (Integer)qr.query("SELECT FK_UZIV FROM OSOBY WHERE NET_ID=?", (ResultSetHandler)BeanHandlers.INTEGER_HANDLER(), new Object[]{netId});
            Ctenari Ctenari2 = (Ctenari)qr.query("SELECT * FROM CTENARI WHERE FK_UZIV=?", (ResultSetHandler)BeanHandlers.ctenariHandler(), new Object[]{fkUziv});
            boolean datumSeLisiOdDB = true;
            if (Ctenari2 == null) {
                try {
                    datReg = Utils.sdfSQLDate().parse((String)ctenar.getCustomMap().get("DAT_REG"));
                }
                catch (NullPointerException | ParseException e) {
                    datReg = Utils.today();
                }
            } else {
                datReg = Ctenari2.getDAT_REG();
                datumSeLisiOdDB = false;
            }
            if (vsbVztahy == null) {
                qr.update("INSERT INTO VSB_VZTAHY (NET_ID, ID_VZTAHU, DAT_KON, DAT_REG) VALUES (?,?,?,?)", new Object[]{netId, idVztahu, Utils.util2sqlDate((Date)ctenarKonReg), Utils.util2sqlDate((Date)datReg)});
                datReg = Utils.today();
            } else {
                String datKonString;
                String ctenarKonRegString = Utils.sdfSQLDate().format(ctenarKonReg);
                if (ctenarKonRegString.equals(datKonString = Utils.sdfSQLDate().format(vsbVztahy.getDAT_KON()))) {
                    boolean datumySeLisi = false;
                    if (vsbVztahy.getDAT_REG() != null) {
                        datReg = vsbVztahy.getDAT_REG();
                    }
                } else {
                    boolean datumySeLisi = true;
                    datReg = Utils.today();
                    vsbVztahy.setDAT_KON(ctenarKonReg);
                    qr.update("UPDATE VSB_VZTAHY SET DAT_KON=?, DAT_REG=? WHERE NET_ID=? AND ID_VZTAHU=?", new Object[]{Utils.util2sqlDate((Date)vsbVztahy.getDAT_KON()), Utils.util2sqlDate((Date)datReg), vsbVztahy.getNET_ID(), vsbVztahy.getID_VZTAHU()});
                }
            }
            if (datumSeLisiOdDB) {
                ctenar.getCustomMap().put("DAT_REG", Utils.sdfSQLDate().format(datReg));
            } else {
                ctenar.getCustomMap().remove("DAT_REG");
            }
        }
        catch (Exception e) {
            this.logger.error("P: zpracovani vztahu ctenare " + idVztahu, (Throwable)e);
        }
    }

    private Map<String, String> parseElements(Document doc, String prefix, String[] elements) {
        HashMap<String, String> elementsMap = new HashMap<String, String>();
        for (String element : elements) {
            elementsMap.put(element, Utils.parseTag((Document)doc, (String)("//Envelope/Body/findReaderInfoResponse/person" + prefix + "/" + element)));
        }
        return elementsMap;
    }

    private String nl(String s) {
        return s == null ? "" : s;
    }

    private String nullJoin(String separator, String ... arguments) {
        StringBuilder sb = new StringBuilder();
        for (String s : arguments) {
            if (s == null) continue;
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public void soapVSBParserFindPersonInfo(ExternCtenInput input, String response, ExternCtenOutput output) throws DocumentException, ParseException, AppServerStatus {
        String relationTypeId;
        String endDate;
        Document doc = XMLService.getDocument((String)XMLService.cleanNamespaceVSB((String)response));
        ExternCtenModel model = new ExternCtenModel();
        Map coreMap = this.parseElements(doc, "", new String[]{"login", "firstName", "lastName", "degreeBefore", "degreeAfter", "birthDate", "citizenshipCode", "email", "phone", "privatePhone", "privateEmail", "chipNum1"});
        String login = StringUtils.lowerCase((String)((String)coreMap.get("login")));
        boolean pripisovatPrechodneBydliste = true;
        if (StringUtils.isBlank((CharSequence)login)) {
            return;
        }
        output.getNalezeniCtenari().add(model);
        String firstName = (String)coreMap.get("firstName");
        String lastName = (String)coreMap.get("lastName");
        String birthDate = (String)coreMap.get("birthDate");
        String citizenshipCode = (String)coreMap.get("citizenshipCode");
        String degreeBefore = (String)coreMap.get("degreeBefore");
        String degreeAfter = (String)coreMap.get("degreeAfter");
        String chipNum1 = (String)coreMap.get("chipNum1");
        model.getCustomMap().put("CISLO_KARTY", chipNum1);
        String zeme = CiselnikCZEM.najdiZemi((String)citizenshipCode);
        String email = (String)coreMap.get("email");
        String privateEmail = (String)coreMap.get("privateEmail");
        model.getCustomMap().put(EMAIL_KOPIE, privateEmail);
        String phone = (String)coreMap.get("phone");
        model.getCustomMap().put("TELEFON", phone);
        String privatePhone = (String)coreMap.get("privatePhone");
        model.setMobil(privatePhone);
        Map relationMap = this.parseElements(doc, "/relations/relation", new String[]{"relationId", "relationTypeId", "beginDate", "endDate", "orgUnitAbbrev", "orgUnitTitle", "workplaceAbbrev", "studyTypeId", "studyTypeCode", "studyFormId", "studyFormCode", "studyProgrammeCode", "studyProgrammeTitle", "studyBranchCode", "studyBranchTitle", "studyResidency", "studyInterruption"});
        String orgUnitAbbrev = (String)relationMap.get("orgUnitAbbrev");
        String studyResidency = (String)relationMap.get("studyResidency");
        model.getCustomMap().put("relationId", (String)relationMap.get("relationId"));
        String beginDate = (String)relationMap.get("beginDate");
        if (StringUtils.isNotBlank((CharSequence)beginDate)) {
            Date datum = this.parseVSBDate(beginDate);
            model.getCustomMap().put("DAT_REG", Utils.sdfSQLDate().format(datum));
        }
        if (StringUtils.isNotBlank((CharSequence)(endDate = (String)relationMap.get("endDate")))) {
            try {
                SimpleDateFormat vsbDate = new SimpleDateFormat("yyyy-MM-dd");
                Date datum = vsbDate.parse(endDate);
                model.getCustomMap().put("KON_REG", Utils.sdfSQLDate().format(datum));
                if (datum.before(Utils.today())) {
                    model.setUzivatelNeaktivni(true);
                }
            }
            catch (Exception e) {
                this.logger.warn("parsovani endDate (" + endDate + ") u ctenare " + login, (Throwable)e);
            }
        } else {
            model.setUzivatelNeaktivni(true);
        }
        Date studyInterruption = this.parseVSBDate((String)relationMap.get("studyInterruption"));
        String studyFormCode = (String)relationMap.get("studyFormCode");
        if (StringUtils.isNotBlank((CharSequence)studyFormCode)) {
            model.getCustomMap().put(FORMA_STUDIA, ((VsbDefFormaStudia)DbCache2.vsbDefFormaStudiaMap.get(studyFormCode)).getPOPIS());
        }
        if (StringUtils.isNotBlank((CharSequence)(relationTypeId = (String)relationMap.get("relationTypeId")))) {
            model.getCustomMap().put(VZTAH_UNIV, ((VsbDefVztahuniv)DbCache2.vsbDefVztahunivMap.get(Short.parseShort(relationTypeId))).getID_VZTAHUNIV());
        }
        String vzdelani = this.nullJoin(" / ", new String[]{(String)relationMap.get("orgUnitAbbrev"), (String)relationMap.get("orgUnitTitle")});
        model.getCustomMap().put("VZDELANI", vzdelani);
        String studyFormCodeDate = this.nullJoin(" ", new String[]{studyFormCode, studyInterruption == null ? "" : "(p\u0159er. " + Utils.sdfHumanDate().format(studyInterruption) + ")"});
        String trida = this.nullJoin(" / ", new String[]{studyFormCodeDate, (String)relationMap.get("studyTypeCode")});
        if (StringUtils.isNotBlank((CharSequence)trida)) {
            model.getCustomMap().put("TRIDA", trida);
        }
        String[] addressElementsSet = new String[]{"street", "number", "city", "zipCode", "country", "countryCode"};
        Map residencyAddressMap = this.parseElements(doc, "/residencyAddress", addressElementsSet);
        Map mailingAddressMap = this.parseElements(doc, "/mailingAddress", addressElementsSet);
        if (pripisovatPrechodneBydliste) {
            model.setPreUl(this.nullJoin(" ", new String[]{(String)mailingAddressMap.get("street"), (String)mailingAddressMap.get("number")}));
            model.setPreMi(this.nullJoin(" / ", new String[]{(String)mailingAddressMap.get("city")}));
            model.setPrePsc(this.nullJoin(" ", new String[]{(String)mailingAddressMap.get("zipCode")}));
            model.getCustomMap().put(PRE_STAT, (String)mailingAddressMap.get("country"));
        }
        model.setTrvUl(this.nullJoin(" ", new String[]{(String)residencyAddressMap.get("street"), (String)residencyAddressMap.get("number")}));
        model.setTrvMi(this.nullJoin(" / ", new String[]{(String)residencyAddressMap.get("city")}));
        model.setTrvPsc(this.nullJoin(" ", new String[]{(String)residencyAddressMap.get("zipCode")}));
        model.getCustomMap().put(TRV_STAT, (String)residencyAddressMap.get("country"));
        model.setJmeno(firstName);
        model.setPrijmeni(lastName);
        model.setTitul(degreeBefore);
        model.getCustomMap().put(TITUL_ZA, degreeAfter);
        model.setDatNar((Date)Utils.util2sqlDate((Date)this.parseVSBDate(birthDate)));
        model.setEmail(email);
        model.getCustomMap().put(EMAIL_KOPIE, privateEmail);
        model.setUid(login);
        model.getCustomMap().put(NET_ID, login);
        this.nastavJmenoPrijmeniTitul(model);
        boolean ignorujPrazdne = input.ignoreList.contains(4);
        String ctenKat = DbCache2.vsbNajdiCtenKat((String)relationTypeId, (String)orgUnitAbbrev, (String)studyResidency, (boolean)ignorujPrazdne);
        if (ctenKat != null) {
            model.setTypUziv(ctenKat);
        }
    }

    private Map<String, String> parsujMapu(Document doc, String prefix, String[] strings) {
        return null;
    }

    public Date parseVSBDate(String stringDate) throws ParseException {
        if (stringDate != null) {
            try {
                SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd");
                Date date = sdfDate.parse(stringDate);
                return date;
            }
            catch (Exception e) {
                this.logger.warn("selhalo parsovani vsb data: " + stringDate, (Throwable)e);
            }
        }
        return null;
    }

    public void aktualizaceUzivatelu() throws SQLException {
    }

    private void logujSeznamId(Date datum, List<String> netIDs) {
        StringBuilder sb = new StringBuilder("seznam ctenaru k aktualizaci pro den " + datum + "\n");
        sb.append(StringUtils.join(netIDs, (String)";") + "\n");
        this.logger.warn(sb.toString());
    }

    private Date zjistiDatumPosledniAktualizaceCtenaruVSB() throws SQLException {
        QueryRunner qr = ProxoolUtil.obtainQueryRunnerRO();
        LogAuto logAuto = (LogAuto)qr.query(DbHelper.limitOffset((String)"SELECT * FROM LOG_AUTO WHERE ID=2 AND NAZEV='AktualizaceCtenVSBOK' ORDER BY LAST_DATE DESC", (int)1, (int)0, (DatabaseEngine)KPWINServiceApplication.dbConfig.dbEngine()), (ResultSetHandler)BeanHandlers.logAutoHandler());
        if (logAuto == null) {
            return DateConversions.localDate2utilDate((LocalDate)LocalDate.now().plusMonths(-3L));
        }
        return logAuto.getLAST_DATE();
    }

    public void nastavKonReg(Ctenari ctenar, boolean anonymizovanyCtenar, ExternCtenModel nalezenyCtenar) {
        Date vcera = GenericExecutor.addDays((Date)Utils.today(), (int)-1);
        if (nalezenyCtenar.isUzivatelNeaktivni()) {
            this.logger.warn("srazim registraci neaktivniho ctenare " + ctenar);
            ctenar.setKON_REG((Date)Utils.util2sqlDate((Date)vcera));
        } else if (anonymizovanyCtenar && ctenar.getKON_REG().after(vcera)) {
            this.logger.warn("srazim registraci anonymizovaneho ctenare " + ctenar);
            ctenar.setKON_REG((Date)Utils.util2sqlDate((Date)vcera));
        }
    }

    private String slozJmenoPrijmeniTitul(String jmeno, String prijmeni, String titul, String titulZa) {
        String jmenoPrijmeniTitul = StringUtils.left((String)Utils.concat((String)(prijmeni + " " + jmeno), (String)Utils.concat((String)titul, (String)titulZa, (String)" "), (String)", ").trim(), (int)60);
        return jmenoPrijmeniTitul;
    }

    public void nastavJmenoPrijmeniTitul(Ctenari ctenar) {
        ExternVSBExecutorNG.nastavJmenoPrijmeniTitul((Ctenari)ctenar);
    }

    public void nastavJmenoPrijmeniTitul(ExternCtenModel ctenModel) {
        String jmenoPrijmeniTitul = this.slozJmenoPrijmeniTitul(ctenModel.getJmeno(), ctenModel.getPrijmeni(), ctenModel.getTitul(), (String)ctenModel.getCustomMap().get(TITUL_ZA));
        ctenModel.getCustomMap().put("TRIDJMENO", StringUtils.upperCase((String)jmenoPrijmeniTitul));
        ctenModel.getCustomMap().put("FLATJMENO", GeneratorKlicu.odstranDiakritikuAUpperCase((String)jmenoPrijmeniTitul));
    }

    void nastavProperty(String sourceProperty, String destProperty, ExternCtenModel sourceBean, Object destBean) {
        try {
            Object value;
            if (sourceProperty.startsWith("customMap(")) {
                String key = StringUtils.removeEnd((String)StringUtils.removeStart((String)sourceProperty, (String)"customMap("), (String)")");
                value = sourceBean.getCustomMap().get(key.toUpperCase());
                if ("kon_reg".equalsIgnoreCase(key) && value != null) {
                    value = Utils.util2sqlDate((Date)Utils.sdfSQLDate().parse((String)value));
                }
            } else {
                value = PropertyUtils.getProperty((Object)sourceBean, (String)sourceProperty);
            }
            if (value == null || value instanceof String && StringUtils.isBlank((CharSequence)((String)value))) {
                return;
            }
            try {
                PropertyUtils.setProperty((Object)destBean, (String)destProperty, (Object)value);
            }
            catch (Exception e) {
                this.logger.error("P: prenos property z beanu na bean / ZAPIS " + sourceProperty + " -> " + destProperty + " " + sourceBean + " " + destBean, (Throwable)e);
            }
        }
        catch (Exception e) {
            this.logger.error("P: prenos property z beanu na bean / CTENI " + sourceProperty + " -> " + destProperty + " " + sourceBean + " " + destBean, (Throwable)e);
        }
    }

    private void nastavBudovyCtenare(QueryRunner qr, Ctenari ctenar) throws SQLException {
        int idCten = ctenar.getFK_UZIV();
        for (int i = 1; i <= 5; ++i) {
            qr.update("UPDATE OR INSERT INTO VAZ_CTEN_PUJC (FK_UZIV_CTEN, FK_PUJC) VALUES (?, ?) MATCHING (FK_UZIV_CTEN, FK_PUJC)", new Object[]{idCten, i});
        }
    }
}

