/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.db;

import cz.kpsys.AppServerStatus;
import cz.kpsys.common.Licensing;
import cz.kpsys.db.DbCache;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.ExternVsbExecutor;
import cz.kpsys.db.GenericExecutor;
import cz.kpsys.db.model.ExternZaplatInput;
import cz.kpsys.db.model.ExternZaplatOutput;
import cz.kpsys.db.model.v2.Osoby;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExternZaplatExecutor
extends GenericExecutor {
    private static final int ERR6_NEPLATNA_INSTITUCE = 6;
    private static final Logger logger = LoggerFactory.getLogger(ExternZaplatExecutor.class);
    final ExternZaplatInput input;
    private ExternZaplatOutput output;

    public ExternZaplatExecutor(DbCore2 core2, ExternZaplatInput input) {
        this.core2 = core2;
        this.input = input;
    }

    public static ExternZaplatInput parseExternZaplatInput(Document doc, DbCore2 core2) throws ParseException, SQLException, AppServerStatus {
        Element rootNode = doc.getRootElement();
        String prefix = "//collection/extern_zaplat/";
        ExternZaplatInput externZaplatInput = new ExternZaplatInput();
        externZaplatInput.idCten = ExternZaplatExecutor.parseCtenTag((Document)doc, (String)"//collection/extern_zaplat/ID_CTEN", (boolean)false);
        List nodes = doc.getRootElement().selectNodes("//collection/extern_zaplat/PLATBA");
        for (Node n : nodes) {
            ExternZaplatInput.Platba platba = new ExternZaplatInput.Platba(externZaplatInput);
            platba.typ = Short.parseShort(n.selectSingleNode("TYP").getText());
            platba.castka = new BigDecimal(n.selectSingleNode("CASTKA").getText());
            externZaplatInput.platby.add(platba);
        }
        if (externZaplatInput.platby.size() == 0) {
            throw new AppServerStatus("neplatny vstup - nezadana zadna platba", 2);
        }
        return externZaplatInput;
    }

    public ExternZaplatOutput externZaplat() throws AppServerStatus, SQLException {
        this.output = new ExternZaplatOutput();
        this.qr = this.core2.obtainQueryRunnerOpened();
        if (!Licensing.isVSB()) {
            throw new AppServerStatus("neplatna instituce, API nepodporovano", 6);
        }
        this.zaplatVsb();
        return this.output;
    }

    private void zaplatVsb() throws AppServerStatus, SQLException {
        String netId = this.zjistiNetId(this.input.idCten);
        if (StringUtils.isBlank((CharSequence)netId)) {
            throw new AppServerStatus("nepodarilo se zjistit NET_ID ctenare v interni DB " + this.input.idCten, 1);
        }
        for (ExternZaplatInput.Platba platba : this.input.platby) {
            ExternVsbExecutor executor = new ExternVsbExecutor();
            Short fkPoplVsbIdTrans = executor.zjistiIdTransakce(platba.typ);
            if (fkPoplVsbIdTrans == null) {
                throw new AppServerStatus("typ platby nema odpovidajici hodnotu v DEF_POPL_VSB: " + platba.typ, 2);
            }
            ExternVsbExecutor.VysledekTransakce vysledekTransakce = executor.vsbZalozTransakci(netId, platba.castka);
            int retVal = vysledekTransakce.transakceZalozena ? executor.vsbUzavriTransakci(vysledekTransakce.idTransakce, fkPoplVsbIdTrans.shortValue(), platba.castka) : -1;
            if (!vysledekTransakce.ok) {
                throw new AppServerStatus("externi system neprovedl platbu s chybou " + vysledekTransakce.message, 4);
            }
            if (retVal == 0) continue;
            throw new AppServerStatus("pri placeni pozadavku " + platba + " byl vracen nenulovy kod " + retVal, 4);
        }
    }

    private String zjistiNetId(int fkUziv) throws SQLException {
        Osoby osoba = DbCache.osoba((int)fkUziv);
        if (osoba != null) {
            return osoba.getNET_ID();
        }
        return null;
    }
}

