/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.db;

import cz.kpsys.common.IniConstants;
import cz.kpsys.common.Licensing;
import cz.kpsys.common.NullHashMap;
import cz.kpsys.db.BeanHandlers;
import cz.kpsys.db.DatabaseEngine;
import cz.kpsys.db.DbCache;
import cz.kpsys.db.DbCache2;
import cz.kpsys.db.DbCache2NG;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.DbCore2Utils;
import cz.kpsys.db.GenericExecutorScala;
import cz.kpsys.db.KPSYSBeanListHandler;
import cz.kpsys.db.OverRezeExecutor;
import cz.kpsys.db.OverRezeExecutorNarArch;
import cz.kpsys.db.ProxoolUtil;
import cz.kpsys.db.QueryRunnerOpened;
import cz.kpsys.db.ScalaRunnerOpened;
import cz.kpsys.db.model.v2.Ctenari;
import cz.kpsys.db.model.v2.DefCtenKat;
import cz.kpsys.db.model.v2.DefCtenVyp;
import cz.kpsys.db.model.v2.DefFond;
import cz.kpsys.db.model.v2.DefLokace;
import cz.kpsys.db.model.v2.DefPujc;
import cz.kpsys.db.model.v2.DefStatus;
import cz.kpsys.db.model.v2.DefUziv;
import cz.kpsys.db.model.v2.DefVypKat;
import cz.kpsys.db.model.v2.Kat1_5;
import cz.kpsys.db.model.v2.Svatek;
import cz.kpsys.db.model.v2.Vypuc;
import cz.kpsys.db.model.v2.Vypuc2;
import cz.kpsys.db.model.v2.VypucTitPer;
import cz.kpsys.service.DateConversions;
import cz.kpsys.service.TaskQueueManagerNG;
import cz.kpsys.service.Utils;
import cz.kpsys.service.cache.RecordIdCache;
import jakarta.validation.constraints.NotNull;
import java.sql.SQLException;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.Iterable;
import scala.collection.JavaConverters;

/*
 * Exception performing whole class analysis ignored.
 */
public class GenericExecutor {
    public static final int NEODESLANA_REZERVACE = 51;
    public static final int NEVYRIZENA_OBJEDNAVKA = 53;
    public static final int ODESLANA_REZERVACE = 52;
    public static final int PRIPRAVENA_MVS = 55;
    public static final int VYRIZENA_OBJEDNAVKA = 54;
    private static final Logger logger = LoggerFactory.getLogger(GenericExecutor.class);
    private static final int LIMIT_POSUNUTI = 180;
    protected DbCore2 core2;
    protected DefCtenKat ctenKat;
    protected DefCtenVyp ctenVyp;
    protected QueryRunner qr;
    protected DefVypKat vypKat;
    protected Map<String, Object> cache = new NullHashMap();
    Set<Short> bratZ = new HashSet();
    Set<Short> posilatNa = new HashSet();
    public static final String superUserUsername = "SU";

    public static List<Short> parsePujcovny(String pujcovny, Set<Short> povolenePujcovny) {
        LinkedList<Short> budovyListPomocne = new LinkedList<Short>();
        if (StringUtils.isNotBlank((CharSequence)pujcovny)) {
            StringTokenizer st = new StringTokenizer(pujcovny, ";");
            while (st.hasMoreTokens()) {
                Short idPujcovna = Short.parseShort(st.nextToken());
                budovyListPomocne.add(idPujcovna);
            }
        } else {
            budovyListPomocne.addAll(JavaConverters.asJavaCollection((Iterable)((scala.collection.immutable.Map)DbCache2NG.pujcovnyMap().get()).values()).stream().map(DefPujc::getID_PUJC).toList());
        }
        ArrayList<Short> pujcovnyList = new ArrayList<Short>(budovyListPomocne.size());
        for (Short pujcovna : budovyListPomocne) {
            if (povolenePujcovny != null && povolenePujcovny.size() != 0 && !povolenePujcovny.contains(pujcovna)) continue;
            pujcovnyList.add(pujcovna);
        }
        return pujcovnyList;
    }

    public static String parseTag(Document doc, String tagName) {
        return Utils.parseTag((Document)doc, (String)tagName);
    }

    public static String parseTag(Document doc, String tagName, String defaultValue) {
        return Utils.parseTag((Document)doc, (String)tagName, (String)defaultValue);
    }

    private static Integer nullCtenValid(boolean nullCtenValid) {
        if (nullCtenValid) {
            return null;
        }
        throw new IllegalArgumentException("neplatna hodnota tagu ID[FK]_CTEN");
    }

    public static Integer parseCtenTag(Document doc, String tagName, boolean isNullCtenValid) {
        String nullString = Utils.parseAttribute((Document)doc, (String)tagName, (String)"null", (String)"false");
        if ("true".equalsIgnoreCase(nullString)) {
            return GenericExecutor.nullCtenValid((boolean)isNullCtenValid);
        }
        String tagContent = Utils.parseTag((Document)doc, (String)tagName, null);
        if (StringUtils.isBlank((CharSequence)tagContent)) {
            return GenericExecutor.nullCtenValid((boolean)isNullCtenValid);
        }
        return Integer.parseInt(tagContent);
    }

    public static boolean tagHasTrueValue(String tagValue) {
        return "1".equals(tagValue) || "true".equalsIgnoreCase(tagValue) || "ano".equalsIgnoreCase(tagValue) || "yes".equalsIgnoreCase(tagValue);
    }

    public static boolean tagHasFalseValue(String tagValue) {
        return "0".equals(tagValue) || "false".equalsIgnoreCase(tagValue) || "ne".equalsIgnoreCase(tagValue) || "no".equalsIgnoreCase(tagValue);
    }

    public static boolean parseBooleanTag(Document doc, String tagName, boolean defaultValue) {
        String tagValue = Utils.parseTag((Document)doc, (String)tagName, (String)"");
        if (defaultValue) {
            return !StringUtils.isNotBlank((CharSequence)tagValue) || !GenericExecutor.tagHasFalseValue((String)tagValue);
        }
        return StringUtils.isNotBlank((CharSequence)tagValue) && GenericExecutor.tagHasTrueValue((String)tagValue);
    }

    public static String parseAttribute(Document doc, String tagName, String attributeName, String defaultValue) {
        return Utils.parseAttribute((Document)doc, (String)tagName, (String)attributeName, (String)defaultValue);
    }

    static short parsujPujcovnu(Document doc) {
        try {
            Node pujcovnaNode = doc.getRootElement().selectSingleNode("//collection/pujcovna");
            if (pujcovnaNode != null) {
                return Short.parseShort(pujcovnaNode.getText());
            }
            return (Short)DbCache.rootPujcovna().get();
        }
        catch (Exception e) {
            logger.debug("id pujcovny se nepovedlo rozklicovat, vracim 1");
            return (Short)DbCache.rootPujcovna().get();
        }
    }

    public static Date addDays(Date originalDate, int daysShift) {
        return DateConversions.localDateTime2utilDate((LocalDateTime)DateConversions.utilDate2localDateTime((Date)originalDate).plusDays(daysShift));
    }

    public static Date addHours(Date originalDate, int hoursShift) {
        return DateConversions.localDateTime2utilDate((LocalDateTime)DateConversions.utilDate2localDateTime((Date)originalDate).plusHours(hoursShift));
    }

    public static long insertIntoVypuc2(QueryRunner qr, Vypuc2 vypuc2, short fkPujcZmena) throws SQLException {
        boolean isFirebird = ProxoolUtil.engine() == DatabaseEngine.FIREBIRD;
        String todayString = Utils.todayNowString((int)1, (DatabaseEngine)ProxoolUtil.engine());
        long vypucId = ((QueryRunnerOpened)qr).queryUOI(isFirebird, "INSERT INTO VYPUC2 (FK_UZIV_CTEN, RECORD_ID, FK_ZAZ, FK_EX, OZNAC, CIS_REZE, DAT_VYP, DAT_PROL, DAT_VR, POC_PROL, DOB_VYP, CENA,  FK_TEMSKUP, FK_LOKACE, FK_VYPKAT, CIS_UPOM, ZPET_KATAL, FK_PUJC, FK_TYPPUJC, FK_PUJC_ZMENA) VALUES (?,?,?,?,?,?," + todayString + "," + todayString + "," + (vypuc2.getDAT_VR() == null ? "NULL" : todayString) + ",?,?,?,?,?,?,?,?,?,?,?) RETURNING ID_VYPUC", new Object[]{vypuc2.getFK_UZIV_CTEN(), vypuc2.getRECORD_ID(), RecordIdCache.recId2fkZaz((String)vypuc2.getRECORD_ID()), vypuc2.getFK_EX(), vypuc2.getOZNAC(), vypuc2.getCIS_REZE(), vypuc2.getPOC_PROL(), vypuc2.getDOB_VYP(), vypuc2.getCENA(), vypuc2.getFK_TEMSKUP(), vypuc2.getFK_LOKACE(), vypuc2.getFK_VYPKAT(), vypuc2.getCIS_UPOM(), vypuc2.getZPET_KATAL(), vypuc2.getFK_PUJC(), vypuc2.getFK_TYPPUJC(), fkPujcZmena});
        vypuc2.setID_VYPUC(vypucId);
        return vypucId;
    }

    public static boolean jeSvatekNeboNelzePujcovatVracet(Date date, DefCtenVyp ctenVyp) {
        Svatek svatek = new Svatek();
        svatek.setSvatek(date);
        if (((scala.collection.immutable.Set)DbCache2NG.svatkySet().get()).contains((Object)svatek)) {
            return true;
        }
        if (ctenVyp == null) {
            return false;
        }
        if (!ctenVyp.isKALENDAR()) {
            return false;
        }
        LocalDate dtFrom = DateConversions.utilDate2localDate((Date)date);
        DayOfWeek denVTydnu = dtFrom.getDayOfWeek();
        return denVTydnu == DayOfWeek.MONDAY && !ctenVyp.isPOND() || denVTydnu == DayOfWeek.TUESDAY && !ctenVyp.isUTER() || denVTydnu == DayOfWeek.WEDNESDAY && !ctenVyp.isSTRE() || denVTydnu == DayOfWeek.THURSDAY && !ctenVyp.isCTVR() || denVTydnu == DayOfWeek.FRIDAY && !ctenVyp.isPATE() || denVTydnu == DayOfWeek.SATURDAY && !ctenVyp.isSOBO() || denVTydnu == DayOfWeek.SUNDAY && !ctenVyp.isNEDE();
    }

    public static DefCtenVyp nactiKombinaciCtenKatVypKat(DefCtenKat ctenKat, DefVypKat vypKat) {
        if (vypKat == null || ctenKat == null) {
            throw new IllegalArgumentException("nejsou nastavene vstupni promenne idCtenKat a/nebo idVypKat");
        }
        logger.debug("nacitam kombinaci pro ctenKat a vypKat " + ctenKat + " / " + vypKat);
        List kombinace = DbCache2.ctenVypList;
        logger.debug("v pameti je nyni celkem kombinaci " + kombinace.size());
        DefCtenVyp ctenVyp = null;
        int shodaLevel = 0;
        for (DefCtenVyp ctenVypTemp : kombinace) {
            if (ctenKat.getID_CTENKAT().equals(ctenVypTemp.getFK_CTENKAT()) && vypKat.getID_VYPKAT().equals(ctenVypTemp.getFK_VYPKAT())) {
                ctenVyp = ctenVypTemp;
                break;
            }
            if (ctenVypTemp.getFK_CTENKAT() == null && vypKat.getID_VYPKAT().equals(ctenVypTemp.getFK_VYPKAT())) {
                if (shodaLevel >= 3) continue;
                shodaLevel = 3;
                ctenVyp = ctenVypTemp;
                continue;
            }
            if (ctenKat.getID_CTENKAT().equals(ctenVypTemp.getFK_CTENKAT()) && ctenVypTemp.getFK_VYPKAT() == null) {
                if (shodaLevel >= 2) continue;
                shodaLevel = 2;
                ctenVyp = ctenVypTemp;
                continue;
            }
            if (ctenVypTemp.getFK_CTENKAT() != null || ctenVypTemp.getFK_VYPKAT() != null || shodaLevel >= 1) continue;
            shodaLevel = 1;
            ctenVyp = ctenVypTemp;
        }
        logger.info("zvolene pravidlo " + ctenVyp);
        return ctenVyp;
    }

    public static int spoctiPracovniDnyMeziDaty(Date dateFrom, Date dateTo, DefCtenVyp ctenVyp) {
        int pocitadloDni = 0;
        if (GenericExecutor.jeSvatekNeboNelzePujcovatVracet((Date)dateFrom, (DefCtenVyp)ctenVyp)) {
            pocitadloDni = -1;
        }
        LocalDate dtFrom = DateConversions.utilDate2localDate((Date)dateFrom);
        LocalDate dtTo = DateConversions.utilDate2localDate((Date)dateTo);
        while (dtFrom.isBefore(dtTo)) {
            if (GenericExecutor.jeSvatekNeboNelzePujcovatVracet((Date)DateConversions.localDate2utilDate((LocalDate)(dtFrom = dtFrom.plusDays(1L))), (DefCtenVyp)ctenVyp)) continue;
            ++pocitadloDni;
        }
        if (pocitadloDni < 0) {
            pocitadloDni = 0;
        }
        return pocitadloDni;
    }

    @NotNull
    protected static Set<Short> seznamPujcovenCtenare(Integer fkCten, Short fkPujc, boolean vynutitPujcovnyKlienta) throws SQLException {
        return GenericExecutorScala.seznamPujcovenCtenare((Integer)fkCten, (short)fkPujc, (boolean)vynutitPujcovnyKlienta);
    }

    public static HashMap<String, String> tokenizujHlaseni(String initKlic) {
        HashMap<String, String> mapa = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)initKlic)) {
            return mapa;
        }
        StringTokenizer st = new StringTokenizer(initKlic, "|");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            try {
                int index = token.indexOf(35);
                if (index <= 0) continue;
                String key = token.substring(0, index);
                String value = token.substring(index + 1);
                mapa.put(key, value);
            }
            catch (Exception e) {
                logger.warn("chyba behem tokenizace: " + token);
            }
        }
        return mapa;
    }

    public void setCache(Map<String, Object> cache) {
        this.cache = cache;
    }

    protected int posunDnyOPripadneSvatkyAZavreno(Date puvodniDatum, int pocDni, DefCtenVyp ctenVyp) {
        if (puvodniDatum == null || pocDni < 0) {
            return pocDni;
        }
        int puvodniPocDni = pocDni;
        Date datumVraceni = GenericExecutor.addDays((Date)puvodniDatum, (int)pocDni);
        while (GenericExecutor.jeSvatekNeboNelzePujcovatVracet((Date)datumVraceni, (DefCtenVyp)ctenVyp) && pocDni < 180) {
            datumVraceni = GenericExecutor.addDays((Date)puvodniDatum, (int)(++pocDni));
        }
        if (pocDni >= 180) {
            pocDni = puvodniPocDni;
        }
        return pocDni;
    }

    private boolean lzePujcit(DefCtenVyp ctenVyp2) {
        return ctenVyp2.isJE_PUJC();
    }

    private boolean lzeRezervovat(DefCtenVyp ctenVyp2) {
        return ctenVyp2.isJE_REZE();
    }

    public static Ctenari nactiCtenare(int fkUzivCten) throws SQLException {
        Ctenari cten;
        try {
            cten = (Ctenari)DbCache2.ctenariCache.get((Object)fkUzivCten);
        }
        catch (ExecutionException e) {
            logger.error("ctenar " + fkUzivCten + " nenalezen, chovam se jako by ctenar nebyl prihlasen", (Throwable)e);
            throw new SQLException("neplatne ID ctenare: " + fkUzivCten);
        }
        return cten;
    }

    public static DefCtenKat nactiCtenKat(String fkCtenKat) {
        DefCtenKat ctenKat = (DefCtenKat)((Map)DbCache2NG.ctenKatMap().get()).get(fkCtenKat);
        if (ctenKat == null) {
            logger.warn("neplatne CTENKAT ID: " + fkCtenKat);
        }
        return ctenKat;
    }

    public static DefFond nactiDokFond(short fkDokFond) throws SQLException {
        DefFond dokFond = (DefFond)DbCache2.defDokFondMap.get(fkDokFond);
        if (dokFond == null) {
            throw new SQLException("Neexistujici dok DEF_FOND ID: " + fkDokFond);
        }
        return dokFond;
    }

    public DefLokace nactiLokaci(int fkLokace) throws SQLException {
        DefLokace lokace = (DefLokace)DbCache2.lokaceMap.get(fkLokace);
        if (lokace == null) {
            throw new SQLException("neplatne ID lokace: " + fkLokace);
        }
        return lokace;
    }

    public DefPujc nactiPrvniPujcovnu(short fkBudova) throws SQLException {
        return DbCache2.prvniPujcovnaNaBudove((short)fkBudova);
    }

    public DefPujc nactiPujcovnu(short fkPujc) throws SQLException {
        DefPujc pujcovna = (DefPujc)((scala.collection.immutable.Map)DbCache2NG.pujcovnyMap().get()).apply((Object)fkPujc);
        if (pujcovna == null) {
            throw new SQLException("neplatne ID pujcovny: " + fkPujc);
        }
        return pujcovna;
    }

    public DefStatus nactiStatus(short fkStatus) throws SQLException {
        DefStatus status = (DefStatus)((Map)DbCache2NG.statusMap().get()).get(fkStatus);
        if (status == null) {
            throw new SQLException("neplatny STATUS  ID: " + fkStatus);
        }
        return status;
    }

    protected HashMap<Kat1_5, Vypuc> nactiVsechnyExemplareAVypujcky(long idZaz) throws SQLException {
        String recordId = RecordIdCache.fkZaz2recIdDoc((long)idZaz);
        HashMap<Kat1_5, Vypuc> exempVypuc = new HashMap<Kat1_5, Vypuc>();
        List exemplare = (List)this.qr.query("SELECT * FROM KAT1_5 WHERE RECORD_ID=? AND FK_UBYTEK IS NULL ORDER BY ID_EX DESC", (ResultSetHandler)BeanHandlers.kat1_5BLH(), new Object[]{recordId});
        for (Kat1_5 exemplar : exemplare) {
            Vypuc vypuc = (Vypuc)this.qr.query("SELECT * FROM VYPUC WHERE FK_EX=?", (ResultSetHandler)BeanHandlers.vypucHandler(), new Object[]{exemplar.getID_EX()});
            exempVypuc.put(exemplar, vypuc);
        }
        return exempVypuc;
    }

    public DefVypKat nactiVypKat(String fkVypKat) throws SQLException {
        DefVypKat vypKat = (DefVypKat)((Map)DbCache2NG.vypKatMap().get()).get(fkVypKat);
        return vypKat;
    }

    public boolean overKombinaciCtenKatAVypKat(boolean vypujcka, DefCtenVyp ctenVyp) throws SQLException {
        if (ctenVyp != null) {
            return vypujcka && this.lzePujcit(ctenVyp) || !vypujcka && this.lzeRezervovat(ctenVyp);
        }
        return false;
    }

    public boolean overZdaPolozkaExistujeVSeznamu(String seznam, String polozka) {
        if (seznam == null || polozka == null) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(seznam, "|,");
        while (st.hasMoreTokens()) {
            if (!st.nextToken().equals(polozka)) continue;
            return true;
        }
        return false;
    }

    protected Date prictiDny(Date baseDate, int diff) {
        Calendar c = Calendar.getInstance();
        c.setTime(baseDate);
        c.add(5, diff);
        return c.getTime();
    }

    @Deprecated
    public Vypuc sklepejRezervaceExemplar(Long idEx) throws SQLException {
        if (idEx == null || idEx == 0L) {
            return null;
        }
        logger.info("sklepavam rezervace pro exemplar " + idEx);
        KPSYSBeanListHandler seznamRezervaciBeanHandler = new KPSYSBeanListHandler(Vypuc.class);
        List seznamRezervaci = (List)this.qr.query("SELECT * FROM VYPUC WHERE FK_EX=? AND CIS_REZE BETWEEN 1 AND 50 ORDER BY CIS_REZE, DATCAS", (ResultSetHandler)seznamRezervaciBeanHandler, new Object[]{idEx});
        ArrayList<Vypuc> rezervaceKUpdate = new ArrayList<Vypuc>(seznamRezervaci.size());
        int uk = 1;
        for (Vypuc vypuc : seznamRezervaci) {
            if (uk != vypuc.getCIS_REZE()) {
                vypuc.setCIS_REZE(Short.valueOf((short)uk));
                rezervaceKUpdate.add(vypuc);
            }
            if ((uk = (short)(uk + 1)) <= 50) continue;
            uk = 50;
        }
        for (Vypuc vypucZapis : rezervaceKUpdate) {
            this.qr.update("UPDATE VYPUC2 SET CIS_REZE=? WHERE ID_VYPUC=?", new Object[]{vypucZapis.getCIS_REZE(), vypucZapis.getFK_VYPUC()});
        }
        if (seznamRezervaci.isEmpty()) {
            return null;
        }
        return (Vypuc)seznamRezervaci.get(0);
    }

    @Deprecated
    public Vypuc sklepejRezervaceTitul(long idZaz) throws SQLException {
        KPSYSBeanListHandler seznamRezervaciBeanHandler = new KPSYSBeanListHandler(Vypuc.class);
        List seznamRezervaci = (List)this.qr.query("SELECT * FROM VYPUC WHERE FK_ZAZ=? AND FK_EX IS NULL AND CIS_REZE BETWEEN 1 AND 50 ORDER BY CIS_REZE, DATCAS", (ResultSetHandler)seznamRezervaciBeanHandler, new Object[]{idZaz});
        logger.info("sklepavam rezervace na titul " + idZaz);
        ArrayList<Vypuc> rezervaceKUpdate = new ArrayList<Vypuc>(seznamRezervaci.size());
        int uk = 1;
        for (Vypuc vypuc : seznamRezervaci) {
            if (uk != vypuc.getCIS_REZE()) {
                vypuc.setCIS_REZE(Short.valueOf((short)uk));
                rezervaceKUpdate.add(vypuc);
            }
            if ((uk = (short)(uk + 1)) <= 50) continue;
            uk = 50;
        }
        for (Vypuc vypucZapis : rezervaceKUpdate) {
            this.qr.update("UPDATE VYPUC2 SET CIS_REZE=? WHERE ID_VYPUC=?", new Object[]{vypucZapis.getCIS_REZE(), vypucZapis.getFK_VYPUC()});
        }
        if (seznamRezervaci.isEmpty()) {
            return null;
        }
        return (Vypuc)seznamRezervaci.get(0);
    }

    public void zapisDoVypucTitPer(VypucTitPer vypucTitPer) throws SQLException {
        this.qr.update("INSERT INTO VYPUC_TITPER (DATUM, FK_VYPUC, ZMENA) VALUES (?,?,?);", new Object[]{Utils.util2sqlDate((Date)vypucTitPer.getDATUM()), vypucTitPer.getFK_VYPUC(), vypucTitPer.getZMENA()});
    }

    public String zjistiANaplnIdentifikatorExemplare(Kat1_5 kat1_5) {
        String defaultIdentifikator = DbCache2.queryINIFlag((String)IniConstants.SEKCE_VYPUC(), (String)IniConstants.VYPUC_DEFAULTIDENTIFIKATOR(), null, (Short)kat1_5.getFK_DOKFOND());
        String identifikator = null;
        if ("BC".equalsIgnoreCase(defaultIdentifikator)) {
            identifikator = kat1_5.getBAR_COD();
        } else if ("SIGN".equalsIgnoreCase(defaultIdentifikator)) {
            identifikator = kat1_5.getSIGNATURA();
        } else if ("PRIC".equalsIgnoreCase(defaultIdentifikator)) {
            identifikator = kat1_5.getPRIR_CISLO();
        }
        if (StringUtils.isBlank((CharSequence)identifikator) && StringUtils.isBlank((CharSequence)(identifikator = kat1_5.getSIGNATURA())) && StringUtils.isBlank((CharSequence)(identifikator = kat1_5.getPRIR_CISLO()))) {
            identifikator = kat1_5.getBAR_COD();
        }
        return identifikator;
    }

    protected DefUziv nactiUziv(int idUziv, ScalaRunnerOpened qr) throws SQLException {
        return DbCore2Utils.nactiDefUziv((int)idUziv, (ScalaRunnerOpened)qr);
    }

    protected boolean zjistiZdaSoucasnyUzivatelMaMensiNeboRovneOpravneniNez(int intValue) throws SQLException {
        DefUziv uziv = this.nactiUziv(this.core2.getSessionData().getUcode(), this.core2.obtainScalaRunnerOpened());
        return uziv.getUROVEN() <= intValue;
    }

    protected Vypuc2 nactiVypujcku(long idVyp) throws SQLException {
        return DbCore2Utils.nactiVypuc2((long)idVyp, (ScalaRunnerOpened)this.core2.obtainScalaRunnerOpened());
    }

    protected void filtrujExemplarePodlePujcoven(List<Kat1_5> seznamExemplaru, Set<Short> seznamPovolenychPujcoven) {
        if (seznamPovolenychPujcoven == null) {
            return;
        }
        ArrayList<Kat1_5> seznamExemplaruKeSmazani = new ArrayList<Kat1_5>(seznamExemplaru.size());
        for (Kat1_5 exemplar : seznamExemplaru) {
            if (seznamPovolenychPujcoven.contains(exemplar.getFK_PUJC())) continue;
            seznamExemplaruKeSmazani.add(exemplar);
        }
        seznamExemplaru.removeAll(seznamExemplaruKeSmazani);
    }

    protected void initVirtualniPujcovny(Short dokFond, List<Short> budovy) {
        this.bratZ.clear();
        budovy.forEach(b -> this.bratZ.addAll(OverRezeExecutor.vydejniBudovyZdroj((Short)dokFond, (Short)b)));
        this.posilatNa.clear();
        budovy.forEach(b -> this.posilatNa.addAll(OverRezeExecutor.vydejniBudovyCil((Short)dokFond, (Short)b)));
    }

    protected boolean pozadovanaVirtualniPujcovna(List<Short> pujcovny) {
        for (Short budova : pujcovny) {
            if (!this.posilatNa.contains(budova)) continue;
            return true;
        }
        return false;
    }

    protected void kontrolaReindexace(QueryRunner qr, String recordId) throws SQLException {
        if (DbCache2.pritomenVypujcniRez) {
            TaskQueueManagerNG.zapisPozadavekNaReindexRecId((String)recordId, (short)2, (boolean)false, (ScalaRunnerOpened)((QueryRunnerOpened)qr).toScalaRunnerOpened());
        }
    }

    public static boolean preskocitExemplar(Ctenari cten, Kat1_5 exemplar, Boolean moznoPrez) throws SQLException {
        if (moznoPrez != null) {
            if (StringUtils.isBlank((CharSequence)exemplar.getFK_VYPKAT())) {
                return true;
            }
            Optional<Boolean> jePrez = GenericExecutor.jePrez((Ctenari)cten, (Kat1_5)exemplar);
            if (jePrez.isEmpty()) {
                return true;
            }
            if (Licensing.isNarArchiv()) {
                boolean jeZam = OverRezeExecutorNarArch.jeZamestnanec((int)cten.getFK_UZIV());
                jePrez = jeZam ? Optional.of(false) : Optional.of(true);
            }
            if (!moznoPrez.booleanValue() && ((Boolean)jePrez.get()).booleanValue()) {
                return true;
            }
        }
        return false;
    }

    public static Optional<Boolean> jePrez(Ctenari cten, Kat1_5 exemplar) {
        DefVypKat vypKat = (DefVypKat)((Map)DbCache2NG.vypKatMap().get()).get(exemplar.getFK_VYPKAT());
        if (vypKat == null) {
            return Optional.empty();
        }
        DefCtenKat defCtenKat = GenericExecutor.nactiCtenKat((String)cten.getFK_CTENKAT());
        DefCtenVyp defCtenVyp = GenericExecutor.nactiKombinaciCtenKatVypKat((DefCtenKat)defCtenKat, (DefVypKat)vypKat);
        boolean vypKatPrez = vypKat.jePrez() || defCtenVyp != null && defCtenVyp.getDOBA_VYP() == 0;
        return Optional.of(vypKatPrez);
    }

    public static String kodOznaceni(Kat1_5 kat1_5) {
        String vychoziTypOznaceni = DbCache2.queryINIFlag((String)IniConstants.SEKCE_VYPUC(), (String)IniConstants.VYPUC_DEFAULTIDENTIFIKATOR(), null, null);
        if (StringUtils.isBlank((CharSequence)vychoziTypOznaceni)) {
            vychoziTypOznaceni = "BC";
        }
        String barCode = kat1_5.getBAR_COD() == null ? null : kat1_5.getBAR_COD().trim();
        String prirCislo = kat1_5.getPRIR_CISLO() == null ? null : kat1_5.getPRIR_CISLO().trim();
        String signa = kat1_5.getSIGNATURA() == null ? null : kat1_5.getSIGNATURA().trim();
        String validniOznaceni = null;
        if ("BC".equals(vychoziTypOznaceni) && StringUtils.isNotBlank((CharSequence)barCode)) {
            validniOznaceni = barCode;
        } else if ("SIGN".equals(vychoziTypOznaceni) && StringUtils.isNotBlank((CharSequence)signa)) {
            validniOznaceni = signa;
        } else if ("PRIC".equals(vychoziTypOznaceni) && StringUtils.isNotBlank((CharSequence)prirCislo)) {
            validniOznaceni = prirCislo;
        }
        return validniOznaceni;
    }
}

