/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.db;

import cz.kpsys.AppServerStatus;
import cz.kpsys.common.IniConstants;
import cz.kpsys.db.DatabaseEngine;
import cz.kpsys.db.DbCache;
import cz.kpsys.db.DbCache2;
import cz.kpsys.db.DbCache2NG;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.GenericExecutor;
import cz.kpsys.db.GenericExecutorScala;
import cz.kpsys.db.KPSYSBeanListHandler;
import cz.kpsys.db.PosilaniPredupominekExecutor;
import cz.kpsys.db.ProxoolUtil;
import cz.kpsys.db.ScalaRunnerOpened;
import cz.kpsys.db.model.PosilaniPredupominekInput;
import cz.kpsys.db.model.intern.PredupominkaEmailPackage;
import cz.kpsys.db.model.intern.SmtpSettings;
import cz.kpsys.db.model.v2.ViewTiskVypujcek;
import cz.kpsys.db.model.v2.message.Message;
import cz.kpsys.db.model.v2.message.MessageSendingEmailUtil;
import cz.kpsys.db.model.v2.message.SendingEmailItem;
import cz.kpsys.kpwin2.sys.MericChybovosti;
import cz.kpsys.kpwin2.tasks.AppServerTimerTask;
import cz.kpsys.service.Utils;
import java.io.File;
import java.lang.invoke.CallSite;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple3;
import scala.collection.mutable.ArrayBuffer;

public class PosilaniPredupominekExecutor
extends GenericExecutor {
    private static final int VYPAKCE_PREDUPOMINKA_92 = 92;
    private static final int DELAY_INTERVAL_1000MS = 1000;
    private static final int ERR1_PROBLEM_PRI_ZPRACOVANI = 1;
    private static final int PROBABLY_SSL_SMTP_PORT = 465;
    private static final Logger logger = LoggerFactory.getLogger(PosilaniPredupominekExecutor.class);
    final MericChybovosti mericEmaily = new MericChybovosti("odeslane predupominky", 0);
    private PosilaniPredupominekInput input;

    public PosilaniPredupominekExecutor(DbCore2 core2, PosilaniPredupominekInput input) {
        this.core2 = core2;
        this.input = input;
        this.qr = core2.obtainQueryRunnerOpened();
    }

    public static PosilaniPredupominekInput parsePosilaniPredupominekInput(String params) {
        PosilaniPredupominekInput input = new PosilaniPredupominekInput();
        Map parametry = AppServerTimerTask.parsujParametry((String)params);
        String KEY_TEST = "TEST";
        String KEY_PUJCOVNY = "PUJCOVNY";
        if (parametry.containsKey("TEST")) {
            input.setTestovaciRezim(true);
            String testovaciEmail = (String)parametry.get("TEST");
            if (EmailValidator.getInstance().isValid(testovaciEmail)) {
                input.setTestovaciEmail(testovaciEmail);
            }
        } else if (parametry.containsKey("PUJCOVNY")) {
            String pujcovny = (String)parametry.get("PUJCOVNY");
            try {
                Set seznamPujcoven = Arrays.stream(pujcovny.split(",")).map(f -> DbCache.podrazenePujcVcetneJavaShort((Short)Short.parseShort(f))).flatMap(Collection::stream).collect(Collectors.toSet());
                logger.info("seznam pujcoven pro posilani predupominek - predany: " + pujcovny + " efektivni: " + StringUtils.join(seznamPujcoven, (String)","));
                input.getFkPujcovny().addAll(seznamPujcoven);
            }
            catch (Exception e) {
                logger.warn("chyba pri zpracovani seznamu pujcoven k zaslani predupominek " + pujcovny, (Throwable)e);
            }
        }
        return input;
    }

    List<ViewTiskVypujcek> seznamVypujcekKPredupomenuti(boolean testovaciRezim) throws SQLException {
        String podminkaEmail = "(email like '%@%' or email_kopie like '%@%')";
        Object where = this.input.getFkPujcovny().size() == 0 ? " FK_UZIV_CTEN > 0 and CIS_REZE = 0 and (email like '%@%' or email_kopie like '%@%')  " : " FK_UZIV_CTEN > 0 and CIS_REZE = 0 and (email like '%@%' or email_kopie like '%@%') AND fk_pujc in (" + StringUtils.join((Iterable)this.input.getFkPujcovny(), (String)", ") + ")";
        Object sql = ProxoolUtil.engine() == DatabaseEngine.FIREBIRD ? "select * from view_tisk_vypujcek where ((dat_vr >= 'TODAY' and (dat_vr - upoz_kon_vyp) <= 'TODAY'))" : "select * from sqlkpwin.view_tisk_vypujcek where ((trunc(dat_vr) >= trunc(current_date) and trunc(dat_vr - upoz_kon_vyp) <= trunc(current_date))";
        String datPredupPodminka = testovaciRezim ? " " : " and (DAT_PREDUP is NULL) ";
        sql = (String)sql + " and " + (String)where + datPredupPodminka + "  and (POSILAT_PREDUPOM='true')  AND (UPOZ_KON_VYP>0) order by FK_UZIV_CTEN,fk_pujc";
        List seznamPredupominek = (List)this.qr.query((String)sql, (ResultSetHandler)new KPSYSBeanListHandler(ViewTiskVypujcek.class));
        return seznamPredupominek;
    }

    protected List<PredupominkaKontejner> seznamPredupominek(boolean predupominkyPoPujcovnach, boolean testovaciRezim) throws SQLException {
        ArrayList<PredupominkaKontejner> seznamPredupominek = new ArrayList<PredupominkaKontejner>();
        HashMap<CallSite, PredupominkaKontejner> mapaVypujcek = new HashMap<CallSite, PredupominkaKontejner>();
        List seznamVypujcekKPredupomenuti = this.seznamVypujcekKPredupomenuti(testovaciRezim);
        for (ViewTiskVypujcek view : seznamVypujcekKPredupomenuti) {
            if (!this.input.getFkPujcovny().isEmpty() && !this.input.getFkPujcovny().contains(view.getFK_PUJC())) continue;
            int fkUzivCten = view.getFK_UZIV_CTEN();
            String key = fkUzivCten + (String)(predupominkyPoPujcovnach ? "_" + view.getFK_PUJC() : "");
            if (!mapaVypujcek.containsKey(key)) {
                kontejner = new PredupominkaKontejner();
                kontejner.fkPujc = view.getFK_PUJC();
                mapaVypujcek.put((CallSite)((Object)key), kontejner);
            } else {
                kontejner = (PredupominkaKontejner)mapaVypujcek.get(key);
            }
            kontejner.fkUzivCten = fkUzivCten;
            ((PredupominkaKontejner)mapaVypujcek.get((Object)key)).seznamVypujcek.add(view);
        }
        Set klice = mapaVypujcek.keySet();
        for (String klic : klice) {
            PredupominkaKontejner kontejner = (PredupominkaKontejner)mapaVypujcek.get(klic);
            try {
                this.naplnKontejner(kontejner);
                seznamPredupominek.add(kontejner);
            }
            catch (Exception e) {
                logger.error("P: plneni kontejneru posilani predupominek " + kontejner, (Throwable)e);
            }
        }
        return seznamPredupominek;
    }

    private void naplnKontejner(PredupominkaKontejner kontejner) throws SQLException {
        SendingEmailItem sendingEmailItem;
        SmtpSettings smtpSettings;
        String emailTo;
        boolean hlavniEmailPrazdny;
        if (kontejner.seznamVypujcek.isEmpty()) {
            logger.warn("seznam predupominek je prazdny, ignoruji pozadavek na pripravu predupominek");
            return;
        }
        short fkPujc = kontejner.fkPujc;
        ViewTiskVypujcek firstView = (ViewTiskVypujcek)kontejner.seznamVypujcek.get(0);
        String defaultMailSubjectPredupom = GenericExecutorScala.processTemplate((String)DbCache2.queryINIFlag((String)IniConstants.SEKCE_EMAIL(), (String)"DEFAULTMAILSUBJECTPREDUPOM", (Short)fkPujc, null), (ViewTiskVypujcek)firstView);
        String defaultMailBodyPredupom = GenericExecutorScala.processTemplate((String)DbCache2.queryINIFlag((String)IniConstants.SEKCE_EMAIL(), (String)"DEFAULTMAILBODYPREDUPOM", (Short)fkPujc, null), (ViewTiskVypujcek)firstView);
        String predupomMailBody = DbCache2.queryINIFlag((String)IniConstants.SEKCE_EMAIL(), (String)"PREDUPOMMAILBODY", (Short)fkPujc, null);
        String defaultMailPataPredupom = GenericExecutorScala.processTemplate((String)DbCache2.queryINIFlag((String)IniConstants.SEKCE_EMAIL(), (String)"DEFAULTMAILPATAPREDUPOM", (Short)fkPujc, null), (ViewTiskVypujcek)firstView);
        StringBuilder sbHTML = new StringBuilder();
        File pracovniAdresar = new File(System.getProperty("java.io.tmpdir"));
        if (StringUtils.isNotBlank((CharSequence)defaultMailBodyPredupom)) {
            sbHTML.append(defaultMailBodyPredupom).append("\n").append("\n");
        }
        for (ViewTiskVypujcek view : kontejner.seznamVypujcek) {
            sbHTML.append(GenericExecutorScala.processTemplate((String)predupomMailBody, (ViewTiskVypujcek)view)).append("\n").append("\n");
        }
        sbHTML.append(defaultMailPataPredupom).append("\n").append("\n");
        String htmlBody = GenericExecutorScala.doplnPripadneHTMLHlavicku((String)sbHTML.toString());
        ArrayBuffer adresy = new ArrayBuffer();
        String emailKopiePredupom = DbCache2.queryINIFlag((String)IniConstants.SEKCE_EMAIL(), (String)"EMAILKOPIEPREDUPOM", null, null);
        if (StringUtils.isNotBlank((CharSequence)emailKopiePredupom)) {
            adresy.$plus$eq((Object)MessageSendingEmailUtil.genMessageSendingEmailAddress((String)emailKopiePredupom, (String)"hidden-address"));
        }
        if (!(hlavniEmailPrazdny = StringUtils.isBlank((CharSequence)(emailTo = firstView.getEMAIL())))) {
            adresy.$plus$eq((Object)MessageSendingEmailUtil.genMessageSendingEmailAddress((String)emailTo, (String)"email-address"));
        }
        Object senderName = StringUtils.isNotBlank((CharSequence)(smtpSettings = DbCache2NG.nactiNastaveniSMTP((short)kontejner.fkPujc)).getSmtpSenderName()) ? smtpSettings.getSmtpSenderName() + " " : "";
        adresy.$plus$eq((Object)MessageSendingEmailUtil.genMessageSendingEmailAddress((String)((String)senderName + "<" + smtpSettings.getSmtpSenderAddress() + "> "), (String)"sender-address"));
        if (StringUtils.isNotBlank((CharSequence)smtpSettings.getSmtpReplyTo())) {
            adresy.$plus$eq((Object)MessageSendingEmailUtil.genMessageSendingEmailAddress((String)smtpSettings.getSmtpReplyTo(), (String)"replyto-address"));
        }
        kontejner.sendingEmailItem = sendingEmailItem = new SendingEmailItem(fkPujc, defaultMailSubjectPredupom, htmlBody, DbCache2.appServerUserID, kontejner.fkUzivCten, Message.TOPIC_PREDUPOMINKA.topicId(), adresy);
    }

    protected boolean posliEmail(boolean testovaciRezim, PredupominkaKontejner kontejner, PredupominkaEmailPackage emailPackage) throws IllegalStateException {
        SendingEmailItem email = kontejner.sendingEmailItem;
        boolean odeslaniProblehlo = false;
        if (testovaciRezim) {
            email.addresses().clear();
            email.addresses().$plus$eq((Object)MessageSendingEmailUtil.genMessageSendingEmailAddress((String)this.input.getTestovaciEmail(), (String)"email-address"));
            email.addresses().$plus$eq((Object)MessageSendingEmailUtil.genMessageSendingEmailAddress((String)this.input.getTestovaciEmail(), (String)"sender-address"));
        }
        try {
            Tuple3 messages = MessageSendingEmailUtil.storeEmailToSend((SendingEmailItem)email, (ScalaRunnerOpened)this.core2.obtainScalaRunnerOpened());
            if (!testovaciRezim) {
                for (ViewTiskVypujcek viewTisk : kontejner.seznamVypujcek) {
                    long fkVypuc = viewTisk.getID_VYPUC();
                    Integer fkCten = viewTisk.getFK_UZIV_CTEN();
                    this.qr.update("UPDATE VYPUC SET DAT_PREDUP=" + Utils.todayNowString((int)1, (DatabaseEngine)ProxoolUtil.engine()) + ", MESSAGE_ID=? WHERE FK_VYPUC=?", new Object[]{((Message)messages._1()).getID(), fkVypuc});
                    this.qr.update("INSERT INTO LOG_VYPUC (FK_VYPAKCE, FK_VYPUC, FK_UZIV_CTEN, DAT_VYP, DOBA_VYP, CIS_REZE, CIS_UPOM) VALUES (?,?,?," + Utils.todayNowString((int)1, (DatabaseEngine)ProxoolUtil.engine()) + ",?,?,?)", new Object[]{92, fkVypuc, fkCten, 0, 1, 0});
                }
            }
            odeslaniProblehlo = true;
        }
        catch (SQLException se) {
            logger.warn("problem pri zapisu data odeslani upominky pro email pro " + email.emailTo(), (Throwable)se);
        }
        catch (Exception ee) {
            logger.warn("problem pri odesilani emailu pro " + email.emailTo(), (Throwable)ee);
        }
        kontejner.postSend();
        this.mericEmaily.zapisKrok(odeslaniProblehlo);
        return odeslaniProblehlo;
    }

    public void posliPredupominky(PosilaniPredupominekInput input) throws AppServerStatus, SQLException {
        try {
            boolean testovaciRezim = input.isTestovaciRezim();
            List kontejnerList = this.seznamPredupominek(true, testovaciRezim);
            logger.info("celkem predupominek k poslani " + kontejnerList.size());
            if (testovaciRezim) {
                logger.warn("testovaci rezim zapnut, posilam pouze max. prvni tri");
            }
            int testingCounter = 0;
            for (PredupominkaKontejner kontejner : kontejnerList) {
                PredupominkaEmailPackage emailPackage = new PredupominkaEmailPackage();
                emailPackage.email = kontejner.sendingEmailItem;
                emailPackage.kontejner = kontejner;
                if (testovaciRezim && ++testingCounter > 3) break;
                try {
                    this.posliEmail(input.isTestovaciRezim(), kontejner, emailPackage);
                }
                catch (Throwable t) {
                    logger.error("selhani posilani emailu predupominky z kontejneru " + kontejner, t);
                }
                this.core2.commit();
            }
            if (this.mericEmaily.chybovost() > 20) {
                throw new AppServerStatus("pri odesilani emailu byla detekovana podezrele velka chybovost", 1);
            }
            this.zapisInfoDoLogAuto();
            this.core2.commit();
        }
        catch (Exception e) {
            logger.error("nepodarilo se pripravit zpravu o predupomince ", (Throwable)e);
            throw new AppServerStatus("problem pri priprave / odesilani predupominek " + e, 1);
        }
    }

    private void zapisInfoDoLogAuto() {
        try {
            this.qr.update("INSERT INTO LOG_AUTO (ID, NAZEV, LAST_DATE) VALUES (?, ?, ?)", new Object[]{1, "UpozKonVypOK", Utils.util2sqlDate((Date)Utils.today())});
        }
        catch (SQLException e) {
            logger.warn("nepodarilo se zapsat info o dokonceni ulohy automatickeho posilani predupominek", (Throwable)e);
        }
    }
}

