/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.db;

import cz.kpsys.AppServerStatus;
import cz.kpsys.common.IniConstants;
import cz.kpsys.db.DbCache2;
import cz.kpsys.db.DbCache2NG;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.DbCore2Utils;
import cz.kpsys.db.GenUpomExecutor;
import cz.kpsys.db.GenericExecutor;
import cz.kpsys.db.GenericExecutorScala;
import cz.kpsys.db.IntegerHandler;
import cz.kpsys.db.KPSYSBeanListHandler;
import cz.kpsys.db.NumberHandler;
import cz.kpsys.db.ScalaRunnerOpened;
import cz.kpsys.db.model.ProlInput;
import cz.kpsys.db.model.ProlOutput;
import cz.kpsys.db.model.v2.Ctenari;
import cz.kpsys.db.model.v2.DefCtenKat;
import cz.kpsys.db.model.v2.DefCtenVyp;
import cz.kpsys.db.model.v2.DefFond;
import cz.kpsys.db.model.v2.DefPujc;
import cz.kpsys.db.model.v2.DefVypKat;
import cz.kpsys.db.model.v2.GeneratorNames;
import cz.kpsys.db.model.v2.Kat1_4;
import cz.kpsys.db.model.v2.Kat1_5;
import cz.kpsys.db.model.v2.MVS;
import cz.kpsys.db.model.v2.Platby;
import cz.kpsys.db.model.v2.Vypuc;
import cz.kpsys.db.model.v2.VypucRezePujcovny;
import cz.kpsys.marc.SessionData;
import cz.kpsys.service.Utils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ProlExecutor
extends GenericExecutor {
    private static final int ERR_19_EXTERNI_VYPUJCKA = 19;
    private static final int ERR_17 = 17;
    private static final int ERR_18 = 18;
    private static final int ERR_16 = 16;
    private static final int ERR_12 = 12;
    private static final int ERR2_CTENAR_NEMUZE_PROLONGOVAT = 2;
    private static final int ERR_9 = 9;
    private static final int ERR_8 = 8;
    private static final int ERR_7 = 7;
    private static final int ERR_6 = 6;
    private static final int ERR_5 = 5;
    private static final int ERR_13 = 13;
    private static final int ERR_10 = 10;
    private static final int ERR20_DLUHY = 20;
    private static final int ERR21 = 21;
    private static final int ERR22_ZKRACENI = 22;
    private static final int ERR23_CHYBI_U1 = 22;
    private static final Logger logger = LoggerFactory.getLogger(ProlExecutor.class);
    final ProlInput input;
    private final Date today = Utils.today();
    private Ctenari cten;
    private Vypuc vypuc;
    private DefPujc pujcovna;
    private Kat1_4 kat1_4;
    private Kat1_5 kat1_5;
    private ProlOutput prolOutput;
    private MVS mvs;

    public ProlExecutor(DbCore2 core2, ProlInput input) {
        this.core2 = core2;
        this.input = input;
    }

    public static ProlInput parseProlInput(Document doc, DbCore2 core2) throws ParseException, SQLException {
        Element rootNode = doc.getRootElement();
        String prefix = "//collection/prol/";
        ProlInput prolInput = new ProlInput();
        prolInput.idVyp = Long.parseLong(ProlExecutor.parseTag((Document)doc, (String)"//collection/prol/ID_VYP"));
        prolInput.pujcovna = Short.parseShort(ProlExecutor.parseTag((Document)doc, (String)"//collection/prol/PUJCOVNA"));
        prolInput.kontrKonreg = ProlExecutor.parseBooleanTag((Document)doc, (String)"//collection/prol/KONTR_KONREG", (boolean)true);
        prolInput.kontrUpom = ProlExecutor.parseBooleanTag((Document)doc, (String)"//collection/prol/KONTR_UPOM", (boolean)true);
        prolInput.kontrProdleni = ProlExecutor.parseBooleanTag((Document)doc, (String)"//collection/prol/KONTR_PRODLENI", (boolean)false);
        prolInput.kontrDluhy = ProlExecutor.parseBooleanTag((Document)doc, (String)"//collection/prol/KONTR_DLUHY", (boolean)false);
        prolInput.prolRez = ProlExecutor.parseBooleanTag((Document)doc, (String)"//collection/prol/PROL_REZ", (boolean)false);
        prolInput.kontrCirkulace = ProlExecutor.parseBooleanTag((Document)doc, (String)"//collection/prol/KONTR_CIRKULACE", (boolean)true);
        prolInput.over = ProlExecutor.parseBooleanTag((Document)doc, (String)"//collection/prol/OVER", (boolean)false);
        prolInput.dotazPokuta = ProlExecutor.tagHasTrueValue((String)ProlExecutor.parseTag((Document)doc, (String)"//collection/prol/DOTAZ_POKUTA", (String)"NE"));
        prolInput.zapisPokuta = ProlExecutor.tagHasTrueValue((String)ProlExecutor.parseTag((Document)doc, (String)"//collection/prol/ZAPIS_POKUTA", (String)"ANO"));
        return prolInput;
    }

    protected void nactiUdaje() throws SQLException, AppServerStatus {
        this.vypuc = DbCore2Utils.nactiVypuc((long)this.input.idVyp, (ScalaRunnerOpened)this.core2.obtainScalaRunnerOpened());
        if (this.vypuc == null) {
            throw new AppServerStatus("vypujcka nenalezena", 1);
        }
        this.mvs = DbCore2Utils.nactiMVS((long)this.input.idVyp, (ScalaRunnerOpened)this.core2.obtainScalaRunnerOpened());
        this.prolOutput.puvodniDatumVraceni = ProlExecutor.addDays((Date)this.vypuc.getDAT_PROL(), (int)this.vypuc.getDOB_VYP().shortValue());
        this.vypKat = this.nactiVypKat(this.vypuc.getFK_VYPKAT());
        if (this.vypuc.getFK_EX() != null && this.vypuc.getFK_EX() > 0L) {
            this.kat1_5 = DbCore2Utils.nactiKat1_5((long)this.vypuc.getFK_EX(), (ScalaRunnerOpened)this.core2.obtainScalaRunnerOpened());
        }
        this.pujcovna = this.nactiPujcovnu(this.input.pujcovna);
        this.cten = ProlExecutor.nactiCtenare((int)this.vypuc.getFK_UZIV_CTEN());
        this.kontrolaCtenare();
        this.kat1_4 = DbCore2Utils.nactiKat1_4((String)this.vypuc.getRECORD_ID(), (ScalaRunnerOpened)this.core2.obtainScalaRunnerOpened());
        this.ctenKat = ProlExecutor.nactiCtenKat((String)this.cten.getFK_CTENKAT());
        this.ctenVyp = ProlExecutor.nactiKombinaciCtenKatVypKat((DefCtenKat)this.ctenKat, (DefVypKat)this.vypKat);
        this.nastavDefaultDniParametr();
    }

    public void nastavDefaultDniParametr() {
        Short dobVyp;
        if (this.ctenVyp != null && (dobVyp = this.ctenVyp.getDOBA_VYP()) != null) {
            this.prolOutput.defaultDni = dobVyp.shortValue();
        }
    }

    public void kontrolaCtenare() throws AppServerStatus, SQLException {
        if (this.cten.isSMAZANYBLOKOVANY()) {
            AppServerStatus ase = new AppServerStatus("ctenar nema pravo prolongovat", 2);
            ase.addReturnValue("ID_CTEN", Integer.toString(this.cten.getFK_UZIV()));
            throw ase;
        }
        if (!this.input.prolongujeCtenar) {
            this.core2.kontrolaDataObnoveni(this.cten, this.input.pujcovna);
        }
    }

    public ProlOutput prol() throws AppServerStatus, SQLException {
        boolean pozadavekZVerbisu;
        this.prolOutput = new ProlOutput();
        this.qr = this.core2.obtainQueryRunnerOpened();
        this.nactiUdaje();
        if (this.vypuc.getDOB_VYP() == -1) {
            this.prolOutput.pocDni = -1;
            return this.prolOutput;
        }
        this.kontrolaExterniVypucjky();
        this.kontrolaZdaJeVCirkulaci(this.qr);
        if (this.input.kontrDluhy && GenericExecutorScala.ctenarDluzi((int)this.cten.getFK_UZIV(), (ScalaRunnerOpened)this.core2.obtainScalaRunnerOpened())) {
            throw new AppServerStatus("ctenar ma dluhy", 20);
        }
        this.vypuc.setDAT_PROL(GenericExecutorScala.zarovnejDatumNaPulnoc((Date)this.vypuc.getDAT_PROL()));
        this.prolOutput.pocProl = this.vypuc.getPOC_PROL() == null ? 0 : (int)this.vypuc.getPOC_PROL().shortValue();
        Date konReg = this.cten.getKON_REG();
        if (konReg != null && konReg.before(this.today) && this.input.kontrKonreg) {
            throw new AppServerStatus("nelze prolognovat, vypr\u0161ela by registrace", 3);
        }
        if (this.vypuc.getCIS_REZE() > 0) {
            throw new AppServerStatus("nelze prolognovat rezervace", 4);
        }
        DefVypKat vypKat = (DefVypKat)((Map)DbCache2NG.vypKatMap().get()).get(this.vypuc.getFK_VYPKAT());
        Kat1_4 kat1_4 = this.core2.nactiKat1_4(this.vypuc.getRECORD_ID());
        DefFond dokFond = (DefFond)DbCache2.defDokFondMap.get(kat1_4.getFK_DOKFOND());
        boolean povolProlRez = DbCache2.queryIINIFlagIsTrue((String)IniConstants.SEKCE_VYPUC(), (String)IniConstants.KATALOGIZACE_POVOLPROLREZ(), (Short)this.input.pujcovna, null);
        SessionData sessionData = this.core2.getSessionData();
        boolean bl = pozadavekZVerbisu = sessionData != null && (this.core2.getSessionData().getTypSession() == 0 || this.core2.getSessionData().getTypSession() == 2);
        if (dokFond.isJE_PERIO()) {
            int pocetRezervaciNaKonkretniCislo = (Integer)this.qr.query("SELECT COUNT(*) FROM VYPUC WHERE FK_EX=? AND CIS_REZE>0", (ResultSetHandler)new IntegerHandler(Integer.valueOf(0)), new Object[]{this.vypuc.getFK_EX()});
            if (pocetRezervaciNaKonkretniCislo > 0) {
                if (!povolProlRez || !pozadavekZVerbisu) {
                    throw new AppServerStatus("cislo periodika je jiz rezervovano", 18);
                }
                if (!this.input.prolRez) {
                    throw new AppServerStatus("Na konkretni cislo periodika jsou rezervace", 17);
                }
            }
        } else {
            boolean lzeProlFronta = GenericExecutorScala.overLzeProlVzhledemKFronte((Kat1_5)this.kat1_5, (ScalaRunnerOpened)this.core2.obtainScalaRunnerOpened());
            if (!lzeProlFronta) {
                if (!povolProlRez || !pozadavekZVerbisu) {
                    throw new AppServerStatus("titul je jiz rezervovan", 10);
                }
                if (!this.input.prolRez) {
                    throw new AppServerStatus("Na titul jsou rezervace", 13);
                }
            }
        }
        if (!(this.mvs != null && this.mvs.getJE_AKTIV() != 1 || this.vypuc.getFK_EX() != null && this.vypuc.getFK_EX() != 0L)) {
            throw new AppServerStatus("s vypujckou neni svazan zadny exemplar", 5);
        }
        if (this.vypuc.getCIS_UPOM() != 0 && (this.input.kontrUpom || this.input.prolongujeCtenar)) {
            throw new AppServerStatus("upominka", 6);
        }
        if (this.vypuc.getFK_TYPPUJC() == 2) {
            boolean pasivniMVS;
            boolean povolProlongaceMVS = DbCache2.queryIINIFlagIsTrue((String)IniConstants.SEKCE_VYPUC(), (String)"PovolProlongaceMVS", null, null);
            if (!povolProlongaceMVS) {
                throw new AppServerStatus("MVS nelze prolongovat - [VYPUC]PovolProlongaceMVS==false", 7);
            }
            boolean bl2 = pasivniMVS = this.vypuc.getFK_EX() == null || this.vypuc.getFK_EX() == 0L;
            if (pasivniMVS) {
                throw new AppServerStatus("pasivni MVS nelze prolongovat", 7);
            }
        }
        Date datProl = this.vypuc.getDAT_PROL();
        if (!this.vypuc.jeTitulovaPodleFkTypPujc()) {
            if (this.ctenVyp != null && this.ctenVyp.getDOBA_VYP() > 0 || this.ctenVyp == null && this.vypuc.getDOB_VYP() >= 0) {
                if (!this.vypuc.getDAT_PROL().before(this.today)) {
                    throw new AppServerStatus("Dnes ji\u017e prolongov\u00e1no", 8);
                }
                boolean i = false;
                this.prolOutput.pocDni = this.zjistiPocetDniKProlongaci();
                if (this.prolOutput.pocDni <= 0) {
                    AppServerStatus ve = new AppServerStatus("Chyba p\u0159i stanoven\u00ed po\u010dtu dn\u00ed k prolongaci", 9);
                    ve.addReturnValue("POC_DNI", Integer.toString(this.prolOutput.pocDni));
                    throw ve;
                }
                long aktReze = 0L;
                if (this.vypuc.getFK_EX() != null && this.vypuc.getFK_EX() > 0L && (aktReze = this.overRezervaceExemplare()) > 0L) {
                    if (dokFond.isJE_PERIO()) {
                        if (!povolProlRez || !pozadavekZVerbisu) {
                            throw new AppServerStatus("exemplar je jiz rezervovan", 10);
                        }
                        if (!this.input.prolRez) {
                            throw new AppServerStatus("Na exemplar jsou rezervace", 13);
                        }
                    } else {
                        throw new AppServerStatus("exemplar je jiz rezervovan", 10);
                    }
                }
                String prolongovatPoString = DbCache2.queryINIFlag((String)IniConstants.SEKCE_VYPUC(), (String)"PROLONGOVATPO", (Short)this.input.pujcovna, null);
                int prolongovatPo = 0;
                if (StringUtils.isNotBlank((CharSequence)prolongovatPoString)) {
                    prolongovatPo = Integer.parseInt(prolongovatPoString);
                } else {
                    logger.warn("chybejici klic/hodnota [VYPUC]PROLONGOVATPO");
                }
                if (prolongovatPo > 0 && !ProlExecutor.addDays((Date)this.vypuc.getDAT_PROL(), (int)(prolongovatPo - 1)).before(this.today)) {
                    throw new AppServerStatus("neuplynul pozadovany cas od minule prolongace", 11);
                }
            }
        } else {
            if (!vypKat.isJE_PROL()) {
                AppServerStatus ve = new AppServerStatus("Titulova se zakazanou prolongaci v kategorii vypujcky - nelze prolongovat", 21);
                ve.addReturnValue("POC_DNI", "0");
                ve.addReturnValue("TITULOVA", "1");
                throw ve;
            }
            if (this.ctenVyp != null && this.ctenVyp.getMAX_PROL() == 0) {
                AppServerStatus ve = new AppServerStatus("Titulova s nulovym poctem max. prolongaci - nelze prolongovat", 21);
                ve.addReturnValue("POC_DNI", "0");
                ve.addReturnValue("TITULOVA", "1");
                throw ve;
            }
            Date datVypProl = (Date)this.qr.query("select MAX(VYPUC_TITPER.DATUM) from VYPUC_TITPER where VYPUC_TITPER.FK_VYPUC = ? and ZMENA > 0", (ResultSetHandler)new ScalarHandler(1), new Object[]{this.vypuc.getFK_VYPUC()});
            Date datVypRozhodujici = datVypProl != null ? (datVypProl.after(this.vypuc.getDAT_VYP()) ? datVypProl : this.vypuc.getDAT_VYP()) : this.vypuc.getDAT_VYP();
            datProl = datVypRozhodujici;
            this.prolOutput.pocDni = this.ctenVyp != null && this.ctenVyp.getDOBA_VYP() != null ? (int)this.ctenVyp.getDOBA_VYP().shortValue() : (int)this.vypuc.getDOB_VYP().shortValue();
        }
        this.kontrolaProdleni(datProl);
        int LIMIT_POSUNUTI = 180;
        int puvodniPocDni = this.prolOutput.pocDni;
        if (puvodniPocDni > 0) {
            this.prolOutput.pocDni = this.posunDnyOPripadneSvatkyAZavreno(this.today, this.prolOutput.pocDni, this.ctenVyp);
        }
        this.kontrolaZkraceni();
        ++this.prolOutput.pocProl;
        if (!this.input.over) {
            this.qr.update("UPDATE vypuc2 SET DAT_PROL=?, POC_PROL=?, DOB_VYP=?, CIS_UPOM=0 WHERE ID_VYPUC=?", new Object[]{Utils.util2sqlDate((Date)this.today), this.prolOutput.pocProl, this.prolOutput.pocDni, this.input.idVyp});
            this.qr.update("DELETE FROM upominky WHERE FK_VYPUC=?", (Object)this.input.idVyp);
        }
        this.prolOutput.novyDatumVraceni = ProlExecutor.addDays((Date)Utils.util2sqlDate((Date)this.today), (int)this.prolOutput.pocDni);
        this.vycistiPoleServis();
        return this.prolOutput;
    }

    private void kontrolaZkraceni() throws AppServerStatus {
        Date noveDatumKonecVypujcky;
        Date datumKonecVypujcky = GenericExecutor.addDays((Date)this.vypuc.getDAT_PROL(), (int)this.vypuc.getDOB_VYP().shortValue());
        if (datumKonecVypujcky.after(noveDatumKonecVypujcky = GenericExecutor.addDays((Date)Utils.today(), (int)this.prolOutput.pocDni))) {
            throw new AppServerStatus("prolongaci by doslo ke zkraceni vypujcky, proto nebylo prolongovano", 22);
        }
    }

    public void kontrolaProdleni(Date datProl) throws AppServerStatus, SQLException {
        if (ProlExecutor.addDays((Date)datProl, (int)this.vypuc.getDOB_VYP().shortValue()).before(this.today)) {
            if (this.input.kontrProdleni) {
                throw new AppServerStatus("ctenar je v prodleni", 12);
            }
            if (ProlExecutor.tagHasTrueValue((String)DbCache2.queryINIFlag((String)IniConstants.SEKCE_VYPUC(), (String)IniConstants.KATALOGIZACE_PLATITPRIPROLONGACI(), (Short)this.input.pujcovna, null))) {
                this.spocitatAZapsatPokutu();
            }
        }
    }

    private void kontrolaExterniVypucjky() throws AppServerStatus {
        if (this.vypuc.getFK_TYPPUJC() == 3) {
            String message = "e-vypujcku nelze prolongovat";
            if (this.vypuc.getOZNAC() != null) {
                if (this.vypuc.getOZNAC().contains("EREADING")) {
                    message = "ereading nelze prolongovat";
                } else if (this.vypuc.getOZNAC().contains("FLEXIBOOKS")) {
                    message = "flexibooks nelze prolongovat";
                }
            }
            throw new AppServerStatus(message, 19);
        }
    }

    private void vycistiPoleServis() throws SQLException {
        GenUpomExecutor.vycistiPoleServis((QueryRunner)this.qr, (short)this.vypuc.getCIS_UPOM(), (short)this.input.pujcovna, (int)this.cten.getFK_UZIV(), (long)this.vypuc.getFK_VYPUC());
    }

    private void kontrolaZdaJeVCirkulaci(QueryRunner qr) throws SQLException, AppServerStatus {
        int count;
        if (this.input.kontrCirkulace && (count = ((Number)qr.query("SELECT COUNT(*) FROM CIRKULACE WHERE FK_EX=? AND FK_VYPUC IS NULL", (ResultSetHandler)new NumberHandler((Number)0), new Object[]{this.vypuc.getFK_EX()})).intValue()) > 0) {
            throw new AppServerStatus("exemplar je v cirkulaci", 16);
        }
    }

    private void spocitatAZapsatPokutu() throws SQLException, AppServerStatus {
        BigDecimal castkaPokuty;
        if (!this.input.zapisPokuta) {
            return;
        }
        if (this.vypuc.getCIS_REZE() != null && this.vypuc.getCIS_REZE() <= 0 && (castkaPokuty = GenericExecutorScala.spoctuPokutu((DefCtenVyp)this.ctenVyp, (short)this.vypuc.getFK_PUJC(), (short)this.kat1_4.getFK_DOKFOND(), (Date)this.vypuc.getDAT_PROL(), (int)this.vypuc.getDOB_VYP().shortValue())).compareTo(BigDecimal.ZERO) > 0) {
            if (!this.input.dotazPokuta) {
                if (this.vypuc.getCIS_UPOM() == 0 && DbCache2.queryIINIFlagIsTrue((String)IniConstants.SEKCE_VYPUC(), (String)IniConstants.VYPUC_POKUTAPOUPOMINCE(), (Short)this.vypuc.getFK_PUJC(), null)) {
                    logger.info("predpokladana castka pokuty " + castkaPokuty + " nebude pripsana, vypujcka jeste nebyla upominana " + this.vypuc);
                } else {
                    this.zapisPokutu(BigDecimal.ZERO.subtract(castkaPokuty));
                }
            } else {
                AppServerStatus ase = new AppServerStatus("zapsat pokutu?", 14);
                ase.addReturnValue("POKUTA", castkaPokuty.toString());
                throw ase;
            }
        }
    }

    private void zapisPokutu(BigDecimal castkaPokuty) throws SQLException {
        Platby platba = new Platby();
        long ID_PLATBY = this.core2.generateID(GeneratorNames.SEQ_ID_PLATBY);
        platba.setFK_UZIV_VLASTNIK((long)this.cten.getFK_UZIV());
        platba.setFK_POPL((short)4);
        platba.setCASTKA(castkaPokuty);
        platba.setDATUM(this.today);
        platba.setFK_PUJC(this.pujcovna.getID_PUJC());
        platba.setFK_UZIV(this.core2.fkUziv());
        platba.setID_PLATBY(ID_PLATBY);
        platba.setFK_VYPUC(Long.valueOf(this.vypuc.getFK_VYPUC()));
        if (!this.input.over) {
            logger.debug("zapisuji pokutu " + platba);
            this.qr.update("INSERT INTO PLATBY (FK_UZIV_VLASTNIK, FK_POPL, CASTKA, DATUM, FK_PUJC, FK_UZIV, ID_PLATBY, FK_VYPUC) VALUES (?,?,?,?,?,?,?,?)", new Object[]{platba.getFK_UZIV_VLASTNIK(), platba.getFK_POPL(), platba.getCASTKA(), Utils.util2sqlDate((Date)platba.getDATUM()), platba.getFK_PUJC(), platba.getFK_UZIV(), platba.getID_PLATBY(), platba.getFK_VYPUC()});
        }
    }

    private long overRezervaceExemplare() throws SQLException {
        Number fkVypuc = (Number)this.qr.query("SELECT POZ_REZ.FK_VYPUC FROM POZ_REZ JOIN VYPUC ON POZ_REZ.FK_VYPUC=VYPUC.FK_VYPUC WHERE POZ_REZ.FK_EX=? AND CIS_REZE>0", (ResultSetHandler)new ScalarHandler(), new Object[]{this.kat1_5.getID_EX()});
        if (fkVypuc != null) {
            return fkVypuc.longValue();
        }
        return 0L;
    }

    private long overRezervaceTitulu() throws SQLException {
        List vypujcky = (List)this.qr.query("SELECT * FROM VYPUC WHERE FK_EX IS NULL AND RECORD_ID=?", (ResultSetHandler)new KPSYSBeanListHandler(Vypuc.class), new Object[]{this.kat1_5.getRECORD_ID()});
        for (Vypuc vypujcka : vypujcky) {
            int count = ((Number)this.qr.query("SELECT COUNT(*) FROM POZ_REZ WHERE POZ_REZ.FK_VYPUC=?", (ResultSetHandler)new ScalarHandler(), new Object[]{vypujcka.getFK_VYPUC()})).intValue();
            if (count == 0) {
                return 0L;
            }
            List vypucRezePujcovny = (List)this.qr.query("SELECT * FROM VYPUC_REZE_PUJCOVNY WHERE FK_VYPUC=?", (ResultSetHandler)new KPSYSBeanListHandler(VypucRezePujcovny.class), new Object[]{vypujcka.getFK_VYPUC()});
            if (vypucRezePujcovny.size() == 0) {
                return vypujcka.getFK_VYPUC();
            }
            for (VypucRezePujcovny pujcovny : vypucRezePujcovny) {
                if (pujcovny.getFK_PUJC() != this.pujcovna.getID_PUJC()) continue;
                return vypujcka.getFK_VYPUC();
            }
        }
        return 0L;
    }

    protected int zjistiPocetDniKProlongaci() throws SQLException, AppServerStatus {
        if (this.ctenVyp == null || !this.vypKat.isJE_PROL()) {
            this.prolOutput.pocDni = -1;
        } else {
            this.prolOutput.pocDni = this.ctenVyp.getDOBA_VYP().shortValue();
            if (this.ctenVyp.getZPUS_PUJC() == 1) {
                if (this.prolOutput.pocProl < this.ctenVyp.getMAX_PROL()) {
                    if (this.ctenVyp.getDATUM_U1() == null) {
                        throw new AppServerStatus("nastaveno pujcovat do data ale DATUM_U1 neni nastaveno - ctenvyp " + this.ctenVyp, 22);
                    }
                    this.prolOutput.pocDni = this.ctenVyp.getDATUM_U1().after(this.today) ? (this.ctenVyp.getDATUM_U1().after(ProlExecutor.addDays((Date)this.vypuc.getDAT_PROL(), (int)this.vypuc.getDOB_VYP().shortValue())) ? Utils.daysBetweenAbs((Date)this.today, (Date)this.ctenVyp.getDATUM_U1()) : 0) : 0;
                } else {
                    this.prolOutput.pocDni = 0;
                }
            } else {
                String typProlong = DbCache2.queryINIFlag((String)IniConstants.SEKCE_VYPUC(), (String)IniConstants.KATALOGIZACE_TYPPROLONG(), (Short)this.input.pujcovna, null);
                if (typProlong == null) {
                    typProlong = "MAXDOB";
                }
                if (typProlong.equalsIgnoreCase("MAXPOC")) {
                    if (this.prolOutput.pocProl >= this.ctenVyp.getMAX_PROL()) {
                        this.prolOutput.pocDni = 0;
                    }
                } else {
                    int maxDelkaVypujcky = this.prolOutput.pocDni * this.ctenVyp.getMAX_PROL();
                    Date limitniDatum = ProlExecutor.addDays((Date)this.vypuc.getDAT_VYP(), (int)maxDelkaVypujcky);
                    while (limitniDatum.before(ProlExecutor.addDays((Date)this.today, (int)this.prolOutput.pocDni)) && this.prolOutput.pocDni >= 0) {
                        --this.prolOutput.pocDni;
                    }
                    if (this.prolOutput.pocDni < 0) {
                        this.prolOutput.pocDni = 0;
                    }
                }
            }
        }
        return this.prolOutput.pocDni;
    }
}

