/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.db;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.pool.HikariProxyConnection;
import cz.kpsys.db.DatabaseEngine;
import cz.kpsys.db.DbConfig;
import cz.kpsys.db.QueryRunnerOpened;
import cz.kpsys.db.SingleConnectionDataSource;
import cz.kpsys.kpwin2.rest.KPWINServiceApplication;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import net.sf.log4jdbc.ConnectionSpy;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.dbutils.QueryRunner;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FirebirdConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.jdbc.metadata.HikariDataSourcePoolMetadata;

/*
 * Exception performing whole class analysis ignored.
 */
public class ProxoolUtil {
    public static final String poolName = "Main Verbis AS DB pool";
    static final Long MINUTA = 60000L;
    static final String poolNameLong = "Background service Verbis AS DB pool";
    static final String fbClass = "org.firebirdsql.jdbc.FBDriver";
    static final String oraClass = "oracle.jdbc.driver.OracleDriver";
    static final String pgClass = "org.postgresql.Driver";
    private static final Logger logger = LoggerFactory.getLogger(ProxoolUtil.class);
    public static DbConfig dbConfig = null;
    static Long maximumActiveTime = 20L * MINUTA;
    static Properties defaultProperties = new Properties();
    private static volatile HikariDataSource dsStandard;
    private static volatile HikariDataSource dsLongRunning;
    static final HikariConfig configProv;
    static HikariDataSource provDataSource;
    private static final Pattern concurrentTransPattern;

    public static DataSource dataSource() {
        return dsStandard;
    }

    public static void setupDbConfig(DbConfig dbConfig) {
        logger.info("url: " + dbConfig.jdbcURL());
        ProxoolUtil.dbConfig = dbConfig;
        boolean connected = false;
        while (!connected) {
            try {
                ProxoolUtil.initDataSources((DbConfig)dbConfig);
                connected = true;
            }
            catch (Exception e) {
                logger.debug("pri pokusu o navazani spojeni s DB", (Throwable)e);
                logger.error("spojeni s DB neni mometalne dostupne, cekam");
                try {
                    Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
                }
                catch (InterruptedException ei) {
                    logger.warn("cekani na spojeni s DB preruseno, koncim", (Throwable)ei);
                    System.exit(5);
                }
            }
        }
    }

    public static DatabaseEngine engine() {
        if (dbConfig != null) {
            return dbConfig.dbEngine();
        }
        return DatabaseEngine.NA;
    }

    public static Properties getDefaultProperties() {
        return defaultProperties;
    }

    private static HikariConfig createHikariConfig(boolean longRunning) {
        return ProxoolUtil.createHikariConfig((DbConfig)dbConfig, (boolean)longRunning);
    }

    public static HikariConfig createHikariConfig(DbConfig dbConfig, boolean longRunning) {
        boolean publicBuild;
        HikariConfig config = new HikariConfig();
        String driverClass = dbConfig.dbEngine().driverClass;
        String dbUrl = dbConfig.jdbcURL();
        config.setDriverClassName(driverClass);
        config.setJdbcUrl(dbUrl);
        config.setUsername(dbConfig.username());
        config.setPassword(dbConfig.password());
        Properties connProps = new Properties();
        connProps.put("process_name", "verbis-application-server");
        config.setDataSourceProperties(connProps);
        config.setConnectionInitSql(null);
        config.setAutoCommit(dbConfig.autoCommit());
        config.setMaxLifetime(TimeUnit.MINUTES.toMillis(5L));
        config.setConnectionTimeout(TimeUnit.SECONDS.toMillis(30L));
        config.setMaximumPoolSize(40);
        boolean bl = publicBuild = !KPWINServiceApplication.internalBuild();
        if (longRunning) {
            config.setPoolName("Background service Verbis AS DB pool");
            config.setMinimumIdle(1);
            if (publicBuild) {
                config.setLeakDetectionThreshold(TimeUnit.MINUTES.toMillis(30L));
            } else {
                config.setLeakDetectionThreshold(0L);
            }
        } else {
            config.setPoolName("Main Verbis AS DB pool");
            if (publicBuild) {
                config.setLeakDetectionThreshold(TimeUnit.SECONDS.toMillis(30L));
            } else {
                config.setLeakDetectionThreshold(0L);
            }
        }
        return config;
    }

    private static void initDataSources(DbConfig dbConfig) {
        HikariConfig configStandard = ProxoolUtil.createHikariConfig((boolean)false);
        dsStandard = new HikariDataSource(configStandard);
        HikariConfig configLongRunning = ProxoolUtil.createHikariConfig((boolean)true);
        dsLongRunning = new HikariDataSource(configLongRunning);
    }

    public static synchronized Connection obtainConnection() throws SQLException {
        return ProxoolUtil.obtainConnection((boolean)false, (boolean)true);
    }

    public static synchronized Connection obtainConnection(boolean logged) throws SQLException {
        return ProxoolUtil.obtainConnection((boolean)false, (boolean)logged);
    }

    public static synchronized Connection obtainProvConnection() throws SQLException {
        return provDataSource.getConnection();
    }

    public static synchronized Connection obtainConnectionBackground() throws SQLException {
        return ProxoolUtil.obtainConnection((boolean)true, (boolean)true);
    }

    public static HikariDataSourcePoolMetadata getPoolMetadata(boolean longRunning) {
        if (longRunning) {
            return new HikariDataSourcePoolMetadata(dsLongRunning);
        }
        return new HikariDataSourcePoolMetadata(dsStandard);
    }

    private static Connection obtainConnection(boolean longRunning, boolean logged) throws SQLException {
        HikariDataSource dataSource = longRunning ? dsLongRunning : dsStandard;
        return ProxoolUtil.obtainConnection((DataSource)dataSource, (boolean)logged);
    }

    private static void setTransactionParams(FirebirdConnection fbConn) throws SQLException {
        TransactionParameterBuffer tpb = fbConn.createTransactionParameterBuffer();
        tpb.addArgument(15);
        tpb.addArgument(17);
        tpb.addArgument(9);
        tpb.addArgument(6);
        tpb.addArgument(21, 5);
        fbConn.setTransactionParameters(tpb);
    }

    public static Connection obtainConnection(DataSource dataSource, boolean logged) throws SQLException {
        Connection conn;
        block5: {
            if (dataSource == null) {
                return null;
            }
            conn = null;
            conn = dataSource.getConnection();
            if (conn instanceof HikariProxyConnection && ProxoolUtil.engine() == DatabaseEngine.FIREBIRD) {
                FirebirdConnection fbConn = conn.unwrap(FirebirdConnection.class);
                fbConn.commit();
                try {
                    ProxoolUtil.setTransactionParams((FirebirdConnection)fbConn);
                }
                catch (FBSQLException fbSQLEx) {
                    if (!fbSQLEx.getMessage().contains("Cannot set transaction parameters when transaction is already started")) break block5;
                    logger.error("spojeni v poolu s otevrenou transakci " + fbSQLEx);
                    fbConn.commit();
                    ProxoolUtil.setTransactionParams((FirebirdConnection)fbConn);
                }
            }
        }
        conn.setAutoCommit(false);
        if (KPWINServiceApplication.internalBuild() || logged || !dbConfig.logSQL()) {
            // empty if block
        }
        return new ConnectionSpy(conn);
    }

    public static void logDeadlockInfo(Exception ex) {
        Matcher m;
        String message;
        if (ProxoolUtil.engine() == DatabaseEngine.FIREBIRD && ex instanceof SQLException && (message = ex.getMessage()) != null && message.contains("concurrent transaction number is") && (m = concurrentTransPattern.matcher(message)).matches()) {
            long transId = Long.parseLong(m.group(2));
            try (Connection conn = ProxoolUtil.obtainConnection();){
                PreparedStatement psAttachment = conn.prepareStatement("SELECT MON$ATTACHMENT_ID FROM MON$TRANSACTIONS WHERE MON$TRANSACTION_ID=?");
                psAttachment.setLong(1, transId);
                ResultSet rsAttachment = psAttachment.executeQuery();
                if (rsAttachment.next()) {
                    int attachmentId = rsAttachment.getInt(1);
                    PreparedStatement psCommand = conn.prepareStatement("SELECT MON$SQL_TEXT FROM MON$STATEMENTS WHERE MON$ATTACHMENT_ID=?");
                    psCommand.setInt(1, attachmentId);
                    ResultSet rsCommand = psCommand.executeQuery();
                    rsCommand.next();
                    String commandText = rsCommand.getString(1);
                    logger.error("detekovan DEADLOCK proti transakci " + transId + " souvisejici prikaz: " + commandText);
                    logger.error("chyba v nasi transakci", (Throwable)ex);
                } else {
                    logger.warn("data o transakci c. " + transId + " nejsou k dispozici");
                }
            }
            catch (SQLException e) {
                logger.warn("nepodarilo se ziskat spojeni pro zjisteni informaci o deadlocku", (Throwable)e);
            }
        }
    }

    public static void setMaximumActiveTime(Long maximumActTime) {
        maximumActiveTime = maximumActTime * 1000L;
    }

    public static QueryRunner obtainQueryRunnerRO() throws SQLException {
        return new QueryRunner((DataSource)dsStandard);
    }

    public static QueryRunner obtainQueryRunnerOpened(Connection conn) {
        return new QueryRunnerOpened((DataSource)new SingleConnectionDataSource(conn));
    }

    static {
        configProv = new HikariConfig();
        String dbUrl = new String(Base64.decodeBase64((String)"amRiYzpwb3N0Z3Jlc3FsOi8vdXBkYXRlLmtwc3lzLmN6OjI1MzQyL3Byb3Zpc2lvbmluZw=="));
        String username = "kpsys";
        String password = new String(Base64.decodeBase64((String)"NThCNThpS0RRcg=="));
        try {
            Class.forName("org.postgresql.Driver");
            configProv.setJdbcUrl(dbUrl);
            configProv.setUsername("kpsys");
            configProv.setPassword(password);
            configProv.setDataSourceProperties(new Properties());
            configProv.setConnectionInitSql(null);
            configProv.setAutoCommit(false);
            configProv.setMaxLifetime(TimeUnit.MINUTES.toMillis(30L));
            configProv.setMaximumPoolSize(5);
            configProv.setMinimumIdle(0);
            configProv.setConnectionTimeout(3000L);
        }
        catch (ClassNotFoundException e) {
            logger.error("ovladac pgSQL nenalezen", (Throwable)e);
        }
        provDataSource = null;
        try {
            if (KPWINServiceApplication.getConfiguration().provisioning) {
                provDataSource = new HikariDataSource(configProv);
            }
        }
        catch (Exception e) {
            logger.debug("inicializaci provisioningu selhala, vypinam");
            KPWINServiceApplication.configuration.provisioning = false;
        }
        concurrentTransPattern = Pattern.compile("(.*)concurrent transaction number is (\\d*) (.*)");
    }
}

