/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.db;

import cz.kpsys.db.DatabaseEngine;
import cz.kpsys.db.TableColumnDescriptor;
import cz.kpsys.db.TableDescriptor;
import cz.kpsys.db.TableDescriptorProvider$;
import cz.kpsys.service.SUtils$;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Tuple2;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.LinkedHashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005-c\u0001B\r\u001b\u0001\u0005B\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\tc\u0001\u0011)\u0019!C\u0001e!Aq\u0007\u0001B\u0001B\u0003%1\u0007C\u00039\u0001\u0011\u0005\u0011\bC\u0004>\u0001\t\u0007I\u0011\u0001 \t\r\u001d\u0003\u0001\u0015!\u0003@\u0011\u001dA\u0005\u00011A\u0005\u0002%Cq\u0001\u0019\u0001A\u0002\u0013\u0005\u0011\r\u0003\u0004h\u0001\u0001\u0006KA\u0013\u0005\bQ\u0002\u0001\r\u0011\"\u0001j\u0011\u001d\u0019\b\u00011A\u0005\u0002QDaA\u001e\u0001!B\u0013Q\u0007\"B<\u0001\t\u0003A\b\"B=\u0001\t\u0003Q\b\"B?\u0001\t\u0003q\b\"CA\u0004\u0001E\u0005I\u0011AA\u0005\u0011\u001d\ty\u0002\u0001C\u0005\u0003CAq!a\n\u0001\t\u0013\tI\u0003C\u0005\u00022\u0001\t\n\u0011\"\u0003\u0002\n!9\u00111\u0007\u0001\u0005\n\u0005Ur!CA\u001f5\u0005\u0005\t\u0012AA \r!I\"$!A\t\u0002\u0005\u0005\u0003B\u0002\u001d\u0017\t\u0003\t\u0019\u0005C\u0005\u0002FY\t\n\u0011\"\u0001\u0002H\t9B+\u00192mK\u0012+7o\u0019:jaR|'\u000f\u0015:pm&$WM\u001d\u0006\u00037q\t!\u0001\u001a2\u000b\u0005uq\u0012!B6qgf\u001c(\"A\u0010\u0002\u0005\rT8\u0001A\n\u0003\u0001\t\u0002\"a\t\u0014\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\u0012a!\u00118z%\u00164\u0017A\u00013t!\tQs&D\u0001,\u0015\taS&A\u0002tc2T\u0011AL\u0001\u0006U\u00064\u0018\r_\u0005\u0003a-\u0012!\u0002R1uCN{WO]2f\u0003!!'-\u00128hS:,W#A\u001a\u0011\u0005Q*T\"\u0001\u000e\n\u0005YR\"A\u0004#bi\u0006\u0014\u0017m]3F]\u001eLg.Z\u0001\nI\n,enZ5oK\u0002\na\u0001P5oSRtDc\u0001\u001e<yA\u0011A\u0007\u0001\u0005\u0006Q\u0011\u0001\r!\u000b\u0005\bc\u0011\u0001\n\u00111\u00014\u0003\u0019awnZ4feV\tq\b\u0005\u0002A\u000b6\t\u0011I\u0003\u0002C\u0007\u0006)1\u000f\u001c45U*\tA)A\u0002pe\u001eL!AR!\u0003\r1{wmZ3s\u0003\u001dawnZ4fe\u0002\n!\u0003^1cY\u0016$Um]2sSB$xN]'baV\t!\n\u0005\u0003L!JkV\"\u0001'\u000b\u00055s\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0003\u001f\u0012\n!bY8mY\u0016\u001cG/[8o\u0013\t\tFJA\u0004ICNDW*\u00199\u0011\u0005MSfB\u0001+Y!\t)F%D\u0001W\u0015\t9\u0006%\u0001\u0004=e>|GOP\u0005\u00033\u0012\na\u0001\u0015:fI\u00164\u0017BA.]\u0005\u0019\u0019FO]5oO*\u0011\u0011\f\n\t\u0003iyK!a\u0018\u000e\u0003\u001fQ\u000b'\r\\3EKN\u001c'/\u001b9u_J\fa\u0003^1cY\u0016$Um]2sSB$xN]'ba~#S-\u001d\u000b\u0003E\u0016\u0004\"aI2\n\u0005\u0011$#\u0001B+oSRDqA\u001a\u0005\u0002\u0002\u0003\u0007!*A\u0002yIE\n1\u0003^1cY\u0016$Um]2sSB$xN]'ba\u0002\na\u0003\u001d:pG\u0016$WO]3EKN\u001c'/\u001b9u_Jl\u0015\r]\u000b\u0002UB!1j[7^\u0013\taGJA\u0007MS:\\W\r\u001a%bg\"l\u0015\r\u001d\t\u0005G9\u0014\u0006/\u0003\u0002pI\t1A+\u001e9mKJ\u0002\"aI9\n\u0005I$#a\u0002\"p_2,\u0017M\\\u0001\u001baJ|7-\u001a3ve\u0016$Um]2sSB$xN]'ba~#S-\u001d\u000b\u0003EVDqAZ\u0006\u0002\u0002\u0003\u0007!.A\fqe>\u001cW\rZ;sK\u0012+7o\u0019:jaR|'/T1qA\u0005)1\r\\3beR\t!-\u0001\nhKR$\u0016M\u00197f\t\u0016\u001c8M]5qi>\u0014HCA/|\u0011\u0015ah\u00021\u0001S\u00031!\u0018M\u00197f\u001d\u0006lW\rU1s\u0003Y9W\r\u001e)s_\u000e,G-\u001e:f\t\u0016\u001c8M]5qi>\u0014H\u0003B/\u0000\u0003\u0007Aa!!\u0001\u0010\u0001\u0004\u0011\u0016\u0001\u00059s_\u000e,G-\u001e:f\u001d\u0006lW\rU1s\u0011!\t)a\u0004I\u0001\u0002\u0004\u0001\u0018aD5oaV$\b+\u0019:b[\u0016$XM]:\u0002A\u001d,G\u000f\u0015:pG\u0016$WO]3EKN\u001c'/\u001b9u_J$C-\u001a4bk2$HEM\u000b\u0003\u0003\u0017Q3\u0001]A\u0007W\t\ty\u0001\u0005\u0003\u0002\u0012\u0005mQBAA\n\u0015\u0011\t)\"a\u0006\u0002\u0013Ut7\r[3dW\u0016$'bAA\rI\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005u\u00111\u0003\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00074j]\u0012$\u0016M\u00197f\t\u0016\u001c8M]5qi>\u0014hI]8n\t\n$2!XA\u0012\u0011\u0019\t)#\u0005a\u0001%\u0006IA/\u00192mK:\u000bW.Z\u0001\u001eM&tG\r\u0015:pG\u0016$WO]3EKN\u001c'/\u001b9u_J4%o\\7EER)Q,a\u000b\u00020!1\u0011Q\u0006\nA\u0002I\u000bQ\u0002\u001d:pG\u0016$WO]3OC6,\u0007\u0002CA\u0003%A\u0005\t\u0019\u00019\u0002O\u0019Lg\u000e\u001a)s_\u000e,G-\u001e:f\t\u0016\u001c8M]5qi>\u0014hI]8n\t\n$C-\u001a4bk2$HEM\u0001\u0014k:\u001cX\u000f\u001d9peR,G\rR1uC\n\f7/\u001a\u000b\u0003\u0003o\u00012aIA\u001d\u0013\r\tY\u0004\n\u0002\b\u001d>$\b.\u001b8h\u0003]!\u0016M\u00197f\t\u0016\u001c8M]5qi>\u0014\bK]8wS\u0012,'\u000f\u0005\u00025-M\u0011aC\t\u000b\u0003\u0003\u007f\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012TCAA%U\r\u0019\u0014Q\u0002")
public class TableDescriptorProvider {
    private final DataSource ds;
    private final DatabaseEngine dbEngine;
    private final Logger logger;
    private HashMap<String, TableDescriptor> tableDescriptorMap;
    private LinkedHashMap<Tuple2<String, Object>, TableDescriptor> procedureDescriptorMap;

    public static DatabaseEngine $lessinit$greater$default$2() {
        return TableDescriptorProvider$.MODULE$.$lessinit$greater$default$2();
    }

    public DatabaseEngine dbEngine() {
        return this.dbEngine;
    }

    public Logger logger() {
        return this.logger;
    }

    public HashMap<String, TableDescriptor> tableDescriptorMap() {
        return this.tableDescriptorMap;
    }

    public void tableDescriptorMap_$eq(HashMap<String, TableDescriptor> x$1) {
        this.tableDescriptorMap = x$1;
    }

    public LinkedHashMap<Tuple2<String, Object>, TableDescriptor> procedureDescriptorMap() {
        return this.procedureDescriptorMap;
    }

    public void procedureDescriptorMap_$eq(LinkedHashMap<Tuple2<String, Object>, TableDescriptor> x$1) {
        this.procedureDescriptorMap = x$1;
    }

    public void clear() {
        this.tableDescriptorMap().clear();
    }

    public synchronized TableDescriptor getTableDescriptor(String tableNamePar) {
        String tableName = tableNamePar.toUpperCase();
        return (TableDescriptor)this.tableDescriptorMap().getOrElseUpdate((Object)tableName, (Function0 & Serializable & scala.Serializable)() -> this.findTableDescriptorFromDb(tableName));
    }

    public synchronized TableDescriptor getProcedureDescriptor(String procedureNamePar, boolean inputParameters) {
        String procedureName = procedureNamePar.toUpperCase();
        Tuple2 KEY = new Tuple2((Object)procedureName, (Object)BoxesRunTime.boxToBoolean((boolean)inputParameters));
        return (TableDescriptor)this.procedureDescriptorMap().getOrElseUpdate((Object)KEY, (Function0 & Serializable & scala.Serializable)() -> this.findProcedureDescriptorFromDb(procedureName, inputParameters));
    }

    public boolean getProcedureDescriptor$default$2() {
        return true;
    }

    private TableDescriptor findTableDescriptorFromDb(String tableName) {
        return (TableDescriptor)SUtils$.MODULE$.withResources((Function0 & Serializable & scala.Serializable)() -> $this.ds.getConnection(), (Function1 & Serializable & scala.Serializable)conn -> {
            TableDescriptor td = new TableDescriptor();
            td.tableName = tableName;
            this.logger().debug(new StringBuilder(29).append("zjistuji informace o tabulce ").append(tableName).toString());
            DatabaseEngine databaseEngine = this.dbEngine();
            if (DatabaseEngine.FIREBIRD.equals(databaseEngine)) {
                PreparedStatement ps = conn.prepareStatement("SELECT RDB$RELATION_FIELDS.RDB$FIELD_NAME AS COLUMN_NAME, RDB$TYPES.RDB$TYPE_NAME AS DATA_TYPE, RDB$FIELDS.RDB$FIELD_LENGTH AS LEN, RDB$FIELDS.RDB$CHARACTER_LENGTH AS CHAR_LEN, RDB$FIELDS.RDB$FIELD_SCALE AS SCALE FROM RDB$RELATION_FIELDS LEFT JOIN RDB$FIELDS ON RDB$RELATION_FIELDS.RDB$FIELD_SOURCE = RDB$FIELDS.RDB$FIELD_NAME LEFT JOIN RDB$TYPES ON RDB$FIELDS.RDB$FIELD_TYPE = RDB$TYPES.RDB$TYPE WHERE RDB$RELATION_FIELDS.RDB$RELATION_NAME = ? AND RDB$TYPES.RDB$FIELD_NAME='RDB$FIELD_TYPE' ORDER BY RDB$RELATION_FIELDS.RDB$FIELD_POSITION ");
                ps.setString(1, tableName);
                if (ps.execute()) {
                    ResultSet rs = ps.getResultSet();
                    while (rs.next()) {
                        TableColumnDescriptor tcd = new TableColumnDescriptor();
                        tcd.columnName = rs.getString(1).trim().toUpperCase();
                        tcd.columnType = rs.getString(2).trim();
                        tcd.columnLength = rs.getInt(3);
                        tcd.columnCharLength = rs.getInt(4);
                        tcd.scale = rs.getInt(5);
                        td.tableColumns.put(tcd.columnName, tcd);
                    }
                    ps.close();
                }
            } else if (DatabaseEngine.ORACLE.equals(databaseEngine)) {
                PreparedStatement ps = conn.prepareStatement("select TABLE_NAME,COLUMN_NAME, DATA_TYPE, DATA_PRECISION, DATA_SCALE, NULLABLE, CHAR_LENGTH from ALL_TAB_COLUMNS WHERE TABLE_NAME=?");
                ps.setString(1, tableName);
                if (ps.execute()) {
                    ResultSet rs = ps.getResultSet();
                    while (rs.next()) {
                        TableColumnDescriptor tcd = new TableColumnDescriptor();
                        tcd.columnName = rs.getString(2).trim().toUpperCase();
                        tcd.columnType = rs.getString(3).trim();
                        tcd.columnLength = rs.getInt(4);
                        tcd.scale = rs.getInt(5);
                        tcd.oracleNullable = rs.getString(6).equalsIgnoreCase("Y");
                        tcd.columnCharLength = rs.getInt(7);
                        td.tableColumns.put(tcd.columnName, tcd);
                    }
                    ps.close();
                }
            } else if (DatabaseEngine.POSTGRESQL.equals(databaseEngine)) {
                PreparedStatement ps = conn.prepareStatement("select TABLE_NAME, COLUMN_NAME, DATA_TYPE, NUMERIC_PRECISION, NUMERIC_SCALE, IS_NULLABLE, CHARACTER_MAXIMUM_LENGTH from information_schema.columns WHERE TABLE_NAME=?");
                ps.setString(1, tableName.toLowerCase());
                if (ps.execute()) {
                    ResultSet rs = ps.getResultSet();
                    while (rs.next()) {
                        TableColumnDescriptor tcd = new TableColumnDescriptor();
                        tcd.columnName = rs.getString(2).trim().toUpperCase();
                        tcd.columnType = rs.getString(3).trim();
                        tcd.columnLength = rs.getInt(4);
                        tcd.scale = rs.getInt(5);
                        tcd.oracleNullable = rs.getString(6).equalsIgnoreCase("YES");
                        tcd.columnCharLength = rs.getInt(7);
                        td.tableColumns.put(tcd.columnName, tcd);
                    }
                    ps.close();
                }
            } else {
                throw this.unsupportedDatabase();
            }
            return td;
        });
    }

    private TableDescriptor findProcedureDescriptorFromDb(String procedureName, boolean inputParameters) {
        return (TableDescriptor)SUtils$.MODULE$.withResources((Function0 & Serializable & scala.Serializable)() -> $this.ds.getConnection(), (Function1 & Serializable & scala.Serializable)conn -> {
            TableDescriptor td = new TableDescriptor();
            td.tableName = procedureName;
            this.logger().debug(new StringBuilder(31).append("zjistuji informace o procedure ").append(procedureName).toString());
            DatabaseEngine databaseEngine = this.dbEngine();
            if (DatabaseEngine.FIREBIRD.equals(databaseEngine)) {
                String command = "SELECT RDB$PROCEDURE_PARAMETERS.RDB$PARAMETER_NAME AS COLUMN_NAME, RDB$TYPES.RDB$TYPE_NAME AS DATA_TYPE, RDB$FIELDS.RDB$FIELD_LENGTH AS LEN, RDB$FIELDS.RDB$CHARACTER_LENGTH AS CHAR_LEN, RDB$FIELDS.RDB$FIELD_SCALE AS SCALE FROM RDB$PROCEDURE_PARAMETERS LEFT JOIN RDB$FIELDS ON RDB$PROCEDURE_PARAMETERS.RDB$FIELD_SOURCE = RDB$FIELDS.RDB$FIELD_NAME LEFT JOIN RDB$TYPES ON RDB$FIELDS.RDB$FIELD_TYPE = RDB$TYPES.RDB$TYPE WHERE RDB$PROCEDURE_PARAMETERS.RDB$PROCEDURE_NAME = ?  AND RDB$TYPES.RDB$FIELD_NAME='RDB$FIELD_TYPE' AND RDB$PROCEDURE_PARAMETERS.RDB$PARAMETER_TYPE=? ORDER BY RDB$PROCEDURE_PARAMETERS.RDB$PARAMETER_NUMBER ";
                PreparedStatement ps = conn.prepareStatement(command);
                ps.setString(1, procedureName);
                ps.setInt(2, inputParameters ? 0 : 1);
                if (ps.execute()) {
                    ResultSet rs = ps.getResultSet();
                    while (rs.next()) {
                        TableColumnDescriptor tcd = new TableColumnDescriptor();
                        tcd.columnName = rs.getString(1).trim().toUpperCase();
                        tcd.columnType = rs.getString(2).trim();
                        tcd.columnLength = rs.getInt(3);
                        tcd.columnCharLength = rs.getInt(4);
                        tcd.scale = rs.getInt(5);
                        td.tableColumns.put(tcd.columnName, tcd);
                    }
                    ps.close();
                }
            } else if (DatabaseEngine.ORACLE.equals(databaseEngine)) {
                PreparedStatement ps = conn.prepareStatement(new StringBuilder(160).append("select argument_name, data_type, data_precision from all_arguments where  owner = '").append($this.dbEngine().dbSchema).append("' and package_name is null ").append("and IN_OUT=? and object_name = ? ").append("order by position").toString());
                ps.setString(1, procedureName);
                ps.setString(2, inputParameters ? "IN" : "OUT");
                if (ps.execute()) {
                    ResultSet rs = ps.getResultSet();
                    while (rs.next()) {
                        TableColumnDescriptor tcd = new TableColumnDescriptor();
                        tcd.columnName = rs.getString(1).trim().toUpperCase();
                        tcd.columnType = rs.getString(2).trim();
                        int colLen = rs.getInt(3);
                        tcd.columnLength = colLen == 0 || rs.wasNull() ? 16 : colLen;
                        td.tableColumns.put(tcd.columnName, tcd);
                    }
                    ps.close();
                }
            } else {
                throw this.unsupportedDatabase();
            }
            return td;
        });
    }

    private boolean findProcedureDescriptorFromDb$default$2() {
        return true;
    }

    private Nothing$ unsupportedDatabase() {
        throw new IllegalArgumentException(new StringBuilder(27).append("nepodporovany typ databaze ").append(this.dbEngine()).toString());
    }

    public TableDescriptorProvider(DataSource ds, DatabaseEngine dbEngine) {
        this.ds = ds;
        this.dbEngine = dbEngine;
        this.logger = LoggerFactory.getLogger(TableDescriptorProvider.class);
        this.tableDescriptorMap = new HashMap();
        this.procedureDescriptorMap = new LinkedHashMap();
    }
}

