/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.db;

import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TransactionHelper<T> {
    private static final Logger logger = LoggerFactory.getLogger(TransactionHelper.class);
    protected Connection conn;

    public TransactionHelper(Connection conn) {
        this.conn = conn;
        try {
            conn.setAutoCommit(false);
        }
        catch (SQLException e) {
            logger.error("nelze vypnout transakcni autocommit mod");
        }
    }

    protected abstract Object run() throws SQLException;

    public T process() throws Exception {
        T o = null;
        Object tran = null;
        try {
            this.run();
            this.conn.commit();
        }
        catch (Exception e) {
            try {
                this.conn.rollback();
            }
            catch (SQLException e1) {
                logger.error("nastala vyjimka pri rollback transakce " + e.getMessage());
                throw e;
            }
            logger.error("nastala vyjimka " + e.getMessage());
            throw e;
        }
        this.conn.close();
        return o;
    }
}

