/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.db;

import cz.kpsys.AppServerStatus;
import cz.kpsys.common.IniConstants;
import cz.kpsys.db.BeanHandlers;
import cz.kpsys.db.CirkulaceExecutor;
import cz.kpsys.db.DatabaseEngine;
import cz.kpsys.db.DbCache;
import cz.kpsys.db.DbCache2;
import cz.kpsys.db.DbCache2NG;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.DbCore2Utils;
import cz.kpsys.db.GenUpomExecutor;
import cz.kpsys.db.GenericExecutor;
import cz.kpsys.db.GenericExecutorScala;
import cz.kpsys.db.KPSYSBeanHandler;
import cz.kpsys.db.NumberHandler;
import cz.kpsys.db.OverRezeExecutor;
import cz.kpsys.db.ProxoolUtil;
import cz.kpsys.db.QueryRunnerOpened;
import cz.kpsys.db.ScalaRunnerOpened;
import cz.kpsys.db.SingleConnectionDataSource;
import cz.kpsys.db.VracExecutorHelper;
import cz.kpsys.db.VypujckaExecutor;
import cz.kpsys.db.VypujckaExecutorHelper;
import cz.kpsys.db.model.LzeRezervovatExemplarOutput;
import cz.kpsys.db.model.OverRezeInput;
import cz.kpsys.db.model.RezervaceResult;
import cz.kpsys.db.model.VracInput;
import cz.kpsys.db.model.VracOutput;
import cz.kpsys.db.model.VypucInput;
import cz.kpsys.db.model.api.boxassign.BoxAssign;
import cz.kpsys.db.model.v2.BoxStation;
import cz.kpsys.db.model.v2.Ctenari;
import cz.kpsys.db.model.v2.DefCtenKat;
import cz.kpsys.db.model.v2.DefCtenVyp;
import cz.kpsys.db.model.v2.DefFond;
import cz.kpsys.db.model.v2.DefLokace;
import cz.kpsys.db.model.v2.DefPujc;
import cz.kpsys.db.model.v2.DefStatus;
import cz.kpsys.db.model.v2.DefVypKat;
import cz.kpsys.db.model.v2.GeneratorNames;
import cz.kpsys.db.model.v2.Kat1_4;
import cz.kpsys.db.model.v2.Kat1_5;
import cz.kpsys.db.model.v2.MVS;
import cz.kpsys.db.model.v2.Platby;
import cz.kpsys.db.model.v2.PozRez;
import cz.kpsys.db.model.v2.Upominky;
import cz.kpsys.db.model.v2.Uzivatele;
import cz.kpsys.db.model.v2.Vypuc;
import cz.kpsys.db.model.v2.Vypuc2;
import cz.kpsys.db.model.v2.VypucTitPer;
import cz.kpsys.kpwin2.services.VerbisBoxService;
import cz.kpsys.marc.SessionData;
import cz.kpsys.service.DateConversions;
import cz.kpsys.service.Utils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.util.Try;

/*
 * Exception performing whole class analysis ignored.
 */
public class VracExecutor
extends GenericExecutor {
    public static final int ERR36_INVALID_PUJC = 36;
    public static final int ERR37_NO_LOCATION = 37;
    public static final int ERR38_INVALID_BUILDING = 38;
    public static final int ERR39_NO_ASSOCIATED_RECORD = 39;
    public static final int ERR48_NO_ASSOCIATED_DEF_DOKFOND = 48;
    public static final int ERR49_CHYBA_VYPUJCKY_CIRKULACE = 49;
    public static final int ERR3_NELZE_VRACET_CIZI_BUDOVY = 3;
    public static final int ERR4_DOTAZ_CIZI_BUDOVA = 4;
    public static final int ERR5_DOTAZ_VRACET_CIZI_LOKACE = 5;
    public static final int ERR6_DOTAZ_CIZI_LOKACE = 6;
    static final Logger logger = LoggerFactory.getLogger(VracExecutor.class);
    static final String vracTemplateHead = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<VRAC>\n   <NAZEV>%s</NAZEV>\n   <AUTOR>%s</AUTOR>\n   <ISBN>%s</ISBN>\n   <NAKL>%s</NAKL>\n   <SIGNATURA>%s</SIGNATURA>\n   <BAR_CODE>%s</BAR_CODE>\n   <PRIR_CISLO>%s</PRIR_CISLO>\n   <LOKACE>%s</LOKACE>\n";
    static final String vracTemplateRezCten = "   <REZ_CTEN>%s</REZ_CTEN>\n   <FK_VYPUC>%s</FK_VYPUC>\n";
    static final String vracTemplateCirkCten = "   <CIRK_CTEN>%s</CIRK_CTEN>\n";
    static final String shipmentItemIdTemplate = "   <SHIPMENT_ITEM_ID>%s</SHIPMENT_ITEM_ID>\n";
    static final String boxStationIdTemplate = "   <BOX_STATION_ID>%s</BOX_STATION_ID>\n";
    static final String verbisBoxErrorTemplate = "   <VERBISBOX_ERROR>%s</VERBISBOX_ERROR>\n";
    static final String vracTemplatePokuta = "   <POKUTA>%s</POKUTA>\n";
    static final String vracTemplateTail = "</VRAC>\n";
    private static final int ERR601_CTENAR_NECHCE_TUTO_BUDOVU = 601;
    private static final int ERR20_HLASENI_PRILOHY = 20;
    private static final int ERR22_HLASENI_VRACENI_LOKACE = 22;
    private static final int ERR23_HLASENI_VRACENI_STATUS = 23;
    private static final int ERR30_EXTERNI_VYPUJCKA = 30;
    private static final int ERR27_HLASIT_MVS = 27;
    private static final int ERR29_HLASIT_POZNAMKA = 29;
    private static final int ERR31_HLASENI_STAVECI_ZNAK = 31;
    private static final int ERR32_EXEMPLAR_BEZ_BUDOVY = 32;
    private static final int ERR33_PREKROCEN_POCET_KUSU = 33;
    private static final int ERR34_TITULOVKA_BEZ_VYPUC_TITPER = 34;
    private static final short STATUS_KAT1_5_ZPETNA_KATALOGIZACE = 15;
    private static final short STATUS_KAT1_4_ZPETNA_KATALOGIZACE = 2;
    private static final int REZERVACE_LIMIT = 50;
    private static final short TYPPUJC_STANDARD = 0;
    private static final short TYPPUJC_TITULOVA = 1;
    private static final short TYPPUJC_MVS = 2;
    private static final int ERR2_NOT_OWN_VYPUC = 2;
    private static final int VYPUJCKA_NOT_FOUND = 1;
    private static final int ERR5_NELZE_ZRUSIT_VE_VERBISBOXU = 5;
    private final VracInput vracInput;
    private final List<DefLokace> lokaceList = new ArrayList();
    private final Date datum = Utils.now();
    Kat1_4 kat1_4;
    Kat1_5 kat1_5;
    Ctenari ctenar;
    DefStatus status;
    DefPujc pujcovna;
    DefFond dokFond;
    private Vypuc2 vypuc2;
    private BigDecimal castkaPokuty = BigDecimal.ZERO;

    public VracExecutor(DbCore2 core2, VracInput vracInput) {
        this.core2 = core2;
        this.qr = new QueryRunnerOpened((DataSource)new SingleConnectionDataSource(core2.conn));
        this.vracInput = vracInput;
    }

    public static void chyba(int errorCode, String message) throws AppServerStatus {
        AppServerStatus ve = new AppServerStatus(message, errorCode);
        throw ve;
    }

    public static void chyba(int errorCode, String message, String key, String value) throws AppServerStatus {
        AppServerStatus ve = new AppServerStatus(message, errorCode);
        ve.addReturnValue(key, value);
        throw ve;
    }

    public static Date zjistiLimitniDatum(String casovyUdaj) {
        if (StringUtils.isBlank((CharSequence)casovyUdaj)) {
            return null;
        }
        Pattern p = Pattern.compile("(\\d{1,2})([\\:/-](\\d{1,2}))?");
        Matcher m = p.matcher(casovyUdaj);
        if (m.matches()) {
            String hodiny = m.group(1);
            String minuty = m.groupCount() > 2 ? m.group(3) : null;
            try {
                LocalDateTime ldt = LocalDate.now().atStartOfDay();
                ldt = ldt.plusHours(Integer.parseInt(hodiny));
                if (StringUtils.isNotBlank((CharSequence)minuty)) {
                    ldt = ldt.plusMinutes(Integer.parseInt(minuty));
                }
                return DateConversions.localDateTime2utilDate((LocalDateTime)ldt);
            }
            catch (Exception e) {
                logger.error("chybne nastaveny cas v [VYPUC]INGOROVAT_POKUTY_DO: " + casovyUdaj, (Throwable)e);
            }
        }
        return null;
    }

    public static VracInput parseVracInput(Document doc, SessionData sessionData) throws SQLException {
        Element rootNode = doc.getRootElement();
        VracInput vracInput = new VracInput();
        vracInput.setIdCten(VracExecutor.parseCtenTag((Document)doc, (String)"//collection/vrac/ID_CTEN", (boolean)false));
        Node idExNode = doc.getRootElement().selectSingleNode("//collection/vrac/ID_EX");
        String idEx = idExNode != null ? idExNode.getText() : "0";
        Node idVypucNode = doc.getRootElement().selectSingleNode("//collection/vrac/ID_VYPUC");
        String idVypuc = idVypucNode != null ? idVypucNode.getText() : "0";
        boolean vynutit = VracExecutor.parseBooleanTag((Document)doc, (String)"//collection/vrac/VYNUTIT", (boolean)false);
        vracInput.setVynutit(vynutit);
        vracInput.setIdEx((long)Integer.parseInt(idEx));
        vracInput.setIdVypujcky(Long.valueOf(Long.parseLong(idVypuc)));
        vracInput.setPujcovna(Short.parseShort(doc.getRootElement().selectSingleNode("//collection/vrac/PUJCOVNA").getText()));
        vracInput.setFkUzivAkce(sessionData.getUcode());
        Node POC_KS_EL = doc.getRootElement().selectSingleNode("//collection/vrac/POCET_KS");
        if (POC_KS_EL != null) {
            String POC_KS = POC_KS_EL.getText();
            vracInput.setPocetKs(Integer.parseInt(POC_KS));
        }
        List nodes = doc.getRootElement().selectNodes("//collection/vrac/node()");
        for (Node n : nodes) {
            String name = n.getName();
            if (name == null) continue;
            vracInput.setPrepinac("ZapisPokuta", true);
            String key = n.getName().toUpperCase();
            if (!key.startsWith("HLASIT") && !key.equalsIgnoreCase("DotazPokuta") && !key.equalsIgnoreCase("ZapisPokuta")) continue;
            String value = n.getText().trim().toUpperCase();
            vracInput.setPrepinac(key, VracExecutor.tagHasTrueValue((String)value));
        }
        return vracInput;
    }

    private boolean isPropertyTrue(String key) {
        return this.vracInput.getPrepinacValue(key.toUpperCase());
    }

    public boolean overAPripravExemplar() throws SQLException {
        if (this.vracInput.idEx > 0L) {
            this.kat1_5 = DbCore2Utils.nactiKat1_5((long)this.vracInput.idEx, (ScalaRunnerOpened)this.core2.obtainScalaRunnerOpened());
            if (this.kat1_5 != null) {
                return true;
            }
        }
        return false;
    }

    public boolean overAPripravOthers() throws SQLException, AppServerStatus {
        this.pujcovna = (DefPujc)((scala.collection.immutable.Map)DbCache2NG.pujcovnyMap().get()).apply((Object)this.vracInput.pujcovna);
        if (this.pujcovna == null) {
            AppServerStatus ex = new AppServerStatus("Zadan\u00e1 FK_PUJC je neplatn\u00e1", 36);
            ex.addReturnValue("FK_PUJC", Integer.toString(this.vracInput.pujcovna));
            throw ex;
        }
        this.lokaceList.clear();
        this.lokaceList.addAll(VypujckaExecutorHelper.lokaceKPujcovneJava((short)this.vracInput.pujcovna));
        if (this.lokaceList.isEmpty()) {
            throw new AppServerStatus("P\u016fj\u010dovna, na kter\u00e9 se vrac\u00ed, nem\u00e1 p\u0159i\u0159azenou \u017e\u00e1dnou lokaci", 37);
        }
        if (this.kat1_4 != null) {
            this.dokFond = (DefFond)DbCache2.defDokFondMap.get(this.kat1_4.getFK_DOKFOND());
            if (this.dokFond == null) {
                throw new AppServerStatus("K z\u00e1znamu neexistuje definice DEF_DOKFOND", 48);
            }
        }
        return true;
    }

    private void pripravCtenKatVypKat() throws SQLException, AppServerStatus {
        if (this.ctenar == null) {
            throw new RuntimeException("nebyl pripraven Ctenar, zavolej overACtenare");
        }
        this.ctenKat = (DefCtenKat)((Map)DbCache2NG.ctenKatMap().get()).get(this.ctenar.getFK_CTENKAT());
        this.vypKat = (DefVypKat)((Map)DbCache2NG.vypKatMap().get()).get(this.vypuc2.getFK_VYPKAT());
        if (this.vypKat == null && this.vypuc2.getCIS_REZE() == 0) {
            AppServerStatus ex = new AppServerStatus("Ulo\u017een\u00e1 FK_VYPKAT je neplatn\u00e1", 611);
            ex.addReturnValue("FK_VYPKAT", this.vypuc2.getFK_VYPKAT());
            throw ex;
        }
    }

    private void pripravKat1_4() throws SQLException, AppServerStatus {
        String recordId = this.vracInput.idExDefinovano() ? this.kat1_5.getRECORD_ID() : this.vypuc2.getRECORD_ID();
        this.kat1_4 = DbCore2Utils.nactiKat1_4((String)recordId, (ScalaRunnerOpened)this.core2.obtainScalaRunnerOpened());
        if (this.kat1_4 == null) {
            throw new AppServerStatus("Na exempl\u00e1\u0159 nen\u00ed nav\u00e1z\u00e1n \u017e\u00e1dn\u00fd z\u00e1znam", 39);
        }
    }

    public void overAPripravCtenare() throws SQLException, AppServerStatus {
        if (this.vracInput.idCten != 0) {
            this.ctenar = DbCore2Utils.nactiCtenare((Integer)this.vracInput.idCten, (ScalaRunnerOpened)this.core2.obtainScalaRunnerOpened());
            if (this.ctenar == null) {
                throw new SQLException("ctenar neexistuje, id=" + this.vracInput.idCten);
            }
        }
        if (this.vracInput.idCten == 0 || this.vypuc2.getFK_UZIV_CTEN().intValue() != this.ctenar.getFK_UZIV()) {
            AppServerStatus ve = new AppServerStatus("Vypujcku nevlastni aktualni ctenar", 2);
            ve.addReturnValue("ID_CTEN", Long.toString(this.vypuc2.getFK_UZIV_CTEN().intValue()));
            throw ve;
        }
        this.core2.kontrolaDataObnoveni(this.ctenar, this.vracInput.pujcovna);
    }

    public boolean overAPripravVypujcku() throws SQLException {
        Vypuc vypuc;
        if (this.vracInput.idVypujcky != null && this.vracInput.idVypujcky != 0L) {
            vypuc = DbCore2Utils.nactiVypuc((long)this.vracInput.idVypujcky, (ScalaRunnerOpened)this.core2.obtainScalaRunnerOpened());
            if (vypuc == null) {
                return false;
            }
            this.vracInput.idEx = vypuc.getFK_EX();
        } else if (this.vracInput.idCten != null) {
            vypuc = (Vypuc)this.qr.query("SELECT * FROM VYPUC WHERE FK_EX=? AND FK_UZIV_CTEN=?", (ResultSetHandler)BeanHandlers.vypucHandler(), new Object[]{this.vracInput.idEx, this.vracInput.idCten});
            if (vypuc == null) {
                vypuc = (Vypuc)this.qr.query("SELECT * FROM VYPUC WHERE FK_EX=?", (ResultSetHandler)BeanHandlers.vypucHandler(), new Object[]{this.vracInput.idEx});
            }
        } else {
            vypuc = (Vypuc)this.qr.query("SELECT * FROM VYPUC WHERE FK_EX=?", (ResultSetHandler)BeanHandlers.vypucHandler(), new Object[]{this.vracInput.idEx});
        }
        if (vypuc != null) {
            this.vypuc2 = Vypuc2.createFromVypuc((Vypuc)vypuc);
            if (this.vracInput.idCten == null) {
                this.vracInput.setIdCten(this.vypuc2.getFK_UZIV_CTEN());
            }
            return true;
        }
        return false;
    }

    public boolean overAPripravStatus() throws SQLException {
        if (this.kat1_5 == null) {
            return true;
        }
        this.status = (DefStatus)((Map)DbCache2NG.statusMap().get()).get(this.kat1_5.getFK_STATUS());
        return this.status != null;
    }

    public void hlaseniRetezce() throws AppServerStatus {
        String kategorieTokens;
        String hlaska;
        String stavZnak;
        String status5Tokens;
        String lokaceTokens = DbCache2.queryINIFlag((String)"HLASENI_RETEZCE_VRACENI", (String)"LOKACE", (Short)this.vracInput.pujcovna, (Short)this.kat1_5.getFK_DOKFOND());
        HashMap tokeny = VracExecutor.tokenizujHlaseni((String)lokaceTokens);
        String hlaska2 = (String)tokeny.get(String.valueOf(this.kat1_5.getFK_LOKACE()));
        if (hlaska2 != null && this.isPropertyTrue("HlasitINILok")) {
            VracExecutor.chyba((int)22, (String)"HlasitINILok", (String)"TEXT", (String)hlaska2);
        }
        if ((hlaska2 = (String)(tokeny = VracExecutor.tokenizujHlaseni((String)(status5Tokens = DbCache2.queryINIFlag((String)"HLASENI_RETEZCE_VRACENI", (String)"STATUS5", (Short)this.vracInput.pujcovna, null)))).get(Short.toString(this.kat1_5.getFK_STATUS()))) != null && this.isPropertyTrue("HlasitINIStatus")) {
            VracExecutor.chyba((int)23, (String)"HlasitINIStatus", (String)"TEXT", (String)hlaska2);
        }
        if (StringUtils.isNotBlank((CharSequence)(stavZnak = this.kat1_5.getPOMOCNE())) && (hlaska = (String)(tokeny = VracExecutor.tokenizujHlaseni((String)(kategorieTokens = DbCache2.queryINIFlag((String)"HLASENI_RETEZCE_VRACENI", (String)"STAVZNAK", (Short)this.vracInput.pujcovna, null)))).get(stavZnak)) != null && this.isPropertyTrue("HlasitINIStavZnak")) {
            VracExecutor.chyba((int)31, (String)"Hlaseni dle INI HLASENI_RETEZCE_VRACENI, STAVZNAK", (String)"TEXT", (String)hlaska);
        }
    }

    public void provedTestyVratitelnosti() throws AppServerStatus, SQLException {
        String kategorieTokens;
        HashMap tokeny;
        String hlaska;
        if (!StringUtils.isBlank((CharSequence)this.kat1_5.getPRILOHY()) && this.isPropertyTrue("HlasitPrilohy")) {
            VracExecutor.chyba((int)20, (String)"DOTAZ: Hlasit prilohy", (String)"PRILOHA", (String)this.kat1_5.getPRILOHY());
        }
        if (this.vypKat != null && (hlaska = (String)(tokeny = VracExecutor.tokenizujHlaseni((String)(kategorieTokens = DbCache2.queryINIFlag((String)"HLASENI_RETEZCE_VRACENI", (String)"KATEGORIE", (Short)this.vracInput.pujcovna, null)))).get(this.vypKat.getID_VYPKAT())) != null && this.isPropertyTrue("HlasitINIKateg")) {
            VracExecutor.chyba((int)24, (String)"HlasitINIKateg", (String)"TEXT", (String)hlaska);
        }
        if ((this.kat1_4.getSTATUS4() == 2 || this.kat1_5 != null && this.kat1_5.getFK_STATUS() == 15) && this.isPropertyTrue("HlasitZpetKat")) {
            VracExecutor.chyba((int)25, (String)"DOTAZ: Zpetna katalogizace");
        }
        if (this.isPropertyTrue("HlasitRezervaci") && this.vypuc2.getCIS_REZE() > 50) {
            switch (this.vypuc2.getCIS_REZE()) {
                case 51: {
                    VracExecutor.chyba((int)26, (String)"DOTAZ: Neodeslana rezervace", (String)"REZNEO", (String)"1");
                }
                case 52: {
                    VracExecutor.chyba((int)26, (String)"DOTAZ: Odeslana rezervace", (String)"REZODE", (String)"1");
                }
                case 53: {
                    VracExecutor.chyba((int)26, (String)"DOTAZ: Nevyrizena objednavka", (String)"OBJNEV", (String)"1");
                }
                case 54: {
                    VracExecutor.chyba((int)26, (String)"DOTAZ: Vyrizena objednavka", (String)"OBJVYR", (String)"1");
                }
            }
        }
        if (this.ctenar.getKON_REG() != null && this.ctenar.getKON_REG().before(Utils.now()) && this.isPropertyTrue("HlasitNereg")) {
            VracExecutor.chyba((int)30, (String)"DOTAZ: Propadla registrace", (String)"DATUM", (String)Utils.sdfSQLDate().format(this.ctenar.getKON_REG()));
        }
    }

    public Vypuc2 pripravAZapisVypuc2(VracOutput vracOutput) throws SQLException, AppServerStatus {
        boolean jeTitulova;
        short fkPujc = this.vracInput.pujcovna;
        if (this.vypuc2 == null) {
            throw new SQLException("Pri zapisu Vypuc2 nebyla znama konkretni vypujcka");
        }
        this.vypuc2.setFK_PUJC_ZMENA(Short.valueOf(this.vracInput.pujcovna));
        boolean bl = jeTitulova = this.vypKat == null ? false : this.vypKat.jeTit();
        if (jeTitulova) {
            Integer pocetZbyvajicichKusu = this.pocetZbyvajicichKusu();
            if (pocetZbyvajicichKusu == null) {
                AppServerStatus se = new AppServerStatus("titulova vypujcka ale chybi evidence pujcenych kusu (tabulka VYPUC_TITPER) ", 34);
                se.addReturnValue("FK_VYPUC", Long.toString(this.vypuc2.getID_VYPUC()));
                throw se;
            }
            if (pocetZbyvajicichKusu < this.vracInput.pocetKs) {
                if (this.isPropertyTrue("HlasitPrekrocenyPocetKusu")) {
                    AppServerStatus status = new AppServerStatus("Nelze vratit vice kusu nez bylo zapujceno", 33);
                    status.addReturnValue("POCET_KUSU", pocetZbyvajicichKusu.toString());
                    throw status;
                }
                this.vracInput.pocetKs = pocetZbyvajicichKusu;
            }
            if (this.vracInput.pocetKs == 0) {
                AppServerStatus status = new AppServerStatus("DOTAZ: Po\u010det kus\u016f k vr\u00e1cen\u00ed?", 11).addReturnValue("ID_VYPUC", Long.toString(this.vypuc2.getID_VYPUC())).addReturnValue("POCET_KS", Integer.toString(pocetZbyvajicichKusu)).addReturnValue("NAZEV", this.kat1_4.getNAZEV());
                throw status;
            }
            if (pocetZbyvajicichKusu >= this.vracInput.pocetKs) {
                VypucTitPer vypucTitPer = new VypucTitPer();
                vypucTitPer.setDATUM(this.datum);
                vypucTitPer.setFK_VYPUC(this.vypuc2.getID_VYPUC());
                vypucTitPer.setZMENA((short)(-this.vracInput.pocetKs));
                this.zapisDoVypucTitPer(vypucTitPer);
                if (pocetZbyvajicichKusu == this.vracInput.pocetKs) {
                    this.qr.update("UPDATE VYPUC2 SET DAT_VR = " + Utils.todayNowString((int)1, (DatabaseEngine)ProxoolUtil.engine()) + " WHERE ID_VYPUC=?", (Object)this.vypuc2.getID_VYPUC());
                } else {
                    this.qr.update("UPDATE VYPUC2 SET DAT_PROL = " + Utils.todayNowString((int)1, (DatabaseEngine)ProxoolUtil.engine()) + " WHERE ID_VYPUC=?", (Object)this.vypuc2.getID_VYPUC());
                }
            }
        } else {
            if (VracExecutor.tagHasTrueValue((String)DbCache2.queryVypujcFlag((String)"NastavitPujcovnuDleVraceni", (short)fkPujc))) {
                this.vypuc2.setFK_PUJC(Short.valueOf(this.vracInput.pujcovna));
            }
            if (this.vypuc2.getFK_TYPPUJC() == 2 && this.vypuc2.getDAT_VR() != null) {
                this.qr.update("UPDATE VYPUC2 SET FK_PUJC = ?, CIS_REZE=0 WHERE ID_VYPUC=?", new Object[]{this.vypuc2.getFK_PUJC(), this.vypuc2.getID_VYPUC()});
            } else {
                this.vypuc2.setDAT_VR(this.datum);
                this.qr.update("UPDATE VYPUC2 SET DAT_VR = " + Utils.todayNowString((int)1, (DatabaseEngine)ProxoolUtil.engine()) + ", FK_PUJC = ?, CIS_REZE=?, FK_PUJC_ZMENA=? WHERE ID_VYPUC=?", new Object[]{this.vypuc2.getFK_PUJC(), this.vypuc2.getCIS_REZE(), this.vypuc2.getFK_PUJC_ZMENA(), this.vypuc2.getID_VYPUC()});
                if (this.vypuc2.getFK_TYPPUJC() == 2) {
                    this.vratPripadneAktivniMVS();
                }
            }
        }
        this.pokutaVraceni();
        return this.vypuc2;
    }

    private void vratPripadneAktivniMVS() throws SQLException {
        MVS aktivniMVS = (MVS)this.qr.query("SELECT * FROM MVS WHERE FK_VYPUC=? AND FK_STAVMVS=2", (ResultSetHandler)BeanHandlers.mvsHandler(), new Object[]{this.vypuc2.getID_VYPUC()});
        if (aktivniMVS != null && aktivniMVS.getJE_AKTIV() > 0) {
            this.qr.update("UPDATE MVS SET DAT_ODE=" + Utils.todayNowString((int)1, (DatabaseEngine)ProxoolUtil.engine()) + ", FK_STAVMVS=3 WHERE ID_MVS=?", (Object)aktivniMVS.getID_MVS());
        }
    }

    private void pokutaVraceni() throws SQLException, AppServerStatus {
        if (!this.isPropertyTrue("ZapisPokuta")) {
            return;
        }
        if (this.vypuc2.getCIS_REZE() == null || this.vypuc2.getCIS_REZE() > 0) {
            return;
        }
        this.castkaPokuty = GenericExecutorScala.spoctuPokutu((DefCtenVyp)this.ctenVyp, (short)this.vracInput.pujcovna, (short)this.kat1_4.getFK_DOKFOND(), (Date)this.vypuc2.getDAT_PROL(), (int)this.vypuc2.getDOB_VYP().shortValue());
        if (this.castkaPokuty.compareTo(BigDecimal.ZERO) > 0) {
            if (this.vypuc2.getCIS_UPOM() == 0 && DbCache2.queryIINIFlagIsTrue((String)IniConstants.SEKCE_VYPUC(), (String)IniConstants.VYPUC_POKUTAPOUPOMINCE(), (Short)this.vypuc2.getFK_PUJC(), null)) {
                logger.info("predpokladana castka pokuty " + this.castkaPokuty + " nebude pripsana, vypujcka jeste nebyla upominana " + this.vypuc2);
                return;
            }
            if (!this.isPropertyTrue("DotazPokuta")) {
                this.zapisPokutu(BigDecimal.ZERO.subtract(this.castkaPokuty), this.vypuc2.getID_VYPUC());
            } else {
                AppServerStatus ase = new AppServerStatus("zapsat pokutu?", 28);
                ase.addReturnValue("POKUTA", this.castkaPokuty.toString());
                throw ase;
            }
        }
    }

    private void zapisPokutu(BigDecimal castkaPokuty, long idVypuc) throws SQLException {
        Platby platba = new Platby();
        long ID_PLATBY = this.core2.generateID(GeneratorNames.SEQ_ID_PLATBY);
        platba.setFK_UZIV_VLASTNIK((long)this.ctenar.getFK_UZIV());
        platba.setFK_POPL((short)4);
        platba.setCASTKA(castkaPokuty);
        platba.setDATUM(this.datum);
        Short pujcovna = this.vracInput.pujcovna;
        platba.setFK_PUJC(pujcovna.shortValue());
        platba.setFK_UZIV((int)((short)this.core2.fkUziv()));
        platba.setFK_VYPUC(Long.valueOf(idVypuc));
        platba.setID_PLATBY(ID_PLATBY);
        logger.debug("zapisuji pokutu " + platba);
        this.qr.update("INSERT INTO PLATBY (FK_UZIV_VLASTNIK, FK_POPL, CASTKA, DATUM, FK_PUJC, FK_UZIV, SERVIS, ID_PLATBY, FK_VYPUC) VALUES (?,?,?,?,?,?,?,?,?)", new Object[]{platba.getFK_UZIV_VLASTNIK(), platba.getFK_POPL(), platba.getCASTKA(), Utils.util2sqlDate((Date)platba.getDATUM()), platba.getFK_PUJC(), platba.getFK_UZIV(), platba.getSERVIS(), platba.getID_PLATBY(), platba.getFK_VYPUC()});
    }

    private Integer pocetZbyvajicichKusu() throws SQLException {
        QueryRunnerOpened qr = this.core2.obtainQueryRunnerOpened();
        Number pocetKusu = (Number)qr.query("SELECT SUM(ZMENA) FROM VYPUC_TITPER WHERE FK_VYPUC=?", new Object[]{this.vypuc2.getID_VYPUC()}, (ResultSetHandler)new ScalarHandler());
        return pocetKusu == null ? null : Integer.valueOf(pocetKusu.intValue());
    }

    public String fillInVracTemplate(VracOutput vracOutput) {
        if (this.kat1_4 != null && this.kat1_5 != null) {
            Upominky upominka;
            String nazev = this.kat1_4.getNAZEV();
            String autor = this.kat1_4.getAUTOR();
            String isbn = this.kat1_4.getISBN();
            String nakl = this.kat1_4.getNAKL();
            String signatura = this.kat1_5.getSIGNATURA();
            String bar_code = this.kat1_5.getBAR_COD();
            String prirCislo = this.kat1_5.getPRIR_CISLO();
            int fkLokace = this.kat1_5.getFK_LOKACE();
            StringBuilder sb = new StringBuilder(String.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<VRAC>\n   <NAZEV>%s</NAZEV>\n   <AUTOR>%s</AUTOR>\n   <ISBN>%s</ISBN>\n   <NAKL>%s</NAKL>\n   <SIGNATURA>%s</SIGNATURA>\n   <BAR_CODE>%s</BAR_CODE>\n   <PRIR_CISLO>%s</PRIR_CISLO>\n   <LOKACE>%s</LOKACE>\n", Utils.xmlEscape((String)nazev), Utils.xmlEscape((String)autor), Utils.xmlEscape((String)isbn), Utils.xmlEscape((String)nakl), Utils.xmlEscape((String)signatura), Utils.xmlEscape((String)bar_code), Utils.xmlEscape((String)prirCislo), fkLokace));
            if (vracOutput != null) {
                if (vracOutput.ctenRez != null) {
                    sb.append(String.format("   <REZ_CTEN>%s</REZ_CTEN>\n   <FK_VYPUC>%s</FK_VYPUC>\n", vracOutput.ctenRez.getFK_UZIV(), vracOutput.fkVypucReze));
                }
                if (vracOutput.shipmentItemId != null) {
                    sb.append(String.format("   <SHIPMENT_ITEM_ID>%s</SHIPMENT_ITEM_ID>\n", vracOutput.shipmentItemId));
                }
                if (vracOutput.boxStationId != null) {
                    sb.append(String.format("   <BOX_STATION_ID>%s</BOX_STATION_ID>\n", vracOutput.boxStationId));
                }
                if (vracOutput.verbisBoxError != null) {
                    sb.append(String.format("   <VERBISBOX_ERROR>%s</VERBISBOX_ERROR>\n", vracOutput.verbisBoxError.getMessage()));
                }
                if (vracOutput.cirkCten != null) {
                    sb.append(String.format("   <CIRK_CTEN>%s</CIRK_CTEN>\n", vracOutput.cirkCten));
                }
            }
            if (this.castkaPokuty.compareTo(BigDecimal.ZERO) == 1) {
                sb.append(String.format("   <POKUTA>%s</POKUTA>\n", this.castkaPokuty.toPlainString()));
            }
            if ((upominka = vracOutput.upominka) != null) {
                sb.append("   <DAT_UPOM>" + Utils.sdfSQLDate().format(upominka.getDAT_GEN()) + "</DAT_UPOM>\n");
                sb.append("   <CISLO_UPOM>" + upominka.getCIS_UPOM() + "</CISLO_UPOM>\n");
            }
            if (this.vypuc2 != null) {
                sb.append("   <ID_VYPUC>" + this.vypuc2.getID_VYPUC() + "</ID_VYPUC>\n");
            }
            if (StringUtils.isNotBlank((CharSequence)vracOutput.zprava)) {
                sb.append("   <ZPRAVA>" + StringEscapeUtils.escapeXml10((String)vracOutput.zprava) + "</ZPRAVA>\n");
            }
            sb.append("</VRAC>\n");
            return sb.toString();
        }
        String s = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<VRAC>\n   <NAZEV>%s</NAZEV>\n   <AUTOR>%s</AUTOR>\n   <ISBN>%s</ISBN>\n   <NAKL>%s</NAKL>\n   <SIGNATURA>%s</SIGNATURA>\n   <BAR_CODE>%s</BAR_CODE>\n   <PRIR_CISLO>%s</PRIR_CISLO>\n   <LOKACE>%s</LOKACE>\n</VRAC>\n".replace("%s", "-");
        return s;
    }

    public void zrusVerbisBox(Vypuc vypuc, VracInput input, VracOutput output) {
        String shipmentItemId = vypuc.getSHIPMENT_ITEM_ID();
        if (StringUtils.isNotBlank((CharSequence)shipmentItemId)) {
            try {
                VerbisBoxService.smazShipmentItemId((int)vypuc.getFK_PUJC(), (int)input.getFkUzivAkce(), (UUID)UUID.fromString(shipmentItemId), (ScalaRunnerOpened)this.core2.obtainScalaRunnerOpened());
            }
            catch (Exception e) {
                logger.error("selhani volani verbisbox cancelItem", (Throwable)e);
                throw new AppServerStatus("Nastal problem s rusenim polozky zasilky ve verbisboxu: " + e.getMessage(), 5, (Throwable)e);
            }
        }
    }

    public VracOutput vrat() throws SQLException, AppServerStatus {
        boolean karantenaNeboNaCesteAktivni;
        boolean naCesteAktivni;
        VracOutput vracOutput = new VracOutput();
        logger.info("vraceni " + this.vracInput.toString());
        if (this.vracInput.isVynutit()) {
            if (this.vracInput.idVypujcky == null) {
                throw new SQLException("pozadovano vynuceni vraceni vypujcky ale nepredano zadne ID_VYPUC");
            }
            long idVypuc = this.vracInput.idVypujcky;
            Vypuc vypuc = DbCore2Utils.nactiVypuc((long)idVypuc, (ScalaRunnerOpened)this.core2.obtainScalaRunnerOpened());
            if (vypuc != null) {
                this.zrusVerbisBox(vypuc, this.vracInput, vracOutput);
            }
            this.qr.update("UPDATE VYPUC2 SET DAT_VR=" + Utils.todayNowString((int)1, (DatabaseEngine)ProxoolUtil.engine()) + " WHERE ID_VYPUC=?", (Object)idVypuc);
            vracOutput.fkVypucReze = idVypuc;
            return vracOutput;
        }
        if (this.vracInput.idExDefinovano()) {
            this.kontrolaExistenceExemplare();
            this.nacteniVypujcky();
        } else {
            this.nacteniVypujcky();
            this.kontrolaExistenceExemplare();
        }
        this.kontrolaExterniVypujcka();
        this.hlaseniPoznamky();
        this.dotazVraceniMVS();
        this.overAPripravCtenare();
        this.pripravKat1_4();
        if (this.vypuc2.getCIS_REZE() == 0) {
            String oznaceni;
            CirkulaceExecutor cirkulaceExecutor;
            Vypuc2 vypuc2cirk;
            this.pripravCtenKatVypKat();
            this.ctenVyp = VracExecutor.nactiKombinaciCtenKatVypKat((DefCtenKat)this.ctenKat, (DefVypKat)this.vypKat);
            if (this.vypKat.jeCirk() && (vypuc2cirk = (cirkulaceExecutor = new CirkulaceExecutor(this.core2)).vyridCirkulaci(this.vracInput, oznaceni = this.vypuc2.getOZNAC())) != null) {
                vracOutput.cirkCten = vypuc2cirk.getFK_UZIV_CTEN();
                vracOutput.fkVypucReze = vypuc2cirk.getID_VYPUC();
                return vracOutput;
            }
        }
        boolean overOthers = this.overAPripravOthers();
        boolean vracimeCiziBudova = false;
        try {
            vracimeCiziBudova = !VracExecutorHelper.jeVlastniBudova((short)this.vracInput.pujcovna, (short)this.kat1_5.getFK_PUJC());
        }
        catch (Exception vypuc2cirk) {
            // empty catch block
        }
        if (!Utils.blankLong((Long)this.vracInput.idEx)) {
            this.vracInput.idVypujcky = this.vypuc2.getID_VYPUC();
            if (!this.overAPripravStatus()) {
                throw new SQLException("nelze zjistit status exemplare, fk_stat=" + this.kat1_5.getFK_STATUS());
            }
            if (!overOthers) {
                throw new SQLException("problem pri zjistovani dat potrebnych k vypujcce");
            }
            this.overKombinaciCtenKatAVypKat(true, this.ctenVyp);
            if (!this.vypuc2.jeMVS()) {
                if (vracimeCiziBudova) {
                    if (!VracExecutor.tagHasTrueValue((String)DbCache2.queryVypujcFlag((String)IniConstants.VYPUC_VRACETCIZIBUDOVY(), (short)this.pujcovna.getID_PUJC()))) {
                        VracExecutor.chyba((int)3, (String)"CHYBA: Nelze vracet cizi pujcovny");
                    }
                    if (this.isPropertyTrue("HlasitCiziBudovy")) {
                        VracExecutor.chyba((int)4, (String)"DOTAZ: Cizi pujcovna");
                    }
                }
                if (!this.overLokaci()) {
                    if (!VracExecutor.tagHasTrueValue((String)DbCache2.queryVypujcFlag((String)IniConstants.VYPUC_VRACETCIZILOKACE(), (short)this.pujcovna.getID_PUJC()))) {
                        VracExecutor.chyba((int)5, (String)"DOTAZ: Vracet cizi lokace");
                    }
                    if (this.isPropertyTrue("HlasitCiziLokace")) {
                        VracExecutor.chyba((int)6, (String)"Dotaz cizi lokace");
                    }
                }
            }
            this.provedTestyVratitelnosti();
        } else {
            this.overAPripravStatus();
            this.vracInput.idVypujcky = this.vypuc2.getID_VYPUC();
        }
        this.kontrolaUpominky(vracOutput);
        Vypuc vypucProVerbisBox = DbCore2Utils.nactiVypuc((long)this.vypuc2.getID_VYPUC(), (ScalaRunnerOpened)this.core2.obtainScalaRunnerOpened());
        Vypuc2 vypuc2 = this.pripravAZapisVypuc2(vracOutput);
        int karantenaDni = (Integer)Try.apply(() -> Integer.parseInt(DbCache2.queryINIFlag((String)IniConstants.SEKCE_VYPUC(), (String)IniConstants.VYPUC_KARANTENA_DNI(), (Short)this.vracInput.getPujcovna(), null))).getOrElse(() -> 0);
        int naCesteDni = (Integer)Try.apply(() -> Integer.parseInt(DbCache2.queryINIFlag((String)IniConstants.SEKCE_VYPUC(), (String)IniConstants.VYPUC_NACESTE_DNI(), (Short)this.vracInput.getPujcovna(), null))).getOrElse(() -> 0);
        boolean karantenaPovolena = karantenaDni > 0;
        boolean naCestePovolena = naCesteDni > 0;
        boolean bl = naCesteAktivni = naCestePovolena && vracimeCiziBudova;
        if (karantenaPovolena && naCestePovolena) {
            logger.warn("jsou zapnuty funkce KARANTENA i NACESTE, toto neni validni, bude uprednostnena funkce KARANTENA");
        }
        boolean bl2 = karantenaNeboNaCesteAktivni = karantenaPovolena || naCesteAktivni;
        if (vypucProVerbisBox != null && vypucProVerbisBox.getCIS_REZE() != 0) {
            this.zrusVerbisBox(vypucProVerbisBox, this.vracInput, vracOutput);
        }
        RezervaceResult rezervaceResult = this.najdiARezervuj(vracOutput, karantenaNeboNaCesteAktivni, this.vypKat);
        if (karantenaPovolena) {
            if (rezervaceResult != null) {
                Uzivatele uzivatel = DbCache.uzivatel((int)rezervaceResult.cten().FK_UZIV);
                vracOutput.pridejZpravu("REZERVACE pro " + uzivatel.getZOBR_JMENO());
            }
            if (vypuc2.getFK_EX() != null && this.kat1_5 != null) {
                DefStatus statusKarantena = (DefStatus)((Map)DbCache2NG.statusMap().get()).get((short)20);
                if (statusKarantena == null) {
                    logger.warn("status KARANTENA neexistuje, karantena nefunkcni");
                } else if (vypuc2.getCIS_REZE() == 0 && (vypuc2.getFK_TYPPUJC() == 0 || vypuc2.getFK_TYPPUJC() == 2) && vypuc2.getFK_EX() > 0L) {
                    VracExecutorHelper.nastavStatusKarantenaNaCesteAZaloguj((Connection)this.core2.conn, (long)vypuc2.getFK_EX(), (short)this.kat1_5.getFK_STATUS(), (String)"KARANTENA");
                    vracOutput.pridejZpravu("Exempl\u00e1\u0159 byl d\u00e1n do karant\u00e9ny na " + karantenaDni + " dn\u00ed");
                    this.status = statusKarantena;
                }
            }
        } else if (naCesteAktivni) {
            if (rezervaceResult != null) {
                Uzivatele uzivatel = DbCache.uzivatel((int)rezervaceResult.cten().FK_UZIV);
                vracOutput.pridejZpravu("REZERVACE pro " + uzivatel.getZOBR_JMENO());
            }
            if (vypuc2.getFK_EX() != null && this.kat1_5 != null) {
                DefStatus statusNaCeste = (DefStatus)((Map)DbCache2NG.statusMap().get()).get((short)21);
                if (statusNaCeste == null) {
                    logger.warn("status NACESTE neexistuje, funkce 'naceste' nefunkcni");
                } else if (vypuc2.getCIS_REZE() == 0 && (vypuc2.getFK_TYPPUJC() == 0 || vypuc2.getFK_TYPPUJC() == 2) && vypuc2.getFK_EX() > 0L) {
                    VracExecutorHelper.nastavStatusKarantenaNaCesteAZaloguj((Connection)this.core2.conn, (long)vypuc2.getFK_EX(), (short)this.kat1_5.getFK_STATUS(), (String)"NACESTE");
                    vracOutput.pridejZpravu("Exempl\u00e1\u0159 je ve stavu Na cest\u011b na " + naCesteDni + " dn\u00ed");
                    this.status = statusNaCeste;
                }
            }
        } else if (rezervaceResult != null) {
            vracOutput.fkVypucReze = rezervaceResult.fkVypuc();
            vracOutput.ctenRez = rezervaceResult.cten();
            vracOutput.shipmentItemId = rezervaceResult.shipmentItemId();
            vracOutput.boxStationId = rezervaceResult.boxStationId();
            vracOutput.verbisBoxError = rezervaceResult.verbisBoxError();
        }
        this.sklepejRezervace();
        GenUpomExecutor.vycistiPoleServis((QueryRunner)this.qr, (short)vypuc2.getCIS_UPOM(), (short)this.vracInput.pujcovna, (int)vypuc2.getFK_UZIV_CTEN(), (long)vypuc2.getID_VYPUC());
        this.kontrolaReindexace(this.qr, vypuc2.getRECORD_ID());
        return vracOutput;
    }

    private void kontrolaExterniVypujcka() throws AppServerStatus {
        if (this.vypuc2.getFK_TYPPUJC() == 3 && this.vypuc2.getOZNAC() != null && this.vypuc2.getOZNAC().contains("EREADING")) {
            throw new AppServerStatus("ereading nelze vracet", 30);
        }
    }

    public void kontrolaExistenceExemplare() throws SQLException, AppServerStatus {
        boolean vysledek = this.overAPripravExemplar();
        if (!vysledek) {
            if (this.vypuc2.getFK_TYPPUJC() != 2) {
                throw new SQLException("exemplar neexistuje, id=" + this.vracInput.idEx);
            }
        } else {
            if (this.vypKat == null) {
                this.vypKat = (DefVypKat)((Map)DbCache2NG.vypKatMap().get()).get(this.kat1_5.getFK_VYPKAT());
            }
            this.hlaseniRetezce();
        }
    }

    public void dotazVraceniMVS() throws AppServerStatus {
        if (this.vypuc2.getFK_TYPPUJC() == 2 && this.isPropertyTrue("HlasitMVS")) {
            throw new AppServerStatus("DOTAZ: vratit MVS?", 27);
        }
    }

    public void nacteniVypujcky() throws SQLException, AppServerStatus {
        if (!this.overAPripravVypujcku()) {
            AppServerStatus ex = new AppServerStatus("nenalezena zadna vypujcka exemplare", 1);
            ex.addReturnValue("ID_EX", Long.toString(this.vracInput.idEx));
            throw ex;
        }
    }

    public void hlaseniPoznamky() throws AppServerStatus {
        if (this.isPropertyTrue("HlasitPoznamka") && StringUtils.isNotBlank((CharSequence)this.vypuc2.getPOZNAMKA())) {
            AppServerStatus ex = new AppServerStatus("poznamka", 29);
            ex.addReturnValue("POZNAMKA", this.vypuc2.getPOZNAMKA());
            throw ex;
        }
    }

    private void kontrolaUpominky(VracOutput output) throws SQLException {
        Upominky upominka;
        if (this.vypuc2.getCIS_UPOM() > 0 && (upominka = (Upominky)this.qr.query("SELECT * FROM UPOMINKY WHERE FK_VYPUC=? AND CIS_UPOM=?", (ResultSetHandler)BeanHandlers.upominkyHandler(), new Object[]{this.vypuc2.getID_VYPUC(), this.vypuc2.getCIS_UPOM()})) != null) {
            output.upominka = upominka;
        }
    }

    public void pripravaZapisQueryDoKat1_5(Kat1_4 kat1_4, Kat1_5 kat1_5) {
        this.kat1_4 = kat1_4;
        this.kat1_5 = kat1_5;
        this.vypKat = (DefVypKat)((Map)DbCache2NG.vypKatMap().get()).get(kat1_5.getFK_VYPKAT());
        this.status = (DefStatus)((Map)DbCache2NG.statusMap().get()).get(kat1_5.getFK_STATUS());
    }

    RezervaceResult najdiARezervuj(VracOutput najdiARezervujOutput, boolean readOnly, DefVypKat vypKatVraceny) throws SQLException, AppServerStatus {
        int count;
        RezervaceResult rezervaceResult = null;
        if (this.kat1_4 == null || this.kat1_5 == null) {
            return null;
        }
        boolean jePerio = ((DefFond)DbCache2.defDokFondMap.get(this.kat1_4.getFK_DOKFOND())).isJE_PERIO();
        if (!jePerio && (count = ((Number)this.qr.query("SELECT COUNT(*) FROM VYPUC WHERE FK_EX=?", (ResultSetHandler)new NumberHandler((Number)0), new Object[]{this.kat1_5.getID_EX()})).intValue()) > 0) {
            return null;
        }
        if (this.kat1_5 != null && this.kat1_4 != null && !StringUtils.equals((CharSequence)this.kat1_4.getRECORD_ID(), (CharSequence)this.kat1_5.getRECORD_ID())) {
            return null;
        }
        this.initVirtualniPujcovny(null, List.of(Short.valueOf(this.vracInput.pujcovna)));
        this.overAPripravOthers();
        if (vypKatVraceny != null && !vypKatVraceny.jeReze() || this.status != null && (!this.status.isJE_REZE() || this.status.getID_STATUS() == 20) || this.pujcovna == null || !this.pujcovna.isJE_ONLINE()) {
            return null;
        }
        KPSYSBeanHandler ctenariHandler = BeanHandlers.ctenariHandler();
        List seznamPredRezervaci = (List)this.qr.query("SELECT * FROM VYPUC WHERE FK_ZAZ=? AND CIS_REZE BETWEEN 1 AND 50 ORDER BY CIS_REZE", (ResultSetHandler)BeanHandlers.vypucListHandler(), new Object[]{this.kat1_4.getID_ZAZ()});
        if (seznamPredRezervaci.isEmpty()) {
            return null;
        }
        Ctenari ctenarSPredrezervaci = null;
        for (Vypuc vypucPredreze : seznamPredRezervaci) {
            Long fkEx;
            VypucInput vypucInput;
            block26: {
                PozRez pozRez;
                Ctenari ctenMPR = DbCore2Utils.nactiCtenare((Integer)vypucPredreze.getFK_UZIV_CTEN(), (ScalaRunnerOpened)this.core2.obtainScalaRunnerOpened());
                if (vypKatVraceny != null && vypKatVraceny.jePrez() && (pozRez = DbCore2Utils.nactiPozRezDleVypuc((long)vypucPredreze.getFK_VYPUC(), (ScalaRunnerOpened)this.core2.obtainScalaRunnerOpened())) != null && !pozRez.isLZE_PREZ() || ctenMPR.isSMAZANYBLOKOVANY()) continue;
                DefCtenKat ctenKatMPR = (DefCtenKat)((Map)DbCache2NG.ctenKatMap().get()).get(ctenMPR.getFK_CTENKAT());
                vypucInput = new VypucInput();
                vypucInput.predRezervace = true;
                vypucInput.idEx = this.kat1_5.getID_EX();
                vypucInput.idCten = vypucPredreze.getFK_UZIV_CTEN();
                vypucInput.pujcovna = this.vracInput.getPujcovna();
                vypucInput.idVyp = vypucPredreze.getFK_VYPUC();
                vypucInput.setFkUzivAkce(this.vracInput.getFkUzivAkce());
                vypucInput.oznaceni = this.zjistiANaplnIdentifikatorExemplare(this.kat1_5);
                vypucInput.vypKat = this.kat1_5.getFK_VYPKAT();
                List seznamValidnichBudov = (List)this.qr.query("SELECT FK_PUJC FROM VYPUC_REZE_PUJCOVNY WHERE FK_VYPUC=?", (ResultSetHandler)BeanHandlers.JSHORT_LIST_HANDLER(), new Object[]{vypucPredreze.getFK_VYPUC()});
                Short pujcovnaExemplare = this.kat1_5.getFK_PUJC();
                boolean jeMoznyPresunNaVirtualniPujcovnu = GenericExecutorScala.jeMoznyPresunNaVirtualniPujcovnu((Kat1_5)this.kat1_5, (Set)this.bratZ, (Set)this.posilatNa, (List)seznamValidnichBudov);
                if (jeMoznyPresunNaVirtualniPujcovnu) {
                    logger.info("exemplar splnuje podminku pro presun na virtualni budovu");
                    short pujcovnaId = (Short)this.posilatNa.iterator().next();
                    List lokaceList = DbCache2.najdiLokaceKPujcovne((short)pujcovnaId);
                    if (!lokaceList.isEmpty()) {
                        this.kat1_5.setFK_LOKACE(((Integer)lokaceList.get(0)).intValue());
                    }
                }
                if (!jeMoznyPresunNaVirtualniPujcovnu && !seznamValidnichBudov.isEmpty() && !seznamValidnichBudov.contains(pujcovnaExemplare)) continue;
                PozRez pozRez2 = DbCore2Utils.nactiPozRezDleVypuc((long)vypucPredreze.getFK_VYPUC(), (ScalaRunnerOpened)this.core2.obtainScalaRunnerOpened());
                boolean pozadavekNaKonkretniKus = false;
                fkEx = null;
                if (pozRez2 != null && (fkEx = pozRez2.getFK_EX()) != null) {
                    if (fkEx.longValue() != this.kat1_5.getID_EX()) continue;
                    pozadavekNaKonkretniKus = true;
                }
                if (fkEx == null) {
                    fkEx = vypucInput.idEx;
                }
                if (fkEx == null) continue;
                if (!pozadavekNaKonkretniKus) {
                    OverRezeInput overRezeInput = new OverRezeInput();
                    overRezeInput.idEx = fkEx;
                    overRezeInput.fkUzivCten = ctenMPR.getFK_UZIV();
                    overRezeInput.ingorovatVyjimkyNelzePujc = true;
                    overRezeInput.naplnUdajeZExemplare(this.kat1_5);
                    OverRezeExecutor overRezeExecutor = new OverRezeExecutor(this.core2, overRezeInput);
                    try {
                        LzeRezervovatExemplarOutput lzeRezervovatExemplarOutput = overRezeExecutor.lzeRezervovatExemplar();
                        if (lzeRezervovatExemplarOutput.nelzePujcit || lzeRezervovatExemplarOutput.nelzeReze) continue;
                        Optional jePrez = GenericExecutor.jePrez((Ctenari)ctenMPR, (Kat1_5)this.kat1_5);
                        if (jePrez.isPresent() && !pozRez2.isLZE_PREZ() && ((Boolean)jePrez.get()).booleanValue()) {
                        }
                        break block26;
                    }
                    catch (Exception se) {
                        if (!(se instanceof AppServerStatus)) break block26;
                        AppServerStatus ase = (AppServerStatus)((Object)se);
                        int errorCode = ase.getErrorCode();
                        if (errorCode < 15) continue;
                        if (errorCode <= 19) break block26;
                    }
                    continue;
                }
            }
            try {
                VypujckaExecutor ve = new VypujckaExecutor(this.core2, vypucInput);
                Vypuc2 vypuc2Zapis = Vypuc2.createFromVypuc((Vypuc)vypucPredreze);
                boolean wasNull = vypuc2Zapis.getFK_EX() == null || vypuc2Zapis.getFK_EX() == 0L;
                vypuc2Zapis.setFK_EX(fkEx);
                vypucPredreze.setFK_EX(fkEx);
                if (wasNull) {
                    vypuc2Zapis.setOZNAC(vypucInput.oznaceni);
                    vypuc2Zapis.setCENA(this.kat1_5.getCENA());
                    vypuc2Zapis.setFK_TEMSKUP(this.kat1_5.getFK_TEMSKUP());
                    vypuc2Zapis.setFK_LOKACE(Integer.valueOf(this.kat1_5.getFK_LOKACE()));
                    vypuc2Zapis.setFK_VYPKAT(this.kat1_5.getFK_VYPKAT());
                    vypuc2Zapis.setFK_PUJC(Short.valueOf(this.vracInput.pujcovna));
                    if (!readOnly) {
                        this.zapisDataExemplare(vypuc2Zapis);
                    }
                }
                if (!readOnly) {
                    ctenarSPredrezervaci = ve.predrezervuj(vypuc2Zapis);
                } else {
                    try {
                        ctenarSPredrezervaci = (Ctenari)DbCache2.ctenariCache.get((Object)vypucPredreze.getFK_UZIV_CTEN());
                    }
                    catch (ExecutionException e) {
                        logger.warn("selhalo nacteni ctenare " + vypucPredreze.getFK_UZIV_CTEN(), (Throwable)e);
                    }
                }
                if (ctenarSPredrezervaci == null) continue;
                UUID shipmentItemId = null;
                Exception verbisBoxError = null;
                UUID boxStationId = null;
                PozRez pozRezPredreze = DbCore2Utils.nactiPozRezDleVypuc((long)vypucPredreze.getFK_VYPUC(), (ScalaRunnerOpened)this.core2.obtainScalaRunnerOpened());
                if (pozRezPredreze.pujcovny().size() == 1) {
                    Short pujcovnaPredrezervace = (Short)pozRezPredreze.pujcovny().iterator().next();
                    BoxStation boxStation = (BoxStation)((scala.collection.immutable.Map)DbCache2NG.boxStationMap().get()).get((Object)pujcovnaPredrezervace).getOrElse(() -> null);
                    if (boxStation != null) {
                        boxStationId = boxStation.ID();
                        logger.info("detekovana rezervace do verbisboxu " + pozRezPredreze);
                        try {
                            BoxAssign boxAssign = VerbisBoxService.zapisZVypujcky((int)pujcovnaPredrezervace.shortValue(), (int)this.vracInput.fkUzivAkce, (Vypuc)vypucPredreze, (short)this.vracInput.pujcovna, (ScalaRunnerOpened)this.core2.obtainScalaRunnerOpened());
                            shipmentItemId = boxAssign.shipmentItemId();
                        }
                        catch (Exception e) {
                            logger.error("selhani komunikace s verbisbox pri zpracovani predrezervace " + vypucPredreze, (Throwable)e);
                            verbisBoxError = e;
                        }
                    }
                }
                rezervaceResult = new RezervaceResult(ctenarSPredrezervaci, vypucPredreze.getFK_VYPUC(), shipmentItemId, verbisBoxError, boxStationId);
                break;
            }
            catch (AppServerStatus ve) {
                logger.error("chyba pri zapisu neodeslane rezervace", (Throwable)ve);
            }
        }
        return rezervaceResult;
    }

    private void zapisDataExemplare(Vypuc2 vypuc2Zapis) throws SQLException {
        this.qr.update("UPDATE VYPUC2 SET FK_EX=?, OZNAC=?, CENA=?, FK_TEMSKUP=?, FK_LOKACE=?, FK_VYPKAT=? WHERE ID_VYPUC=?", new Object[]{vypuc2Zapis.getFK_EX(), vypuc2Zapis.getOZNAC(), vypuc2Zapis.getCENA(), vypuc2Zapis.getFK_TEMSKUP(), vypuc2Zapis.getFK_LOKACE(), vypuc2Zapis.getFK_VYPKAT(), vypuc2Zapis.getID_VYPUC()});
    }

    public void sklepejRezervace() throws SQLException {
        if (this.vracInput.getIdEx() == null || this.vracInput.getIdEx() == 0L || this.kat1_4 == null) {
            return;
        }
        this.sklepejRezervaceExemplar(this.vracInput.getIdEx());
        this.sklepejRezervaceTitul(this.kat1_4.getID_ZAZ());
    }

    private boolean overLokaci() {
        for (DefLokace defLokace : this.lokaceList) {
            if (defLokace.getID_LOKACE() != this.kat1_5.getFK_LOKACE()) continue;
            return true;
        }
        return false;
    }

    public Vypuc2 najdiAktivniVypujcku() throws SQLException {
        return (Vypuc2)this.qr.query("SELECT * FROM VYPUC WHERE FK_ZAZ=? AND FK_UZIV_CTEN=?", (ResultSetHandler)new ScalarHandler(), new Object[]{this.kat1_4.getID_ZAZ(), this.vracInput.idCten});
    }
}

