/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.db;

import cz.kpsys.AppServerStatus;
import cz.kpsys.db.DatabaseEngine;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.DbCore2Utils;
import cz.kpsys.db.GenericExecutor;
import cz.kpsys.db.ProxoolUtil;
import cz.kpsys.db.QueryRunnerOpened;
import cz.kpsys.db.ScalaRunnerOpened;
import cz.kpsys.db.SingleConnectionDataSource;
import cz.kpsys.db.VracExecutor;
import cz.kpsys.db.model.VracInput;
import cz.kpsys.db.model.VracMVSInput;
import cz.kpsys.db.model.VracMVSOutput;
import cz.kpsys.db.model.VracOutput;
import cz.kpsys.db.model.v2.Ctenari;
import cz.kpsys.db.model.v2.MVS;
import cz.kpsys.db.model.v2.Vypuc2;
import cz.kpsys.marc.SessionData;
import cz.kpsys.service.Utils;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class VracMVSExecutor
extends GenericExecutor {
    public static final int ERR130_MVS_NENALEZENA = 130;
    public static final int ERR132_JIZ_VRACENO = 132;
    static final String vracTemplateHead = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<VRAC_MVS>\n   <ID_MVS>%s</ID_MVS>\n";
    static final String vracTemplateTail = "</VRAC_MVS>\n";
    private static final Logger logger = LoggerFactory.getLogger(VracMVSExecutor.class);
    private final VracMVSInput vracMVSInput;
    private MVS mvs;
    private Ctenari cten;
    private Vypuc2 vypuc2;
    private VracMVSOutput mvsOutput;

    public VracMVSExecutor(DbCore2 core2, VracMVSInput vracMVSInput) {
        this.core2 = core2;
        this.qr = new QueryRunnerOpened((DataSource)new SingleConnectionDataSource(core2.conn));
        this.vracMVSInput = vracMVSInput;
    }

    public static void chyba(int errorCode, String message, String key, String value) throws AppServerStatus {
        AppServerStatus ve = new AppServerStatus(message, errorCode);
        ve.addReturnValue(key, value);
        throw ve;
    }

    public static void chyba(int errorCode, String message) throws AppServerStatus {
        AppServerStatus ve = new AppServerStatus(message, errorCode);
        throw ve;
    }

    public static VracMVSInput parseVracMVSInput(Document doc, SessionData sessionData) {
        Element rootNode = doc.getRootElement();
        String prefix = "//collection/vrac_mvs/";
        VracMVSInput vracInput = new VracMVSInput();
        vracInput.setIdMVS(Integer.parseInt(doc.getRootElement().selectSingleNode("//collection/vrac_mvs/ID_MVS").getText()));
        vracInput.setPujcovna(Short.parseShort(doc.getRootElement().selectSingleNode("//collection/pujcovna").getText()));
        vracInput.setFkUzivAkce(sessionData.getUcode());
        List nodes = doc.getRootElement().selectNodes("//collection/vrac_mvs/node()");
        for (Node n : nodes) {
            String key;
            String name = n.getName();
            if (name == null || !(key = n.getName().toUpperCase()).startsWith("HLASIT")) continue;
            String value = n.getText().trim().toUpperCase();
            if (VracMVSExecutor.tagHasTrueValue((String)value)) {
                vracInput.setPrepinac(key, true);
                continue;
            }
            vracInput.setPrepinac(key, false);
        }
        return vracInput;
    }

    public boolean provedVraceniMVS() throws SQLException, AppServerStatus {
        logger.info("vraceni MVS " + this.vracMVSInput.toString());
        this.mvs = DbCore2Utils.nactiMVS((long)this.vracMVSInput.idMVS, (ScalaRunnerOpened)this.core2.obtainScalaRunnerOpened());
        if (this.mvs == null) {
            throw new AppServerStatus("chyba pri nacitani MVS", 130);
        }
        if (this.mvs.getFK_STAVMVS() > 2) {
            throw new AppServerStatus("jiz ve stavu vraceno nebo storno", 132);
        }
        this.cten = DbCore2Utils.nactiCtenare((Integer)this.mvs.getFK_UZIV_CTEN(), (ScalaRunnerOpened)this.core2.obtainScalaRunnerOpened());
        this.vypuc2 = DbCore2Utils.nactiVypuc2((long)this.mvs.getFK_VYPUC(), (ScalaRunnerOpened)this.core2.obtainScalaRunnerOpened());
        if (this.vypuc2 != null && this.vypuc2.getDAT_VR() == null) {
            if (this.vypuc2.getFK_EX() != null) {
                VracInput vracInput = new VracInput();
                vracInput.setFkUzivAkce(this.vracMVSInput.getFkUzivAkce());
                for (String key : this.vracMVSInput.prepinace.keySet()) {
                    if (!this.vracMVSInput.getPrepinacValue(key).booleanValue()) continue;
                    vracInput.setPrepinac(key, true);
                }
                vracInput.idCten = this.mvs.getFK_UZIV_CTEN();
                vracInput.idEx = this.vypuc2.getFK_EX();
                vracInput.pujcovna = this.vracMVSInput.pujcovna;
                vracInput.idVypujcky = this.vypuc2.getID_VYPUC();
                logger.info("vracim MVS pres /vrac ");
                VracExecutor vracEx = new VracExecutor(this.core2, vracInput);
                VracOutput result = vracEx.vrat();
                this.mvsOutput.fkVypuc = result.fkVypucReze;
            } else {
                logger.info("vracim MVS ve vypujcaku: ID_VYPUC=" + this.mvs.getFK_VYPUC());
                this.qr.update("UPDATE VYPUC2 SET DAT_VR=" + Utils.todayNowString((int)1, (DatabaseEngine)ProxoolUtil.engine()) + " WHERE ID_VYPUC=?", (Object)this.mvs.getFK_VYPUC());
            }
        }
        try {
            this.qr.update("UPDATE MVS SET FK_STAVMVS=3, DAT_ODE=" + Utils.todayNowString((int)1, (DatabaseEngine)ProxoolUtil.engine()) + " WHERE ID_MVS=?", (Object)this.vracMVSInput.idMVS);
        }
        catch (SQLException se) {
            logger.error("selhani", (Throwable)se);
            throw new AppServerStatus("chyba pri vraceni (MVS)", 38);
        }
        return false;
    }

    public String fillInVracTemplate(VracMVSOutput vracMVSOutput) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<VRAC_MVS>\n   <ID_MVS>%s</ID_MVS>\n", Utils.xmlEscape((String)Integer.toString(this.vracMVSInput.idMVS))));
        if (vracMVSOutput.fkVypuc != 0L) {
            sb.append("   <FK_VYPUC>" + vracMVSOutput.fkVypuc + "</FK_VYPUC>\n");
        }
        sb.append("</VRAC_MVS>\n");
        return sb.toString();
    }

    public VracMVSOutput vratMVS() throws SQLException, AppServerStatus {
        this.mvsOutput = new VracMVSOutput();
        this.mvsOutput.idMVS = this.vracMVSInput.idMVS;
        this.provedVraceniMVS();
        return this.mvsOutput;
    }
}

