/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.db.query;

import cz.kpsys.db.DatabaseEngine;
import cz.kpsys.db.TableColumnDescriptor;
import cz.kpsys.db.query.DatabaseColumnCondition;
import cz.kpsys.db.query.QueryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseColumn {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseColumn.class);
    private String columnName;
    int columnType;
    Object value;
    private TableColumnDescriptor tableColumnDescriptor;
    String masterTableDotColumn = null;
    boolean blank;
    boolean explicitNull;
    boolean explicitNotNull;
    private boolean pk;
    private boolean returning;
    private boolean plus;
    private boolean raw;
    private boolean minus;
    private DatabaseColumnCondition condition;

    public boolean isRaw() {
        return this.raw;
    }

    public void setRaw(boolean raw) {
        this.raw = raw;
    }

    public boolean isPlus() {
        return this.plus;
    }

    public void setPlus(boolean plus) {
        this.plus = plus;
    }

    public boolean isMinus() {
        return this.minus;
    }

    public void setMinus(boolean minus) {
        this.minus = minus;
    }

    public DatabaseColumnCondition getCondition() {
        return this.condition;
    }

    public void setCondition(DatabaseColumnCondition condition) {
        this.condition = condition;
    }

    public boolean isReturning() {
        return this.returning;
    }

    public void setReturning(boolean returning) {
        this.returning = returning;
    }

    public boolean isNullInfected() {
        return this.explicitNull || this.explicitNotNull;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = QueryUtil.normalizeName((String)columnName);
    }

    public int getColumnType() {
        return this.columnType;
    }

    public void setColumnType(int columnType) {
        this.columnType = columnType;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setTableColumnDescriptor(TableColumnDescriptor tdc) {
        this.tableColumnDescriptor = tdc;
    }

    public TableColumnDescriptor getTableColumnDescriptor() {
        return this.tableColumnDescriptor;
    }

    public String getMasterTableDotColumn() {
        return this.masterTableDotColumn;
    }

    public void setMasterTableDotColumn(String masterTableDotColumn) {
        this.masterTableDotColumn = masterTableDotColumn;
    }

    public String toString() {
        return this.columnName + ":" + this.columnType + "[" + this.value + "]";
    }

    public boolean isBlank() {
        return this.blank;
    }

    public void setBlank(boolean blank) {
        this.blank = blank;
    }

    public boolean isExplicitNull() {
        return this.explicitNull;
    }

    public void setExplicitNull(boolean explicitNull) {
        if (explicitNull) {
            this.blank = false;
        }
        this.explicitNull = explicitNull;
    }

    public boolean isExplicitNotNull() {
        return this.explicitNotNull;
    }

    public void setExplicitNotNull(boolean explicitNotNull) {
        this.explicitNotNull = explicitNotNull;
    }

    public String getTodayNowString(boolean isFirebird) {
        String text = this.value.toString();
        if (text.equalsIgnoreCase("TODAY")) {
            if (isFirebird) {
                return "'TODAY'";
            }
            return "TRUNC(SYSDATE)";
        }
        if (text.equalsIgnoreCase("NOW")) {
            if (isFirebird) {
                return "'NOW'";
            }
            return "SYSDATE";
        }
        return null;
    }

    public void setPk(boolean pk) {
        this.pk = pk;
    }

    public boolean isPk() {
        return this.pk;
    }

    public void fillColumnType(TableColumnDescriptor tdc, DatabaseEngine dbe) {
        if (tdc.columnType == null) {
            logger.error("nelze zjistit datovy typ sloupce, columnType==null");
            return;
        }
        if (dbe == DatabaseEngine.FIREBIRD) {
            if ("SHORT".equals(tdc.columnType)) {
                this.setColumnType(5);
            } else if ("INT64".equals(tdc.columnType) || "LONG".equals(tdc.columnType)) {
                this.setColumnType(-5);
            } else if ("VARYING".equals(tdc.columnType) || "TEXT".equals(tdc.columnType)) {
                this.setColumnType(12);
            } else if ("TIMESTAMP".equals(tdc.columnType)) {
                this.setColumnType(93);
            } else if ("DATE".equals(tdc.columnType)) {
                this.setColumnType(91);
            } else if ("TIME".equals(tdc.columnType)) {
                this.setColumnType(92);
            } else if ("DATETIME".equals(tdc.columnType)) {
                this.setColumnType(93);
            } else if ("BLOB".equals(tdc.columnType)) {
                this.setColumnType(2004);
            } else if ("SMALLINT".equals(tdc.columnType) || "INTEGER".equals(tdc.columnType)) {
                this.setColumnType(4);
            } else {
                logger.error("zjisten neznamy (firebird) datovy typ sloupce " + tdc.columnType);
            }
        } else if (dbe == DatabaseEngine.POSTGRESQL || dbe == DatabaseEngine.ORACLE) {
            if (tdc.columnType.startsWith("TIMESTAMP")) {
                this.setColumnType(93);
            } else if (tdc.columnType.startsWith("NUMBER")) {
                this.setColumnType(2);
            } else if (tdc.columnType.startsWith("CLOB")) {
                this.setColumnType(2005);
            } else if (tdc.columnType.startsWith("CHAR")) {
                this.setColumnType(1);
            } else if (tdc.columnType.startsWith("DATE")) {
                this.setColumnType(91);
            } else if (tdc.columnType.startsWith("INTEGER")) {
                this.setColumnType(4);
            } else if (tdc.columnType.startsWith("BIGINT")) {
                this.setColumnType(-5);
            } else if (tdc.columnType.startsWith("SHORT")) {
                this.setColumnType(5);
            } else if (tdc.columnType.startsWith("VARCHAR2")) {
                this.setColumnType(12);
            } else if (tdc.columnType.startsWith("BLOB")) {
                this.setColumnType(2004);
            } else {
                logger.error("zjisten neznamy (oracle) datovy typ sloupce " + tdc.columnType);
            }
        } else {
            dbe.unknownEngine();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columnName == null ? 0 : this.columnName.hashCode());
        result = 31 * result + (this.tableColumnDescriptor == null ? 0 : this.tableColumnDescriptor.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DatabaseColumn other = (DatabaseColumn)obj;
        if (this.columnName == null ? other.columnName != null : !this.columnName.equals(other.columnName)) {
            return false;
        }
        if (this.tableColumnDescriptor == null ? other.tableColumnDescriptor != null : !this.tableColumnDescriptor.equals((Object)other.tableColumnDescriptor)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

