/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.kpwin2.rest.action;

import cz.kpsys.db.model.AuthOutput;
import cz.kpsys.service.UUIDCache;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Auth
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(Auth.class);
    static final String authTemplateHead = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<auth>\n";
    static final String authTemplateBody = "\t<APPSERVER_KEY>%s</APPSERVER_KEY>\n";
    static final String authTemplateTail = "</auth>\n";

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.postHandler(req, resp);
    }

    private void postHandler(HttpServletRequest req, HttpServletResponse resp) {
        String uuid;
        String data = req.getParameter("data");
        AuthOutput authOutput = new AuthOutput();
        authOutput.uuid = uuid = UUIDCache.getInstance().generateUUID();
        String output = this.fillStartupReturnTemplate(authOutput);
        try {
            this.finish(req, resp, output);
        }
        catch (IOException e) {
            logger.error("selhani", (Throwable)e);
        }
    }

    private String fillStartupReturnTemplate(AuthOutput authOutput) {
        return authTemplateHead + String.format(authTemplateBody, authOutput.uuid) + authTemplateTail;
    }

    protected void finish(HttpServletRequest request, HttpServletResponse resp, String response) throws IOException {
        resp.setContentType("text/html;charset=utf-8");
        resp.getWriter().println(response);
        logger.info(response);
    }
}

