/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.kpwin2.rest.action;

import cz.kpsys.AppServerStatus;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.model.HledZInput;
import cz.kpsys.db.model.HledZOutput;
import cz.kpsys.kpwin2.rest.action.API_THREAD_ID;
import cz.kpsys.kpwin2.rest.action.RESTActionsServlet;
import cz.kpsys.kpwin2.rest.executors.HledZExecutor;
import cz.kpsys.kpwinsql.z3950.model.ZServerID;
import cz.kpsys.marc.Record;
import cz.kpsys.marc.RecordExporter;
import cz.kpsys.marc.SessionData;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.text.StringEscapeUtils;
import org.dom4j.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HledZ
extends RESTActionsServlet<HledZInput, HledZOutput> {
    static final String jledZTemplateHead = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<hled_z>\n";
    static final String hledZTemplateBody = "%s";
    static final String hledZTemplateTail = "</hled_z>\n";
    private static final Logger logger = LoggerFactory.getLogger(HledZ.class);

    public boolean validateRelogUser() {
        return false;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.setThreadName(API_THREAD_ID.HLED_Z);
        this.postHandler(req, resp);
    }

    private String fillHledZReturnTemplate(HledZInput input, HledZOutput hledZOutput) {
        StringBuilder sb = new StringBuilder();
        if (input.queryType == HledZInput.QUERY_TYPE.SEARCH) {
            sb.append("   <token>" + hledZOutput.token + "</token>\n");
            sb.append("   <results>\n");
            for (ZServerID zServerID : hledZOutput.nalezeneZaznamy.keySet()) {
                int nalezene = (Integer)hledZOutput.nalezeneZaznamy.get(zServerID);
                String nalezeneString = Integer.toString(nalezene);
                String afterZServerContent = nalezene < 0 ? String.format("            <error><id>%s</id><message>%s</message></error>\n", zServerID.id(), "ERROR - " + StringEscapeUtils.escapeXml10((String)((String)hledZOutput.chyby.get(zServerID)))) : String.format("            <count>%s</count>\n", nalezeneString);
                sb.append(String.format("      <result>\n         <zserver id=\"%s\"></zserver>\n%s      </result>\n\n", zServerID.id(), afterZServerContent));
            }
            sb.append("   </results>\n");
        } else if (input.queryType == HledZInput.QUERY_TYPE.FETCH) {
            RecordExporter re = new RecordExporter();
            for (Record r : hledZOutput.zaznamy) {
                sb.append(re.marcXmlEnvelope(r, false, false));
            }
        }
        return jledZTemplateHead + String.format(hledZTemplateBody, sb.toString()) + hledZTemplateTail;
    }

    public RESTActionsServlet.ResultData<HledZInput, HledZOutput> postCore(Document doc, SessionData sessionData, DbCore2 core2) throws Exception, AppServerStatus {
        HledZInput input = HledZExecutor.parseHledZInput((Document)doc, (DbCore2)core2);
        HledZExecutor hledZExecutor = new HledZExecutor(input);
        HledZOutput hledZOutput = hledZExecutor.hledZ();
        return new RESTActionsServlet.ResultData((RESTActionsServlet)this, this.fillHledZReturnTemplate(input, hledZOutput), (Object)input, (Object)hledZOutput);
    }
}

