/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.kpwin2.rest.action;

import cz.kpsys.db.DbCore2;
import cz.kpsys.db.ProxoolUtil;
import cz.kpsys.db.ZProxyExecutor;
import cz.kpsys.db.model.ZProxyInput;
import cz.kpsys.db.model.ZProxyOutput;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObalkyProxy
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ObalkyProxy.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String isbn = req.getParameter("isbn");
        String idZazString = req.getParameter("id_zaz");
        resp.setContentType("text/html;charset=utf-8");
        if (StringUtils.isNotBlank((CharSequence)isbn) || StringUtils.isNotBlank((CharSequence)idZazString)) {
            Connection conn = null;
            try {
                conn = ProxoolUtil.obtainConnection();
                DbCore2 core2 = new DbCore2();
                core2.setConnection(conn);
                ZProxyInput input = new ZProxyInput();
                if (StringUtils.isNotBlank((CharSequence)idZazString)) {
                    input.setIdZaz(Long.parseLong(idZazString));
                } else {
                    input.setIsbn(isbn);
                }
                ZProxyExecutor executor = new ZProxyExecutor(core2, input);
                ZProxyOutput output = executor.zProxy();
                String outputString = this.formatujVystup(input, output);
                resp.getWriter().println(outputString);
                conn.commit();
            }
            catch (SQLException e) {
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        logger.error("selhani", (Throwable)e);
                    }
                }
            }
        }
    }

    final String formatujVystup(ZProxyInput input, ZProxyOutput output) {
        if (StringUtils.isNotBlank((CharSequence)input.getIsbn())) {
            return this.formatujVystupHledani(output);
        }
        if (input.getIdZaz() > 0L) {
            return this.formatujVystupFetch(output);
        }
        return null;
    }

    private String formatujVystupHledani(ZProxyOutput output) {
        StringBuilder sb = new StringBuilder();
        sb.append(output.getRecId());
        sb.append("\n");
        for (String isbn : output.getIsbn()) {
            sb.append(isbn + "\n");
        }
        return sb.toString();
    }

    private String formatujVystupFetch(ZProxyOutput output) {
        StringBuilder sb = new StringBuilder();
        sb.append(output.getXmlData());
        return sb.toString();
    }
}

