/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.kpwin2.rest.action;

import cz.kpsys.db.DbCore2;
import cz.kpsys.db.ProxoolUtil;
import cz.kpsys.db.RecordReconstructor2;
import cz.kpsys.kpwin2.rest.KPWINServiceApplication;
import cz.kpsys.marc.Record;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PitterImage
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(PitterImage.class);
    final String templateKd = "/kd/kd-%06d/kd-%06d/kd-%06d/kd-%06d";
    final String templateApp = "/app/app-%06d/app-%06d/app-%06d/app-%06d";

    public String obtainFileName(String template, int number, int order) {
        String basicPath = KPWINServiceApplication.configuration.config.getString("pitter_mezisklad_dir", System.getProperty("user.dir"));
        String fileName = String.format(basicPath + template, number / 100 / 100 * 100 * 100, number / 100 * 100, number, number) + "_" + String.format("%03d", order) + ".png";
        return fileName;
    }

    private String getParameter(HttpServletRequest req, String paramName, String defaultValue) {
        String value = req.getParameter(paramName);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block18: {
            long recId = Long.parseLong(this.getParameter(req, "recId", "0"));
            int order = Integer.parseInt(this.getParameter(req, "order", "1"));
            int htmlTemplate = Integer.parseInt(this.getParameter(req, "template", "0"));
            Connection conn = null;
            try {
                conn = ProxoolUtil.obtainConnection();
                DbCore2 core2 = new DbCore2(conn);
                try {
                    RecordReconstructor2 rc2 = new RecordReconstructor2(core2);
                    rc2.setValidaceEnabled(false);
                    Record r = rc2.reconstructRecord(recId, false);
                    String status = r.getFieldContent(96, "a");
                    if ("EXT".equals(status)) {
                        String f97 = r.getFieldContent(97, "a");
                        String template = null;
                        int imgNr = 0;
                        if (f97.startsWith("KD-")) {
                            imgNr = Integer.parseInt(f97.substring(3));
                            template = "/kd/kd-%06d/kd-%06d/kd-%06d/kd-%06d";
                        } else if (f97.startsWith("APP-")) {
                            imgNr = Integer.parseInt(f97.substring(4));
                            template = "/app/app-%06d/app-%06d/app-%06d/app-%06d";
                        }
                        if (htmlTemplate > 0) {
                            int counter = 1;
                            boolean exists = true;
                            resp.setContentType("text/html");
                            PrintWriter w = resp.getWriter();
                            ((Writer)w).append("<html><body>\n");
                            ((Writer)w).append("<table>\n");
                            while (exists) {
                                String filename = this.obtainFileName(template, imgNr, counter);
                                File file = new File(filename);
                                if (file.exists()) {
                                    ((Writer)w).append("<tr><td>");
                                    ((Writer)w).append("<img width=\"100%\" src=\"pitter_image?recId=" + recId + "&order=" + counter + "\">");
                                    ((Writer)w).append("</td></tr>\n");
                                } else {
                                    exists = false;
                                }
                                ++counter;
                            }
                            ((Writer)w).append("</table>\n");
                            ((Writer)w).append("</html></body>\n");
                        } else {
                            resp.setContentType("image/png");
                            String filename = this.obtainFileName(template, imgNr, order);
                            File file = new File(filename);
                            resp.setContentLength((int)file.length());
                            FileInputStream in = new FileInputStream(file);
                            ServletOutputStream out = resp.getOutputStream();
                            byte[] buf = new byte[4096];
                            int count = 0;
                            while ((count = in.read(buf)) >= 0) {
                                out.write(buf, 0, count);
                            }
                            in.close();
                            out.close();
                        }
                    } else {
                        resp.setContentType("text/html");
                        PrintWriter w = resp.getWriter();
                        ((Writer)w).append("<html><body>\n");
                        ((Writer)w).append("<h1>Dokument nen\u00ed dostupn\u00fd online</h1></body></html>\n");
                    }
                }
                finally {
                    conn.commit();
                    conn.close();
                }
            }
            catch (Exception e) {
                if (conn == null) break block18;
                try {
                    conn.close();
                }
                catch (SQLException e1) {
                    logger.error("chyba v stahovani pitter obrazku", (Throwable)e1);
                }
            }
        }
    }
}

