/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.kpwin2.rest.action;

import cz.kpsys.AppServerStatus;
import cz.kpsys.db.AbstractRecordReconstructor;
import cz.kpsys.db.DbCache;
import cz.kpsys.db.DbCache2;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.GenericExecutor;
import cz.kpsys.db.ProxoolUtil;
import cz.kpsys.db.RecordReconstructor2;
import cz.kpsys.db.RecordReconstructor2Helper;
import cz.kpsys.db.RecordReconstructor2Util;
import cz.kpsys.db.model.DuplicitaOutput;
import cz.kpsys.db.model.ZdrojDokOutput;
import cz.kpsys.kpwin2.XMLService;
import cz.kpsys.kpwin2.rest.KPWINServiceApplication;
import cz.kpsys.kpwin2.rest.action.API_THREAD_ID;
import cz.kpsys.kpwin2.rest.action.RESTActionsServlet;
import cz.kpsys.kpwin2.rest.action.RESTResponse;
import cz.kpsys.kpwin2.rest.action.ReadWriteRecordUtil;
import cz.kpsys.kpwin2.rest.action.ReqData;
import cz.kpsys.kpwin2.rest.common.CacheOnlineWaiter;
import cz.kpsys.marc.Record;
import cz.kpsys.marc.RecordRef;
import cz.kpsys.marc.SessionData;
import cz.kpsys.service.TaskQueueManager;
import cz.kpsys.service.Utils;
import cz.kpsys.service.cache.RecordIdCache;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.None;

/*
 * Exception performing whole class analysis ignored.
 */
public class ReadWriteRecord
extends RESTActionsServlet<None, None> {
    private static final Logger logger = LoggerFactory.getLogger(ReadWriteRecord.class);

    protected void doInit(HttpServletRequest req, ReqData data) {
        String uuid = req.getParameter("uuid");
        if (StringUtils.isNotBlank((CharSequence)uuid)) {
            data.uuid = uuid.split("[,;]");
        } else {
            long zaznamID = Long.parseLong(req.getParameter("id"));
            boolean jeAut = DbCache2.jeAutFond((short)Short.parseShort(req.getParameter("fond")));
            RecordRef zaznamIdJeAut = RecordIdCache.getByCisZazAut((long)zaznamID, (boolean)jeAut);
            data.uuid = new String[]{zaznamIdJeAut.recordId()};
        }
        String formatParameter = req.getParameter("format");
        if (formatParameter != null) {
            data.outputFormat = Integer.parseInt(formatParameter);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String data;
        this.setThreadName(API_THREAD_ID.READ_WRITE_RECORD);
        CacheOnlineWaiter.waitForCacheOnline();
        ReqData rd = new ReqData();
        String mimeType = ReadWriteRecord.XML_MIMETYPE();
        try {
            this.doInit(req, rd);
            String uCodeParam = req.getParameter("ucode");
            String uSessParam = req.getParameter("usess");
            String portaroParam = req.getParameter("portaro");
            String prirustkyParam = req.getParameter("prirustky");
            String exportParam = req.getParameter("export");
            String pujcovnaParam = req.getParameter("pujcovna");
            String idExSeznam = req.getParameter("id_ex");
            rd.sessionData = new SessionData();
            if (GenericExecutor.tagHasTrueValue((String)portaroParam)) {
                rd.sessionData.setTypSession(3);
            } else {
                rd.sessionData.setTypSession(0);
                rd.sessionData.setUcode(DbCache2.opacUserID);
            }
            rd.sessionData.setPujcovna((Short)DbCache.rootPujcovna().get());
            if (uCodeParam != null && uSessParam != null) {
                rd.sessionData.setUcode(Integer.parseInt(uCodeParam));
                rd.sessionData.setuSess(Long.valueOf(Long.parseLong(uSessParam)));
                rd.sessionData.setTypSession(0);
            }
            rd.generujPrirustky = GenericExecutor.tagHasTrueValue((String)prirustkyParam);
            if (StringUtils.isNotBlank((CharSequence)exportParam)) {
                if (GenericExecutor.tagHasTrueValue((String)exportParam) || "standard".equalsIgnoreCase(exportParam)) {
                    rd.exportuj = 1;
                } else if ("2".equals(exportParam) || "interpunkce".equalsIgnoreCase(exportParam)) {
                    rd.exportuj = 2;
                } else if ("3".equals(exportParam) || "caslin".equalsIgnoreCase(exportParam)) {
                    rd.exportuj = 3;
                }
            }
            if (StringUtils.isNotBlank((CharSequence)pujcovnaParam)) {
                rd.sessionData.pujcovna = Short.parseShort(pujcovnaParam);
            }
            if (StringUtils.isNotBlank((CharSequence)idExSeznam)) {
                for (String idString : Utils.split((String)idExSeznam, (String)",")) {
                    try {
                        Long idEx = Long.parseLong(idString);
                        rd.exportovaneExemplare.add(idEx);
                    }
                    catch (Throwable t) {
                        logger.error("predan neplatny idEx " + idString);
                    }
                }
            }
            if (rd.outputFormat == ReadWriteRecordUtil.FORMAT_MARC21()) {
                mimeType = ReadWriteRecord.MARC21_MIMETYPE();
            }
            data = this.getData(rd);
        }
        catch (Exception e) {
            logger.error("selhani recons", (Throwable)e);
            data = this.createError(e.toString(), 100);
        }
        this.finish(req, resp, new RESTResponse(data, mimeType));
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String postReturnData;
        this.setThreadName(API_THREAD_ID.READ_WRITE_RECORD);
        ReqData rd = new ReqData();
        String marcXml = "";
        try {
            rd.core2 = this.obtainDbCore2();
            marcXml = req.getParameter("data");
            logger.info("zapis zaznamu: \n" + marcXml);
            postReturnData = this.postData(marcXml, req, rd);
            logger.info("zapis zaznamu dokoncen\n");
            rd.core2.closeConnectionCommit();
        }
        catch (Exception se) {
            if (se instanceof AppServerStatus && ((AppServerStatus)((Object)se)).getErrorCode() == 1002) {
                resp.setStatus(401);
                postReturnData = this.createError(KPWINServiceApplication.zpracujHlaseniVyjimky((Exception)se), ((AppServerStatus)((Object)se)).getErrorCode());
            } else {
                logger.error("P: zapis zaznamu", (Throwable)se);
                postReturnData = this.createError(marcXml + "\n" + KPWINServiceApplication.zpracujHlaseniVyjimky((Exception)se), 201);
            }
            rd.core2.closeConnectionRollback();
        }
        this.finish(req, resp, new RESTResponse(postReturnData, RESTActionsServlet.XML_MIMETYPE()));
    }

    public String getData(ReqData rd) {
        Object record = null;
        StringBuilder sb = new StringBuilder();
        try {
            long reconsStartTime = System.currentTimeMillis();
            logger.info("recons zaznamu " + StringUtils.join((Object[])rd.uuid, (String)","));
            rd.core2 = this.obtainDbCore2();
            rd.core2.setSessionData(rd.sessionData);
            if (rd.sessionData.getTypSession() == 0 && rd.sessionData.getuSess() != null && rd.sessionData != null && !rd.core2.validateSessionData(rd.sessionData)) {
                sb.append(this.createError(101));
                return sb.toString();
            }
            ReadWriteRecordUtil util = new ReadWriteRecordUtil();
            sb.append(util.reconsMulti(rd));
            long reconsFinishTime = System.currentTimeMillis();
            long recordElapsedTime = reconsFinishTime - reconsStartTime;
            logger.info("recons zaznamu " + StringUtils.join((Object[])rd.uuid, (String)",") + " hotovo ( " + recordElapsedTime + "ms)");
            return sb.toString();
        }
        catch (Exception se) {
            ProxoolUtil.logDeadlockInfo((Exception)se);
            logger.error("doslo k chybe pri rekons zaznamu", (Throwable)se);
            rd.core2.closeConnectionRollback();
            String trace = "";
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(os);
            se.printStackTrace(ps);
            try {
                trace = os.toString(StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                logger.warn("chyba pri generovani stacktrace");
            }
            return this.createError(se.getMessage() + trace, 201);
        }
    }

    public String postData(String marcXml, HttpServletRequest req, ReqData rd) throws SQLException, AppServerStatus {
        block26: {
            logger.info("zapis zaznamu\n" + marcXml);
            CacheOnlineWaiter.waitForCacheOnline();
            try {
                Document doc = XMLService.getDocument((String)marcXml);
                SessionData sessionData = XMLService.parseSessionData((Document)doc, (HttpServletRequest)req);
                Record r = AbstractRecordReconstructor.recordFromXML((Document)doc);
                r.setFkUziv(sessionData.getUcode());
                rd.setSessionData(sessionData);
                RecordReconstructor2 rc2 = new RecordReconstructor2(rd.core2, ((Short)r.getDepartmentOption().getOrElse(() -> sessionData.pujcovna)).shortValue());
                boolean masterMode = KPWINServiceApplication.configuration.masterMode;
                if (masterMode && sessionData.getTypSession() == -1) {
                    r.setFkUziv(DbCache2.appServerUserID);
                    rd.sessionData = new SessionData(DbCache2.appServerUserID, ((Short)DbCache.rootPujcovna().get()).shortValue());
                } else {
                    boolean validUser = rd.core2.validateSessionData(rd.sessionData);
                    if (!validUser) {
                        return this.createError("Pro zapis zaznamu musi byt uzivatel prihlasen", 201);
                    }
                }
                rd.core2.relogUser(rd.sessionData);
                String zdrojDokString = doc.selectSingleNode("//collection/record").valueOf("@zdroj_dok");
                Properties props = new Properties();
                String dbIdString = doc.selectSingleNode("//collection/record").valueOf("@db_id");
                if (StringUtils.isNotBlank((CharSequence)dbIdString)) {
                    if (!masterMode) {
                        throw new SQLException("pokus o zapis zaznamu z jine DB ale neni zapnut MASTER rezim");
                    }
                    try {
                        int dbId = Integer.parseInt(dbIdString);
                        return this.zapisZaznamDoMasterIndexu(rd, rc2, r, props, dbId);
                    }
                    catch (Exception e) {
                        logger.error("selhal zapis do master indexu DB ID: " + dbIdString + " " + r, (Throwable)e);
                        break block26;
                    }
                }
                if (GenericExecutor.tagHasTrueValue((String)doc.selectSingleNode("//collection/record").valueOf("@duplicita"))) {
                    logger.info("test duplicity zaznamu " + r.getId() + " RECORD_ID " + r.recordId);
                    DuplicitaOutput duplicita = RecordReconstructor2Helper.najdiDuplicitniZaznam((Record)r, (short)r.deparmentOrRoot());
                    if (duplicita != null) {
                        props.put("UUID", duplicita.duplicitniUUID);
                        props.put("ID", duplicita.duplicitniId);
                        props.put("KOD", (Object)duplicita.kodDuplicity);
                        props.put("PRICINA", duplicita.pricinaDuplicity);
                        props.put("DUPLICITA", "TRUE");
                        logger.info("vysledek deduplikace UUID:" + duplicita.duplicitniUUID + " ID:" + duplicita.duplicitniId + " KOD:" + duplicita.kodDuplicity + " PRICINA:" + duplicita.pricinaDuplicity);
                    } else {
                        props.put("UUID", "");
                        props.put("ID", (Object)0);
                        props.put("DUPLICITA", "FALSE");
                        logger.info("vysledek deduplikace - NENI DUPLICITA");
                    }
                } else if (StringUtils.isNotEmpty((CharSequence)zdrojDokString)) {
                    short fondZdrojDok = Short.parseShort(zdrojDokString);
                    logger.info("zdrojovy dokument " + r.getId());
                    ZdrojDokOutput zdrojDok = rc2.zapisZdrojovyDokument(r, fondZdrojDok);
                    if (zdrojDok != null) {
                        props.put("ID", zdrojDok.autId);
                        props.put("aut_record_id", zdrojDok.authRecordId);
                        props.put("AUTH_FOND", (Object)zdrojDok.authFond);
                        props.put("DOC_ID", (Object)zdrojDok.docId);
                        props.put("doc_record_id", zdrojDok.docRecordId);
                        props.put("DOC_FOND", (Object)zdrojDok.docFond);
                    }
                } else {
                    long idZaz = r.getId();
                    logger.info("zapis zaznamu " + idZaz + " / " + r.recordId);
                    RecordReconstructor2Util.writeRecordProtected((Record)r, (RecordReconstructor2)rc2);
                    if (!masterMode) {
                        try {
                            RecordReconstructor2Helper.log2ZaznamHistorie((long)r.getId(), (boolean)r.isAuthority(), (String)(switch (rd.sessionData.getTypSession()) {
                                case 0 -> "VERBIS";
                                case 2 -> "EVERBIS";
                                default -> "UNKNOWN " + rd.sessionData.getTypSession();
                            }), (int)rd.sessionData.getUcode(), (String)marcXml);
                        }
                        catch (Exception e) {
                            logger.warn("nepodarilo se zapsat kopii zaznamu do ZAZNAM_HISTORIE " + r.getFondId(), (Throwable)e);
                        }
                    }
                    rd.core2.commit();
                    TaskQueueManager.vzbudSeBudulinku();
                    props.put("record_id", r.recordId);
                    props.put("ID", (Object)r.getId());
                    props.put("FOND", (Object)r.getFond());
                    props.put("STATUS4", (Object)r.getStatus4());
                    props.put("RECORD_STATUS", (Object)r.getRecordStatus());
                    Long fkFullTextSkupiny = r.getFkFullTextSkupiny();
                    if (fkFullTextSkupiny == null) {
                        logger.warn("fkFullTextSkupiny je null " + r + " / " + props);
                    } else {
                        props.put("FULLTEXT_SKUPINA", r.getFkFullTextSkupiny());
                    }
                    if (r.getNazev() != null) {
                        props.put("NAZEV", r.getNazev());
                    }
                }
                return this.fillGenericTemplate(props);
            }
            catch (DocumentException de) {
                logger.error("Doslo k chybe pri parsovani XML", (Throwable)de);
                throw new SQLException("Doslo k chybe pri parsovani XML", de);
            }
        }
        return null;
    }

    public String zapisZaznamDoMasterIndexu(ReqData rd, RecordReconstructor2 rc2, Record r, Properties props, int dbId) throws SQLException {
        try {
            logger.info("zapis zaznamu do CI " + r.getId() + " db " + dbId);
            int pocet = rc2.zapisExterniDokument(r, Long.toString(r.getId()), dbId);
            rd.core2.commit();
            TaskQueueManager.vzbudSeBudulinku();
            props.put("ID", (Object)r.getId());
            props.put("POCET", (Object)pocet);
            props.put("STATUS", "OK");
            return this.fillGenericTemplate(props);
        }
        catch (AppServerStatus e) {
            logger.error("selhani", (Throwable)e);
            throw new SQLException(e.getErrorCode() + " " + e.getMessage());
        }
    }

    public RESTActionsServlet.ResultData<None, None> postCore(Document doc, SessionData sessionData, DbCore2 core2) throws Exception, AppServerStatus {
        throw new NotImplementedException("nevola se");
    }
}

