/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.kpwin2.services;

import cz.kpsys.kpwin2.services.LongProcessMeter;
import cz.kpsys.service.Utils;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongProcessMeter {
    private static final Logger logger = LoggerFactory.getLogger(LongProcessMeter.class);
    private int totalCount;
    private int count = 0;
    Date startTime;
    long lastTimeMessageShown;
    long showMessageAfter = 5000L;

    public void setTotalItemsCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public void start() {
        this.startTime = Utils.now();
    }

    public void incrementItemsProcessed() {
        ++this.count;
    }

    public void logInfo() {
        if (Utils.now().getTime() - this.lastTimeMessageShown > this.showMessageAfter) {
            this.lastTimeMessageShown = Utils.now().getTime();
        }
        logger.warn(this.formatInfoLine(this.progressInfo()));
    }

    public String formatInfoLine(ProgressInfo progressInfo) {
        return progressInfo.itemsProcessed + " / " + this.totalCount + " " + Utils.sdfSQLDateTime().format(progressInfo.estimatedEnd);
    }

    public ProgressInfo progressInfo() {
        ProgressInfo progressInfo = new ProgressInfo();
        progressInfo.itemsProcessed = this.count;
        progressInfo.itemsRemaining = this.totalCount - this.count;
        progressInfo.percentProcessed = (double)this.count / (double)this.totalCount;
        progressInfo.percentRemaning = 100.0 - progressInfo.percentProcessed;
        progressInfo.timeElapsed = Utils.now().getTime() - this.startTime.getTime();
        if (progressInfo.percentProcessed > 0.0) {
            long totalTime = (long)((double)progressInfo.timeElapsed / progressInfo.percentProcessed * 100.0);
            progressInfo.timeRemaing = totalTime - progressInfo.timeElapsed;
            progressInfo.estimatedEnd = new Date(Utils.now().getTime() + progressInfo.timeRemaing);
        }
        return progressInfo;
    }
}

