/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.kpwin2.services.extzdroje;

import cz.kpsys.AppServerStatus;
import cz.kpsys.common.IniConstants;
import cz.kpsys.db.BeanHandlers;
import cz.kpsys.db.DatabaseEngine;
import cz.kpsys.db.DbCache;
import cz.kpsys.db.DbCache2;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.ISBNUtil;
import cz.kpsys.db.IntegerHandler;
import cz.kpsys.db.LongListHandler;
import cz.kpsys.db.NumberHandler;
import cz.kpsys.db.ProxoolUtil;
import cz.kpsys.db.QueryRunnerOpened;
import cz.kpsys.db.RecordReconstructor2;
import cz.kpsys.db.ScalaRunnerOpened;
import cz.kpsys.db.model.HledZInput;
import cz.kpsys.db.model.HledZOutput;
import cz.kpsys.db.model.v2.DefFond;
import cz.kpsys.db.model.v2.DefVykony;
import cz.kpsys.db.model.v2.Kat1_4;
import cz.kpsys.db.model.v2.RecordKey;
import cz.kpsys.kpwin2.XMLService;
import cz.kpsys.kpwin2.rest.executors.HledZExecutor;
import cz.kpsys.kpwin2.services.RecordISBN;
import cz.kpsys.kpwin2.services.ZaznamyNarodkaService;
import cz.kpsys.kpwin2.services.extzdroje.EBooksUtils;
import cz.kpsys.kpwin2.services.extzdroje.ExterniZdrojeProvider;
import cz.kpsys.kpwin2.services.extzdroje.ExterniZdrojeProviderFactory;
import cz.kpsys.marc.Field;
import cz.kpsys.marc.Record;
import cz.kpsys.marc.SessionData;
import cz.kpsys.service.KPUtils;
import cz.kpsys.service.TaskQueueManagerNG;
import cz.kpsys.service.Utils;
import cz.kpsys.service.cache.RecordIdCache;
import cz.kpsys.service.model.ZServerInfo;
import events.ERDEvent;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.ElementHandler;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class EBooksUtils {
    public static final int CEKANI_PO_HLEDANI_Z = 500;
    final String pujcApiURL = "http://www.ereading.cz/api_knihovny/vypujcit.php";
    public static final int LIMIT_NA_DOBU_OTEVRENI_SPOJENI = 600;
    public static final int ZSERVER_BATCH_SIZE = 2;
    public static final int ZSERVER_BATCH_RELAX_TIME = 5;
    public static final String WWC_RECOMMENDED_UTF_8 = StandardCharsets.UTF_8.toString();
    private static final int MAX_POCET_SOUCASNE_STAHOVANYCH_ZAZNAMU = 1;
    private static final Logger logger = LoggerFactory.getLogger(EBooksUtils.class);
    final String isbnSearchQueryTemplate = "<?xml version=\"1.0\" encoding=\"utf-8\"?><collection><hled_z><ZSERVER>%s</ZSERVER><DOTAZ><constraintModel><constraint><semantic>7</semantic><relation>3</relation><position>3</position><structure>6</structure><truncation>1</truncation><completion>1</completion></constraint><model>%s</model></constraintModel></DOTAZ></hled_z></collection>";
    private final DbCore2 core2;
    public DefFond dokFondExt;
    Map<String, RecordISBN> ereadingZaznamy = null;
    private int nestazenych;
    private int stazenych;
    private int zserverBatchCounter = 0;
    private static String dataBookXMLURL = "http://www.ereading.cz/xml/data/xml_knihy.xml";
    private long lastZQueryTime;
    private QueryRunner qr;
    private ZaznamyNarodkaService narodkaService;
    private String recordsCacheDir;

    public EBooksUtils(DbCore2 core2) {
        this.core2 = core2;
        this.qr = core2.obtainQueryRunnerOpened();
        try {
            this.kontrolaExistenceFondu();
        }
        catch (AppServerStatus appServerStatus) {
            logger.warn("selhala kontrola existence externiho fondu", (Throwable)appServerStatus);
        }
    }

    public static boolean odstranNeplatneISBN(Collection<String> isbnSeznam) {
        ArrayList<String> kOdstraneni = new ArrayList<String>(isbnSeznam.size());
        for (String isbn : isbnSeznam) {
            if (EBooksUtils.platneISBN((String)isbn)) continue;
            kOdstraneni.add(isbn);
        }
        isbnSeznam.removeAll(kOdstraneni);
        return !isbnSeznam.isEmpty();
    }

    public static boolean platneISBN(String isbn) {
        if (StringUtils.isBlank((CharSequence)isbn)) {
            return false;
        }
        if (isbn.matches("[0123456789xX -]*")) {
            return true;
        }
        logger.error("vadne ISBN v eReading " + isbn);
        return false;
    }

    public static String generujURL(String userEmail, int count, long ebook, long timeStamp, short fkPujc) {
        int idKnihovna = Integer.parseInt(DbCache2.queryINIFlag((String)"EXT_ZDROJE", (String)"EXTZEREADINGKNIHID", (Short)fkPujc, null));
        String pk = DbCache2.queryINIFlag((String)"EXT_ZDROJE", (String)"EXTZEREADINGKNIHKLIC", (Short)fkPujc, null);
        String prefix = "http://www.ereading.cz/api_knihovny/vypujcit.php";
        String template = "?knihovna=%d&user=%s&count=%d&ebook=%d&time=%d";
        String url = String.format("?knihovna=%d&user=%s&count=%d&ebook=%d&time=%d", idKnihovna, Utils.urlEncode((String)userEmail), count, ebook, timeStamp);
        String hashUrl = url + pk;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] thedigest = md.digest(hashUrl.getBytes("ISO-8859-1"));
            String hash = Hex.encodeHexString((byte[])thedigest);
            return "http://www.ereading.cz/api_knihovny/vypujcit.php" + url + "&hash=" + hash;
        }
        catch (UnsupportedEncodingException e) {
            logger.error("UnsupportedEncodingException - nemelo by NIKDY nastat");
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("NoSuchAlgorithmException - nemelo by NIKDY nastat");
        }
        return null;
    }

    private ZServerInfo pripravSeznamZServeruKHledaniISBN(int index) {
        switch (index) {
            case 0: {
                return HledZExecutor.narodkaZServer();
            }
            case 1: {
                return HledZExecutor.caslinZServer();
            }
            case 2: {
                return HledZExecutor.knihovnyCZZServer();
            }
        }
        throw new IllegalArgumentException("pozadavan neznamy Zserver, index=" + index);
    }

    public synchronized void eReadingExterniZdrojeUpdater() throws SQLException {
        ExterniZdrojeProvider provider = ExterniZdrojeProviderFactory.obtainProvider((EBooksProvider)EBooksProvider.EREADING);
        provider.update();
    }

    public void flexiBooksExterniZdrojeUpdater() throws SQLException, AppServerStatus {
        ExterniZdrojeProvider provider = ExterniZdrojeProviderFactory.obtainProvider((EBooksProvider)EBooksProvider.FLEXIBOOKS);
        provider.update();
    }

    private void spoctiStatistiku() throws SQLException {
        int pocetVSech = (Integer)this.qr.query("SELECT COUNT(*) FROM EXTERNI_ZDROJE WHERE ZDROJ='EREADING'", (ResultSetHandler)new IntegerHandler(Integer.valueOf(0)));
        int pocetMimoExterniFond = (Integer)this.qr.query("SELECT COUNT(*) FROM EXTERNI_ZDROJE LEFT JOIN KAT1_4 ON KAT1_4.ID_ZAZ=EXTERNI_ZDROJE.FK_ZAZ WHERE ZDROJ='EREADING' AND KAT1_4.FK_DOKFOND<21", (ResultSetHandler)new IntegerHandler(Integer.valueOf(0)));
        int pocetExternich = pocetVSech - pocetMimoExterniFond;
        String message = "pocet eReading titulu " + pocetVSech + " z toho ve fondu externich zaznamu " + pocetExternich;
        logger.info(message);
        Utils.postEvent((Object)new ERDEvent(ERDEvent.ERDEventType.STATISTIKA, message));
    }

    private void docisteniZaznamuVExternimFondu() throws SQLException {
        List ids = (List)this.qr.query("SELECT ID_ZAZ FROM KAT1_4 WHERE FK_DOKFOND=? AND STATUS4<9 AND ID_ZAZ=FK_ZAZ", (ResultSetHandler)new LongListHandler(), new Object[]{this.dokFondExt.getID_FOND()});
        for (Long id : ids) {
            try {
                int pocetPujcenych;
                int pocetExternich = ((Number)this.qr.query("SELECT COUNT(*) FROM EXTERNI_ZDROJE WHERE FK_ZAZ=?", (ResultSetHandler)new NumberHandler((Number)0), new Object[]{id})).intValue();
                if (pocetExternich != 0 || (pocetPujcenych = ((Number)this.qr.query("SELECT COUNT(*) FROM VYPUC2 WHERE FK_ZAZ=?", (ResultSetHandler)new NumberHandler((Number)0), new Object[]{id})).intValue()) != 0) continue;
                this.qr.update("DELETE FROM KAT1_1 WHERE FK_ZAZ=?", (Object)id);
                this.qr.update("UPDATE KAT1_4 SET STATUS4=99, ISBN=NULL WHERE FK_ZAZ=?", (Object)id);
                this.core2.commit();
                TaskQueueManagerNG.zapisPozadavekNaReindex((long)id, (boolean)false, (short)4, (boolean)false, (ScalaRunnerOpened)((QueryRunnerOpened)this.qr).toScalaRunnerOpened());
            }
            catch (Exception e) {
                logger.warn("P: odstranovani redundantniho zaznamu ID_ZAZ:" + id, (Throwable)e);
            }
        }
    }

    public static DefFond fondExternichZdroju() {
        String extZFondString = DbCache2.queryINIFlag((String)IniConstants.SEKCE_EXT_ZDROJE(), (String)"EXTZFOND", null, null);
        if (StringUtils.isBlank((CharSequence)extZFondString)) {
            return null;
        }
        DefFond dokFondExt = (DefFond)DbCache2.defDokFondMap.get(Short.parseShort(extZFondString));
        if (dokFondExt == null) {
            logger.error("fond externich zdroju neexistuje, prestoze je nastaven");
        } else if (dokFondExt.isJE_EXEMP()) {
            logger.warn("fond externich zdroju neni spravne nastaven ale neni to fatalni");
        }
        return dokFondExt;
    }

    public boolean kontrolaExistenceFondu() throws AppServerStatus {
        this.dokFondExt = EBooksUtils.fondExternichZdroju();
        if (this.dokFondExt == null) {
            logger.info("fond externich zdroju neni nastaven");
            return false;
        }
        return true;
    }

    private Map<String, List<Kat1_4>> naplnMapuKat1_4(List<String> duplicitniISBN) {
        HashMap<String, List<Kat1_4>> map = new HashMap<String, List<Kat1_4>>();
        1 batchProcessor = new /* Unavailable Anonymous Inner Class!! */;
        batchProcessor.process();
        return map;
    }

    public long dohledejVRejstriku(Collection<String> seznamISBN) throws SQLException {
        for (String isbn : seznamISBN) {
            if (StringUtils.isBlank((CharSequence)isbn)) continue;
            String isbnCore = ISBNUtil.normalizujISBN((String)isbn).core();
            RecordKey recordKey = (RecordKey)this.qr.query("SELECT FIRST 1 * FROM RECORD_KEY INNER JOIN KAT1_4 ON KAT1_4.RECORD_ID=RECORD_KEY.RECORD_ID WHERE NAME=? AND VAL=? AND STATUS4!=99 AND KAT1_4.FK_DOKFOND!=? ORDER BY FK_DOKFOND", (ResultSetHandler)BeanHandlers.recordKeyHandler(), new Object[]{RecordKey.CORE_ISBN(), isbnCore, 21});
            if (recordKey == null) continue;
            long cisZaz = RecordIdCache.getByRecordId((String)recordKey.getRECORD_ID()).cisZaz();
            return cisZaz;
        }
        return 0L;
    }

    @Deprecated
    public static boolean pridejOdkazNaNahled(Record r, String previewPDF, String previewEPub) {
        boolean pridano = false;
        if (StringUtils.isNotBlank((CharSequence)previewPDF)) {
            Field odkazFieldPDF = new Field();
            odkazFieldPDF.setNumber((short)1856);
            odkazFieldPDF.setIndicators("42");
            odkazFieldPDF.getOrCreateSubfield("u").setContent(previewPDF);
            odkazFieldPDF.getOrCreateSubfield("z").setContent("n\u00e1hled");
            boolean poleExistujePDF = EBooksUtils.poleExistuje((Record)r, (Field)odkazFieldPDF);
            if (!poleExistujePDF) {
                r.addField(odkazFieldPDF);
                pridano = true;
                logger.info("pridavam PDF nahled k zaznamu " + r.getId() + " " + previewPDF);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)previewEPub)) {
            Field odkazFieldEPub = new Field();
            odkazFieldEPub.setNumber((short)1856);
            odkazFieldEPub.setIndicators("42");
            odkazFieldEPub.getOrCreateSubfield("u").setContent(previewEPub);
            odkazFieldEPub.getOrCreateSubfield("z").setContent("n\u00e1hled");
            boolean poleExistujeEPub = EBooksUtils.poleExistuje((Record)r, (Field)odkazFieldEPub);
            if (!poleExistujeEPub) {
                r.addField(odkazFieldEPub);
                pridano = true;
                logger.info("pridavam ePub nahled k zaznamu " + r.getId() + " " + previewEPub);
            }
        }
        return pridano;
    }

    private static boolean poleExistuje(Record r, Field odkazField) {
        boolean poleExistuje = false;
        for (Field f : r.getFields()) {
            if (f.getNumber() != odkazField.getNumber() || !odkazField.getPlainContent(true).equals(f.getPlainContent(true))) continue;
            poleExistuje = true;
            break;
        }
        return poleExistuje;
    }

    public Record zkusNajitZaznamZkem(List<String> seznamISBN) {
        for (int i = 0; i <= 2; ++i) {
            for (String isbn : seznamISBN) {
                Record r = this.zkusNajitZaznamZkem(isbn, i);
                if (r == null) continue;
                return r;
            }
            KPUtils.sleep((int)500);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Record zkusNajitZaznamZkem(String isbn, int zserverIndex) {
        Record r = null;
        ZServerInfo info = null;
        try {
            String zServer;
            switch (zserverIndex) {
                case 0: {
                    zServer = HledZExecutor.ZSERVER_PREDEFINED_NARODKA();
                    info = HledZExecutor.narodkaZServer();
                    break;
                }
                case 1: {
                    zServer = HledZExecutor.ZSERVER_PREDEFINED_CASLIN();
                    info = HledZExecutor.caslinZServer();
                    break;
                }
                case 2: {
                    zServer = HledZExecutor.ZSERVER_PREDEFINED_KNIHOVNYCZ();
                    info = HledZExecutor.knihovnyCZZServer();
                    break;
                }
                default: {
                    zServer = null;
                }
            }
            String zQuery = String.format("<?xml version=\"1.0\" encoding=\"utf-8\"?><collection><hled_z><ZSERVER>%s</ZSERVER><DOTAZ><constraintModel><constraint><semantic>7</semantic><relation>3</relation><position>3</position><structure>6</structure><truncation>1</truncation><completion>1</completion></constraint><model>%s</model></constraintModel></DOTAZ></hled_z></collection>", zServer, isbn);
            Document doc = XMLService.getDocument((String)zQuery);
            HledZInput input = HledZExecutor.parseHledZInput((Document)doc, (DbCore2)this.core2);
            input.zserverInfos.add(this.pripravSeznamZServeruKHledaniISBN(0));
            input.zserverInfos.add(this.pripravSeznamZServeruKHledaniISBN(1));
            input.zserverInfos.add(this.pripravSeznamZServeruKHledaniISBN(2));
            HledZExecutor hledZExecutor = new HledZExecutor(input);
            try {
                HledZOutput output = hledZExecutor.hledZ();
                input.dotaz = null;
                input.token = output.token;
                if (output.nalezeneZaznamy.containsKey(zServer) && (Integer)output.nalezeneZaznamy.get(zServer) > 0) {
                    input.dotaz = null;
                    input.pocetKeStazeni = 1;
                    try {
                        HledZOutput outputNalezene = hledZExecutor.hledZ();
                        r = (Record)outputNalezene.zaznamy.get(0);
                    }
                    catch (Exception e) {
                        logger.error("problem pri hledani zaznamu dle ISBN " + isbn + " v " + info);
                    }
                }
            }
            finally {
                input.queryType = HledZInput.QUERY_TYPE.CLOSE;
                try {
                    hledZExecutor.hledZ();
                }
                catch (Exception e) {
                    logger.error("problem pri zavirani spojeni na ZSERVER " + info, (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.warn("jiny problem pri hledani zaznamu dle ISBN " + isbn + " v " + info, (Throwable)e);
        }
        return r;
    }

    public void zapisDoplnenyZaznam(Record r, RecordReconstructor2 rc2) throws SQLException {
        r.setVykon((int)DefVykony.ID_18_OPRAVENO_EXTERNI_APLIKACI());
        try {
            int fkUziv = r.getFkUziv();
            if (fkUziv == 0) {
                fkUziv = DbCache2.opacUserID;
                r.setFkUziv(fkUziv);
            }
            DbCore2.relogUserCommit((int)fkUziv, (short)((Short)DbCache.rootPujcovna().get()), (Connection)this.core2.getConn(), (DatabaseEngine)ProxoolUtil.engine());
            logger.info("pridany odkazy, zapisuji zaznam " + r.getId());
            SessionData sessionData = new SessionData();
            sessionData.setUcode(DbCache2.appServerUserID);
            this.core2.setSessionData(sessionData);
            rc2.writeRecord(r);
            DbCore2.relogUserCommit((int)DbCache2.appServerUserID, (short)((Short)DbCache.rootPujcovna().get()), (Connection)this.core2.getConn(), (DatabaseEngine)ProxoolUtil.engine());
        }
        catch (AppServerStatus e) {
            logger.warn("problem pri doplnovani 1856 - odkazy na nahledy PDF a ePub - do existujiciho zaznamu " + r.getId(), (Throwable)e);
        }
    }

    public void zpozdovaciLinka() {
        long currentTime;
        long timeFromLastQuery;
        ++this.zserverBatchCounter;
        if (this.zserverBatchCounter > 2) {
            KPUtils.sleep((int)5000);
            this.zserverBatchCounter = 0;
        }
        if ((timeFromLastQuery = (currentTime = System.currentTimeMillis()) - this.lastZQueryTime) < 2000L) {
            KPUtils.sleep((int)((int)(2000L - timeFromLastQuery)));
        }
        this.lastZQueryTime = currentTime;
    }

    public static List<PomocnyExterniZdroj> parsujXMLERD(Reader rd) throws IOException {
        ArrayList<PomocnyExterniZdroj> zdroje = new ArrayList<PomocnyExterniZdroj>();
        SAXReader reader = new SAXReader();
        reader.addHandler("/EBOOKS/EBOOK", (ElementHandler)new /* Unavailable Anonymous Inner Class!! */);
        try {
            Document document = reader.read(rd);
        }
        catch (DocumentException e) {
            logger.error("behem parsovani XML eReading doslo k chybe", (Throwable)e);
            throw new IOException("selhalo stahovani definic", e);
        }
        logger.info("dokonceno");
        return zdroje;
    }

    public static List<PomocnyExterniZdroj> parsujXMLFlexi(Reader rd) throws DocumentException, SQLException {
        ArrayList<PomocnyExterniZdroj> zdroje = new ArrayList<PomocnyExterniZdroj>();
        SAXReader reader = new SAXReader();
        reader.addHandler("/output/produkt", (ElementHandler)new /* Unavailable Anonymous Inner Class!! */);
        Document document = reader.read(rd);
        logger.info("dokonceno, celkem nacteno dokumentu " + zdroje.size());
        return zdroje;
    }
}

