/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.kpwin2.tasks;

import cz.kpsys.AppServerStatus;
import cz.kpsys.common.AutomatLogger;
import cz.kpsys.db.DbCache;
import cz.kpsys.db.DbCache2;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.GenericExecutor;
import cz.kpsys.db.OAIClientCore;
import cz.kpsys.db.model.v2.CentralMapaFondu;
import cz.kpsys.db.model.v2.DefAutomat;
import cz.kpsys.kpwin2.tasks.AppServerTimerTask;
import cz.kpsys.service.DateConversions;
import cz.kpsys.service.Utils;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Map;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class AktualizaceOAITimerTask
extends AppServerTimerTask {
    private static final String PAR_URL = "URL";
    private static final String PAR_DATCAS = "DATCAS";
    private static final String PAR_DB = "DB";
    private static final String PAR_FOND = "FOND";
    private static final String PAR_DEPARTMENT = "DEPARTMENT";
    private static final String PAR_IDREGEXP = "IDREGEXP";
    private static final String PAR_SET = "SET";
    private static final String PAR_META = "META";
    private static final String PAR_SKIP = "SKIP";
    private static final int ERR1_PARAMETR_NEZADAN = 1;
    private static final Logger logger = LoggerFactory.getLogger(AktualizaceOAITimerTask.class);

    public AktualizaceOAITimerTask(DefAutomat defAutomat) {
        super(defAutomat);
    }

    public void doJob(Connection conn, DbCore2 core2, QueryRunner qr, AutomatLogger automatLogger) throws Exception {
        String parDepartment;
        CentralMapaFondu mapaFondu;
        logger.info("spoustim ulohu aktualizace OAI");
        String parametr = this.defAutomat.getPARAMETRY();
        if (StringUtils.isBlank((CharSequence)parametr)) {
            throw new AppServerStatus("parametr musi byt zadan", 1);
        }
        Map parametry = AktualizaceOAITimerTask.parsujParametry((String)parametr);
        Date datum = null;
        int skip = 0;
        short department = (Short)DbCache.rootPujcovna().get();
        int dbId = Integer.parseInt((String)parametry.get("DB"));
        short fond = Short.parseShort((String)parametry.get("FOND"));
        String parDatCas = (String)parametry.get("DATCAS");
        if (StringUtils.isNotBlank((CharSequence)parDatCas)) {
            datum = Utils.sdfHumanDate().parse(parDatCas);
        }
        if ((mapaFondu = (CentralMapaFondu)((Map)DbCache2.centralMapaFonduMapMap.get((short)dbId)).get(fond)) != null && mapaFondu.getFK_PUJC() != null) {
            department = mapaFondu.getFK_PUJC();
        }
        if (StringUtils.isNotBlank((CharSequence)(parDepartment = (String)parametry.get("DEPARTMENT")))) {
            department = Short.parseShort(parDepartment);
        }
        String url = (String)parametry.get("URL");
        String idRegExp = (String)parametry.get("IDREGEXP");
        String set = (String)parametry.get("SET");
        String meta = (String)parametry.get("META");
        try {
            skip = Integer.parseInt((String)parametry.get("SKIP"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new IllegalArgumentException();
        }
        OAIClientCore oaiClientCore = new OAIClientCore(core2, automatLogger, url, dbId, fond, idRegExp, set, meta);
        if (datum != null) {
            while (datum.before(Utils.today())) {
                Date datumDo = GenericExecutor.addDays((Date)datum, (int)30);
                if (datumDo.after(Utils.today())) {
                    oaiClientCore.listRecords(datum, null, department, skip);
                } else {
                    oaiClientCore.listRecords(datum, datumDo, department, skip);
                }
                datum = datumDo;
            }
        } else {
            oaiClientCore.listRecords(null, null, department, skip);
        }
        Date noveDatum = this.updatuj();
        String noveDatumString = Utils.sdfHumanDate().format(noveDatum);
        parametry.put("DATCAS", noveDatumString);
        String params = AktualizaceOAITimerTask.poskladejParametry((Map)parametry);
        this.zapisParametryUlohy(qr, params);
        logger.info("uloha aktualizace OAI dobehla");
    }

    public String oznaceniTypuUlohy() {
        return "Aktualizace pomoci OAI";
    }

    private void zapisParametryUlohy(QueryRunner qr, String params) throws SQLException {
        qr.update("UPDATE DEF_AUTOMAT SET PARAMETRY=? WHERE ID_AUTOMAT=?", new Object[]{params, this.defAutomat.getID_AUTOMAT()});
    }

    private Date updatuj() {
        return DateConversions.localDateTime2utilDate((LocalDateTime)LocalDateTime.now().plusMinutes(-5L));
    }

    public String toString() {
        return String.format("AktualizaceOAITimerTask", new Object[0]);
    }
}

