/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.kpwin2.tasks;

import cz.kpsys.AppServerStatus;
import cz.kpsys.common.AutomatLogger;
import cz.kpsys.common.Licensing;
import cz.kpsys.common.ZipExtractor;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.model.v2.DefAutomat;
import cz.kpsys.kpwin2.tasks.AppServerTimerTask;
import cz.kpsys.kpwin2.tasks.UpdateVerbisTimerTask;
import cz.kpsys.service.OkHttpClientFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.dbutils.QueryRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateVerbisTimerTask
extends AppServerTimerTask {
    private static final Logger logger = LoggerFactory.getLogger(UpdateVerbisTimerTask.class);

    public UpdateVerbisTimerTask(DefAutomat defAutomat) {
        super(defAutomat);
    }

    public void doJob(Connection conn, DbCore2 core2, QueryRunner qr, AutomatLogger automatLogger) throws SQLException, AppServerStatus {
        logger.info("spoustim update verbis");
        String path = this.defAutomat.getPARAMETRY();
        File extractDir = new File(path);
        String tmpDir = System.getProperty("java.io.tmpdir");
        String tempZip = tmpDir + File.separator + "verbis.zip";
        String adresar = this.adresarProUpdate();
        try {
            OkHttpClient client = OkHttpClientFactory.client();
            URL website = new URL("http://podpora.kpsys.cz/update/" + adresar + "/verbis.zip");
            logger.info("stahuji update verbis z URL " + website.toExternalForm());
            Request request = new Request.Builder().url(website).get().build();
            Response response = client.newCall(request).execute();
            ReadableByteChannel rbc = Channels.newChannel(response.body().byteStream());
            FileOutputStream fos = new FileOutputStream(tempZip);
            fos.getChannel().transferFrom(rbc, 0L, 0x40000000L);
        }
        catch (IOException e) {
            throw new AppServerStatus("problem pri stahovani update: " + e, 2);
        }
        logger.info("adresar pro rozbaleni " + extractDir);
        if (extractDir.exists()) {
            if (extractDir.isFile()) {
                logger.error("nastavena cesta ukazuje na soubor, nutno nastavit adresar");
                throw new AppServerStatus("spatne nastavena cesta", 1);
            }
        } else {
            logger.error("nastaveny adresar pro update neexistuje");
            throw new AppServerStatus("adresar neexistuje " + extractDir, 2);
        }
        File tempZipFile = new File(tempZip);
        boolean maSeAktualizovat = this.maSeAktualizovat(tempZipFile, extractDir);
        if (maSeAktualizovat) {
            try {
                ZipExtractor.unpackArchive((File)tempZipFile, (File)extractDir);
            }
            catch (IOException e) {
                logger.error("selhani", (Throwable)e);
                throw new AppServerStatus("problem pri rozbalovani archivu: " + e, 3);
            }
        } else {
            logger.warn("aktualni verbis.exe je novejsi nez archiv s update, proces aktualizace zastaven");
        }
        logger.info("update verbis dobehlo");
    }

    public String oznaceniTypuUlohy() {
        return "Aktualizace Verbis";
    }

    private String adresarProUpdate() {
        switch (1.$SwitchMap$cz$kpsys$common$VerbisVersion[Licensing.verbisVersion().ordinal()]) {
            case 1: {
                return "g399dvi49vns0";
            }
            case 2: {
                return "3id9vke94d_3";
            }
            case 3: {
                return "ab49ds_40sa";
            }
        }
        throw new IllegalArgumentException("nepodporovana verze pro update Verbis " + Licensing.verbisVersion());
    }

    private boolean maSeAktualizovat(File tempZipFile, File extractDir) {
        File verbisFile = new File(extractDir.getAbsolutePath() + File.separator + "verbis.exe");
        if (!verbisFile.exists()) {
            logger.warn("verbis.exe v cilovem adresari nenalezen, budu aktualizovat");
            return true;
        }
        boolean maSeAktualizovat = true;
        try {
            long verbisZipTime = ZipExtractor.fileDateInArchive((File)tempZipFile, (String)"verbis.exe");
            Date zipDate = new Date(verbisZipTime);
            Date verbisDate = new Date(verbisFile.lastModified());
            maSeAktualizovat = zipDate.after(verbisDate);
        }
        catch (IOException e) {
            logger.error("chyba behem testu potrebnosti aktualizace, aktualizace vynucena", (Throwable)e);
            return true;
        }
        return maSeAktualizovat;
    }

    public String toString() {
        return String.format("UpdateVerbisTimerTask", new Object[0]);
    }
}

