/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.kpwinsql.z3950.server;

import cz.kpsys.db.DbConfig;
import cz.kpsys.kpwinsql.z3950.model.ZServerConfig;
import cz.kpsys.kpwinsql.z3950.server.KPZserverManager;
import cz.kpsys.kpwinsql.z3950.services.ZServerConfigService;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZServerService {
    private static final Logger logger = LoggerFactory.getLogger(ZServerService.class);
    private static ZServerConfig zServerConfig;
    private static KPZserverManager kpZserverManager;

    public boolean zServerConfigValid(DbConfig dbConfig) {
        try {
            String iniInWorkingDir = this.iniInWorkingDir();
            String configFileName = System.getProperty("kpsys.z39ini", iniInWorkingDir);
            zServerConfig = ZServerConfigService.loadConfig((String)configFileName, (DbConfig)dbConfig);
            if (zServerConfig == null) {
                return false;
            }
        }
        catch (Exception e) {
            logger.warn("pri zkusebnim nacteni konfigurace zserveru se vyskytl problem", (Throwable)e);
            return false;
        }
        return true;
    }

    private String iniInWorkingDir() {
        String workingDir = System.getProperty("user.dir");
        String iniInWorkingDir = workingDir + File.separator + "zserver.ini";
        if (!new File(iniInWorkingDir).canRead()) {
            logger.info("ZServer not available");
            return null;
        }
        return iniInWorkingDir;
    }

    public void initZServer(DbConfig dbConfig) {
        String iniInWorkingDir = this.iniInWorkingDir();
        String configFileName = System.getProperty("kpsys.z39ini", iniInWorkingDir);
        zServerConfig = ZServerConfigService.loadConfig((String)configFileName, (DbConfig)dbConfig);
        if (zServerConfig == null) {
            return;
        }
        kpZserverManager = new KPZserverManager();
        kpZserverManager.startListening();
    }

    public void stopZServer() {
        if (kpZserverManager != null) {
            kpZserverManager.stopServer(3000L);
            kpZserverManager = null;
        }
    }
}

