/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.marc;

import cz.kpsys.db.DbCache2NG;
import cz.kpsys.marc.SubField;
import cz.kpsys.service.ICacheSerializer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;

public final class Field
implements ICacheSerializer {
    short number;
    char ind1 = (char)32;
    char ind2 = (char)32;
    List<SubField> subFields = new ArrayList();
    String content;
    private String idZazZdroj;
    private short idZazZdrojDb;

    public Field() {
    }

    public Field(short fieldNumber) {
        this.number = fieldNumber;
    }

    public short getIdZazZdrojDb() {
        return this.idZazZdrojDb;
    }

    public void setIdZazZdrojDb(short idZazZdrojDb) {
        this.idZazZdrojDb = idZazZdrojDb;
    }

    public boolean isFixedLength() {
        return this.number < 10;
    }

    public boolean isVariableLength() {
        return this.number >= 10;
    }

    public String getIndikatory() {
        return String.format("%c%c", Character.valueOf(this.ind1), Character.valueOf(this.ind2));
    }

    public void sort(String poradi) {
        SubField[] pole = this.subFields.toArray(new SubField[0]);
        Arrays.sort(pole, (o1, o2) -> {
            Integer index1 = poradi.indexOf(o1.prefix);
            Integer index2 = poradi.indexOf(o2.prefix);
            if (index1 == -1 && index2 == -1) {
                return o1.prefix.compareTo(o2.prefix);
            }
            return index1.compareTo(index2);
        });
        this.subFields.clear();
        this.subFields.addAll(Arrays.asList(pole));
    }

    public void removeSubfields(String prefix) {
        for (int i = 0; i < this.subFields.size(); ++i) {
            if (!prefix.equals(((SubField)this.subFields.get(i)).getPrefix())) continue;
            this.subFields.remove(i);
            --i;
        }
    }

    public SubField getFirstSubfield(String prefix) {
        for (SubField sf : this.subFields) {
            if (!prefix.equals(sf.getPrefix())) continue;
            return sf;
        }
        return null;
    }

    public SubField getLastSubfield(String prefix) {
        if (this.subFields.size() > 0) {
            for (int i = this.subFields.size() - 1; i >= 0; --i) {
                SubField sf = (SubField)this.subFields.get(i);
                if (!prefix.equals(sf.getPrefix())) continue;
                return sf;
            }
        }
        return null;
    }

    public void insertSubFieldAt(int position, SubField sf) {
        this.subFields.add(position, sf);
    }

    public List<SubField> getSubfields(String prefix) {
        ArrayList<SubField> list = new ArrayList<SubField>(this.subFields.size());
        for (SubField sf : this.subFields) {
            if (!prefix.equals(sf.getPrefix())) continue;
            list.add(sf);
        }
        return list;
    }

    public short getNumber() {
        return this.number;
    }

    public void setNumber(short number) {
        this.number = number;
    }

    public char getInd1() {
        return this.ind1;
    }

    public void setInd1(char ind1) {
        this.ind1 = ind1;
    }

    public String getIndString1() {
        return Character.toString(this.ind1);
    }

    public String getIndString1ZServer() {
        if (this.ind1 == '#') {
            return " ";
        }
        return Character.toString(this.ind1);
    }

    public char getInd2() {
        return this.ind2;
    }

    public void setInd2(char ind2) {
        this.ind2 = ind2;
    }

    public String getIndString2() {
        return Character.toString(this.ind2);
    }

    public String getIndString2ZServer() {
        if (this.ind2 == '#') {
            return " ";
        }
        return Character.toString(this.ind2);
    }

    public List<SubField> getSubfields() {
        return this.subFields;
    }

    public void setSubfields(List<SubField> subFields) {
        this.subFields = subFields;
    }

    public String getContent() {
        return this.content;
    }

    public Field setContent(String content) {
        this.content = content;
        return this;
    }

    public String getPlainContent(boolean marc21strict) {
        if (this.number < 10 && marc21strict) {
            return this.content;
        }
        StringBuilder sb = new StringBuilder(20);
        boolean first = true;
        for (SubField sf : this.getSubfields()) {
            if (!first) {
                sb.append(" ");
            }
            sb.append(sf.getContent());
            first = false;
        }
        return sb.toString();
    }

    public String getMinusSeparatedContent() {
        StringBuilder sb = new StringBuilder(20);
        boolean first = true;
        for (SubField sf : this.getSubfields()) {
            if (!first) {
                sb.append(" - ");
            }
            if (sf.isVisible()) {
                sb.append(sf.getContent());
            }
            first = false;
        }
        return sb.toString();
    }

    public String getFormattedSubfieldContent(String subfieldCharMark, boolean marc21strict) {
        if (this.number < 10 && marc21strict || this.number == 0) {
            return this.content;
        }
        StringBuilder sb = new StringBuilder(20);
        if (this.number >= 1000 && StringUtils.isNotBlank((CharSequence)this.content) && !((Set)DbCache2NG.poleSPodpoliDok().get()).contains(this.number)) {
            sb.append(this.content);
        }
        for (SubField sf : this.getSubfields()) {
            if (!sf.isVisible()) continue;
            sb.append(subfieldCharMark + sf.getPrefix() + sf.getContent().replace('^', '\u21e7'));
        }
        return sb.toString();
    }

    public String getDollarFormattedSubfieldContent(boolean marc21strict) {
        return this.getFormattedSubfieldContent("$", marc21strict);
    }

    public String getStriskaFormattedSubfieldContent(boolean marc21strict) {
        return this.getFormattedSubfieldContent("^", marc21strict);
    }

    public String toString() {
        return "Field [number=" + this.number + ", numbercontent=" + this.content + ", ind1=" + this.ind1 + ", ind2=" + this.ind2 + ", subfields=" + this.subFields + "]";
    }

    public Field addSubfield(SubField sf) {
        this.subFields.add(sf);
        return this;
    }

    public Field addSubfield(String prefix, String content) {
        SubField sf = new SubField(prefix, content);
        this.subFields.add(sf);
        return this;
    }

    public void removeSubfield(String prefix) {
        SubField sfToRemove = null;
        for (SubField sf : this.subFields) {
            if (!sf.prefix.equals(prefix)) continue;
            sfToRemove = sf;
            break;
        }
        if (sfToRemove != null) {
            this.subFields.remove(sfToRemove);
        }
    }

    public void setIndicators(String string) {
        this.ind1 = string.charAt(0);
        this.ind2 = string.charAt(1);
    }

    public SubField getOrCreateSubfield(String prefix) {
        SubField sf = this.getFirstSubfield(prefix);
        if (sf == null) {
            sf = new SubField();
            sf.setPrefix(prefix);
            this.addSubfield(sf);
        }
        return sf;
    }

    public boolean hasVoidContent() {
        if (this.number < 10) {
            return this.content == null || this.content.length() == 0;
        }
        if (this.number >= 1000 && StringUtils.isNotBlank((CharSequence)this.content)) {
            return false;
        }
        return this.subFields == null || this.subFields.size() == 0;
    }

    public boolean isVisible(boolean marc21strict) {
        if (this.number > 10 || !marc21strict) {
            for (SubField sf : this.subFields) {
                if (!sf.isVisible()) continue;
                return true;
            }
        } else if (this.content != null && this.content.length() > 0) {
            return true;
        }
        return false;
    }

    public boolean isTheSameAs(Field anotherField) {
        if (anotherField == null || anotherField.getNumber() != this.number) {
            return false;
        }
        if (this.number < 10) {
            if (this.content != anotherField.getContent()) {
                return false;
            }
            if (this.subFields.size() != anotherField.subFields.size()) {
                return false;
            }
            if (this.ind1 != anotherField.ind1 || this.ind2 != anotherField.ind2) {
                return false;
            }
            for (int i = 0; i < this.subFields.size(); ++i) {
                SubField sf = (SubField)this.subFields.get(i);
                SubField anotherSf = (SubField)this.subFields.get(i);
                if (sf.prefix != anotherSf.prefix) {
                    return false;
                }
                if (sf.content == anotherField.content) continue;
                return false;
            }
        }
        return true;
    }

    public String najdiOdkazNaAutoritu() {
        for (SubField sf : this.subFields) {
            if (sf.authLink <= 0L) continue;
            return Long.toString(sf.authLink);
        }
        return null;
    }

    public Field klonuj() {
        Field f = new Field();
        f.content = this.content;
        f.ind1 = this.ind1;
        f.ind2 = this.ind2;
        f.number = this.number;
        for (SubField sf : this.subFields) {
            f.subFields.add(sf.klonuj());
        }
        return f;
    }

    public String getSubfieldContent(String prefix) {
        SubField sf = this.getFirstSubfield(prefix);
        if (sf != null) {
            return sf.content;
        }
        return null;
    }

    public void sort() {
        this.sort("");
    }

    public SubField getLastSubField() {
        int last = this.subFields.size() - 1;
        if (last >= 0) {
            return (SubField)this.subFields.get(last);
        }
        return null;
    }

    public SubField createSubfield(String prefix) {
        SubField sf = new SubField();
        sf.setPrefix(prefix);
        this.subFields.add(sf);
        return sf;
    }

    public void nastavIndikatoryZRetezce(String indik) {
        if (indik.length() != 2) {
            throw new IllegalArgumentException("predany retezec musi byt delky presne 2 znaky");
        }
        this.ind1 = indik.charAt(0);
        this.ind2 = indik.charAt(1);
    }

    public void nastavObsahVytvorPodpole(String content, String delimeter) {
        if (this.number < 10) {
            throw new UnsupportedOperationException("lze pouzit pouze pro pole promenne delky");
        }
        StringTokenizer st = new StringTokenizer(content, delimeter);
        while (st.hasMoreTokens()) {
            String subFieldRaw = st.nextToken();
            if (subFieldRaw.length() < 2) continue;
            SubField sf = new SubField();
            sf.setPrefix(subFieldRaw.substring(0, 1));
            sf.setContent(subFieldRaw.substring(1));
            this.subFields.add(sf);
        }
    }

    public String getIdZazZdroj() {
        return this.idZazZdroj;
    }

    public void setIdZazZdroj(String idZazZdroj) {
        this.idZazZdroj = idZazZdroj;
    }

    public void serializeToCache(ObjectOutputStream os) throws IOException {
        os.writeInt(this.number);
        os.writeUTF(String.valueOf(this.ind1) + String.valueOf(this.ind2));
        os.writeInt(this.subFields.size());
        for (SubField sf : this.subFields) {
            sf.serializeToCache(os);
        }
    }

    public void deserializeFromCache(ObjectInputStream is) throws IOException {
        this.number = (short)is.readInt();
        String inds = is.readUTF();
        this.setInd1(inds.charAt(0));
        this.setInd2(inds.charAt(1));
        int subfieldsCount = is.readInt();
        for (int i = 0; i < subfieldsCount; ++i) {
            SubField sf = new SubField();
            sf.deserializeFromCache(is);
            this.subFields.add(sf);
        }
    }
}

