/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.marc;

import cz.kpsys.marc.Field;
import cz.kpsys.marc.Field008;
import java.util.Calendar;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Field008 {
    public static final Range<Integer> nullRange = Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(0));
    static final int mistoVydaniBegin = 15;
    static final int mistoVydaniEnd = 18;
    static final int jazykVydaniBegin = 35;
    static final int jazykVydaniEnd = 38;
    static final int datum1Begin = 7;
    static final int datum1End = 11;
    static final int datum2Begin = 11;
    static final int datum2End = 15;
    static final Pattern pat1 = Pattern.compile("(.*?)[\\$\\n$]");
    static final Pattern pat2 = Pattern.compile("[^\\d]*(\\d+)([^\\d]+(\\d+))?");
    private static final Logger logger = LoggerFactory.getLogger(Field008.class);
    private static final int POSITION_OF_TYPE_OF_DATE_STATUS = 6;
    private final Field f;

    public static Field008 instance(Field f) {
        if (f == null) {
            return null;
        }
        return new Field008(f);
    }

    private Field008(Field f) {
        this.f = f;
    }

    public void setKodStatu(String kodStatu) {
        Object originalContent;
        if (kodStatu.length() < 2) {
            logger.error("neplatny kod statu: " + kodStatu);
            return;
        }
        if (kodStatu.length() < 3) {
            kodStatu = kodStatu.concat("|");
        }
        if (((String)(originalContent = this.f.getContent())).length() < 18) {
            originalContent = (String)originalContent + StringUtils.repeat((String)" ", (int)(18 - ((String)originalContent).length()));
        }
        this.f.setContent(((String)originalContent).substring(0, 15) + kodStatu + ((String)originalContent).substring(18));
    }

    public String getKodStatu() {
        String content = this.f.getContent();
        if (StringUtils.isBlank((CharSequence)content) || content.length() < 18) {
            logger.error("nevalidni pole 008, neni kod statu");
            return null;
        }
        return content.substring(15, 18).replace("-", "").trim();
    }

    public void setKodJazyka(String kodJazyka) {
        String originalContent;
        if (kodJazyka.length() < 2) {
            logger.error("neplatny kod jazyka: " + kodJazyka);
            return;
        }
        if (kodJazyka.length() < 3) {
            kodJazyka = kodJazyka.concat("|");
        }
        if ((originalContent = this.f.getContent()).length() < 38) {
            logger.error("nevalidni pole 008, neni kod jazyka: " + kodJazyka);
            return;
        }
        this.f.setContent(originalContent.substring(0, 35) + kodJazyka + originalContent.substring(38));
    }

    public String getKodJazyka() {
        String content = this.f.getContent();
        if (content != null) {
            content = content.trim();
        }
        if (StringUtils.isBlank((CharSequence)content) || content.length() < 38) {
            logger.error("nevalidni pole 008, neni kod jazyka");
            return null;
        }
        return content.substring(35, 38).replace("-", "");
    }

    public String getDatum1() {
        String content = this.f.getContent();
        if (content.length() < 11) {
            return null;
        }
        return content.substring(7, 11);
    }

    public String getDatum2() {
        String content = this.f.getContent();
        if (content.length() < 15) {
            return null;
        }
        return content.substring(11, 15);
    }

    public char typDataPublikacniStatus() {
        return this.f.getContent().charAt(6);
    }

    public String generuj260c() {
        char status = this.typDataPublikacniStatus();
        switch (status) {
            case 'b': {
                return "B.C.";
            }
            case 'c': {
                return this.getDatum1();
            }
        }
        return null;
    }

    public char indikatorTypuData() {
        if (this.f == null) {
            return '#';
        }
        String field008Content = this.f.getContent();
        if (field008Content == null || field008Content.length() <= 6) {
            return '#';
        }
        return field008Content.charAt(6);
    }

    public MoznostiData008 typData008() {
        char status = this.indikatorTypuData();
        switch (status) {
            case 'e': 
            case 's': {
                return MoznostiData008.JEDEN_ROK;
            }
            case 'p': 
            case 'q': 
            case 'r': 
            case 't': {
                return MoznostiData008.DVA_ROKY_NEZAVISLE;
            }
            case 'c': 
            case 'd': 
            case 'i': 
            case 'k': 
            case 'm': {
                return MoznostiData008.DVA_ROKY_INTERVAL;
            }
        }
        return MoznostiData008.ZADNE_DATUM;
    }

    public Range<Integer> parseRokyFrom008() {
        MoznostiData008 moznostiData008 = this.typData008();
        if (moznostiData008 == null) {
            return nullRange;
        }
        switch (1.$SwitchMap$cz$kpsys$marc$Field008$MoznostiData008[moznostiData008.ordinal()]) {
            case 1: {
                try {
                    String datum = this.convertUtoDate(this.getDatum1(), false);
                    if (datum != null) {
                        int datumInt = Integer.parseInt(datum);
                        return Range.between((Comparable)Integer.valueOf(datumInt), (Comparable)Integer.valueOf(datumInt));
                    }
                    return nullRange;
                }
                catch (NumberFormatException nfe) {
                    logger.debug("selhani", (Throwable)nfe);
                    return nullRange;
                }
            }
            case 2: {
                try {
                    String datum1 = this.convertUtoDate(this.getDatum1(), false);
                    int datumInt1 = Integer.parseInt(datum1);
                    String datum2 = this.convertUtoDate(this.getDatum2(), true);
                    int datumInt2 = Integer.parseInt(datum2);
                    if (datumInt2 == 9999) {
                        int year;
                        datumInt2 = year = Calendar.getInstance().get(1);
                    }
                    if (datum1 != null && datum2 != null) {
                        return Range.between((Comparable)Integer.valueOf(datumInt1), (Comparable)Integer.valueOf(datumInt2));
                    }
                    if (datum1 != null && datum2 == null) {
                        return Range.between((Comparable)Integer.valueOf(datumInt1), (Comparable)Integer.valueOf(datumInt1));
                    }
                    return nullRange;
                }
                catch (NumberFormatException nfe) {
                    logger.debug("selhani", (Throwable)nfe);
                    return nullRange;
                }
            }
            case 3: {
                try {
                    String datum1 = this.convertUtoDate(this.getDatum1(), false);
                    int datumInt1 = Integer.parseInt(datum1);
                    return Range.between((Comparable)Integer.valueOf(datumInt1), (Comparable)Integer.valueOf(datumInt1));
                }
                catch (NumberFormatException nfe) {
                    logger.debug("selhani", (Throwable)nfe);
                    return nullRange;
                }
            }
            case 4: {
                return nullRange;
            }
        }
        return nullRange;
    }

    @Deprecated
    public Range<Integer> parseRokyFrom008Serial() {
        try {
            String datum1String = this.getDatum1();
            String datum2String = this.getDatum2();
            int thisYear = Calendar.getInstance().get(1);
            if (StringUtils.isBlank((CharSequence)datum1String) || StringUtils.isBlank((CharSequence)datum2String)) {
                return null;
            }
            int rok1 = Integer.parseInt(datum1String);
            int rok2 = 0;
            char typData = this.indikatorTypuData();
            try {
                rok2 = typData != 'e' ? Integer.parseInt(datum2String) : rok1;
            }
            catch (NumberFormatException nfe) {
                rok2 = 'm' == typData || 'n' == typData ? thisYear : rok1;
            }
            if (rok2 > thisYear) {
                rok2 = thisYear;
            }
            if (rok2 >= rok1 && rok2 - rok1 < 400) {
                return Range.between((Comparable)Integer.valueOf(rok1), (Comparable)Integer.valueOf(rok2));
            }
            return null;
        }
        catch (NumberFormatException nfe) {
            logger.debug("selhani", (Throwable)nfe);
            return null;
        }
    }

    public String convertUtoDate(String date, boolean replaceWithNines) {
        if (date == null) {
            return null;
        }
        if (date.substring(1).equalsIgnoreCase("uuu")) {
            return null;
        }
        if (replaceWithNines) {
            return date.replace('u', '9');
        }
        return date.replace('u', '0');
    }
}

