/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.marc;

import cz.kpsys.db.DbCache;
import cz.kpsys.db.DbCache2;
import cz.kpsys.db.DbCache2NG;
import cz.kpsys.db.model.PolePodpole;
import cz.kpsys.db.model.v2.Kat1_7;
import cz.kpsys.marc.Field;
import cz.kpsys.marc.SubField;
import cz.kpsys.portaro.record.RecordStatus;
import cz.kpsys.service.ICacheSerializer;
import cz.kpsys.service.SUtils;
import cz.kpsys.service.Utils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.Short;

public class Record
implements ICacheSerializer {
    public static final String defaultLeader = "-----nam a22--------4500";
    public static final String defaultLeaderZHead = "-----";
    public static final String defaultLeaderZTail = "2--------4500";
    static final Pattern p = Pattern.compile("(\\d*)(.*)");
    short fond = 0;
    public String recordId = SUtils.uuid();
    private static final Logger logger = LoggerFactory.getLogger(Record.class);
    public Set<Kat1_7> seznamAutoritnichVazeb;
    long id;
    public Option<Boolean> recordExists = Option.empty();
    Option<java.lang.Short> department = Option.empty();
    long fkZaz;
    private int recordStatus = 0;
    String nazev;
    private Long fkFullTextSkupiny;
    private Long fkFulltextImage;
    String toc;
    String citace;
    String tocPdfUrl;
    String cisloNarodniAutority;
    int dbId;
    int[] localDbIds;
    int vykon;
    int fkUziv;
    boolean stazenoZ39_50 = false;
    String leader = null;
    boolean active;
    ArrayList<Field> fields = new ArrayList();
    private String comment;
    private boolean leaderLocked = false;

    public Option<java.lang.Short> getDepartmentOption() {
        return this.department;
    }

    public java.lang.Short deparmentOrRoot() {
        return (java.lang.Short)this.department.getOrElse(() -> Short.unbox((Object)DbCache.rootPujcovna()));
    }

    public void setDepartment(short department) {
        this.department = Option.apply((Object)department);
    }

    public void departmentAgnostic() {
        this.department = Option.empty();
    }

    private void recordStatusCheck() {
        if (this.recordStatus == RecordStatus.CUSTOM.getId() && StringUtils.isNotBlank((CharSequence)this.cisloNarodniAutority)) {
            this.recordStatus = RecordStatus.NATIONAL.getId();
        }
    }

    public int getRecordStatus() {
        this.recordStatusCheck();
        return this.recordStatus;
    }

    public void setRecordStatus(int recordStatus) {
        this.recordStatus = recordStatus;
        this.recordStatusCheck();
    }

    public String getTocPdfUrl() {
        return this.tocPdfUrl;
    }

    public void setTocPdfUrl(String tocPdfUrl) {
        this.tocPdfUrl = tocPdfUrl;
    }

    public boolean isStazenoZ39_50() {
        return this.stazenoZ39_50;
    }

    public void setStazenoZ39_50(boolean stazenoZ39_50) {
        this.stazenoZ39_50 = stazenoZ39_50;
    }

    public String getToc() {
        return this.toc;
    }

    public void setToc(String toc) {
        this.toc = toc;
    }

    public String getCitace() {
        return this.citace;
    }

    public void setCitace(String citace) {
        this.citace = citace;
    }

    public Record addField(Field f) {
        this.fields.add(f);
        return this;
    }

    public Field getFirstField(int fieldNumber) {
        for (Field field : this.fields) {
            if (field.getNumber() != fieldNumber) continue;
            return field;
        }
        return null;
    }

    public int isAutorityInt() {
        return this.isAuthority() ? 1 : 0;
    }

    public boolean isAuthority() {
        return DbCache2.defAutFondMap.containsKey(this.fond);
    }

    public short getFond() {
        return this.fond;
    }

    public void setFond(short fond) {
        this.fond = fond;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getLeader() {
        return this.leader;
    }

    public Long getFkFullTextSkupiny() {
        return this.fkFullTextSkupiny;
    }

    public void setFkFullTextSkupiny(Long fkFullTextSkupiny) {
        this.fkFullTextSkupiny = fkFullTextSkupiny;
    }

    public String getRecordId() {
        return this.recordId;
    }

    public void setRecordId(String recordId) {
        this.recordId = recordId;
    }

    public Long getFkFulltextImage() {
        return this.fkFulltextImage;
    }

    public void setFkFulltextImage(Long fkFulltextImage) {
        this.fkFulltextImage = fkFulltextImage;
    }

    public void setLeader(String leader) {
        if (!this.leaderLocked) {
            this.leader = leader;
        }
    }

    public List<Field> getFields(int fieldNumber) {
        ArrayList<Field> returnFields = new ArrayList<Field>(2);
        for (Field field : this.fields) {
            if (field.getNumber() != fieldNumber) continue;
            returnFields.add(field);
        }
        return returnFields;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fond;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Record other = (Record)obj;
        if (this.fond != other.fond) {
            return false;
        }
        return this.id == other.id;
    }

    @Deprecated
    public int getStatus4() {
        if (this.isAuthority()) {
            return ((RecordStatus)RecordStatus.CODEBOOK.getById((Object)this.recordStatus)).toLegacyAuthorityStatusId();
        }
        return this.recordStatus;
    }

    @Deprecated
    public void setStatus4(int status4) {
        this.recordStatus = this.isAuthority() ? RecordStatus.NOT_DEFINED.fromLegacyAuthorityStatusId(Integer.valueOf(status4)).getId() : status4;
    }

    public String getFieldContent(int fieldNumber, String subfield) {
        for (Field f : this.fields) {
            if (f.getNumber() != fieldNumber) continue;
            if (subfield == null) {
                return f.getContent();
            }
            for (SubField sf : f.getSubfields()) {
                if (!sf.getPrefix().equals(subfield)) continue;
                return sf.getContent();
            }
        }
        return null;
    }

    public String getFieldContent(PolePodpole polePodpole) {
        return this.getFieldContent((int)polePodpole.pole(), polePodpole.podpole().isEmpty() ? null : (String)polePodpole.podpole().get());
    }

    public Field getOrCreateField(int i) {
        Field f = this.getFirstField(i);
        if (f == null) {
            f = new Field();
            f.setNumber((short)i);
            this.addField(f);
        }
        return f;
    }

    public void renumberField(Field f, short newFieldNumber) {
        f.setNumber(newFieldNumber);
    }

    public List<Field> getFieldsWithNumberStarting(String string) {
        LinkedList<Field> returnList = new LinkedList<Field>();
        for (Field f : this.fields) {
            if (!java.lang.Short.toString(f.getNumber()).startsWith(string)) continue;
            returnList.add(f);
        }
        return returnList;
    }

    public List<Field> getXXXFieldsWithNumberStarting(String string) {
        LinkedList<Field> returnList = new LinkedList<Field>();
        for (Field f : this.fields) {
            if (!java.lang.Short.toString(f.getNumber()).startsWith(string) || f.getNumber() < 100) continue;
            returnList.add(f);
        }
        return returnList;
    }

    public void removeField(Field field) {
        this.fields.remove(field);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean isFieldPresent(String ff) {
        Matcher m = p.matcher(ff);
        if (m.matches()) {
            java.lang.Short fieldNumber = java.lang.Short.parseShort(m.group(1));
            String subfield = m.group(2);
            if (this.getFirstField((int)fieldNumber.shortValue()) != null) {
                if (subfield.length() == 0) {
                    return true;
                }
                if (this.getFirstField((int)fieldNumber.shortValue()).getFirstSubfield(subfield) != null) {
                    return true;
                }
            }
        }
        return false;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public Long recordIDfrom001() {
        Field f = this.getFirstField(1);
        if (f == null) {
            return null;
        }
        String data = f.getContent();
        if (data == null || !data.startsWith(DbCache2NG.prefix001ProFond((int)this.fond))) {
            return null;
        }
        try {
            return Long.parseLong(data.substring(5));
        }
        catch (NumberFormatException nfe) {
            logger.error("selhani", (Throwable)nfe);
            return null;
        }
    }

    public Integer recordFondfrom001() {
        Field f = this.getFirstField(1);
        if (f == null) {
            return null;
        }
        String data = f.getContent();
        if (data == null || !data.startsWith(DbCache2NG.prefix001ProFond((int)this.fond))) {
            return null;
        }
        try {
            return Integer.parseInt(data.substring(3, 4));
        }
        catch (NumberFormatException nfe) {
            logger.error("selhani", (Throwable)nfe);
            return null;
        }
    }

    public String toString() {
        return "Record [fond=" + this.fond + ", recordId=" + this.recordId + ", id=" + this.id + ", fkZaz=" + this.fkZaz + ", recordStatus=" + this.recordStatus + ", nazev=" + this.nazev + ", fkUziv=" + this.fkUziv + "]";
    }

    public int getFkUziv() {
        return this.fkUziv;
    }

    public void setFkUziv(int fkUziv) {
        this.fkUziv = fkUziv;
    }

    public void fillRecIdFondFromField001() {
        Field field001 = this.getFirstField(1);
        if (field001 != null) {
            this.setFond(java.lang.Short.parseShort(field001.getContent().substring(3, 5)));
            this.setId((long)Integer.parseInt(field001.getContent().substring(5)));
        }
    }

    public String getNazev() {
        return this.nazev;
    }

    public void setNazev(String nazev) {
        this.nazev = nazev;
    }

    public int getVykon() {
        return this.vykon;
    }

    public void setVykon(int vykon) {
        this.vykon = vykon;
    }

    public String getFondId() {
        return String.format("kpw%02d%d", this.fond, this.id);
    }

    public long getFondIdAsLong() {
        return Long.parseLong(String.format("%02d%d", this.fond, this.id));
    }

    public long getFkZaz() {
        return this.fkZaz;
    }

    public void setFkZaz(long fkZaz) {
        this.fkZaz = fkZaz;
    }

    public void odstranPrazdnaPodPole(boolean marc21strict) {
        ArrayList<Field> poleKOdstraneni = new ArrayList<Field>();
        ArrayList<SubField> podpoleKOdstraneni = new ArrayList<SubField>();
        for (Field f : this.fields) {
            if (f.getNumber() > 10 && StringUtils.isBlank((CharSequence)f.getContent())) {
                podpoleKOdstraneni.clear();
                for (SubField sf : f.getSubfields()) {
                    if (!sf.hasVoidContent()) continue;
                    podpoleKOdstraneni.add(sf);
                }
                f.getSubfields().removeAll(podpoleKOdstraneni);
                continue;
            }
            if (!f.hasVoidContent() || !marc21strict) continue;
            poleKOdstraneni.add(f);
        }
        this.fields.removeAll(poleKOdstraneni);
    }

    public void initSeznamAutoritnichVazeb() {
        this.seznamAutoritnichVazeb = new HashSet();
    }

    public String getCisloNarodniAutority() {
        return this.cisloNarodniAutority;
    }

    public void setCisloNarodniAutority(String cisloNarodniAutority) {
        this.cisloNarodniAutority = cisloNarodniAutority;
    }

    public boolean jeSmazanyNeboOdstraneny() {
        return this.recordStatus == 9 || this.recordStatus == 99;
    }

    public boolean jeOdstraneny() {
        return this.recordStatus == 99;
    }

    public void setFixedFieldContent(int i, String oznaceni) {
        if (i > 10) {
            logger.error("pokus o nastaveni pole nefixni delky");
            return;
        }
        Field f = this.getFirstField(i);
        if (f == null) {
            f = new Field();
            f.setNumber((short)i);
            this.addFieldAtRightPosition(f);
        }
        f.setContent(oznaceni);
    }

    public void addFieldAtRightPosition(Field f) {
        short cisPolVkladane = f.getNumber();
        for (Field field : this.fields) {
            if (field.getNumber() <= cisPolVkladane) continue;
            this.fields.add(this.fields.indexOf(field), f);
            return;
        }
        this.fields.add(f);
    }

    public boolean isBlank(short pole, String podpole) {
        Field f = this.getFirstField((int)pole);
        if (f == null) {
            return true;
        }
        if (podpole == null) {
            return f.hasVoidContent();
        }
        SubField sf = f.getFirstSubfield(podpole);
        if (sf == null) {
            return true;
        }
        return StringUtils.isBlank((CharSequence)sf.getContent());
    }

    public Record klonuj() {
        Record r = new Record();
        r.cisloNarodniAutority = this.cisloNarodniAutority;
        r.comment = this.comment;
        r.fkZaz = this.fkZaz;
        r.fond = this.fond;
        r.id = this.id;
        r.leader = this.leader;
        r.nazev = this.nazev;
        r.seznamAutoritnichVazeb = new HashSet();
        if (this.seznamAutoritnichVazeb != null) {
            r.seznamAutoritnichVazeb.addAll(this.seznamAutoritnichVazeb);
        }
        r.recordStatus = this.recordStatus;
        r.toc = this.toc;
        r.citace = this.citace;
        r.tocPdfUrl = this.tocPdfUrl;
        r.vykon = this.vykon;
        for (Field f : this.fields) {
            Field fClone = new Field(f.number);
            fClone.ind1 = f.ind1;
            fClone.ind1 = f.ind2;
            fClone.content = f.content;
            for (SubField sf : f.subFields) {
                SubField sfClone = new SubField();
                sfClone.authLink = sf.authLink;
                sfClone.content = sf.content;
                sfClone.interpunkceZa = sf.interpunkceZa;
                sfClone.prefix = sf.prefix;
                sfClone.remapped = sf.remapped;
                sfClone.zdrojDokLink = sf.zdrojDokLink;
                fClone.subFields.add(sfClone);
            }
            r.fields.add(fClone);
        }
        return r;
    }

    public int getDbId() {
        return this.dbId;
    }

    public void setDbId(int dbId) {
        this.dbId = dbId;
    }

    public boolean obsahujeRDA264() {
        for (Field f : this.fields) {
            if (f.getNumber() != 264) continue;
            return true;
        }
        return false;
    }

    public boolean zaznamJeRDA() {
        for (Field f : this.fields) {
            if (f.getNumber() == 264) {
                return true;
            }
            if (f.getNumber() == 336) {
                return true;
            }
            if (f.getNumber() == 337) {
                return true;
            }
            if (f.getNumber() != 338) continue;
            return true;
        }
        return false;
    }

    public Date datumPosledniZmeny() {
        Field f005 = this.getFirstField(5);
        if (f005 != null) {
            String content = f005.content;
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss.S");
            try {
                if (content != null) {
                    return format.parse(content);
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return Utils.now();
    }

    public void setLeaderLocked(boolean locked) {
        this.leaderLocked = locked;
    }

    public void serializeToCache(ObjectOutputStream os) throws IOException {
        os.writeLong(this.id);
        os.writeLong(this.fkZaz);
        os.writeInt(this.fkUziv);
        os.writeInt(this.recordStatus);
        os.writeUTF(this.nazev);
        os.writeLong(this.fkFullTextSkupiny);
        os.writeUTF(this.cisloNarodniAutority);
        os.writeInt(this.fields.size());
        for (Field f : this.fields) {
            f.serializeToCache(os);
        }
    }

    public void deserializeFromCache(ObjectInputStream is) throws IOException {
        this.id = is.readLong();
        this.fkZaz = is.readLong();
        this.fkUziv = is.readInt();
        this.recordStatus = is.readInt();
        this.nazev = is.readUTF();
        this.fkFullTextSkupiny = is.readLong();
        this.cisloNarodniAutority = is.readUTF();
        int fieldsCount = is.readInt();
        for (int i = 0; i < fieldsCount; ++i) {
            Field f = new Field();
            f.deserializeFromCache(is);
        }
    }
}

