/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.marc;

import cz.kpsys.db.DbCache2;
import cz.kpsys.db.model.v2.DefFond;
import cz.kpsys.kpwin2.rest.KPWINServiceApplication;
import cz.kpsys.marc.Field;
import cz.kpsys.marc.Record;
import cz.kpsys.marc.RecordRef;
import cz.kpsys.marc.SubField;
import cz.kpsys.service.SUtils;
import cz.kpsys.service.cache.RecordIdCache;
import cz.kpsys.service.ci.CentralIndexContributorService;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.text.TextStringBuilder;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class RecordExporter {
    static final Logger logger = LoggerFactory.getLogger(RecordExporter.class);
    public static final String xmlHeaderEnvelope = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<collection xmlns=\"http://www.loc.gov/MARC21/slim\">\n";
    static final String xmlHeader = "\t<record status=\"#STATUS4#\" record_status=\"#RECORD_STATUS_ID#\" id=\"#ID#\" fond=\"#FOND#\" record_id=\"#RECORD_ID#\" #DB_ID# >\n";
    static final String xmlFooter = "\t</record>\n";
    public static final String xmlFooterEnvelope = "</collection>\n";
    static final String leaderMask = "\t\t<leader>%s</leader>\n";
    static final String controlFieldMask = "\t\t<controlfield tag=\"%03d\">%s</controlfield>\n";
    static final String dataFieldMask = "\t\t<datafield tag=\"%03d\" ind1=\"%s\" ind2=\"%s\"%s>\n%s\t\t</datafield>\n";
    static final String subfieldMask = "\t\t\t<subfield code=\"%s\"%s>%s</subfield>\n";
    static final String tocMask = "\t\t<toc %s>\n%s\t\t</toc>\n";
    static final String citaceMask = "\t\t<citation %s>\n%s\t\t</citation>\n";
    final boolean marc21strict;
    boolean outputFieldsHigherThan999 = false;
    boolean removeSvislitka = true;
    String lineMarcPrefixMark = "$";

    public RecordExporter() {
        this.marc21strict = KPWINServiceApplication.configuration.marc21strict;
    }

    public static List<Field> sortFields(List<Field> fields) {
        Field[] fieldsArray = fields.toArray(new Field[0]);
        Arrays.sort(fieldsArray, new /* Unavailable Anonymous Inner Class!! */);
        return Arrays.asList(fieldsArray);
    }

    public static String generateLeader(Record r) {
        StringBuilder sb = new StringBuilder("-----");
        if (r.getStatus4() > 4) {
            sb.append("c");
        } else {
            sb.append("n");
        }
        String oznaceniRda = r.zaznamJeRDA() ? "-i" : "-a";
        short fond = r.getFond();
        if (DbCache2.jeDokFond((short)fond)) {
            DefFond dokFond = (DefFond)DbCache2.defDokFondMap.get(fond);
            if (dokFond != null) {
                sb.append(dokFond.getTYP_ZAZ());
                sb.append(dokFond.getBIB_UROV());
            } else {
                sb.append("am");
            }
            sb.append("-a22-----" + oznaceniRda + "-4500");
        } else {
            sb.append("am-a22-----" + oznaceniRda + "-4500");
        }
        return sb.toString();
    }

    public String lineMARC21(Record rec, boolean sortBeforeExport) {
        StringBuilder sb = new StringBuilder();
        if (rec.getLeader() != null) {
            sb.append(rec.getLeader()).append("\n");
        }
        List fields = sortBeforeExport ? RecordExporter.sortFields((List)rec.getFields()) : rec.getFields();
        for (Field field : fields) {
            if (!this.outputFieldsHigherThan999 && field.getNumber() > 999) break;
            String indikatory = field.getIndikatory();
            if (this.marc21strict) {
                if (field.getNumber() < 10) {
                    String content;
                    String string = content = field.getContent() == null ? "" : field.getContent();
                    if (field.getNumber() != 8 && this.removeSvislitka) {
                        content = content.replace("|", "");
                    }
                    sb.append(String.format("%03d %s %s", field.getNumber(), indikatory, field.getContent()));
                } else {
                    sb.append(String.format("%03d %s %s", field.getNumber(), indikatory, field.getDollarFormattedSubfieldContent(this.marc21strict)));
                }
            } else {
                sb.append(String.format("%03d %s %s", field.getNumber(), indikatory, field.getDollarFormattedSubfieldContent(this.marc21strict)));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public String lineMARC21(Record rec) {
        return this.lineMARC21(rec, false);
    }

    public String marcXml(Record rec, boolean sortBeforeExport) {
        if (sortBeforeExport) {
            List fields = RecordExporter.sortFields((List)rec.getFields());
            rec.getFields().clear();
            rec.getFields().addAll(fields);
        }
        return this.marcXml(rec);
    }

    public String marcXml(Record rec) {
        return this.marcXmlEnvelope(rec, true, true);
    }

    public String marcXmlEnvelope(@NotNull Record rec, boolean generateEnvelope, boolean generateLeader) {
        String tocValidXML;
        if (generateLeader) {
            rec.setLeader(RecordExporter.generateLeader((Record)rec));
        }
        String header = generateEnvelope ? "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<collection xmlns=\"http://www.loc.gov/MARC21/slim\">\n\t<record status=\"#STATUS4#\" record_status=\"#RECORD_STATUS_ID#\" id=\"#ID#\" fond=\"#FOND#\" record_id=\"#RECORD_ID#\" #DB_ID# >\n" : "\t<record status=\"#STATUS4#\" record_status=\"#RECORD_STATUS_ID#\" id=\"#ID#\" fond=\"#FOND#\" record_id=\"#RECORD_ID#\" #DB_ID# >\n";
        StringBuilder sb = new StringBuilder(header.replace("#STATUS4#", Integer.toString(rec.getStatus4())).replace("#RECORD_STATUS_ID#", Integer.toString(rec.getRecordStatus())).replace("#ID#", Long.toString(rec.getId())).replace("#RECORD_ID#", StringUtils.defaultIfBlank((CharSequence)rec.recordId, (CharSequence)SUtils.uuid())).replace("#FOND#", Integer.toString(rec.getFond())));
        String leader = rec.getLeader();
        if (StringUtils.isNotBlank((CharSequence)leader)) {
            sb.append(String.format("\t\t<leader>%s</leader>\n", leader));
        }
        for (Field field : rec.getFields()) {
            if (!this.outputFieldsHigherThan999 && field.getNumber() > 999) break;
            String indikatory = field.getIndikatory();
            if (this.marc21strict) {
                if (field.getNumber() < 10) {
                    String content;
                    String string = content = field.getContent() == null ? "" : field.getContent();
                    if (field.getNumber() != 8 && this.removeSvislitka) {
                        content = content.replace("|", "").replaceAll("\\p{C}", "?");
                    }
                    try {
                        sb.append(String.format("\t\t<controlfield tag=\"%03d\">%s</controlfield>\n", field.getNumber(), this.escapeXMLSimple(field.getContent())));
                    }
                    catch (Exception e) {
                        logger.error("problem pri exportu pole " + field + " zaznam c. " + rec.getId());
                    }
                    continue;
                }
                if (!field.isVisible(this.marc21strict)) continue;
                StringBuilder another = new StringBuilder();
                if (StringUtils.isNotBlank((CharSequence)field.getIdZazZdroj())) {
                    another.append(" id_zaz_zdroj=\"" + field.getIdZazZdroj() + "\"");
                }
                sb.append(String.format("\t\t<datafield tag=\"%03d\" ind1=\"%s\" ind2=\"%s\"%s>\n%s\t\t</datafield>\n", field.getNumber(), Character.valueOf(field.getInd1()), Character.valueOf(field.getInd2()), another.toString(), this.subfieldsToXml(field)));
                continue;
            }
            if (!field.isVisible(this.marc21strict)) continue;
            sb.append(String.format("\t\t<datafield tag=\"%03d\" ind1=\"%s\" ind2=\"%s\"%s>\n%s\t\t</datafield>\n", field.getNumber(), Character.valueOf(field.getInd1()), Character.valueOf(field.getInd2()), "", this.subfieldsToXml(field)));
        }
        if (rec.toc != null && StringUtils.isNotBlank((CharSequence)(tocValidXML = StringEscapeUtils.escapeXml10((String)rec.toc))) && StringUtils.isNotBlank((CharSequence)rec.tocPdfUrl)) {
            Object tocPdfUrlAttr = StringUtils.isNotBlank((CharSequence)rec.tocPdfUrl) ? "pdf=\"" + StringEscapeUtils.escapeXml10((String)rec.tocPdfUrl) + "\"" : "";
            sb.append(String.format("\t\t<toc %s>\n%s\t\t</toc>\n", tocPdfUrlAttr, tocValidXML));
        }
        if (StringUtils.isNotBlank((CharSequence)rec.citace)) {
            String citaceValidXML = StringEscapeUtils.escapeXml10((String)rec.citace);
            sb.append(String.format("\t\t<citation %s>\n%s\t\t</citation>\n", "norm='ISO690'", citaceValidXML));
        }
        sb.append(generateEnvelope ? "\t</record>\n</collection>\n" : "\t</record>\n");
        String retVal = sb.toString();
        if (rec.getDbId() > 0) {
            int dbId = rec.getDbId();
            String crc = CentralIndexContributorService.computeCRC((long)rec.getId(), (int)dbId);
            retVal = retVal.replace("#DB_ID#", "db_id=\"" + Integer.toString(dbId) + "\" crc=\"" + crc + "\"");
        } else {
            retVal = retVal.replace("#DB_ID#", "");
        }
        return retVal;
    }

    private String escapeXMLSimple(String input) {
        return input.replace("&", "&amp;").replace("<", "&lt;").replace("\n", "&#10;").replace("\r", "&#13;").replace(">", "&gt;").replaceAll("\\p{C}", "?");
    }

    private String subfieldsToXml(Field field) {
        TextStringBuilder sb = new TextStringBuilder(512);
        for (SubField sf : field.getSubfields()) {
            if (!sf.isVisible()) continue;
            String content = this.escapeXMLSimple(this.removeSvislitka ? sf.getContent().replace("|", "") : sf.getContent());
            TextStringBuilder others = new TextStringBuilder(128);
            if (sf.authLink != 0L) {
                others.append(" id=\"" + sf.authLink + "\"");
                RecordRef recordRef = RecordIdCache.getByCisZazAut((long)sf.getAuthLinkID(), (boolean)true);
                others.append(" record_id=\"" + (String)StringUtils.defaultIfBlank((CharSequence)recordRef.recordId(), (CharSequence)SUtils.uuid()) + "\"");
            }
            if (sf.getInterpunkceZa() != null) {
                others.append(" interpunkce_za=\"" + this.escapeXMLSimple(sf.getInterpunkceZa()) + "\"");
            }
            sb.append(String.format("\t\t\t<subfield code=\"%s\"%s>%s</subfield>\n", sf.getPrefix(), others.toString(), content));
        }
        return sb.toString();
    }

    public boolean isOutputFieldsHigherThan999() {
        return this.outputFieldsHigherThan999;
    }

    public void setOutputFieldsHigherThan999(boolean outputFieldsHigherThan999) {
        this.outputFieldsHigherThan999 = outputFieldsHigherThan999;
    }
}

