/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.service;

import cz.kpsys.db.ProxoolUtil;
import cz.kpsys.service.KPUtils;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;

public class ConnectionCheckerService {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionCheckerService.class);
    private static final ConnectionCheckerService instance = new ConnectionCheckerService();
    public volatile boolean serviceAvailable = false;
    private DataSource dataSource;

    public static ConnectionCheckerService getInstance() {
        return instance;
    }

    public void setParams(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Scheduled(initialDelay=1000L, fixedDelay=10000L)
    public synchronized void updateConnectivityState() {
        try {
            Connection conn = ProxoolUtil.obtainConnection((DataSource)this.dataSource, (boolean)false);
            if (conn != null) {
                conn.rollback();
                conn.close();
            }
            if (!this.serviceAvailable) {
                logger.warn("navazano spojeni s DB");
            }
            this.serviceAvailable = true;
        }
        catch (SQLException e) {
            if (this.serviceAvailable) {
                logger.warn("ConnectionCheckerService - ztraceno spojeni s DB");
            }
            this.serviceAvailable = false;
        }
    }

    public void waitForDbOnline() {
        while (!this.serviceAvailable && !Thread.currentThread().isInterrupted()) {
            KPUtils.sleep((int)500);
            this.updateConnectivityState();
        }
    }

    public boolean isServiceAvailable() {
        return this.serviceAvailable;
    }
}

