/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.service;

import cz.kpsys.service.ExitConstants$;
import cz.kpsys.service.KPUtils$;
import java.io.IOException;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction1;

/*
 * Exception performing whole class analysis ignored.
 */
public final class PerfMon$ {
    public static PerfMon$ MODULE$;
    private final Logger logger;
    private volatile double lastLoadAvg;
    private long lastCpuTimeMillis;
    private long lastPollTimeMillis;
    private int tickCounter;
    private int watchdogCounter;

    static {
        new PerfMon$();
    }

    public Logger logger() {
        return this.logger;
    }

    public double lastLoadAvg() {
        return this.lastLoadAvg;
    }

    public void lastLoadAvg_$eq(double x$1) {
        this.lastLoadAvg = x$1;
    }

    private long lastCpuTimeMillis() {
        return this.lastCpuTimeMillis;
    }

    private void lastCpuTimeMillis_$eq(long x$1) {
        this.lastCpuTimeMillis = x$1;
    }

    private long lastPollTimeMillis() {
        return this.lastPollTimeMillis;
    }

    private void lastPollTimeMillis_$eq(long x$1) {
        this.lastPollTimeMillis = x$1;
    }

    private int tickCounter() {
        return this.tickCounter;
    }

    private void tickCounter_$eq(int x$1) {
        this.tickCounter = x$1;
    }

    private int watchdogCounter() {
        return this.watchdogCounter;
    }

    private void watchdogCounter_$eq(int x$1) {
        this.watchdogCounter = x$1;
    }

    public void init() {
        this.logger().info("inicializace systemu pro monitoring vykonu");
        ThreadMXBean mxBean = ManagementFactory.getThreadMXBean();
        Timer perfMonTimer = new Timer("performance monitoring", true);
        int DELAY = 20000;
        perfMonTimer.schedule((TimerTask)new /* Unavailable Anonymous Inner Class!! */, DELAY, (long)DELAY);
    }

    private static final String loadMessage$1(double loadAvg) {
        double arg$macro$1 = loadAvg;
        return new StringOps("load %1.3f").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$1)}));
    }

    public final void cz$kpsys$service$PerfMon$$checkLoadAverage$1(int DELAY$1, ThreadMXBean mxBean$1) {
        long now = System.currentTimeMillis();
        long currentCpuMillis = PerfMon$.getTotalCpuTimeMillis$1((ThreadMXBean)mxBean$1);
        double loadAvg = this.calcLoadAveragePercentage$1(now, currentCpuMillis);
        this.lastLoadAvg_$eq(loadAvg);
        if (loadAvg > 0.5 || this.tickCounter() % (5 * (60000 / DELAY$1)) == 0) {
            this.logger().warn(PerfMon$.loadMessage$1((double)loadAvg));
        }
        if (loadAvg > (double)2) {
            try {
                this.watchdogCounter_$eq(this.watchdogCounter() + 1);
                String threadDump = PerfMon$.crunchifyGenerateThreadDump$1();
                this.logger().error(new StringBuilder(15).append("perfmon alert ").append(PerfMon$.loadMessage$1((double)loadAvg)).append("\n").append(threadDump).toString());
                if (this.watchdogCounter() > 60 * (60000 / DELAY$1)) {
                    this.logger().error("prilis dlouha doba vysoke zateze CPU, restartuji AS");
                    KPUtils$.MODULE$.sleep(5000);
                    System.exit(ExitConstants$.MODULE$.TOO_HIGH_LOAD());
                }
            }
            catch (IOException e) {
                this.logger().warn("selhani", (Throwable)e);
            }
        } else {
            this.watchdogCounter_$eq(0);
        }
        this.tickCounter_$eq(this.tickCounter() + 1);
        this.lastCpuTimeMillis_$eq(currentCpuMillis);
        this.lastPollTimeMillis_$eq(now);
    }

    private static final long getTotalCpuTimeMillis$1(ThreadMXBean mxBean$1) {
        LongRef total = LongRef.create((long)0L);
        new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(mxBean$1.getAllThreadIds())).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)id -> {
            long cpuTime = mxBean$1.getThreadCpuTime(id);
            if (cpuTime > 0L) {
                total$1.elem += cpuTime;
                return;
            }
        });
        long currentCpuMillis = total.elem / 1000000L;
        return currentCpuMillis;
    }

    private final double calcLoadAveragePercentage$1(long now, long currentCpuMillis) {
        long timeDiff = now - this.lastPollTimeMillis();
        if (timeDiff == 0L) {
            timeDiff = 1L;
        }
        long cpuDiff = currentCpuMillis - this.lastCpuTimeMillis();
        double loadAvg = (double)cpuDiff / (double)timeDiff;
        return loadAvg;
    }

    public static final /* synthetic */ long $anonfun$init$2(ThreadMXBean threadMXBean$1, ThreadInfo x) {
        return -threadMXBean$1.getThreadCpuTime(x.getThreadId());
    }

    private static final String crunchifyGenerateThreadDump$1() {
        scala.collection.mutable.StringBuilder dump = new scala.collection.mutable.StringBuilder();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] threadInfosUnsorted = threadMXBean.getThreadInfo(threadMXBean.getAllThreadIds(), 30);
        ThreadInfo[] threadInfos = (ThreadInfo[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])threadInfosUnsorted)).sortBy((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToLong((long)PerfMon$.$anonfun$init$2((ThreadMXBean)threadMXBean, (ThreadInfo)x)), (Ordering)Ordering.Long$.MODULE$))).take(5);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])threadInfos)).foreach((Function1 & Serializable & scala.Serializable)threadInfo -> {
            dump.append('\"');
            dump.append(threadInfo.getThreadName());
            dump.append(new StringBuilder(11).append("\" cpu time ").append(threadMXBean.getThreadCpuTime(threadInfo.getThreadId()) / 1000000L).toString());
            Thread.State state = threadInfo.getThreadState();
            dump.append("\n   State: ");
            dump.append((Object)state);
            StackTraceElement[] stackTraceElements = threadInfo.getStackTrace();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stackTraceElements)).foreach((Function1 & Serializable & scala.Serializable)stackTraceElement -> {
                dump.append("\n        at ");
                return dump.append(stackTraceElement);
            });
            return dump.append("\n\n");
        });
        return dump.toString();
    }

    private PerfMon$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((Class)this.getClass());
        this.lastLoadAvg = 0.0;
        this.lastCpuTimeMillis = 0L;
        this.lastPollTimeMillis = 0L;
        this.tickCounter = 0;
        this.watchdogCounter = 0;
    }
}

