/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.service;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReloadableClassLoader
extends ClassLoader {
    public static final Logger logger = LoggerFactory.getLogger(ReloadableClassLoader.class);

    public ReloadableClassLoader(ClassLoader parent) {
        super(parent);
    }

    public Class loadClass(String classId, String url) throws ClassNotFoundException {
        try {
            URL classURL = new URL(url);
            URLConnection connection = classURL.openConnection();
            InputStream input = connection.getInputStream();
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)input, (OutputStream)buffer);
            byte[] classData = buffer.toByteArray();
            return this.defineClass(classId, classData, 0, classData.length);
        }
        catch (IOException e) {
            logger.error("nepodarilo se nacist tridu", (Throwable)e);
            return null;
        }
    }
}

