/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.databeans;

import java.util.Hashtable;
import java.util.Random;
import org.jafer.databeans.DatabeanManager;
import org.jafer.interfaces.Databean;
import org.jafer.interfaces.DatabeanFactory;

public class DatabeanManagerFactory
extends DatabeanFactory {
    public static final String MODE_SERIAL = "serial";
    public static final String MODE_PARALLEL = "parallel";
    private Hashtable databeanFactories = new Hashtable();
    private String mode = "parallel";
    private String[] allDatabases;

    public Databean getDatabean() {
        DatabeanManager bean = new DatabeanManager();
        bean.setDatabeanFactories(this.databeanFactories);
        bean.setMode(this.mode);
        bean.setName(this.getName());
        bean.setAllDatabases(this.allDatabases);
        bean.setDatabases(this.getName());
        return bean;
    }

    public void setDatabeanFactories(DatabeanFactory[] databeanFactories) {
        this.databeanFactories.clear();
        this.allDatabases = new String[databeanFactories.length];
        Random rnd = new Random();
        for (int n = 0; n < databeanFactories.length; ++n) {
            Object name = databeanFactories[n].getName();
            if (name == null) {
                name = "DB" + Integer.toHexString(rnd.nextInt());
            }
            this.databeanFactories.put(name, databeanFactories[n]);
            this.allDatabases[n] = name;
        }
    }

    public DatabeanFactory[] getDatabeanFactories() {
        return this.databeanFactories.values().toArray(new DatabeanFactory[this.databeanFactories.size()]);
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getMode() {
        return this.mode;
    }
}

