/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.query;

import java.util.StringTokenizer;
import java.util.Vector;
import org.jafer.conf.Config;
import org.jafer.exception.JaferException;
import org.jafer.query.QueryException;
import org.jafer.query.QueryParser;
import org.jafer.util.xml.DOMFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class QueryBuilder
implements org.jafer.interfaces.QueryBuilder {
    private final Document document;
    int[] defaultAttributes = new int[]{1003, 1, 1, 1, 1, 1};
    boolean dummyNodePresent = false;

    public QueryBuilder() {
        this.document = DOMFactory.newDocument();
    }

    public QueryBuilder(String searchProfile) {
        this.defaultAttributes = Config.convertSyntax((String)searchProfile);
        this.document = DOMFactory.newDocument();
    }

    public Node getNode(String useAttribute, String term) throws QueryException {
        return this.getNode(this.lookUpUseAttribute(useAttribute), term);
    }

    public Node getNode(int useAttribute, String term) throws QueryException {
        if (useAttribute > 63 && useAttribute < 1000 || useAttribute > 1036) {
            throw new QueryException("int parameter out of range: " + useAttribute);
        }
        int[] attributes = new int[]{useAttribute};
        return this.getNode(attributes, term);
    }

    public Node getNode(int[] attributes, String term) throws QueryException {
        if (term == null || term.equals("")) {
            throw new QueryException("Query term supplied is either empty or null");
        }
        if (this.defaultAttributes.length < 1 || this.defaultAttributes.length > 6) {
            throw new QueryException("Invalid setting found for default attribute array.");
        }
        int[] modifiedArray = new int[this.defaultAttributes.length + 1];
        System.arraycopy(this.defaultAttributes, 0, modifiedArray, 1, this.defaultAttributes.length);
        for (int i = 0; i < attributes.length; ++i) {
            modifiedArray[i + 1] = attributes[i];
        }
        return this.buildConstraintModelNode(modifiedArray, term);
    }

    public Node getNode(int[][] attTypesValues, String term) throws QueryException {
        if (term == null || term.equals("")) {
            throw new QueryException("Query term supplied is either empty or null");
        }
        if (attTypesValues.length < 1 || attTypesValues.length > 6) {
            throw new QueryException("Attributes array too long/short.");
        }
        if (attTypesValues[0].length < 2 || attTypesValues[0][1] == 0) {
            throw new QueryException("Attributes incorrectly set.");
        }
        int[] modifiedArray = new int[this.defaultAttributes.length + 1];
        System.arraycopy(this.defaultAttributes, 0, modifiedArray, 1, this.defaultAttributes.length);
        for (int i = 0; i < attTypesValues.length; ++i) {
            modifiedArray[attTypesValues[i][0]] = attTypesValues[i][1];
        }
        return this.buildConstraintModelNode(modifiedArray, term);
    }

    private Node buildConstraintModelNode(int[] attributes, String term) throws QueryException {
        Element constraintModel = this.document.createElement("constraintModel");
        Node constraint = constraintModel.appendChild(this.document.createElement("constraint"));
        Node n = constraintModel.appendChild(this.document.createElement("model"));
        n.appendChild(this.document.createTextNode(term));
        if (attributes[1] < 1) {
            throw new QueryException("Use (or equivalent) attribute has not been set.");
        }
        for (int i = 1; i < attributes.length; ++i) {
            if (attributes[i] <= 0) continue;
            try {
                n = constraint.appendChild(this.document.createElement(Config.getAttributeType((int)i)));
            }
            catch (JaferException e) {
                throw new QueryException("Attribute not found", (Throwable)e);
            }
            n.appendChild(this.document.createTextNode(Integer.toString(attributes[i])));
        }
        return constraintModel;
    }

    public Node and(Node leftNode, Node rightNode) throws QueryException {
        Element n = this.document.createElement("and");
        if (leftNode != null && rightNode != null) {
            n.appendChild(leftNode);
            n.appendChild(rightNode);
            return n;
        }
        throw new QueryException("Node being used in building the query is null.");
    }

    public Node and(Vector useAttributes, Vector terms) throws QueryException {
        Node currentNode = null;
        if (useAttributes.size() == terms.size() && useAttributes.size() > 1) {
            Node right;
            for (int i = 1; i < useAttributes.size(); i += 2) {
                Node left = this.getNode(useAttributes.get(i - 1).toString(), terms.get(i - 1).toString());
                right = this.getNode(useAttributes.get(i).toString(), terms.get(i).toString());
                currentNode = currentNode != null ? this.and(currentNode, this.and(left, right)) : this.and(left, right);
            }
            if (useAttributes.size() % 2 == 1) {
                int j = useAttributes.size() - 1;
                right = this.getNode(useAttributes.get(j).toString(), terms.get(j).toString());
                currentNode = this.and(currentNode, right);
            }
            return currentNode;
        }
        throw new QueryException("input vector problem...");
    }

    public Node or(Node leftNode, Node rightNode) throws QueryException {
        Element n = this.document.createElement("or");
        if (leftNode != null && rightNode != null) {
            n.appendChild(leftNode);
            n.appendChild(rightNode);
            return n;
        }
        throw new QueryException("Node being used in building the query is null.");
    }

    public Node or(Vector useAttributes, Vector terms) throws QueryException {
        Node currentNode = null;
        if (useAttributes.size() == terms.size() && useAttributes.size() > 1) {
            Node right;
            for (int i = 1; i < useAttributes.size(); i += 2) {
                Node left = this.getNode(useAttributes.get(i - 1).toString(), terms.get(i - 1).toString());
                right = this.getNode(useAttributes.get(i).toString(), terms.get(i).toString());
                currentNode = currentNode != null ? this.or(currentNode, this.or(left, right)) : this.or(left, right);
            }
            if (useAttributes.size() % 2 == 1) {
                int j = useAttributes.size() - 1;
                right = this.getNode(useAttributes.get(j).toString(), terms.get(j).toString());
                currentNode = this.or(currentNode, right);
            }
            return currentNode;
        }
        throw new QueryException("input vector problem...");
    }

    public Node not(Node inputNode) throws QueryException {
        Element n = this.document.createElement("not");
        if (inputNode != null) {
            n.appendChild(inputNode);
            return n;
        }
        throw new QueryException("Node being used in building the query is null.");
    }

    public Node parse(Node queryNode) throws QueryException {
        QueryParser parser = new QueryParser(this, queryNode.getOwnerDocument());
        return parser.parseQuery(queryNode);
    }

    public boolean isDummyNodePresent() {
        return this.dummyNodePresent;
    }

    public Node getNode(String queryExp) throws QueryException {
        if (queryExp != null && queryExp.length() > 0) {
            StringTokenizer st = new StringTokenizer(queryExp, "= ", true);
            String attribute = null;
            String op = null;
            boolean isAttribute = true;
            boolean isTerm = false;
            Node node = null;
            while (st.hasMoreTokens()) {
                try {
                    String s = st.nextToken().trim();
                    if (s.length() <= 0) continue;
                    if (s.equals("=")) {
                        isTerm = true;
                        continue;
                    }
                    if (isTerm) {
                        isTerm = false;
                        if (node == null) {
                            if (op == null) {
                                node = this.getNode(attribute, s);
                                continue;
                            }
                            if (!op.equalsIgnoreCase("not")) continue;
                            node = this.not(this.getNode(attribute, s));
                            continue;
                        }
                        if (op.equalsIgnoreCase("and")) {
                            node = this.and(node, this.getNode(attribute, s));
                            continue;
                        }
                        if (op.equalsIgnoreCase("or")) {
                            node = this.or(node, this.getNode(attribute, s));
                            continue;
                        }
                        if (op.equalsIgnoreCase("not")) {
                            node = this.and(node, this.not(this.getNode(attribute, s)));
                            continue;
                        }
                        if (op.equalsIgnoreCase("andNot")) {
                            node = this.and(node, this.not(this.getNode(attribute, s)));
                            continue;
                        }
                        if (!op.equalsIgnoreCase("orNot")) continue;
                        node = this.or(node, this.not(this.getNode(attribute, s)));
                        continue;
                    }
                    if (s.equalsIgnoreCase("and") || s.equalsIgnoreCase("or") || s.equalsIgnoreCase("not") || s.equalsIgnoreCase("andNot") || s.equalsIgnoreCase("orNot")) {
                        isAttribute = true;
                        op = s;
                        continue;
                    }
                    if (isAttribute) {
                        isAttribute = false;
                        attribute = s;
                        continue;
                    }
                    throw new QueryException();
                }
                catch (Exception e) {
                    throw new QueryException("Cannot parse query expression; " + e.toString(), (Throwable)e);
                }
            }
            if (node == null) {
                throw new QueryException("Cannot parse query expression");
            }
            return node;
        }
        throw new QueryException("Null or empty query expression");
    }

    private int lookUpUseAttribute(String attributeString) throws QueryException {
        int attributeInt = 0;
        try {
            attributeInt = Integer.parseInt(attributeString);
        }
        catch (IllegalArgumentException e) {
            String attributeName;
            String attributeSet;
            int i = attributeString.indexOf(46);
            if (i > 0) {
                attributeSet = attributeString.substring(0, i);
                attributeName = attributeString.substring(i + 1);
            } else {
                attributeSet = Config.getAttributeSetName();
                attributeName = attributeString;
            }
            attributeInt = Config.getAttributeValue((String)attributeSet, (String)"semantic", (String)attributeName);
        }
        return attributeInt;
    }
}

