/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.record;

import java.util.Hashtable;
import java.util.TreeMap;
import org.jafer.exception.JaferException;
import org.jafer.record.DataObject;
import org.jafer.record.RecordFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Cache {
    private Hashtable dataCache;
    private Hashtable xmlCache;
    private Hashtable berCache;
    private TreeMap dataTimeStamp;
    private int dataCacheSize;
    private RecordFactory recordFactory;
    private static Logger logger;
    public double clear = 0.2;

    public Cache(RecordFactory recordFactory, int dataCacheSize) {
        this.dataCacheSize = dataCacheSize;
        this.recordFactory = recordFactory;
        this.dataCache = new Hashtable((int)((double)dataCacheSize * 0.5));
        this.dataTimeStamp = new TreeMap();
        this.xmlCache = new Hashtable();
        this.berCache = new Hashtable();
        logger = LoggerFactory.getLogger((String)"org.jafer.zclient");
    }

    public Object getBER(Document document, String schema, Integer recNo) throws JaferException {
        if (this.contains(recNo)) {
            if (!this.berCache.containsKey(recNo)) {
                DataObject dataObject = (DataObject)this.dataCache.get(recNo);
                Object ber = this.recordFactory.getBER(dataObject, document, recNo.intValue());
                this.berCache.put(recNo, ber);
            }
            return this.berCache.get(recNo);
        }
        String message = "Cache, Record (BER) not found - record number: " + recNo;
        JaferException exception = new JaferException(message);
        logger.warn(message, (Throwable)exception);
        throw exception;
    }

    public Node getXML(Document document, String targetSchema, Integer recNo) throws JaferException {
        if (this.contains(recNo)) {
            if (!this.xmlCache.containsKey(recNo)) {
                DataObject dataObject = (DataObject)this.dataCache.get(recNo);
                Node recordRoot = (Node)this.recordFactory.getXML(dataObject, document, targetSchema, recNo.intValue());
                recordRoot.normalize();
                this.xmlCache.put(recNo, recordRoot);
            }
            return ((Node)this.xmlCache.get(recNo)).cloneNode(true);
        }
        String message = "Cache, Record (XML) not found - record number: " + recNo;
        JaferException exception = new JaferException(message);
        logger.warn(message, (Throwable)exception);
        throw exception;
    }

    public DataObject getDataObject(Integer recNo) throws JaferException {
        if (this.dataCache.containsKey(recNo)) {
            return (DataObject)this.dataCache.get(recNo);
        }
        String message = "Cache, DataObject not found - record number: " + recNo;
        JaferException exception = new JaferException(message);
        logger.warn(message, (Throwable)exception);
        throw exception;
    }

    public boolean contains(Integer recNo) {
        if (recNo == null) {
            return false;
        }
        return this.dataCache.containsKey(recNo);
    }

    public void put(Integer recNo, DataObject dataObject) {
        if (!this.contains(recNo)) {
            this.checkCacheSize(this.dataCacheSize);
            this.dataTimeStamp.put(new Long(System.currentTimeMillis() + recNo.longValue()), recNo);
            this.dataCache.put(recNo, dataObject);
        }
    }

    private void checkCacheSize(int size) {
        if (this.dataCache.size() + 1 > size) {
            int i = 0;
            while ((double)i < (double)size * this.clear) {
                Integer recNo = (Integer)this.dataTimeStamp.remove(this.dataTimeStamp.firstKey());
                this.dataCache.remove(recNo);
                this.xmlCache.remove(recNo);
                this.berCache.remove(recNo);
                ++i;
            }
        }
    }

    public void clear() {
        if (this.dataCache != null) {
            this.dataCache.clear();
        }
        if (this.dataTimeStamp != null) {
            this.dataTimeStamp.clear();
        }
        if (this.xmlCache != null) {
            this.xmlCache.clear();
        }
        if (this.berCache != null) {
            this.berCache.clear();
        }
    }
}

