/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.record;

import asn1.ASN1Boolean;
import asn1.ASN1Exception;
import asn1.ASN1External;
import asn1.ASN1GeneralString;
import asn1.ASN1GeneralizedTime;
import asn1.ASN1Integer;
import asn1.ASN1ObjectIdentifier;
import asn1.BEREncoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.jafer.conf.Config;
import org.jafer.record.DataObject;
import org.jafer.record.RecordException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import z3950.RS_generic.ElementData;
import z3950.RS_generic.GenericRecord;
import z3950.RS_generic.TaggedElement;
import z3950.v3.IntUnit;
import z3950.v3.InternationalString;
import z3950.v3.StringOrNumeric;

public class GRS1Record
extends DataObject {
    private Node root;
    private BEREncoding ber;
    private String dbName;

    public GRS1Record(String dbName, BEREncoding ber) {
        super(dbName, ber);
        this.ber = ber;
    }

    public GRS1Record(String dbName, Node root) {
        super(dbName, root);
        this.root = root.getFirstChild();
    }

    public BEREncoding getBER() throws RecordException {
        if (this.ber != null) {
            return this.ber;
        }
        if (this.root == null) {
            return null;
        }
        GenericRecord record = new GenericRecord();
        try {
            record.value = this.processElement(this.root.getChildNodes());
            ASN1External asn1External = new ASN1External();
            asn1External.c_singleASN1type = record;
            asn1External.s_direct_reference = new ASN1ObjectIdentifier(super.getRecordSyntax());
            this.ber = asn1External.ber_encode();
        }
        catch (ASN1Exception e) {
            String message = "ASN1Exception processing GRS1Record; " + e.toString();
            throw new RecordException(message, (Throwable)e);
        }
        catch (NullPointerException e) {
            String message = "NullPointerException processing GRS1Record; " + e.toString();
            throw new RecordException(message, (Throwable)e);
        }
        catch (StringIndexOutOfBoundsException e) {
            String message = "StringIndexOutOfBoundsException processing GRS1Record; " + e.toString();
            throw new RecordException(message, (Throwable)e);
        }
        return this.ber;
    }

    private TaggedElement[] processElement(NodeList list) throws NullPointerException, StringIndexOutOfBoundsException {
        TaggedElement[] taggedElements = new TaggedElement[list.getLength()];
        for (int i = 0; i < list.getLength(); ++i) {
            Element e = (Element)list.item(i);
            String tagName = e.getTagName();
            int last = tagName.lastIndexOf("_", tagName.length() - 1);
            String tagType = tagName.substring(tagName.lastIndexOf("_", last - 1) + 1, last);
            String tagValue = tagName.substring(last + 1);
            String contentType = e.getAttribute("type");
            String content = Config.getValue((Node)e);
            TaggedElement taggedElement = new TaggedElement();
            taggedElement.s_tagType = this.getASN1Integer(tagType);
            taggedElement.s_tagValue = this.getStringOrNumeric(tagValue);
            taggedElement.s_content = this.getElementData(contentType, content);
            if (e.hasChildNodes() && e.getFirstChild().getNodeType() != 3) {
                taggedElement.s_content.c_subtree = this.processElement(e.getChildNodes());
            }
            taggedElements[i] = taggedElement;
        }
        return taggedElements;
    }

    public Node getXML(Document document) throws RecordException {
        if (document == null) {
            return null;
        }
        if (this.root != null) {
            if (document.equals(this.root.getOwnerDocument())) {
                return this.root;
            }
            return document.importNode(this.root, true);
        }
        if (this.ber == null) {
            return null;
        }
        ASN1External asn1External = null;
        try {
            asn1External = new ASN1External(this.getBER(), true);
            GenericRecord record = new GenericRecord(asn1External.c_singleASN1type.ber_encode(), true);
            this.root = document.createElement("GRS1Record");
            this.processElement(record.value, this.root, document);
        }
        catch (ASN1Exception e) {
            String message = "ASN1Exception processing GRS1Record; " + e.toString();
            throw new RecordException(message, (Throwable)e);
        }
        catch (NullPointerException e) {
            String message = "NullPointerException processing GRS1Record; " + e.toString();
            throw new RecordException(message, (Throwable)e);
        }
        catch (IOException e) {
            String message = "IOException processing GRS1Record; " + e.toString();
            throw new RecordException(message, (Throwable)e);
        }
        return this.root;
    }

    private void processElement(TaggedElement[] t, Node x, Document d) throws IOException {
        for (int n = 0; n < t.length; ++n) {
            String parentTagName = "";
            if (!((Element)x).getTagName().equalsIgnoreCase("GRS1Record")) {
                parentTagName = ((Element)x).getTagName();
            }
            Element e = d.createElement(parentTagName + "_" + this.getTag(t[n].s_tagType) + "_" + this.getTag(t[n].s_tagValue));
            if (t[n].s_content.c_subtree != null) {
                this.processElement(t[n].s_content.c_subtree, (Node)e, d);
            } else if (t[n].s_content.c_string != null) {
                e.appendChild(d.createTextNode(t[n].s_content.c_string.value.get()));
                e.setAttribute("type", "String");
            } else if (t[n].s_content.c_oid != null) {
                e.appendChild(d.createTextNode(Config.convertSyntax((int[])t[n].s_content.c_oid.get())));
                e.setAttribute("type", "OID");
            } else if (t[n].s_content.c_numeric != null) {
                e.appendChild(d.createTextNode(Integer.toString(t[n].s_content.c_numeric.get())));
                e.setAttribute("type", "Integer");
            } else if (t[n].s_content.c_trueOrFalse != null) {
                e.appendChild(d.createTextNode(t[n].s_content.c_trueOrFalse.get() ? "true" : "false"));
                e.setAttribute("type", "Boolean");
            } else if (t[n].s_content.c_date != null) {
                e.appendChild(d.createTextNode(t[n].s_content.c_date.get()));
                e.setAttribute("type", "Date");
            } else if (t[n].s_content.c_intUnit != null) {
                e.appendChild(d.createTextNode(Integer.toString(t[n].s_content.c_intUnit.s_value.get())));
                e.setAttribute("type", "intUnit");
            }
            x.appendChild(e);
        }
    }

    private ElementData getElementData(String contentType, String content) {
        ElementData elementData = new ElementData();
        if (contentType.equalsIgnoreCase("String")) {
            elementData.c_string = this.getInternationalString(content);
        } else if (contentType.equalsIgnoreCase("Integer")) {
            elementData.c_numeric = this.getASN1Integer(content);
        } else if (contentType.equalsIgnoreCase("OID")) {
            elementData.c_oid = this.getASN1ObjectIdentifier(content);
        } else if (contentType.equalsIgnoreCase("Boolean")) {
            elementData.c_trueOrFalse = this.getASN1Boolean(content);
        } else if (contentType.equalsIgnoreCase("Date")) {
            elementData.c_date = this.getASN1GeneralizedTime(content);
        } else if (contentType.equalsIgnoreCase("intUnit")) {
            elementData.c_intUnit = this.getIntUnit(content);
        }
        return elementData;
    }

    private StringOrNumeric getStringOrNumeric(String s) {
        StringOrNumeric sOr = new StringOrNumeric();
        try {
            int i = Integer.parseInt(s);
            sOr.c_numeric = this.getASN1Integer(s);
            return sOr;
        }
        catch (NumberFormatException ex) {
            sOr.c_string = this.getInternationalString(s);
            return sOr;
        }
    }

    private InternationalString getInternationalString(String s) {
        InternationalString is = new InternationalString();
        is.value = new ASN1GeneralString(s);
        return is;
    }

    private ASN1Integer getASN1Integer(String s) {
        return new ASN1Integer(Integer.parseInt(s));
    }

    private ASN1ObjectIdentifier getASN1ObjectIdentifier(String s) {
        return new ASN1ObjectIdentifier(Config.convertSyntax((String)s));
    }

    private ASN1Boolean getASN1Boolean(String s) {
        return new ASN1Boolean(Boolean.getBoolean(s));
    }

    private ASN1GeneralizedTime getASN1GeneralizedTime(String s) {
        return new ASN1GeneralizedTime(s);
    }

    private IntUnit getIntUnit(String s) {
        IntUnit iu = new IntUnit();
        iu.s_value = this.getASN1Integer(s);
        return iu;
    }

    private String getTag(StringOrNumeric sOn) throws IOException {
        if (sOn.c_numeric != null) {
            return Integer.toString(sOn.c_numeric.get());
        }
        return this.javaIdentifierTag(sOn.c_string.value.get());
    }

    private String getTag(ASN1Integer i) {
        return Integer.toString(i.get());
    }

    private String javaIdentifierTag(String s) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '_' || !Character.isJavaIdentifierPart(s.charAt(i))) continue;
            out.write(s.charAt(i));
        }
        out.close();
        return out.toString();
    }

    public String toString() {
        return this.root.toString();
    }
}

