/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.record;

import asn1.ASN1Exception;
import asn1.ASN1External;
import asn1.ASN1ObjectIdentifier;
import asn1.ASN1OctetString;
import asn1.BEREncoding;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.jafer.conf.Config;
import org.jafer.exception.JaferException;
import org.jafer.record.DataObject;
import org.jafer.record.MARC8Unicode;
import org.jafer.record.RecordException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * Exception performing whole class analysis ignored.
 */
public class MARCRecord
extends DataObject {
    private static final Logger logger = LoggerFactory.getLogger(MARCRecord.class);
    public static final char RECORD_DELIMETER = (char)Integer.parseInt("1D", 16);
    public static final char FIELD_DELIMETER = (char)Integer.parseInt("1E", 16);
    public static final char SUBFIELD_DELIMETER = (char)Integer.parseInt("1F", 16);
    private static final char MARC8_ENCODING = (char)Integer.parseInt("20", 16);
    private static final char UTF8_ENCODING = (char)Integer.parseInt("61", 16);
    public static final String MARC8 = "US-ASCII";
    public static final String UTF8 = StandardCharsets.UTF_8.toString();
    public static final String OAI_NAMESPACE = "http://www.openarchives.org/OAI/oai_marc";
    public static final String[] OAI_ATTRIBUTE_NAMES = new String[]{"status", "type", "level", "ctlType", "charEnc", "encLvl", "catForm", "lrRqrd"};
    private Node root;
    private BEREncoding ber;
    private final MARC8Unicode marc8Unicode;
    private String encoding = UTF8;

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public MARCRecord(String dbName, BEREncoding ber) {
        super(dbName, ber);
        this.ber = ber;
        this.marc8Unicode = new MARC8Unicode();
    }

    public MARCRecord(String dbName, Node root, String encoding) {
        super(dbName, root);
        this.root = root.getFirstChild();
        this.encoding = encoding;
        this.marc8Unicode = new MARC8Unicode();
    }

    public Node getXML(Document document) throws RecordException {
        if (document == null) {
            return null;
        }
        if (this.root != null) {
            if (document.equals(this.root.getOwnerDocument())) {
                return this.root;
            }
            return document.importNode(this.root, true);
        }
        if (this.ber == null) {
            return null;
        }
        this.root = document.createElementNS("http://www.openarchives.org/OAI/oai_marc", "oai_marc");
        ASN1External asn1External = null;
        try {
            asn1External = new ASN1External(this.ber, true);
            byte[] bytes = asn1External.c_octetAligned.get_bytes();
            int recordLength = this.getInt(bytes, 0, 5);
            int baseAddress = this.getInt(bytes, 12, 5);
            int numFields = (baseAddress - 1 - 24) / 12;
            for (int i = 5; i <= 19; ++i) {
                if (MARCRecord.getOAIAttributeName((int)i) == "" || bytes[i] == 32) continue;
                String value = this.getString(bytes, i, 1);
                this.getString(bytes, 0, 14);
                ((Element)this.root).setAttributeNS("http://www.openarchives.org/OAI/oai_marc", MARCRecord.getOAIAttributeName((int)i), value);
            }
            String labLeaderPart = this.getString(bytes, 5, 6);
            ((Element)this.root).setAttributeNS("http://www.openarchives.org/OAI/oai_marc", "lab", "-----" + labLeaderPart + "2--------4500");
            this.processRecord(document, bytes, baseAddress, numFields);
        }
        catch (ASN1Exception e) {
            String message = "ASN1Exception processing MARCRecord; " + e.toString();
            throw new RecordException(message, (Throwable)e);
        }
        catch (NullPointerException e) {
            String message = "NullPointerException processing MARCRecord; " + e.toString();
            throw new RecordException(message, (Throwable)e);
        }
        catch (IOException e) {
            String message = "IOException processing MARCRecord; " + e.toString();
            throw new RecordException(message, (Throwable)e);
        }
        catch (JaferException e) {
            String message = "JaferException processing MARCRecord; " + e.toString();
            throw new RecordException(message, (Throwable)e);
        }
        return this.root;
    }

    private void processRecord(Document document, byte[] bytes, int baseAddress, int numFields) throws IOException, JaferException {
        ByteArrayInputStream byteIn = null;
        for (int i = 0; i < numFields; ++i) {
            Element field;
            int offset = i * 12 + 24;
            int len = this.getInt(bytes, offset + 3, 4);
            int start = this.getInt(bytes, offset + 7, 5);
            String tag = this.getJavaIdentifierTag(this.getString(bytes, offset, 3));
            byteIn = new ByteArrayInputStream(bytes, baseAddress + start, len - 1);
            try {
                field = Integer.parseInt(tag) < 10 ? document.createElementNS("http://www.openarchives.org/OAI/oai_marc", "fixfield") : document.createElementNS("http://www.openarchives.org/OAI/oai_marc", "varfield");
            }
            catch (NumberFormatException nfe) {
                logger.debug("divne cislo pole " + tag);
                field = document.createElementNS("http://www.openarchives.org/OAI/oai_marc", "fixfield");
            }
            field.setAttributeNS("http://www.openarchives.org/OAI/oai_marc", "id", tag);
            this.processField(document, (Node)field, byteIn);
            this.root.appendChild(field);
            byteIn.close();
        }
    }

    private void processField(Document document, Node field, ByteArrayInputStream byteIn) throws IOException, JaferException {
        int b;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        String ind1 = null;
        String ind2 = null;
        while ((b = byteIn.read()) != -1) {
            if (b == SUBFIELD_DELIMETER) {
                if (ind1 == null && ind2 == null) {
                    ind1 = this.getString(byteOut, 0, 1);
                    ind2 = this.getString(byteOut, 1, 1);
                } else {
                    field.appendChild(this.getSubFieldElement(document, byteOut));
                }
                byteOut.reset();
                continue;
            }
            byteOut.write(b);
        }
        if (ind1 != null && ind2 != null) {
            field.appendChild(this.getSubFieldElement(document, byteOut));
            ((Element)field).setAttributeNS("http://www.openarchives.org/OAI/oai_marc", "i1", ind1);
            ((Element)field).setAttributeNS("http://www.openarchives.org/OAI/oai_marc", "i2", ind2);
        } else {
            field.appendChild(document.createTextNode("\"" + this.getString(byteOut, 0) + "\""));
        }
        byteOut.close();
    }

    private Node getSubFieldElement(Document document, ByteArrayOutputStream byteOut) throws IOException, JaferException {
        String tag = this.getJavaIdentifierTag(this.getString(byteOut, 0, 1));
        Element subfield = document.createElementNS("http://www.openarchives.org/OAI/oai_marc", "subfield");
        subfield.setAttributeNS("http://www.openarchives.org/OAI/oai_marc", "label", tag);
        subfield.appendChild(document.createTextNode(this.getString(byteOut, 1)));
        return subfield;
    }

    private String getString(byte[] bytes, int offset, int len) {
        if ("LATIN-1".equals(this.encoding)) {
            this.encoding = "ISO-8859-1";
        }
        try {
            if (this.encoding == null || this.encoding.equals(StandardCharsets.UTF_8.toString())) {
                return this.marc8Unicode.toUnicode(new String(bytes, offset, len));
            }
            return new String(bytes, offset, len, this.encoding);
        }
        catch (JaferException ex) {
            System.out.println("ERROR: " + ex.toString());
            return null;
        }
        catch (UnsupportedEncodingException ex) {
            System.out.println("ERROR: " + ex.toString());
            return null;
        }
    }

    private String getJavaIdentifierTag(String s) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isJavaIdentifierPart(s.charAt(i))) continue;
            out.write(s.charAt(i));
        }
        out.close();
        return out.toString(this.encoding);
    }

    private String getString(ByteArrayOutputStream byteOut, int offset, int len) {
        return this.getString(byteOut.toByteArray(), offset, len);
    }

    private String getString(ByteArrayOutputStream byteOut, int offset) {
        byte[] byteString = byteOut.toByteArray();
        try {
            return new String(byteString, this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private int getInt(byte[] bytes, int offset, int len) {
        return Integer.parseInt(this.getString(bytes, offset, len));
    }

    public BEREncoding getBER() throws RecordException {
        if (this.ber != null) {
            return this.ber;
        }
        if (this.root == null) {
            return null;
        }
        ByteArrayOutputStream leader = new ByteArrayOutputStream(24);
        ByteArrayOutputStream directory = new ByteArrayOutputStream();
        ByteArrayOutputStream fieldData = new ByteArrayOutputStream();
        ByteArrayOutputStream out = null;
        try {
            this.processRecord(directory, fieldData, this.root);
            int recordLength = 24 + directory.size() + fieldData.size() + 2;
            int baseAddress = 24 + directory.size() + 1;
            out = new ByteArrayOutputStream(recordLength);
            this.buildLeader(leader, this.root.getAttributes(), recordLength, baseAddress);
            leader.writeTo(out);
            leader.flush();
            leader.close();
            directory.writeTo(out);
            directory.flush();
            directory.close();
            out.write((byte)FIELD_DELIMETER);
            fieldData.writeTo(out);
            fieldData.flush();
            fieldData.close();
            out.write((byte)RECORD_DELIMETER);
            ASN1External asn1External = new ASN1External();
            asn1External.c_octetAligned = new ASN1OctetString(out.toByteArray(), "ASCII");
            asn1External.s_direct_reference = new ASN1ObjectIdentifier(super.getRecordSyntax());
            this.ber = asn1External.ber_encode();
        }
        catch (IOException e) {
            logger.error("selhani", (Throwable)e);
        }
        catch (JaferException e) {
            logger.error("selhani", (Throwable)e);
        }
        catch (ASN1Exception e) {
            logger.error("selhani", (Throwable)e);
        }
        return this.ber;
    }

    private void processRecord(ByteArrayOutputStream directory, ByteArrayOutputStream fieldData, Node node) throws JaferException {
        int dataStartPos = 0;
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (list.item(i).getNodeName().equals("fixfield")) {
                dataStartPos = this.addFixField(directory, fieldData, dataStartPos, list.item(i));
                continue;
            }
            if (!list.item(i).getNodeName().equals("varfield")) continue;
            dataStartPos = this.addVarField(directory, fieldData, dataStartPos, list.item(i));
        }
    }

    private int addFixField(ByteArrayOutputStream directory, ByteArrayOutputStream fieldData, int dataStartPos, Node fixField) throws JaferException {
        String tag = ((Element)fixField).getAttribute("id");
        int id = Integer.parseInt(tag);
        String data = this.getMARC8Value(fixField);
        if (data.charAt(0) == '\"' && data.charAt(data.length() - 1) == '\"') {
            data = data.substring(1, data.length() - 1);
        }
        this.write(fieldData, data);
        fieldData.write((byte)FIELD_DELIMETER);
        this.write(directory, 3, id);
        this.write(directory, 4, data.length() + 1);
        this.write(directory, 5, dataStartPos);
        return dataStartPos += data.length() + 1;
    }

    private int addVarField(ByteArrayOutputStream directory, ByteArrayOutputStream fieldData, int dataStartPos, Node varfield) throws JaferException {
        String i1 = ((Element)varfield).getAttribute("i1");
        String i2 = ((Element)varfield).getAttribute("i2");
        String tag = ((Element)varfield).getAttribute("id");
        NodeList subfieldList = ((Element)varfield).getElementsByTagName("subfield");
        this.write(fieldData, i1);
        this.write(fieldData, i2);
        int len = 2;
        for (int i = 0; i < subfieldList.getLength(); ++i) {
            String label = ((Element)subfieldList.item(i)).getAttribute("label");
            String valueOrig = Config.getValue((Node)subfieldList.item(i));
            byte[] codes = this.getMARCEncodedValue(subfieldList.item(i), this.encoding);
            fieldData.write((byte)SUBFIELD_DELIMETER);
            this.write(fieldData, label);
            this.write(fieldData, codes);
            len += label.length() + codes.length + 1;
        }
        fieldData.write((byte)FIELD_DELIMETER);
        this.write(directory, 3, Integer.parseInt(tag));
        this.write(directory, 4, len + 1);
        this.write(directory, 5, dataStartPos);
        return dataStartPos += len + 1;
    }

    private void write(ByteArrayOutputStream fieldData, int[] codes) {
        for (int i = 0; i < codes.length; ++i) {
            fieldData.write(codes[i]);
        }
    }

    private void write(ByteArrayOutputStream fieldData, byte[] codes) {
        try {
            fieldData.write(codes);
        }
        catch (IOException e) {
            logger.error("chyba pri vystupu zaznamu ve formatu bytestream", (Throwable)e);
        }
    }

    private void buildLeader(ByteArrayOutputStream leader, NamedNodeMap leaderAttributes, int recordLength, int baseAddress) throws JaferException {
        int status4 = 0;
        try {
            status4 = Integer.parseInt(leaderAttributes.getNamedItem("status4").getNodeValue());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.write(leader, 5, recordLength);
        leader.write(status4 < 4 ? 110 : 99);
        leader.write(this.getLeaderValue(leaderAttributes, 6, 'a'));
        leader.write(this.getLeaderValue(leaderAttributes, 7, 'm'));
        leader.write(this.getLeaderValue(leaderAttributes, 8, ' '));
        leader.write(this.getLeaderValue(leaderAttributes, 9, UTF8_ENCODING));
        leader.write(50);
        leader.write(50);
        this.write(leader, 5, baseAddress);
        leader.write(this.getLeaderValue(leaderAttributes, 17, '5'));
        leader.write(this.getLeaderValue(leaderAttributes, 18, ' '));
        leader.write(this.getLeaderValue(leaderAttributes, 19, ' '));
        leader.write(52);
        leader.write(53);
        leader.write(48);
        leader.write(48);
    }

    private char getLeaderValue(NamedNodeMap leaderAttributes, int leaderPos, char defaultValue) throws JaferException {
        Node n = leaderAttributes.getNamedItem(MARCRecord.getOAIAttributeName((int)leaderPos));
        char c = n == null ? defaultValue : Config.getValue((Node)n).charAt(0);
        return c;
    }

    private void write(ByteArrayOutputStream byteArray, int length, int value) {
        Object s = Integer.toString(value);
        while (((String)s).length() < length) {
            s = "0" + (String)s;
        }
        for (int i = 0; i < length; ++i) {
            byteArray.write(((String)s).charAt(i));
        }
    }

    private void write(ByteArrayOutputStream byteArray, String data) {
        for (int i = 0; i < data.length(); ++i) {
            byteArray.write(data.charAt(i));
        }
    }

    private String getMARC8Value(Node node) throws JaferException {
        return this.marc8Unicode.toMARC8(Config.getValue((Node)node));
    }

    private byte[] getMARCEncodedValue(Node node, String encoding) throws JaferException {
        byte[] code = null;
        try {
            String value = Config.getValue((Node)node);
            code = value.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("nezname kodovani " + encoding, (Throwable)e);
        }
        return code;
    }

    private static String getOAIAttributeName(int position) {
        if (position >= 5 && position <= 9) {
            return OAI_ATTRIBUTE_NAMES[position - 5];
        }
        if (position >= 17 && position <= 19) {
            return OAI_ATTRIBUTE_NAMES[position - 12];
        }
        return "";
    }
}

