/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.record;

import asn1.ASN1Any;
import asn1.ASN1Boolean;
import asn1.ASN1Exception;
import asn1.ASN1External;
import asn1.ASN1Integer;
import asn1.BEREncoding;
import java.lang.reflect.Field;
import org.jafer.record.DataObject;
import org.jafer.record.MARCRecord;
import org.jafer.record.RecordException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import z3950.RS_opac.HoldingsAndCircData;
import z3950.RS_opac.HoldingsRecord;
import z3950.v3.InternationalString;

public class OPACRecord
extends DataObject {
    private Node root;
    private BEREncoding ber;

    public OPACRecord(String dbName, BEREncoding ber) {
        super(dbName, ber);
        this.ber = ber;
    }

    public OPACRecord(String dbName, Node root) {
        super(dbName, root);
        this.root = root;
    }

    public BEREncoding getBER() throws RecordException {
        return super.getBER();
    }

    public Node getXML(Document document) throws RecordException {
        if (document == null) {
            return null;
        }
        if (this.root != null) {
            if (document.equals(this.root.getOwnerDocument())) {
                return this.root;
            }
            return document.importNode(this.root, true);
        }
        if (this.ber == null) {
            return null;
        }
        this.root = document.createElement("OPACRecord");
        z3950.RS_opac.OPACRecord opacRec = new z3950.RS_opac.OPACRecord();
        try {
            ASN1External ext = new ASN1External(this.getBER(), true);
            opacRec = new z3950.RS_opac.OPACRecord(ext.c_singleASN1type.ber_encode(), true);
        }
        catch (ASN1Exception e) {
            e.printStackTrace();
        }
        Element bib = document.createElement("bibliographic");
        if (opacRec.s_bibliographicRecord != null) {
            try {
                MARCRecord bibRec = new MARCRecord(this.getDatabaseName(), opacRec.s_bibliographicRecord.ber_encode());
                bib.appendChild(bibRec.getXML(document));
                this.root.appendChild(bib);
            }
            catch (ASN1Exception e) {
                e.printStackTrace();
            }
        }
        Element holdings = document.createElement("holdings");
        HoldingsRecord[] holdRecs = opacRec.s_holdingsData;
        if (holdRecs != null) {
            for (int n = 0; n < holdRecs.length; ++n) {
                Element holding = document.createElement("holdingRecord");
                if (holdRecs[n].c_marcHoldingsRecord != null) {
                    try {
                        MARCRecord holdRec = new MARCRecord(this.getDatabaseName(), holdRecs[n].c_marcHoldingsRecord.ber_encode());
                        holding.appendChild(holdRec.getXML(document));
                    }
                    catch (ASN1Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    this.processHoldingsAndCirc((Node)holding, holdRecs[n].c_holdingsAndCirc);
                }
                holdings.appendChild(holding);
            }
        }
        this.root.appendChild(holdings);
        return this.root;
    }

    private void processHoldingsAndCirc(Node node, HoldingsAndCircData data) {
        Element el = node.getOwnerDocument().createElement("holdingsAndCirc");
        Element circs = node.getOwnerDocument().createElement("circRecords");
        for (int n = 0; n < data.s_circulationData.length; ++n) {
            Element circ = node.getOwnerDocument().createElement("circulationData");
            this.processAny((Node)circ, (ASN1Any)data.s_circulationData[n]);
            circs.appendChild(circ);
        }
        el.appendChild(circs);
        Element vols = node.getOwnerDocument().createElement("volumes");
        for (int n = 0; n < data.s_volumes.length; ++n) {
            Element vol = node.getOwnerDocument().createElement("volume");
            this.processAny((Node)vol, (ASN1Any)data.s_volumes[n]);
            vols.appendChild(vol);
        }
        el.appendChild(vols);
        this.processAny((Node)el, (ASN1Any)data);
        node.appendChild(el);
    }

    private void processAny(Node node, ASN1Any data) {
        Field[] field = data.getClass().getFields();
        for (int n = 0; n < field.length; ++n) {
            if (!field[n].getName().startsWith("s_")) continue;
            String elname = field[n].getName().substring(2);
            Element el = node.getOwnerDocument().createElement(elname);
            if (field[n].getType().isInstance(new InternationalString())) {
                try {
                    el.setNodeValue(((InternationalString)field[n].get((Object)data)).value.get());
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            if (field[n].getType().isInstance(new ASN1Boolean(true))) {
                try {
                    el.setNodeValue(Boolean.toString(((ASN1Boolean)field[n].get(data)).get()));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            if (field[n].getType().isInstance(new ASN1Integer(0))) {
                try {
                    el.setNodeValue(Integer.toString(((ASN1Integer)field[n].get(data)).get()));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            node.appendChild(el);
        }
    }
}

