/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.record;

import asn1.ASN1Exception;
import asn1.ASN1External;
import asn1.ASN1GeneralString;
import asn1.ASN1ObjectIdentifier;
import asn1.BEREncoding;
import org.jafer.record.DataObject;
import org.jafer.record.RecordException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import z3950.RS_SUTRS.SutrsRecord;

public class SUTRSRecord
extends DataObject {
    private Node root;
    private BEREncoding ber;

    public SUTRSRecord(String dbName, BEREncoding ber) {
        super(dbName, ber);
        this.ber = ber;
    }

    public SUTRSRecord(String dbName, Node root) {
        super(dbName, root);
        this.root = root.getFirstChild();
    }

    public BEREncoding getBER() throws RecordException {
        if (this.ber != null) {
            return this.ber;
        }
        if (this.root == null) {
            return null;
        }
        try {
            ASN1External asn1External = new ASN1External();
            asn1External.c_singleASN1type = new ASN1GeneralString(this.processRecord(this.root));
            asn1External.s_direct_reference = new ASN1ObjectIdentifier(super.getRecordSyntax());
            this.ber = asn1External.ber_encode();
        }
        catch (ASN1Exception e) {
            System.out.println(e.toString());
        }
        return this.ber;
    }

    public Node getXML(Document document) throws RecordException {
        if (document == null) {
            return null;
        }
        if (this.root != null) {
            if (document.equals(this.root.getOwnerDocument())) {
                return this.root;
            }
            return document.importNode(this.root, true);
        }
        if (this.ber == null) {
            return null;
        }
        try {
            this.root = document.createElement("SUTRSRecord");
            ASN1External asn1External = new ASN1External(this.ber, true);
            this.processRecord(document, asn1External);
        }
        catch (ASN1Exception ex) {
            String message = "ASN1Exception processing SUTRSRecord; " + ex.toString();
            throw new RecordException(message, (Throwable)ex);
        }
        return this.root;
    }

    private String processRecord(Node node) {
        Object data = "";
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            data = child.getNodeType() == 3 ? (String)data + list.item(i).getNodeValue() : (String)data + this.processRecord(child);
        }
        return (String)data + "\n";
    }

    private void processRecord(Document document, ASN1External asn1External) throws ASN1Exception {
        String data = "";
        SutrsRecord record = new SutrsRecord(asn1External.c_singleASN1type.ber_encode(), true);
        if (record.value != null && record.value.value != null) {
            data = record.value.value.get();
        }
        int start = 1;
        int end = data.indexOf(10);
        while (end != -1) {
            String substring = data.substring(start, end);
            this.addNewLine(document, substring);
            start = end + 1;
            end = data.indexOf(10, start);
        }
    }

    private void addNewLine(Document document, String data) {
        if (!data.equals("")) {
            Element line = document.createElement("line");
            line.appendChild(document.createTextNode(data));
            this.root.appendChild(line);
        }
    }
}

