/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.util;

import asn1.ASN1Exception;
import asn1.ASN1Integer;
import asn1.BEREncoding;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Hashtable;
import org.jafer.util.ConnectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import z3950.v3.Close;
import z3950.v3.CloseReason;
import z3950.v3.PDU;

public class PDUDriver {
    private static Logger logger;
    private Hashtable closeReason;
    private Socket socket;
    private BufferedInputStream src;
    private BufferedOutputStream dest;
    private String sessionName;

    public PDUDriver(String sessionName, Socket socket, int timeout) throws IOException {
        logger = LoggerFactory.getLogger((String)"org.jafer.util");
        this.sessionName = sessionName;
        this.socket = socket;
        this.closeReason = this.loadCloseReason(new Hashtable());
        try {
            this.src = new BufferedInputStream(socket.getInputStream());
            this.dest = new BufferedOutputStream(socket.getOutputStream());
        }
        catch (SocketException e) {
            String message = sessionName + " could not reset timeout on socket (" + e.toString() + ")";
            logger.warn(message, (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            socket = null;
            throw e;
        }
    }

    public BEREncoding getBEREncoding() throws ConnectionException {
        try {
            return BEREncoding.input((InputStream)this.src);
        }
        catch (SocketException ex) {
            throw new ConnectionException("socket closed", (Throwable)ex);
        }
        catch (SocketTimeoutException ex) {
            this.initClose(7);
            throw new ConnectionException("association timed out", (Throwable)ex);
        }
        catch (InterruptedIOException ex) {
            this.initClose(7);
            throw new ConnectionException("association interrupted", (Throwable)ex);
        }
        catch (IOException ex) {
            this.initClose(6);
            throw new ConnectionException(ex.toString(), (Throwable)ex);
        }
        catch (ASN1Exception ex) {
            this.initClose(2);
            throw new ConnectionException(ex.toString(), (Throwable)ex);
        }
    }

    public PDU getPDU() throws ConnectionException {
        try {
            BEREncoding ber = this.getBEREncoding();
            return new PDU(ber, true);
        }
        catch (ASN1Exception ex) {
            throw new ConnectionException("ASN1 data error", (Throwable)ex);
        }
        catch (NullPointerException ex) {
            throw new ConnectionException("spojeni ukonceno protistranou - zrejme chybna implementace, ocekavan prikaz close", (Throwable)ex);
        }
    }

    public synchronized void sendPDU(PDU pduResponse) throws ConnectionException {
        try {
            pduResponse.ber_encode().output((OutputStream)this.dest);
            this.dest.flush();
        }
        catch (SocketException ex) {
            throw new ConnectionException("socket closed", (Throwable)ex);
        }
        catch (SocketTimeoutException ex) {
            throw new ConnectionException("association timed out", (Throwable)ex);
        }
        catch (InterruptedIOException ex) {
            throw new ConnectionException("association interrupted", (Throwable)ex);
        }
        catch (IOException ex) {
            throw new ConnectionException(ex.toString(), (Throwable)ex);
        }
        catch (ASN1Exception ex) {
            throw new ConnectionException(ex.toString(), (Throwable)ex);
        }
    }

    public void initClose(int reason) throws ConnectionException {
        String closeReason = this.getCloseReason(reason);
        logger.debug(this.sessionName + " requesting close due to " + closeReason);
        PDU pduResponse = new PDU();
        pduResponse.c_close = new Close();
        pduResponse.c_close.s_closeReason = new CloseReason();
        pduResponse.c_close.s_closeReason.value = new ASN1Integer(reason);
        pduResponse.c_close.s_referenceId = null;
        this.sendPDU(pduResponse);
        this.waitClosePDU();
    }

    public void respClose(PDU pduRequest) throws ConnectionException {
        int k = 9;
        if (pduRequest.c_close.s_closeReason.value != null) {
            k = pduRequest.c_close.s_closeReason.value.get();
        }
        logger.debug(this.sessionName + " close requested due to " + this.getCloseReason(k));
        PDU pduResponse = new PDU();
        pduResponse.c_close = new Close();
        pduResponse.c_close.s_closeReason = new CloseReason();
        CloseReason cfr_ignored_0 = pduResponse.c_close.s_closeReason;
        pduResponse.c_close.s_closeReason.value = new ASN1Integer(8);
        pduResponse.c_close.s_referenceId = pduRequest.c_close.s_referenceId;
        this.sendPDU(pduResponse);
    }

    private void waitClosePDU() {
        PDU pdu = null;
        logger.debug(this.sessionName + " waiting for close response");
        try {
            for (int n = 0; n < 10; ++n) {
                pdu = this.waitForPDU();
                if (pdu.c_close == null) continue;
                logger.debug(this.sessionName + " got close response");
                return;
            }
            logger.debug(this.sessionName + " close PDU not received");
        }
        catch (Exception ex) {
            logger.warn(this.sessionName + " communications error waiting for Close response (" + ex.toString() + ")");
        }
    }

    private PDU waitForPDU() throws ConnectionException {
        BEREncoding ber = this.getBEREncoding();
        if (ber == null) {
            return null;
        }
        PDU pdu = null;
        try {
            pdu = new PDU(ber, true);
        }
        catch (ASN1Exception ex) {
            return null;
        }
        return pdu;
    }

    private String getCloseReason(int k) {
        Integer key = new Integer(k);
        if (this.closeReason.containsKey(key)) {
            return (String)this.closeReason.get(key);
        }
        return (String)this.closeReason.get(new Integer(9));
    }

    private Hashtable loadCloseReason(Hashtable closeReason) {
        closeReason.put(new Integer(0), "Finished");
        closeReason.put(new Integer(1), "Shutdown");
        closeReason.put(new Integer(2), "System Problem");
        closeReason.put(new Integer(3), "Cost Limit");
        closeReason.put(new Integer(4), "Resources");
        closeReason.put(new Integer(5), "Security violation");
        closeReason.put(new Integer(6), "Protocol error");
        closeReason.put(new Integer(7), "Lack of activity");
        closeReason.put(new Integer(8), "Peer abort");
        closeReason.put(new Integer(9), "unknown reason");
        return closeReason;
    }
}

